/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTableEntry;

public class ExceptionTable
implements Cloneable {
    private ConstPool constPool;
    private ArrayList entries;

    public ExceptionTable(ConstPool constPool) {
        this.constPool = constPool;
        this.entries = new ArrayList();
    }

    ExceptionTable(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        this.constPool = constPool;
        int n2 = dataInputStream.readUnsignedShort();
        ArrayList<ExceptionTableEntry> arrayList = new ArrayList<ExceptionTableEntry>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = dataInputStream.readUnsignedShort();
            int n6 = dataInputStream.readUnsignedShort();
            arrayList.add(new ExceptionTableEntry(n3, n4, n5, n6));
        }
        this.entries = arrayList;
    }

    public Object clone() throws CloneNotSupportedException {
        ExceptionTable exceptionTable = (ExceptionTable)super.clone();
        exceptionTable.entries = new ArrayList(this.entries);
        return exceptionTable;
    }

    public int size() {
        return this.entries.size();
    }

    public int startPc(int n2) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        return exceptionTableEntry.startPc;
    }

    public void setStartPc(int n2, int n3) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        exceptionTableEntry.startPc = n3;
    }

    public int endPc(int n2) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        return exceptionTableEntry.endPc;
    }

    public void setEndPc(int n2, int n3) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        exceptionTableEntry.endPc = n3;
    }

    public int handlerPc(int n2) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        return exceptionTableEntry.handlerPc;
    }

    public void setHandlerPc(int n2, int n3) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        exceptionTableEntry.handlerPc = n3;
    }

    public int catchType(int n2) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        return exceptionTableEntry.catchType;
    }

    public void setCatchType(int n2, int n3) {
        ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(n2);
        exceptionTableEntry.catchType = n3;
    }

    public void add(int n2, ExceptionTable exceptionTable, int n3) {
        int n4 = exceptionTable.size();
        while (--n4 >= 0) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)exceptionTable.entries.get(n4);
            this.add(n2, exceptionTableEntry.startPc + n3, exceptionTableEntry.endPc + n3, exceptionTableEntry.handlerPc + n3, exceptionTableEntry.catchType);
        }
    }

    public void add(int n2, int n3, int n4, int n5, int n6) {
        if (n3 < n4) {
            this.entries.add(n2, new ExceptionTableEntry(n3, n4, n5, n6));
        }
    }

    public void add(int n2, int n3, int n4, int n5) {
        if (n2 < n3) {
            this.entries.add(new ExceptionTableEntry(n2, n3, n4, n5));
        }
    }

    public void remove(int n2) {
        this.entries.remove(n2);
    }

    public ExceptionTable copy(ConstPool constPool, Map map) {
        ExceptionTable exceptionTable = new ExceptionTable(constPool);
        ConstPool constPool2 = this.constPool;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(i2);
            int n3 = constPool2.copy(exceptionTableEntry.catchType, constPool, map);
            exceptionTable.add(exceptionTableEntry.startPc, exceptionTableEntry.endPc, exceptionTableEntry.handlerPc, n3);
        }
        return exceptionTable;
    }

    void shiftPc(int n2, int n3, boolean bl2) {
        int n4 = this.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(i2);
            exceptionTableEntry.startPc = ExceptionTable.shiftPc(exceptionTableEntry.startPc, n2, n3, bl2);
            exceptionTableEntry.endPc = ExceptionTable.shiftPc(exceptionTableEntry.endPc, n2, n3, bl2);
            exceptionTableEntry.handlerPc = ExceptionTable.shiftPc(exceptionTableEntry.handlerPc, n2, n3, bl2);
        }
    }

    private static int shiftPc(int n2, int n3, int n4, boolean bl2) {
        if (n2 > n3 || bl2 && n2 == n3) {
            n2 += n4;
        }
        return n2;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        int n2 = this.size();
        dataOutputStream.writeShort(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.entries.get(i2);
            dataOutputStream.writeShort(exceptionTableEntry.startPc);
            dataOutputStream.writeShort(exceptionTableEntry.endPc);
            dataOutputStream.writeShort(exceptionTableEntry.handlerPc);
            dataOutputStream.writeShort(exceptionTableEntry.catchType);
        }
    }
}

