/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

public class EnclosingMethodAttribute
extends AttributeInfo {
    public static final String tag = "EnclosingMethod";

    EnclosingMethodAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    public EnclosingMethodAttribute(ConstPool constPool, String string, String string2, String string3) {
        super(constPool, tag);
        int n2 = constPool.addClassInfo(string);
        int n3 = constPool.addNameAndTypeInfo(string2, string3);
        byte[] byArray = new byte[]{(byte)(n2 >>> 8), (byte)n2, (byte)(n3 >>> 8), (byte)n3};
        this.set(byArray);
    }

    public EnclosingMethodAttribute(ConstPool constPool, String string) {
        super(constPool, tag);
        int n2 = constPool.addClassInfo(string);
        int n3 = 0;
        byte[] byArray = new byte[]{(byte)(n2 >>> 8), (byte)n2, (byte)(n3 >>> 8), (byte)n3};
        this.set(byArray);
    }

    public int classIndex() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    public int methodIndex() {
        return ByteArray.readU16bit(this.get(), 2);
    }

    public String className() {
        return this.getConstPool().getClassInfo(this.classIndex());
    }

    public String methodName() {
        ConstPool constPool = this.getConstPool();
        int n2 = this.methodIndex();
        int n3 = constPool.getNameAndTypeName(n2);
        return constPool.getUtf8Info(n3);
    }

    public String methodDescriptor() {
        ConstPool constPool = this.getConstPool();
        int n2 = this.methodIndex();
        int n3 = constPool.getNameAndTypeDescriptor(n2);
        return constPool.getUtf8Info(n3);
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        if (this.methodIndex() == 0) {
            return new EnclosingMethodAttribute(constPool, this.className());
        }
        return new EnclosingMethodAttribute(constPool, this.className(), this.methodName(), this.methodDescriptor());
    }
}

