/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

class DoubleInfo
extends ConstInfo {
    static final int tag = 6;
    double value;

    public DoubleInfo(double d2, int n2) {
        super(n2);
        this.value = d2;
    }

    public DoubleInfo(DataInputStream dataInputStream, int n2) throws IOException {
        super(n2);
        this.value = dataInputStream.readDouble();
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof DoubleInfo && ((DoubleInfo)object).value == this.value;
    }

    public int getTag() {
        return 6;
    }

    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        return constPool2.addDoubleInfo(this.value);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(6);
        dataOutputStream.writeDouble(this.value);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("Double ");
        printWriter.println(this.value);
    }
}

