/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.IOException;
import java.io.OutputStream;
import org.zeroturnaround.bundled.javassist.bytecode.ByteStream;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFileWriter;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFileWriter$AttributeWriter;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFileWriter$ConstPoolWriter;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Writer;

public final class ClassFileWriter$MethodWriter {
    protected ByteStream output = new ByteStream(256);
    protected ClassFileWriter$ConstPoolWriter constPool;
    private int methodCount;
    protected int codeIndex;
    protected int throwsIndex;
    protected int stackIndex;
    private int startPos;
    private boolean isAbstract;
    private int catchPos;
    private int catchCount;

    ClassFileWriter$MethodWriter(ClassFileWriter$ConstPoolWriter classFileWriter$ConstPoolWriter) {
        this.constPool = classFileWriter$ConstPoolWriter;
        this.methodCount = 0;
        this.codeIndex = 0;
        this.throwsIndex = 0;
        this.stackIndex = 0;
    }

    public void begin(int n2, String string, String string2, String[] stringArray, ClassFileWriter$AttributeWriter classFileWriter$AttributeWriter) {
        int n3 = this.constPool.addUtf8Info(string);
        int n4 = this.constPool.addUtf8Info(string2);
        int[] nArray = stringArray == null ? null : this.constPool.addClassInfo(stringArray);
        this.begin(n2, n3, n4, nArray, classFileWriter$AttributeWriter);
    }

    public void begin(int n2, int n3, int n4, int[] nArray, ClassFileWriter$AttributeWriter classFileWriter$AttributeWriter) {
        int n5;
        ++this.methodCount;
        this.output.writeShort(n2);
        this.output.writeShort(n3);
        this.output.writeShort(n4);
        this.isAbstract = (n2 & 0x400) != 0;
        int n6 = n5 = this.isAbstract ? 0 : 1;
        if (nArray != null) {
            ++n5;
        }
        ClassFileWriter.writeAttribute(this.output, classFileWriter$AttributeWriter, n5);
        if (nArray != null) {
            this.writeThrows(nArray);
        }
        if (!this.isAbstract) {
            if (this.codeIndex == 0) {
                this.codeIndex = this.constPool.addUtf8Info("Code");
            }
            this.startPos = this.output.getPos();
            this.output.writeShort(this.codeIndex);
            this.output.writeBlank(12);
        }
        this.catchPos = -1;
        this.catchCount = 0;
    }

    private void writeThrows(int[] nArray) {
        if (this.throwsIndex == 0) {
            this.throwsIndex = this.constPool.addUtf8Info("Exceptions");
        }
        this.output.writeShort(this.throwsIndex);
        this.output.writeInt(nArray.length * 2 + 2);
        this.output.writeShort(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.output.writeShort(nArray[i2]);
        }
    }

    public void add(int n2) {
        this.output.write(n2);
    }

    public void add16(int n2) {
        this.output.writeShort(n2);
    }

    public void add32(int n2) {
        this.output.writeInt(n2);
    }

    public void addInvoke(int n2, String string, String string2, String string3) {
        int n3 = this.constPool.addClassInfo(string);
        int n4 = this.constPool.addNameAndTypeInfo(string2, string3);
        int n5 = this.constPool.addMethodrefInfo(n3, n4);
        this.add(n2);
        this.add16(n5);
    }

    public void codeEnd(int n2, int n3) {
        if (!this.isAbstract) {
            this.output.writeShort(this.startPos + 6, n2);
            this.output.writeShort(this.startPos + 8, n3);
            this.output.writeInt(this.startPos + 10, this.output.getPos() - this.startPos - 14);
            this.catchPos = this.output.getPos();
            this.catchCount = 0;
            this.output.writeShort(0);
        }
    }

    public void addCatch(int n2, int n3, int n4, int n5) {
        ++this.catchCount;
        this.output.writeShort(n2);
        this.output.writeShort(n3);
        this.output.writeShort(n4);
        this.output.writeShort(n5);
    }

    public void end(StackMapTable$Writer stackMapTable$Writer, ClassFileWriter$AttributeWriter classFileWriter$AttributeWriter) {
        if (this.isAbstract) {
            return;
        }
        this.output.writeShort(this.catchPos, this.catchCount);
        int n2 = stackMapTable$Writer == null ? 0 : 1;
        ClassFileWriter.writeAttribute(this.output, classFileWriter$AttributeWriter, n2);
        if (stackMapTable$Writer != null) {
            if (this.stackIndex == 0) {
                this.stackIndex = this.constPool.addUtf8Info("StackMapTable");
            }
            this.output.writeShort(this.stackIndex);
            byte[] byArray = stackMapTable$Writer.toByteArray();
            this.output.writeInt(byArray.length);
            this.output.write(byArray);
        }
        this.output.writeInt(this.startPos + 2, this.output.getPos() - this.startPos - 6);
    }

    int size() {
        return this.methodCount;
    }

    int dataSize() {
        return this.output.size();
    }

    void write(OutputStream outputStream) throws IOException {
        this.output.writeTo(outputStream);
    }
}

