/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

class ByteVector
implements Cloneable {
    private byte[] buffer = new byte[64];
    private int size = 0;

    public Object clone() throws CloneNotSupportedException {
        ByteVector byteVector = (ByteVector)super.clone();
        byteVector.buffer = (byte[])this.buffer.clone();
        return byteVector;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] copy() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buffer, 0, byArray, 0, this.size);
        return byArray;
    }

    public int read(int n2) {
        if (n2 < 0 || this.size <= n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.buffer[n2];
    }

    public void write(int n2, int n3) {
        if (n2 < 0 || this.size <= n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.buffer[n2] = (byte)n3;
    }

    public void add(int n2) {
        this.addGap(1);
        this.buffer[this.size - 1] = (byte)n2;
    }

    public void add(int n2, int n3) {
        this.addGap(2);
        this.buffer[this.size - 2] = (byte)n2;
        this.buffer[this.size - 1] = (byte)n3;
    }

    public void add(int n2, int n3, int n4, int n5) {
        this.addGap(4);
        this.buffer[this.size - 4] = (byte)n2;
        this.buffer[this.size - 3] = (byte)n3;
        this.buffer[this.size - 2] = (byte)n4;
        this.buffer[this.size - 1] = (byte)n5;
    }

    public void addGap(int n2) {
        if (this.size + n2 > this.buffer.length) {
            int n3 = this.size << 1;
            if (n3 < this.size + n2) {
                n3 = this.size + n2;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buffer, 0, byArray, 0, this.size);
            this.buffer = byArray;
        }
        this.size += n2;
    }
}

