/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassMap;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMember;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtMethod$ConstParameter;
import org.zeroturnaround.bundled.javassist.CtNewWrappedConstructor;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;

public class CtNewConstructor {
    public static final int PASS_NONE = 0;
    public static final int PASS_ARRAY = 1;
    public static final int PASS_PARAMS = 2;

    public static CtConstructor make(String string, CtClass ctClass) throws CannotCompileException {
        Javac javac = new Javac(ctClass);
        try {
            CtMember ctMember = javac.compile(string);
            if (ctMember instanceof CtConstructor) {
                return (CtConstructor)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a constructor");
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, String string, CtClass ctClass) throws CannotCompileException {
        try {
            CtConstructor ctConstructor = new CtConstructor(ctClassArray, ctClass);
            ctConstructor.setExceptionTypes(ctClassArray2);
            ctConstructor.setBody(string);
            return ctConstructor;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public static CtConstructor copy(CtConstructor ctConstructor, CtClass ctClass, ClassMap classMap) throws CannotCompileException {
        return new CtConstructor(ctConstructor, ctClass, classMap);
    }

    public static CtConstructor defaultConstructor(CtClass ctClass) throws CannotCompileException {
        CtConstructor ctConstructor = new CtConstructor((CtClass[])null, ctClass);
        ConstPool constPool = ctClass.getClassFile2().getConstPool();
        Bytecode bytecode = new Bytecode(constPool, 1, 1);
        bytecode.addAload(0);
        try {
            bytecode.addInvokespecial(ctClass.getSuperclass(), "<init>", "()V");
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        bytecode.add(177);
        ctConstructor.getMethodInfo2().setCodeAttribute(bytecode.toCodeAttribute());
        return ctConstructor;
    }

    public static CtConstructor skeleton(CtClass[] ctClassArray, CtClass[] ctClassArray2, CtClass ctClass) throws CannotCompileException {
        return CtNewConstructor.make(ctClassArray, ctClassArray2, 0, null, null, ctClass);
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, CtClass ctClass) throws CannotCompileException {
        return CtNewConstructor.make(ctClassArray, ctClassArray2, 2, null, null, ctClass);
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, int n2, CtMethod ctMethod, CtMethod$ConstParameter ctMethod$ConstParameter, CtClass ctClass) throws CannotCompileException {
        return CtNewWrappedConstructor.wrapped(ctClassArray, ctClassArray2, n2, ctMethod, ctMethod$ConstParameter, ctClass);
    }
}

