/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassMap;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod$ConstParameter;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.CtNewWrappedMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;

public final class CtMethod
extends CtBehavior {
    protected String cachedStringRep = null;

    CtMethod(MethodInfo methodInfo, CtClass ctClass) {
        super(ctClass, methodInfo);
    }

    public CtMethod(CtClass ctClass, String string, CtClass[] ctClassArray, CtClass ctClass2) {
        this(null, ctClass2);
        ConstPool constPool = ctClass2.getClassFile2().getConstPool();
        String string2 = Descriptor.ofMethod(ctClass, ctClassArray);
        this.methodInfo = new MethodInfo(constPool, string, string2);
        this.setModifiers(1025);
    }

    public CtMethod(CtMethod ctMethod, CtClass ctClass, ClassMap classMap) throws CannotCompileException {
        this(null, ctClass);
        this.copy(ctMethod, false, classMap);
    }

    public static CtMethod make(String string, CtClass ctClass) throws CannotCompileException {
        return CtNewMethod.make(string, ctClass);
    }

    public static CtMethod make(MethodInfo methodInfo, CtClass ctClass) throws CannotCompileException {
        if (ctClass.getClassFile2().getConstPool() != methodInfo.getConstPool()) {
            throw new CannotCompileException("bad declaring class");
        }
        return new CtMethod(methodInfo, ctClass);
    }

    public int hashCode() {
        return this.getStringRep().hashCode();
    }

    void nameReplaced() {
        this.cachedStringRep = null;
    }

    final String getStringRep() {
        if (this.cachedStringRep == null) {
            this.cachedStringRep = this.methodInfo.getName() + Descriptor.getParamDescriptor(this.methodInfo.getDescriptor());
        }
        return this.cachedStringRep;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CtMethod && ((CtMethod)object).getStringRep().equals(this.getStringRep());
    }

    public String getLongName() {
        return this.getDeclaringClass().getName() + "." + this.getName() + Descriptor.toString(this.getSignature());
    }

    public String getName() {
        return this.methodInfo.getName();
    }

    public void setName(String string) {
        this.declaringClass.checkModify();
        this.methodInfo.setName(string);
    }

    public CtClass getReturnType() throws NotFoundException {
        return this.getReturnType0();
    }

    public boolean isEmpty() {
        CodeAttribute codeAttribute = this.getMethodInfo2().getCodeAttribute();
        if (codeAttribute == null) {
            return (this.getModifiers() & 0x400) != 0;
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        try {
            return codeIterator.hasNext() && codeIterator.byteAt(codeIterator.next()) == 177 && !codeIterator.hasNext();
        }
        catch (BadBytecode badBytecode) {
            return false;
        }
    }

    public void setBody(CtMethod ctMethod, ClassMap classMap) throws CannotCompileException {
        CtMethod.setBody0(ctMethod.declaringClass, ctMethod.methodInfo, this.declaringClass, this.methodInfo, classMap);
    }

    public void setWrappedBody(CtMethod ctMethod, CtMethod$ConstParameter ctMethod$ConstParameter) throws CannotCompileException {
        CtClass ctClass;
        CtClass[] ctClassArray;
        this.declaringClass.checkModify();
        CtClass ctClass2 = this.getDeclaringClass();
        try {
            ctClassArray = this.getParameterTypes();
            ctClass = this.getReturnType();
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        Bytecode bytecode = CtNewWrappedMethod.makeBody(ctClass2, ctClass2.getClassFile2(), ctMethod, ctClassArray, ctClass, ctMethod$ConstParameter);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        this.methodInfo.setCodeAttribute(codeAttribute);
        this.methodInfo.setAccessFlags(this.methodInfo.getAccessFlags() & 0xFFFFFBFF);
    }
}

