/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.exec.impl;

import com.zeroturnaround.bundled.org.json.simple.JSONArray;
import com.zeroturnaround.bundled.org.json.simple.JSONObject;
import com.zeroturnaround.bundled.org.json.simple.JSONValue;
import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.bN;
import com.zeroturnaround.javarebel.bO;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.liverebel.util.SpaceUtil;
import com.zeroturnaround.liverebel.util.exec.Script;
import com.zeroturnaround.liverebel.util.exec.ScriptSource;
import com.zeroturnaround.liverebel.util.exec.impl.ArchiveEntryScriptSource;
import com.zeroturnaround.liverebel.util.exec.impl.FileScriptSource;
import com.zeroturnaround.liverebel.util.exec.impl.MapBasedUpdateScriptStore;
import com.zeroturnaround.liverebel.util.exec.impl.StringScriptSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipUtil;

public class UpdateScriptStoreDescription {
    private static final Logger log;
    public static final int MODE_ALL = 0;
    public static final int MODE_PER_UPDATE = 1;
    public static final int MODE_PER_SERVER = 2;
    private static final String PER_UPDATE_KEY = "perUpdate";
    private static final String PER_SERVER_KEY = "perServer";
    private static final String EVENT_KEY = "event";
    private static final String UNDOSCRIPT_KEY = "undoscript";
    private static final String SCRIPT_KEY = "script";
    private static final String SCRIPT_TIMEOUT_KEY = "timeout";
    private static final String SCRIPT_ENTRY_KEY = "entry";
    private static final String SCRIPT_TYPE_KEY = "type";
    private static final String TYPE_INLINE = "inlined";
    private static final String TYPE_ARCHIVE = "archive";
    private static final String TYPE_FILE = "file";
    public static final String ARCHIVE_URL_SEPARATOR = "!/";
    private final int mode;
    static Class class$com$zeroturnaround$liverebel$util$exec$impl$UpdateScriptStoreDescription;

    public UpdateScriptStoreDescription(int n2) {
        this.mode = n2;
    }

    public static MapBasedUpdateScriptStore parse(File file) throws IOException {
        return UpdateScriptStoreDescription.parse(0, file, null);
    }

    public static MapBasedUpdateScriptStore parse(int n2, File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " doesn't exist");
        }
        String string = dh.a(file);
        return UpdateScriptStoreDescription.parse(n2, string, file2);
    }

    public static MapBasedUpdateScriptStore parse(int n2, String string, File file) {
        UpdateScriptStoreDescription updateScriptStoreDescription = new UpdateScriptStoreDescription(n2);
        return updateScriptStoreDescription.init(string, file);
    }

    private MapBasedUpdateScriptStore init(String string, File file) {
        MapBasedUpdateScriptStore mapBasedUpdateScriptStore = new MapBasedUpdateScriptStore();
        log.trace("Initializing MapBasedUpdateScriptStore: desc = " + string + ", entriesArchive = " + file);
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        try {
            JSONArray jSONArray;
            JSONObject jSONObject = (JSONObject)JSONValue.parse(string);
            if (jSONObject == null) {
                throw new IllegalArgumentException("String '" + string + "' is not a valid script store description");
            }
            if ((this.mode == 0 || this.mode == 1) && (jSONArray = (JSONArray)jSONObject.get(PER_UPDATE_KEY)) != null) {
                this.consumeScriptDescriptions(mapBasedUpdateScriptStore, jSONArray.iterator(), true, arrayList, hashMap, file);
            }
            if ((this.mode == 0 || this.mode == 2) && (jSONArray = (JSONArray)jSONObject.get(PER_SERVER_KEY)) != null) {
                this.consumeScriptDescriptions(mapBasedUpdateScriptStore, jSONArray.iterator(), false, arrayList, hashMap, file);
            }
        }
        catch (Exception exception) {
            bO bO2 = bN.a("String '" + string + "' is not a valid script store description", exception);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(bO2.a());
            bO2.a(illegalArgumentException);
            throw illegalArgumentException;
        }
        mapBasedUpdateScriptStore.setDescription(string);
        if (file != null) {
            mapBasedUpdateScriptStore.setEntriesArchive(file);
        } else if (!arrayList.isEmpty()) {
            mapBasedUpdateScriptStore.initEntriesArchive(SpaceUtil.createTempFile("scripts-repackaged.zip"), arrayList, hashMap);
        }
        return mapBasedUpdateScriptStore;
    }

    private void consumeScriptDescriptions(MapBasedUpdateScriptStore mapBasedUpdateScriptStore, Iterator iterator, boolean bl2, List list, Map map, File file) {
        while (iterator.hasNext()) {
            Object object;
            String string;
            Object object2;
            JSONObject jSONObject = (JSONObject)iterator.next();
            String string2 = (String)jSONObject.get(EVENT_KEY);
            if (string2 == null) {
                throw new IllegalArgumentException("Event field cannot be null");
            }
            Script script = null;
            Script script2 = null;
            JSONObject jSONObject2 = (JSONObject)jSONObject.get(SCRIPT_KEY);
            if (jSONObject2 != null) {
                object2 = (String)jSONObject2.get(SCRIPT_TYPE_KEY);
                string = (String)jSONObject2.get(SCRIPT_ENTRY_KEY);
                object = (Long)jSONObject2.get(SCRIPT_TIMEOUT_KEY);
                script = this.makeScript(string2, (String)object2, string, (Long)object, list, bl2, map, file);
            }
            if ((object2 = (JSONObject)jSONObject.get(UNDOSCRIPT_KEY)) != null) {
                string = (String)((HashMap)object2).get(SCRIPT_TYPE_KEY);
                object = (String)((HashMap)object2).get(SCRIPT_ENTRY_KEY);
                Long l2 = (Long)jSONObject2.get(SCRIPT_TIMEOUT_KEY);
                script2 = this.makeScript(string2, string, (String)object, l2, list, bl2, map, file);
            }
            log.trace("Adding a script = " + script + ", undo = " + script2 + ", global = " + bl2);
            mapBasedUpdateScriptStore.addScript(string2, script, script2, bl2);
        }
    }

    private Script makeScript(String string, String string2, String string3, Long l2, List list, boolean bl2, Map map, File file) {
        ScriptSource scriptSource = null;
        String string4 = TYPE_INLINE;
        if (TYPE_INLINE.equalsIgnoreCase(string2)) {
            scriptSource = new StringScriptSource(string3);
        } else if (TYPE_ARCHIVE.equalsIgnoreCase(string2)) {
            int n2 = string3.indexOf(ARCHIVE_URL_SEPARATOR);
            if (n2 < 0) {
                throw new IllegalArgumentException("archive type scripts want entry like: 'path/to/archive!/path/to/entry', note '!/'");
            }
            String string5 = string3.substring(0, n2);
            String string6 = string3.substring(n2 + ARCHIVE_URL_SEPARATOR.length());
            String string7 = this.makeScriptEntryName(string, string6, bl2, map);
            map.put(string3, string7);
            if (file == null) {
                File file2 = new File(string5);
                byte[] byArray = ZipUtil.unpackEntry(file2, string6);
                list.add(new ByteSource(string7, byArray));
                scriptSource = new ArchiveEntryScriptSource(file2, string6);
            } else {
                scriptSource = new ArchiveEntryScriptSource(file, string7);
            }
            string4 = this.getName(string3);
        } else if (TYPE_FILE.equalsIgnoreCase(string2)) {
            String string8 = this.makeScriptEntryName(string, string3, bl2, map);
            map.put(string3, string8);
            if (file == null) {
                File file3 = new File(string3);
                scriptSource = new FileScriptSource(file3);
                list.add(new FileSource(string8, file3));
            } else {
                scriptSource = new ArchiveEntryScriptSource(file, string8);
            }
            string4 = this.getName(string3);
        }
        if (scriptSource == null) {
            throw new IllegalArgumentException("Script source type " + string2 + " is not supported");
        }
        long l3 = l2 == null ? 0L : l2;
        return new Script(string4, scriptSource, l3);
    }

    private String makeScriptEntryName(String string, String string2, boolean bl2, Map map) {
        String string3 = this.makeNameBase(string, string2, bl2);
        int n2 = 1;
        while (map.containsValue(string3)) {
            string3 = this.makeNameBase(string, string2, bl2) + "-" + n2++;
        }
        return string3;
    }

    private String makeNameBase(String string, String string2, boolean bl2) {
        return "liverebel/scripts/" + (bl2 ? PER_UPDATE_KEY : PER_SERVER_KEY) + "/" + string + "/" + this.getName(string2);
    }

    private String getName(String string) {
        int n2 = string.lastIndexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$exec$impl$UpdateScriptStoreDescription;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$exec$impl$UpdateScriptStoreDescription = new UpdateScriptStoreDescription[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
    }
}

