/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.exec.impl;

import com.zeroturnaround.liverebel.util.exec.Script;
import com.zeroturnaround.liverebel.util.exec.ScriptEventType;
import com.zeroturnaround.liverebel.util.exec.UpdateScriptStore;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

public class MapBasedUpdateScriptStore
implements UpdateScriptStore {
    private Map globalEvents;
    private Map globalUndoEvents;
    private Map serverEvents;
    private Map serverUndoEvents;
    private String description;
    private File entriesArchive;
    private Map json2zipEntries = new HashMap();

    public MapBasedUpdateScriptStore() {
        this.globalEvents = new HashMap();
        this.globalUndoEvents = new HashMap();
        this.serverEvents = new HashMap();
        this.serverUndoEvents = new HashMap();
    }

    public void initEntriesArchive(File file, List list, Map map) {
        this.json2zipEntries = map;
        if (list == null || list.isEmpty()) {
            return;
        }
        ZipEntrySource[] zipEntrySourceArray = list.toArray(new ZipEntrySource[list.size()]);
        ZipUtil.pack(zipEntrySourceArray, file);
        this.entriesArchive = file;
    }

    public void setEntriesArchive(File file) {
        this.entriesArchive = file;
    }

    public File getEntriesArchive() {
        return this.entriesArchive;
    }

    public Map getJson2ZipEntries() {
        return this.json2zipEntries;
    }

    public MapBasedUpdateScriptStore(Map map, Map map2) {
        this.globalEvents = map;
        this.globalUndoEvents = new HashMap();
        this.serverEvents = map2;
        this.serverUndoEvents = new HashMap();
    }

    public void addScript(String string, Script script) {
        this.addScript(string, script, true);
    }

    public void addScript(String string, Script script, boolean bl2) {
        Map map;
        string = string.toLowerCase();
        Map map2 = map = bl2 ? this.globalEvents : this.serverEvents;
        if (map.containsKey(string)) {
            ((List)map.get(string)).add(script);
        } else {
            LinkedList<Script> linkedList = new LinkedList<Script>();
            linkedList.add(script);
            map.put(string, linkedList);
        }
    }

    public void addScript(String string, Script script, Script script2, boolean bl2) {
        LinkedList<Script> linkedList;
        Map map;
        string = string.toLowerCase();
        if (script != null) {
            Map map2 = map = bl2 ? this.globalEvents : this.serverEvents;
            if (map.containsKey(string)) {
                ((List)map.get(string)).add(script);
            } else {
                linkedList = new LinkedList<Script>();
                linkedList.add(script);
                map.put(string, linkedList);
            }
        }
        if (script2 != null) {
            Map map3 = map = bl2 ? this.globalUndoEvents : this.serverUndoEvents;
            if (map.containsKey(string)) {
                ((List)map.get(string)).add(script2);
            } else {
                linkedList = new LinkedList();
                linkedList.add(script2);
                map.put(string, linkedList);
            }
        }
    }

    public Collection getScripts(ScriptEventType scriptEventType, boolean bl2) {
        Map map = bl2 ? this.globalEvents : this.serverEvents;
        String[] stringArray = scriptEventType.getAliases();
        return this.getScripts(map, stringArray);
    }

    public Collection getUndoScripts(ScriptEventType scriptEventType, boolean bl2) {
        Map map = bl2 ? this.globalUndoEvents : this.serverUndoEvents;
        String[] stringArray = scriptEventType.getAliases();
        return this.getScripts(map, stringArray);
    }

    private Collection getScripts(Map map, String[] stringArray) {
        LinkedList linkedList = new LinkedList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            List list = (List)map.get(stringArray[i2].toLowerCase());
            if (list == null) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "MapBasedScriptStore globalEvents = " + this.globalEvents.keySet() + ", onServer = " + this.serverEvents.keySet();
    }
}

