/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.exec.impl;

import com.zeroturnaround.liverebel.util.exec.ScriptSource;
import java.io.File;
import java.io.IOException;
import org.zeroturnaround.zip.ZipUtil;

public class ArchiveEntryScriptSource
implements ScriptSource {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final File archive;
    private final String entryName;
    private String charset;

    public ArchiveEntryScriptSource(File file, String string) {
        this.archive = file;
        this.entryName = string;
    }

    public ArchiveEntryScriptSource(File file, String string, String string2) {
        this.archive = file;
        this.entryName = string;
        this.charset = string2;
    }

    public String getSource() throws IOException {
        byte[] byArray = ZipUtil.unpackEntry(this.archive, this.entryName);
        if (byArray == null) {
            throw new IOException("Cannot find entry " + this.entryName + " in the archive " + this.archive);
        }
        if (this.charset == null) {
            return new String(byArray, DEFAULT_CHARSET);
        }
        return new String(byArray, this.charset);
    }

    public String toString() {
        return "ArchiveEntryScriptSource [archive=" + this.archive.getAbsolutePath() + ", entryName=" + this.entryName + ", valid=" + this.isValidSource() + "]";
    }

    public boolean fillFile(File file) throws IOException {
        return ZipUtil.unpackEntry(this.archive, this.entryName, file);
    }

    public boolean isValidSource() {
        return ZipUtil.containsEntry(this.archive, this.entryName);
    }
}

