/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.exec;

import com.zeroturnaround.liverebel.util.exec.ScriptSource;
import java.io.File;
import java.io.IOException;

public class Script {
    private static final long DEFAULT_TIMEOUT = 3600000L;
    private final String name;
    private final ScriptSource source;
    private long timeout = -1L;

    public Script(String string, ScriptSource scriptSource) {
        this.name = string;
        this.source = scriptSource;
    }

    public Script(String string, ScriptSource scriptSource, long l2) {
        this.name = string;
        this.source = scriptSource;
        this.timeout = l2;
    }

    public boolean hasValidSource() {
        return this.source.isValidSource();
    }

    public String getSourceString() throws IOException {
        return this.source.getSource();
    }

    public String getName() {
        return this.name;
    }

    public long getTimeout() {
        return this.timeout > 0L ? this.timeout : 3600000L;
    }

    public boolean fillFile(File file) throws IOException {
        return this.source.fillFile(file);
    }

    public String toString() {
        return "Script: " + this.name + " [timeout = " + this.timeout + "ms, s = " + this.source + "";
    }

    public void setTimeout(long l2) {
        if (this.timeout <= 0L) {
            this.timeout = l2 <= 0L ? 3600000L : l2;
        }
    }
}

