/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.diff.simple;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.dj;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import com.zeroturnaround.liverebel.util.OverrideLiveRebelXmlUtil;
import com.zeroturnaround.liverebel.util.diff.simple.VersionListing;
import com.zeroturnaround.liverebel.util.diff.simple.VersionListingDiff;
import com.zeroturnaround.liverebel.util.diff.simple.VersionListingResource;
import com.zeroturnaround.liverebel.util.diff.simple.ZipSimpleDiffUtil$CopySourceResourcesToOutputArchiveCallback;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

public class ZipSimpleDiffUtil {
    private static final Logger log;
    private static final String META_INF_CHECKSUMS = "META-INF/lr-diff-checksums.properties";
    private static final String META_INF_DELETED_RESOURCES_LIST = "META-INF/lr-deleted.list";
    private static final String META_INF_FILE_LIST = "META-INF/lrdiff.list";
    static Class class$com$zeroturnaround$liverebel$util$diff$simple$ZipSimpleDiffUtil;

    public static VersionListingDiff analyze(VersionListing versionListing, VersionListing versionListing2) {
        VersionListingResource versionListingResource;
        String string;
        Map.Entry entry;
        HashMap<String, VersionListingResource> hashMap = new HashMap<String, VersionListingResource>();
        HashMap<String, VersionListingResource> hashMap2 = new HashMap<String, VersionListingResource>();
        HashMap<String, VersionListingResource> hashMap3 = new HashMap<String, VersionListingResource>();
        Iterator iterator = versionListing.getResources().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            versionListingResource = (VersionListingResource)entry.getValue();
            if (versionListing2.getResources().containsKey(string)) {
                VersionListingResource versionListingResource2 = (VersionListingResource)versionListing2.getResources().get(string);
                if (versionListingResource2.isDirectory() && versionListingResource.isDirectory()) continue;
                if (!versionListingResource2.isDirectory() && !versionListingResource.isDirectory()) {
                    if (versionListingResource2.getCrc().equals(versionListingResource.getCrc())) continue;
                    hashMap3.put(string, versionListingResource2);
                    continue;
                }
                if (versionListingResource2.isDirectory() && !versionListingResource.isDirectory()) {
                    hashMap2.put(string, versionListingResource);
                    hashMap.put(string, versionListingResource2);
                    continue;
                }
                if (versionListingResource2.isDirectory() || !versionListingResource.isDirectory()) continue;
                hashMap2.put(string, versionListingResource2);
                hashMap.put(string, versionListingResource);
                continue;
            }
            hashMap2.put(string, (VersionListingResource)entry.getValue());
        }
        iterator = versionListing2.getResources().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            versionListingResource = (VersionListingResource)entry.getValue();
            if (versionListing.getResources().containsKey(string)) continue;
            hashMap.put(string, versionListingResource);
        }
        return new VersionListingDiff(hashMap, hashMap3, hashMap2);
    }

    public static void makeDiff(File file, LiveRebelXml liveRebelXml, VersionListing versionListing, VersionListing versionListing2, ZipOutputStream zipOutputStream) throws IOException {
        String string = OverrideLiveRebelXmlUtil.getLiveRebelXMLLocationByType(file);
        VersionListingDiff versionListingDiff = ZipSimpleDiffUtil.analyze(versionListing, versionListing2);
        versionListingDiff.replaceLiveRebelXml(string, liveRebelXml);
        ZipSimpleDiffUtil.makeDiff(file, versionListingDiff, zipOutputStream);
    }

    public static void makeDiff(File file, VersionListing versionListing, VersionListing versionListing2, ZipOutputStream zipOutputStream) throws IOException {
        ZipSimpleDiffUtil.makeDiff(file, ZipSimpleDiffUtil.analyze(versionListing, versionListing2), zipOutputStream);
    }

    public static void makeDiff(File file, VersionListingDiff versionListingDiff, ZipOutputStream zipOutputStream) throws UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
        try {
            ZipSimpleDiffUtil.copyResourcesToArchive(file, versionListingDiff.getAddedEntries().values(), zipOutputStream, printWriter);
            ZipSimpleDiffUtil.copyResourcesToArchive(file, versionListingDiff.getModifiedEntries().values(), zipOutputStream, printWriter);
            if (!versionListingDiff.getDeletedEntries().isEmpty()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter2 = new PrintWriter(stringWriter);
                Iterator iterator = versionListingDiff.getDeletedEntries().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    printWriter2.println((String)entry.getKey());
                }
                ZipSimpleDiffUtil.createEntry(new ByteSource(META_INF_DELETED_RESOURCES_LIST, stringWriter.toString().getBytes("UTF-8")), META_INF_DELETED_RESOURCES_LIST, zipOutputStream);
                printWriter.println(META_INF_DELETED_RESOURCES_LIST);
            }
            dj.a(printWriter);
            ZipSimpleDiffUtil.createEntry(new ByteSource(META_INF_FILE_LIST, byteArrayOutputStream.toByteArray()), META_INF_FILE_LIST, zipOutputStream);
            printWriter.println(META_INF_DELETED_RESOURCES_LIST);
        }
        catch (IOException iOException) {
            log.warn("Unable to create zip diff for {}", (Object)file.getName(), (Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patch(File file, File file2, File file3) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file3));
            ZipSimpleDiffUtil.patch(file, file2, zipOutputStream);
        }
        catch (Throwable throwable) {
            dj.a(zipOutputStream);
            throw throwable;
        }
        dj.a(zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyBytesToArchive(byte[] byArray, String string, ZipOutputStream zipOutputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ZipSimpleDiffUtil.createEntryFromInputStream(byteArrayInputStream, string, zipOutputStream);
        }
        catch (Throwable throwable) {
            dj.a(byteArrayInputStream);
            throw throwable;
        }
        dj.a(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToArchive(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ZipSimpleDiffUtil.createEntryFromInputStream(bufferedInputStream, string, zipOutputStream);
        }
        catch (Throwable throwable) {
            dj.a(bufferedInputStream);
            throw throwable;
        }
        dj.a(bufferedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourcesFromArchiveToArchive(File file, Collection collection, ZipOutputStream zipOutputStream, PrintWriter printWriter) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                VersionListingResource versionListingResource = (VersionListingResource)iterator.next();
                String string = versionListingResource.getPath();
                if (versionListingResource.getContent() == null) {
                    ZipSimpleDiffUtil.createEntry(zipFile, string, zipOutputStream);
                } else {
                    ZipSimpleDiffUtil.copyBytesToArchive(versionListingResource.getContent(), string, zipOutputStream);
                }
                printWriter.println(string);
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static void copyResourcesFromDirectoryToArchive(File file, Collection collection, ZipOutputStream zipOutputStream, PrintWriter printWriter) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            VersionListingResource versionListingResource = (VersionListingResource)iterator.next();
            String string = versionListingResource.getPath();
            if (versionListingResource.getContent() == null) {
                ZipSimpleDiffUtil.copyFileToArchive(new File(file, string), string, zipOutputStream);
            } else {
                ZipSimpleDiffUtil.copyBytesToArchive(versionListingResource.getContent(), string, zipOutputStream);
            }
            printWriter.println(string);
        }
    }

    private static void copyResourcesToArchive(File file, Collection collection, ZipOutputStream zipOutputStream, PrintWriter printWriter) throws IOException {
        if (file.isDirectory()) {
            ZipSimpleDiffUtil.copyResourcesFromDirectoryToArchive(file, collection, zipOutputStream, printWriter);
        } else {
            ZipSimpleDiffUtil.copyResourcesFromArchiveToArchive(file, collection, zipOutputStream, printWriter);
        }
    }

    private static void createEntry(ZipEntrySource zipEntrySource, String string, ZipOutputStream zipOutputStream) throws IOException {
        ZipSimpleDiffUtil.createEntryFromInputStream(zipEntrySource.getInputStream(), string, zipOutputStream);
    }

    private static void createEntry(ZipFile zipFile, String string, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            dj.a(zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    private static void createEntryFromInputStream(InputStream inputStream, String string, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(string));
        dj.a(inputStream, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private static void patch(File file, File file2, ZipOutputStream zipOutputStream) throws IOException {
        log.debug("Patching zip with a diff: " + file + " -> " + file2);
        ZipFile zipFile = null;
        ZipFile zipFile2 = null;
        try {
            zipFile = new ZipFile(file);
            zipFile2 = new ZipFile(file2);
            ZipEntry zipEntry = zipFile2.getEntry(META_INF_FILE_LIST);
            if (zipEntry == null) {
                throw new IllegalArgumentException("File " + file2 + "is not a simple diff file, doesn't contain " + META_INF_FILE_LIST + " entry.");
            }
            ZipEntry zipEntry2 = zipFile2.getEntry(META_INF_DELETED_RESOURCES_LIST);
            List list = zipEntry2 != null ? dj.a(zipFile2.getInputStream(zipEntry2), "UTF-8") : new ArrayList();
            List list2 = dj.a(zipFile2.getInputStream(zipEntry), "UTF-8");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string;
                if (META_INF_FILE_LIST.equalsIgnoreCase(string2) || META_INF_CHECKSUMS.equalsIgnoreCase(string2) || META_INF_DELETED_RESOURCES_LIST.equalsIgnoreCase(string2)) continue;
                ZipSimpleDiffUtil.createEntry(zipFile2, string2, zipOutputStream);
            }
            ZipUtil.iterate(file, new ZipSimpleDiffUtil$CopySourceResourcesToOutputArchiveCallback(zipFile, list, list2, zipOutputStream));
            zipOutputStream.flush();
        }
        catch (IOException iOException) {
            try {
                log.warn("Unable to apply patch to a zip: " + file.getName() + ", patch is " + file2.getName(), iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                ZipUtil.closeQuietly(zipFile2);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        ZipUtil.closeQuietly(zipFile2);
    }

    static void access$000(ZipFile zipFile, String string, ZipOutputStream zipOutputStream) throws IOException {
        ZipSimpleDiffUtil.createEntry(zipFile, string, zipOutputStream);
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$diff$simple$ZipSimpleDiffUtil;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$diff$simple$ZipSimpleDiffUtil = new ZipSimpleDiffUtil[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
    }
}

