/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util.diff.simple;

import com.zeroturnaround.bundled.org.json.simple.JSONObject;
import com.zeroturnaround.javarebel.bQ;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.javarebel.di;
import com.zeroturnaround.javarebel.dj;
import com.zeroturnaround.javarebel.dm;
import com.zeroturnaround.javarebel.ds;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import com.zeroturnaround.liverebel.util.diff.simple.VersionListing$1;
import com.zeroturnaround.liverebel.util.diff.simple.VersionListingResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipException;
import org.zeroturnaround.zip.ZipUtil;

public class VersionListing {
    public static final String LISTING_DIRECTORY = "DIR";
    private static final String EMPTY_STRING = "";
    private String applicationId;
    private String versionId;
    private Map resources = new HashMap();

    public VersionListing() {
    }

    public VersionListing(JSONObject jSONObject) {
        this.setApplicationId((String)jSONObject.get("applicationId"));
        this.setVersionId((String)jSONObject.get("versionId"));
        JSONObject jSONObject2 = (JSONObject)jSONObject.get("resources");
        if (jSONObject2 != null) {
            Iterator iterator = jSONObject2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                VersionListingResource versionListingResource = new VersionListingResource((JSONObject)entry.getValue());
                this.resources.put(versionListingResource.getPath(), versionListingResource);
            }
        }
    }

    public VersionListing(String string, String string2) {
        this.applicationId = string;
        this.versionId = string2;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Map getResources() {
        return this.resources;
    }

    public String getVersionId() {
        return this.versionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        Properties properties = new Properties();
        Object object = this.resources.values().iterator();
        while (object.hasNext()) {
            VersionListingResource versionListingResource = (VersionListingResource)object.next();
            String string = versionListingResource.isDirectory() ? LISTING_DIRECTORY : (versionListingResource.getCrc() != null ? versionListingResource.getCrc().toString() : EMPTY_STRING);
            properties.put(versionListingResource.getPath(), string);
        }
        object = null;
        try {
            object = new BufferedOutputStream(new FileOutputStream(file));
            properties.store((OutputStream)object, null);
        }
        catch (Throwable throwable) {
            dj.a(object);
            throw throwable;
        }
        dj.a((OutputStream)object);
    }

    public void setApplicationId(String string) {
        this.applicationId = string;
    }

    public void setResources(Map map) {
        this.resources = map;
    }

    public void setVersionId(String string) {
        this.versionId = string;
    }

    public String toString() {
        return "VersionListing { applicationId: " + this.applicationId + ", versionId: " + this.versionId + ", resources: " + this.resources + "}";
    }

    public static VersionListing createFrom(File file) throws ZipException, IOException {
        LiveRebelXml liveRebelXml = LiveApplicationUtil.findLiveRebelXml(file);
        if (liveRebelXml == null) {
            throw new IllegalArgumentException("liverebel.xml is not found in given archive " + file);
        }
        return VersionListing.createFrom(liveRebelXml, file);
    }

    public static VersionListing createFrom(LiveRebelXml liveRebelXml, File file) throws IOException {
        if (file.isDirectory()) {
            return VersionListing.createFromDirectory(liveRebelXml, file);
        }
        return VersionListing.createFromArchive(liveRebelXml, file);
    }

    public static VersionListing createFromArchive(LiveRebelXml liveRebelXml, File file) throws IOException {
        VersionListing versionListing = new VersionListing(liveRebelXml.getApplicationId(), liveRebelXml.getVersionId());
        ZipUtil.iterate(file, new VersionListing$1(versionListing));
        return versionListing;
    }

    public static VersionListing createFromDirectory(File file) throws IOException {
        LiveRebelXml liveRebelXml = LiveApplicationUtil.findLiveRebelXml(file);
        if (liveRebelXml == null) {
            throw new IllegalArgumentException("liverebel.xml is not found in given directory " + file);
        }
        return VersionListing.createFrom(liveRebelXml, file);
    }

    public static VersionListing createFromDirectory(LiveRebelXml liveRebelXml, File file) throws IOException {
        VersionListing versionListing = new VersionListing(liveRebelXml.getApplicationId(), liveRebelXml.getVersionId());
        String string = file.getAbsolutePath();
        VersionListing.collectDirectories(versionListing, file, string);
        Iterator iterator = dh.a(file, ds.b, ds.b);
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            String string2 = VersionListing.stripRootPathAndConvertSeparators(file2.getAbsolutePath(), string);
            VersionListingResource versionListingResource = new VersionListingResource(string2, bQ.a(dh.a(file2)));
            versionListing.resources.put(versionListingResource.getPath(), versionListingResource);
        }
        return versionListing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionListing load(File file, String string, String string2) throws IOException {
        VersionListing versionListing = new VersionListing();
        versionListing.setApplicationId(string);
        versionListing.setVersionId(string2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        try {
            properties.load(bufferedInputStream);
        }
        finally {
            dj.a(bufferedInputStream);
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry;
            Map.Entry<Object, Object> entry2 = entry = iterator.next();
            VersionListingResource versionListingResource = new VersionListingResource();
            versionListingResource.setPath((String)entry2.getKey());
            if (LISTING_DIRECTORY.equals(entry2.getValue())) {
                versionListingResource.setDirectory(true);
                versionListingResource.setCrc(null);
            } else {
                versionListingResource.setDirectory(false);
                versionListingResource.setCrc(Long.valueOf((String)entry2.getValue()));
            }
            versionListing.resources.put(versionListingResource.getPath(), versionListingResource);
        }
        return versionListing;
    }

    protected static void collectDirectories(VersionListing versionListing, File file, String string) {
        String[] stringArray = file.list(dm.b);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            File file2 = new File(file, string2);
            String string3 = VersionListing.stripRootPathAndConvertSeparators(file2.getAbsolutePath(), string) + "/";
            VersionListingResource versionListingResource = new VersionListingResource(string3);
            versionListing.resources.put(versionListingResource.getPath(), versionListingResource);
            VersionListing.collectDirectories(versionListing, file2, string);
        }
    }

    protected static String stripRootPathAndConvertSeparators(String string, String string2) {
        return di.a(string.substring(string2.length() + 1));
    }

    static Map access$000(VersionListing versionListing) {
        return versionListing.resources;
    }
}

