/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.nothome.delta.GDiffPatcher;
import com.nothome.delta.RandomAccessFileSeekableSource;
import com.nothome.delta.SeekableSource;
import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.javarebel.dj;
import com.zeroturnaround.liverebel.util.MD5CheckSum;
import com.zeroturnaround.liverebel.util.MD5CheckSum$MD5ReaderThread;
import com.zeroturnaround.liverebel.util.SpaceUtil;
import com.zeroturnaround.liverebel.util.TeeZipOutputStream;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$1;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$2;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$3;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$4;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$ChecksumException;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$OutputStreamCallback;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$PatchingVO;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$ZipEntryDiffCallback;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil;

public class ZipDiffUtil {
    private static final String CHECKSUM_VALUE_SEPARATOR = " ";
    private static final String CHECKSUM_MISSING = "null";
    private static final String FROM_MD5 = "fromFileMD5";
    public static final String META_INF_CHECKSUMS = "META-INF/lr-diff-checksums.properties";
    private static final String META_INF_FILE_LIST = "META-INF/lrdiff.list";
    private static final String GDIFF_SUFFIX = ".gdiff";
    private static final long FOUR_MEGABYTES = 0x400000L;
    private static final int DELTA_CHUNK_SIZE = 8192;
    private static final Logger log;
    static Class class$com$zeroturnaround$liverebel$util$ZipDiffUtil;

    public static boolean isRegularEntry(String string) {
        return !string.endsWith(GDIFF_SUFFIX) && !string.equals(META_INF_FILE_LIST) && !string.equals(META_INF_CHECKSUMS);
    }

    public static void makeDiff(File file, File file2, ZipOutputStream zipOutputStream) {
        ZipDiffUtil.makeDiff(file, file2, zipOutputStream, new File("."));
    }

    public static void makeDiff(File file, File file2, File file3, File file4) {
        try {
            ZipDiffUtil.makeDiff(file, file2, new ZipOutputStream(new FileOutputStream(file3)), file4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Can't open FileOutputStream to " + file3, fileNotFoundException);
        }
    }

    public static void makeDiff(File file, File file2, ZipOutputStream zipOutputStream, File file3) {
        log.trace("Making zip diff: " + file + " -> " + file2);
        ZipFile zipFile = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
        try {
            zipFile = new ZipFile(file);
            ZipDiffUtil$ZipEntryDiffCallback zipDiffUtil$ZipEntryDiffCallback = new ZipDiffUtil$ZipEntryDiffCallback(zipFile, zipOutputStream, printWriter, file3, null);
            ZipUtil.iterate(file2, (ZipEntryCallback)zipDiffUtil$ZipEntryDiffCallback);
            printWriter.flush();
            dj.a(printWriter);
            ZipEntry zipEntry = new ZipEntry(META_INF_FILE_LIST);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
            Map map = zipDiffUtil$ZipEntryDiffCallback.calculateAllFromCheckSums(file);
            ZipDiffUtil.addCheckSum(map, zipDiffUtil$ZipEntryDiffCallback.getToChecksums(), zipOutputStream);
        }
        catch (IOException iOException) {
            log.warn("Unable to create zip diff between " + file.getName() + " and " + file2.getName(), iOException);
            throw new RuntimeException(iOException);
        }
        finally {
            dj.a(printWriter);
            dj.a(zipOutputStream);
            ZipUtil.closeQuietly(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map addCheckSum(Map map, Map map2, ZipOutputStream zipOutputStream) throws IOException {
        Object v2;
        Object object;
        Object object2;
        Properties properties = new Properties();
        Object object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = object2.getKey();
            v2 = object2.getValue();
            String string = (String)map2.remove(object);
            properties.put(object, v2 + CHECKSUM_VALUE_SEPARATOR + string);
        }
        object3 = map2.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = object2.getKey();
            v2 = object2.getValue();
            properties.put(object, "null " + v2);
        }
        object3 = new ByteArrayOutputStream();
        try {
            object2 = new ZipEntry(META_INF_CHECKSUMS);
            properties.store((OutputStream)object3, "This file contains MD5 checksums of patch source and result entries\nzipEntryName=sourceEntryCheckSum resultEntryCheckSum");
            zipOutputStream.putNextEntry((ZipEntry)object2);
            zipOutputStream.write(((ByteArrayOutputStream)object3).toByteArray());
            zipOutputStream.closeEntry();
            object = map;
            return object;
        }
        finally {
            dj.a((OutputStream)object3);
        }
    }

    public static void patch(File file, File file2, File file3) {
        ZipDiffUtil.patch(file, file2, file3, null);
    }

    public static void patch(File file, File file2, File file3, File file4) {
        try {
            ZipDiffUtil.patch(file, file2, new ZipOutputStream(new FileOutputStream(file3)), file4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Failed to open FileOutputStream to " + file3, fileNotFoundException);
        }
    }

    private static void patch(File file, File file2, ZipOutputStream zipOutputStream, File file3) {
        log.debug("Patching zip with a diff: " + file + " -> " + file2);
        ZipFile zipFile = null;
        ZipFile zipFile2 = null;
        try {
            zipFile = new ZipFile(file);
            zipFile2 = new ZipFile(file2);
            ZipEntry zipEntry = zipFile2.getEntry(META_INF_FILE_LIST);
            if (zipEntry == null) {
                throw new IllegalArgumentException("File " + file2 + "is not a patch file, doesn't contain " + META_INF_FILE_LIST + " entry.");
            }
            ZipDiffUtil.validateSourceIntegrity(file, zipFile2);
            Properties properties = null;
            byte[] byArray = ZipUtil.unpackEntry(file2, META_INF_CHECKSUMS);
            if (byArray != null) {
                properties = new Properties();
                properties.load(new ByteArrayInputStream(byArray));
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile2.getInputStream(zipEntry)));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!META_INF_FILE_LIST.equalsIgnoreCase(string) && !META_INF_CHECKSUMS.equalsIgnoreCase(string)) {
                    ZipDiffUtil.patchEntry(zipFile, zipFile2, string, zipOutputStream, file3, properties);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            try {
                log.warn("Unable to apply patch to a zip: " + file.getName() + ", patch is " + file2.getName(), iOException);
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zipFile);
                ZipUtil.closeQuietly(zipFile2);
                dj.a(zipOutputStream);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zipFile);
        ZipUtil.closeQuietly(zipFile2);
        dj.a(zipOutputStream);
    }

    private static void validateSourceIntegrity(File file, ZipFile zipFile) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(META_INF_CHECKSUMS);
        if (zipEntry != null) {
            Properties properties = new Properties();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                properties.load(inputStream);
                String string = properties.getProperty(FROM_MD5);
                if (string != null) {
                    String string2 = MD5CheckSum.md5Hex(file);
                    if (!string2.equals(string)) {
                        throw new RuntimeException("Expected md5 hash of file to be patched must be '" + string + "', but actual hash is '" + string2 + "'");
                    }
                    log.debug("successfully validated integrity of file to be patched using hash '" + string + "'");
                }
            }
            catch (IOException iOException) {
                dj.a(inputStream);
                throw new RuntimeException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchEntry(ZipFile zipFile, ZipFile zipFile2, String string, ZipOutputStream zipOutputStream, File file, Properties properties) throws IOException {
        InputStream inputStream;
        File file2;
        RandomAccessFileSeekableSource randomAccessFileSeekableSource;
        block21: {
            Object object;
            Object object2;
            boolean bl2;
            String string2 = null;
            String string3 = null;
            boolean bl3 = bl2 = properties != null;
            if (bl2 && (object2 = (String)properties.get(string)) != null) {
                object = ((String)object2).trim().split(CHECKSUM_VALUE_SEPARATOR);
                string2 = object[0].trim();
                string3 = object[1].trim();
                if (CHECKSUM_MISSING.equals(string2)) {
                    string2 = null;
                }
                if (CHECKSUM_MISSING.equals(string3)) {
                    string3 = null;
                }
            }
            if ((object2 = zipFile2.getEntry(string)) != null) {
                if (bl2) {
                    if (string3 == null) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch checksum metainfo, resulting zip after applying patch should contain file '" + string + "' with checksum " + string3);
                    }
                    object = object2;
                    String string4 = MD5CheckSum.md5Hex(zipFile2.getInputStream((ZipEntry)object2), new ZipDiffUtil$1(zipOutputStream, (ZipEntry)object));
                    if (!string4.equals(string3)) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch checksum metainfo zip entry '" + string + "' checksum should be in result file '" + string3 + "', but actual checksum is '" + string4 + "'");
                    }
                } else {
                    ZipDiffUtil.handleNonDiffPatchEntry(zipOutputStream, (ZipEntry)object2, zipFile2.getInputStream((ZipEntry)object2));
                }
                return;
            }
            object = zipFile.getEntry(string);
            if (object == null) {
                throw new IllegalArgumentException("Can't patch source: entry " + string + " not found in " + zipFile.getName());
            }
            object2 = zipFile2.getEntry(string + GDIFF_SUFFIX);
            if (object2 == null) {
                if (bl2) {
                    if (string2 == null) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch zip being patched shoul not contain file '" + string + "'");
                    }
                    if (string3 == null) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch checksum metainfo resulting zip after applying patch shoul not contain file '" + string + "'");
                    }
                    if (!string2.equals(string3)) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch checksum metainfo file '" + string + "' should be modified after applying patch. Expected checksum before applying patch: '" + string2 + "', expected checksum after applying patch: '" + string3 + "'");
                    }
                }
                ZipEntry zipEntry = ZipDiffUtil.recreate((ZipEntry)object);
                zipOutputStream.putNextEntry(zipEntry);
                if (zipFile.getInputStream((ZipEntry)object) != null) {
                    String string5 = MD5CheckSum.md5Hex(zipFile.getInputStream((ZipEntry)object), new ZipDiffUtil$2(zipOutputStream));
                    if (bl2 && !string5.equals(string2)) {
                        throw new ZipDiffUtil$ChecksumException("Based on patch checksum metainfo zip entry '" + string + "' checksum should be in both source and result file '" + string2 + "', but actual checksum is '" + string5 + "'");
                    }
                }
                zipOutputStream.closeEntry();
                return;
            }
            randomAccessFileSeekableSource = null;
            GDiffPatcher gDiffPatcher = new GDiffPatcher();
            file2 = SpaceUtil.createTempFile(file, "gdiff.tmp");
            inputStream = null;
            try {
                long l2 = ((ZipEntry)object).getSize();
                log.trace("Patching entry name = " + string + ", writing to a file: size = " + l2 / 1024L + "kb");
                String string6 = MD5CheckSum.md5Hex(zipFile.getInputStream((ZipEntry)object), new ZipDiffUtil$3(file2));
                if (bl2 && !string6.equals(string2)) {
                    throw new ZipDiffUtil$ChecksumException("Zip entry '" + string + "' checksum in source file should be '" + string2 + "' to be able to apply given patch, but actual checksum is '" + string6 + "'");
                }
                randomAccessFileSeekableSource = new RandomAccessFileSeekableSource(new RandomAccessFile(file2, "r"));
                ZipEntry zipEntry = ZipDiffUtil.recreate((ZipEntry)object2, ((ZipEntry)object).getName());
                inputStream = zipFile2.getInputStream((ZipEntry)object2);
                ZipDiffUtil$PatchingVO zipDiffUtil$PatchingVO = new ZipDiffUtil$PatchingVO((SeekableSource)randomAccessFileSeekableSource, inputStream);
                String string7 = ZipDiffUtil.withChecksumFromOutStream(zipOutputStream, new ZipDiffUtil$4(zipEntry, gDiffPatcher, zipDiffUtil$PatchingVO));
                if (string3 == null || string3.equals(string7)) break block21;
                throw new ZipDiffUtil$ChecksumException("Result checksum '" + string7 + "' after applying patch " + "to zip entry '" + string + "' doesn't match expected result checksum '" + string3 + "'");
            }
            catch (Throwable throwable) {
                dj.a(inputStream);
                if (randomAccessFileSeekableSource != null) {
                    randomAccessFileSeekableSource.close();
                }
                dh.a(file2);
                throw throwable;
            }
        }
        dj.a(inputStream);
        if (randomAccessFileSeekableSource != null) {
            randomAccessFileSeekableSource.close();
        }
        dh.a(file2);
    }

    private static boolean handleNonDiffPatchEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws IOException {
        if (zipEntry != null) {
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            zipOutputStream.putNextEntry(zipEntry2);
            if (zipEntry != null) {
                dj.a(inputStream, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
            return true;
        }
        return false;
    }

    private static ZipEntry recreate(ZipEntry zipEntry) {
        return ZipDiffUtil.recreate(zipEntry, null);
    }

    private static ZipEntry recreate(ZipEntry zipEntry, String string) {
        ZipEntry zipEntry2 = null;
        zipEntry2 = string != null ? new ZipEntry(string) : new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        if (zipEntry.getExtra() != null) {
            zipEntry2.setExtra((byte[])zipEntry.getExtra().clone());
        }
        zipEntry2.setSize(zipEntry.getSize());
        zipEntry2.setTime(zipEntry.getTime());
        return zipEntry2;
    }

    private static String withChecksumFromOutStream(ZipOutputStream zipOutputStream, ZipDiffUtil$OutputStreamCallback zipDiffUtil$OutputStreamCallback) throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        TeeZipOutputStream teeZipOutputStream = new TeeZipOutputStream(zipOutputStream, bufferedOutputStream);
        MD5CheckSum$MD5ReaderThread mD5CheckSum$MD5ReaderThread = new MD5CheckSum$MD5ReaderThread(pipedInputStream, null);
        mD5CheckSum$MD5ReaderThread.start();
        zipDiffUtil$OutputStreamCallback.execute(teeZipOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        try {
            mD5CheckSum$MD5ReaderThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return mD5CheckSum$MD5ReaderThread.getMd5();
    }

    static Logger access$100() {
        return log;
    }

    static ZipEntry access$200(ZipEntry zipEntry, String string) {
        return ZipDiffUtil.recreate(zipEntry, string);
    }

    static ZipEntry access$300(ZipEntry zipEntry) {
        return ZipDiffUtil.recreate(zipEntry);
    }

    static boolean access$400(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws IOException {
        return ZipDiffUtil.handleNonDiffPatchEntry(zipOutputStream, zipEntry, inputStream);
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$ZipDiffUtil;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$ZipDiffUtil = new ZipDiffUtil[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
    }
}

