/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.nothome.delta.Delta;
import com.nothome.delta.DiffWriter;
import com.nothome.delta.GDiffWriter;
import com.nothome.delta.RandomAccessFileSeekableSource;
import com.nothome.delta.SeekableSource;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.javarebel.dj;
import com.zeroturnaround.liverebel.util.MD5CheckSum;
import com.zeroturnaround.liverebel.util.SpaceUtil;
import com.zeroturnaround.liverebel.util.ZipDiffUtil;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$1;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$ZipEntryDiffCallback$1;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$ZipEntryDiffCallback$2;
import com.zeroturnaround.liverebel.util.ZipDiffUtil$ZipEntryDiffCallback$3;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil;

class ZipDiffUtil$ZipEntryDiffCallback
implements ZipEntryCallback {
    private final ZipFile source;
    private final ZipOutputStream output;
    private final PrintWriter fileList;
    private final File tmpDir;
    private final Map toCheckSums = new LinkedHashMap();
    private final Map fromCheckSums = new LinkedHashMap();

    private ZipDiffUtil$ZipEntryDiffCallback(ZipFile zipFile, ZipOutputStream zipOutputStream, PrintWriter printWriter, File file) {
        this.source = zipFile;
        this.output = zipOutputStream;
        this.fileList = printWriter;
        this.tmpDir = file;
    }

    public void process(InputStream inputStream, ZipEntry zipEntry) throws IOException {
        String string = MD5CheckSum.md5Hex(inputStream, new ZipDiffUtil$ZipEntryDiffCallback$1(this, zipEntry));
        this.toCheckSums.put(zipEntry.getName(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeZipDiff(InputStream inputStream, ZipEntry zipEntry) throws IOException {
        String string = zipEntry.getName();
        this.fileList.println(string);
        ZipEntry zipEntry2 = this.source.getEntry(string);
        int n2 = this.guessBestDeltaChunkSizeFromSourceSize(zipEntry2);
        if (this.handleNonGDiffEntry(zipEntry2, zipEntry, inputStream, n2)) {
            return;
        }
        RandomAccessFileSeekableSource randomAccessFileSeekableSource = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GDiffWriter gDiffWriter = new GDiffWriter((OutputStream)byteArrayOutputStream);
        Delta delta = new Delta();
        delta.setChunkSize(n2);
        File file = null;
        try {
            file = SpaceUtil.createTempFile(this.tmpDir, "gdiff.tmp");
            ZipDiffUtil.access$100().trace("Entry name = " + string + ", writing to a file: size = " + zipEntry2.getSize() / 1024L + "kb");
            this.copySourceEntryToTmpFile(zipEntry2, file);
            randomAccessFileSeekableSource = new RandomAccessFileSeekableSource(new RandomAccessFile(file, "r"));
            try {
                delta.compute((SeekableSource)randomAccessFileSeekableSource, inputStream, (DiffWriter)gDiffWriter);
            }
            finally {
                gDiffWriter.close();
                dj.a(inputStream);
            }
            ZipEntry zipEntry3 = ZipDiffUtil.access$200(zipEntry, zipEntry.getName() + ".gdiff");
            this.output.putNextEntry(zipEntry3);
            try {
                byteArrayOutputStream.writeTo(this.output);
            }
            finally {
                this.output.closeEntry();
            }
        }
        finally {
            if (randomAccessFileSeekableSource != null) {
                randomAccessFileSeekableSource.close();
            }
            dh.a(file);
        }
    }

    private void copySourceEntryToTmpFile(ZipEntry zipEntry, File file) throws IOException, FileNotFoundException {
        String string = MD5CheckSum.md5Hex(this.source.getInputStream(zipEntry), new ZipDiffUtil$ZipEntryDiffCallback$2(this, file));
        this.fromCheckSums.put(zipEntry.getName(), string);
    }

    public Map calculateAllFromCheckSums(File file) {
        ZipDiffUtil$ZipEntryDiffCallback$3 zipDiffUtil$ZipEntryDiffCallback$3 = new ZipDiffUtil$ZipEntryDiffCallback$3(this, this.fromCheckSums);
        ZipUtil.iterate(file, (ZipEntryCallback)zipDiffUtil$ZipEntryDiffCallback$3);
        return this.fromCheckSums;
    }

    public Map getToChecksums() {
        return this.toCheckSums;
    }

    private int guessBestDeltaChunkSizeFromSourceSize(ZipEntry zipEntry) {
        if (zipEntry == null) {
            return -1;
        }
        long l2 = zipEntry.getSize();
        if (l2 == -1L) {
            return 8192;
        }
        if (l2 < 64L) {
            return 64;
        }
        for (int i2 = 6; i2 < 13; ++i2) {
            int n2 = 1 << i2;
            long l3 = l2 / (long)n2;
            long l4 = 0x400000L / l3;
            if (l4 <= 32L) continue;
            return n2;
        }
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleNonGDiffEntry(ZipEntry zipEntry, ZipEntry zipEntry2, InputStream inputStream, int n2) throws IOException {
        if (this.tooShortToDiff(zipEntry, zipEntry2, n2)) {
            ZipEntry zipEntry3 = ZipDiffUtil.access$300(zipEntry2);
            try {
                this.output.putNextEntry(zipEntry3);
                if (inputStream != null) {
                    dj.a(inputStream, (OutputStream)this.output);
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                this.output.closeEntry();
            }
        }
        return false;
    }

    private boolean tooShortToDiff(ZipEntry zipEntry, ZipEntry zipEntry2, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = zipEntry2.isDirectory() || zipEntry == null;
        if (bl2) {
            return true;
        }
        boolean bl4 = zipEntry.getSize() != -1L && zipEntry.getSize() <= (long)n2;
        boolean bl5 = zipEntry2.getSize() != -1L && zipEntry2.getSize() <= (long)n2;
        return bl4 || bl5;
    }

    ZipDiffUtil$ZipEntryDiffCallback(ZipFile zipFile, ZipOutputStream zipOutputStream, PrintWriter printWriter, File file, ZipDiffUtil$1 zipDiffUtil$1) {
        this(zipFile, zipOutputStream, printWriter, file);
    }
}

