/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import com.zeroturnaround.liverebel.util.SanitizeHelper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.zeroturnaround.zip.ZipUtil;

public class OverrideLiveRebelXmlUtil {
    public static File addLiveRebelXml(File file, LiveRebelXml liveRebelXml) {
        byte[] byArray;
        String string = file.getParentFile().getAbsolutePath() + "/" + SanitizeHelper.sanitize(liveRebelXml.getApplicationId() + "-" + liveRebelXml.getVersionId() + "-" + System.currentTimeMillis());
        File file2 = new File(string);
        try {
            byArray = liveRebelXml.getAsXml().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        String string2 = OverrideLiveRebelXmlUtil.getLiveRebelXMLLocationByType(file);
        if (file.isFile()) {
            if (ZipUtil.containsEntry(file, string2)) {
                ZipUtil.replaceEntry(file, string2, byArray, file2);
            } else {
                ZipUtil.addEntry(file, string2, byArray, file2);
            }
            return file2;
        }
        File file3 = new File(file, string2);
        try {
            dh.a(file3, byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return file;
    }

    public static String getLiveRebelXMLLocationByType(File file) throws IllegalStateException {
        String string = LiveApplicationUtil.findApplicationType(file);
        String string2 = null;
        if (string.equals("WAR")) {
            string2 = "WEB-INF/classes/liverebel.xml";
        } else if (string.equals("EAR")) {
            string2 = "liverebel.xml";
        } else if (string.equals("JAR")) {
            string2 = "liverebel.xml";
        }
        if (string2 == null) {
            throw new IllegalStateException("Uknown file type: " + string);
        }
        return string2;
    }

    public static File overrideOrCreateXML(File file, String string, String string2) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
        }
        LiveRebelXml liveRebelXml = OverrideLiveRebelXmlUtil.getLiveRebelXml(file);
        if (liveRebelXml == null) {
            return OverrideLiveRebelXmlUtil.createLiveRebelXml(file, string, string2);
        }
        return OverrideLiveRebelXmlUtil.overrideLiveRebelXml(file, string, string2, liveRebelXml);
    }

    public static LiveRebelXml getLiveRebelXml(File file) {
        return LiveApplicationUtil.findLiveRebelXml(file);
    }

    private static File overrideLiveRebelXml(File file, String string, String string2, LiveRebelXml liveRebelXml) {
        LiveRebelXml liveRebelXml2 = string != null && string2 != null ? new LiveRebelXml(string, string2) : (string == null ? new LiveRebelXml(liveRebelXml.getApplicationId(), string2) : new LiveRebelXml(string, liveRebelXml.getVersionId()));
        return OverrideLiveRebelXmlUtil.addLiveRebelXml(file, liveRebelXml2);
    }

    private static File createLiveRebelXml(File file, String string, String string2) {
        if (string == null || string2 == null) {
            throw new RuntimeException("ERROR! Both \"-app\" and \"-ver\" must be given to create new liverebel.xml!");
        }
        LiveRebelXml liveRebelXml = new LiveRebelXml(string, string2);
        return OverrideLiveRebelXmlUtil.addLiveRebelXml(file, liveRebelXml);
    }
}

