/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.dh;
import com.zeroturnaround.javarebel.dj;
import com.zeroturnaround.liverebel.util.AppXmlHandler;
import com.zeroturnaround.liverebel.util.AppXmlParser;
import com.zeroturnaround.liverebel.util.ErrorUtil;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil$1;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import com.zeroturnaround.liverebel.util.SanitizeHelper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.zeroturnaround.zip.ZipUtil;

public class LiveApplicationUtil {
    private static final Logger log;
    public static final String TYPE_JAR = "JAR";
    public static final String TYPE_WAR = "WAR";
    public static final String TYPE_EAR = "EAR";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    public static final String WEB_INF_CLASSES_PREFIX = "WEB-INF/classes/";
    private static final String[] WAR_ARCHIVE_ENTRIES;
    static Class class$com$zeroturnaround$liverebel$util$LiveApplicationUtil;

    public static String findApplicationType(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        if (file.isDirectory()) {
            File file2 = new File(new File(file, META_INF), "application.xml");
            if (file2.isFile()) {
                return TYPE_EAR;
            }
            File file3 = new File(file, WEB_INF);
            if (file3.isDirectory()) {
                return TYPE_WAR;
            }
            return TYPE_JAR;
        }
        if (ZipUtil.containsEntry(file, "META-INF/application.xml")) {
            return TYPE_EAR;
        }
        if (ZipUtil.containsAnyEntry(file, WAR_ARCHIVE_ENTRIES)) {
            return TYPE_WAR;
        }
        return TYPE_JAR;
    }

    public static Set findEarModulePaths(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        byte[] byArray = LiveApplicationUtil.getEntry(file, "META-INF/application.xml");
        if (byArray == null) {
            throw new IllegalArgumentException("application.xml not found in '" + file + "'.");
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        AppXmlParser.parse(byArray, (AppXmlHandler)new LiveApplicationUtil$1(linkedHashSet));
        return linkedHashSet;
    }

    public static LiveRebelXml findLiveRebelXml(File file) {
        byte[] byArray = LiveApplicationUtil.findLiveRebelXmlContents(file);
        if (byArray == null) {
            return null;
        }
        return LiveRebelXml.parse(byArray);
    }

    public static LiveRebelXml findLiveRebelXml(ZipInputStream zipInputStream) {
        byte[] byArray = LiveApplicationUtil.findLiveRebelXmlContents(zipInputStream);
        if (byArray == null) {
            return null;
        }
        return LiveRebelXml.parse(byArray);
    }

    public static byte[] findLiveRebelXmlContents(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        String string = "liverebel.xml";
        if (TYPE_WAR.equals(LiveApplicationUtil.findApplicationType(file))) {
            string = WEB_INF_CLASSES_PREFIX + string;
        }
        return LiveApplicationUtil.getEntry(file, string);
    }

    public static byte[] findLiveRebelXmlContents(ZipInputStream zipInputStream) {
        if (zipInputStream == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        byte[] byArray = null;
        String string = "liverebel.xml";
        String string2 = "WEB-INF/classes/liverebel.xml";
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (string.equals(zipEntry.getName()) || string2.equals(zipEntry.getName())) {
                    byArray = dj.a(zipInputStream);
                    break;
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            throw ErrorUtil.rethrow(iOException);
        }
        return byArray;
    }

    private static byte[] getEntry(File file, String string) {
        byte[] byArray = null;
        if (file.isDirectory()) {
            File file2 = new File(file, string.replace('/', File.separatorChar));
            log.debug("Checking {}", file2);
            if (file2.exists()) {
                try {
                    byArray = dh.a(file2);
                }
                catch (IOException iOException) {
                    throw ErrorUtil.logAndRethrow(iOException);
                }
            }
        } else {
            log.debug("Looking for {} at {}", (Object)string, (Object)file);
            byArray = ZipUtil.unpackEntry(file, string);
        }
        return byArray;
    }

    public static String getDefaultContextPath(String string) {
        return SanitizeHelper.sanitizeNoHash(string);
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$LiveApplicationUtil;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$LiveApplicationUtil = new LiveApplicationUtil[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
        WAR_ARCHIVE_ENTRIES = new String[]{"WEB-INF/", "WEB-INF/web.xml", "WEB-INF/classes/liverebel.xml"};
    }
}

