/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.Z;
import com.zeroturnaround.liverebel.util.AppXmlHandler;
import com.zeroturnaround.liverebel.util.AppXmlParser$HandlerException;
import com.zeroturnaround.liverebel.util.ErrorUtil;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class AppXmlParser {
    private static final Logger log;
    public static final String APPLICATION_XML = "application.xml";
    private static final String ELEMENT_APPLICATION = "application";
    private static final String ELEMENT_DISPLAY_NAME = "display-name";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_EJB = "ejb";
    private static final String ELEMENT_JAVA = "java";
    private static final String ELEMENT_WEB = "web";
    private static final String ELEMENT_WEB_URI = "web-uri";
    private static final String ELEMENT_CONTEXT_ROOT = "context-root";
    static Class class$com$zeroturnaround$liverebel$util$AppXmlParser;

    public static void parse(byte[] byArray, AppXmlHandler appXmlHandler) {
        String string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        AppXmlParser.parse(string, appXmlHandler);
    }

    public static void parse(String string, AppXmlHandler appXmlHandler) {
        log.trace("Parsing {}: {}", (Object)APPLICATION_XML, (Object)string);
        try {
            Z z2 = new Z();
            z2.a(string);
            AppXmlParser.processDocument(z2, appXmlHandler);
        }
        catch (AppXmlParser$HandlerException appXmlParser$HandlerException) {
            throw ErrorUtil.rethrow(appXmlParser$HandlerException.getCause());
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to process 'application.xml", exception);
        }
    }

    private static void processDocument(Z z2, AppXmlHandler appXmlHandler) {
        AppXmlParser.expectName(z2, ELEMENT_APPLICATION);
        Iterator iterator = z2.a().iterator();
        while (iterator.hasNext()) {
            Z z3 = (Z)iterator.next();
            String string = z3.b();
            if (ELEMENT_DISPLAY_NAME.equals(string)) {
                try {
                    appXmlHandler.displayName(z3.a());
                    continue;
                }
                catch (Exception exception) {
                    throw new AppXmlParser$HandlerException(exception);
                }
            }
            if (ELEMENT_DESCRIPTION.equals(string)) {
                try {
                    appXmlHandler.description(z3.a());
                    continue;
                }
                catch (Exception exception) {
                    throw new AppXmlParser$HandlerException(exception);
                }
            }
            if (!ELEMENT_MODULE.equals(string)) continue;
            AppXmlParser.processModule(z3, appXmlHandler);
        }
    }

    private static void processModule(Z z2, AppXmlHandler appXmlHandler) {
        Iterator iterator = z2.a().iterator();
        while (iterator.hasNext()) {
            Z z3 = (Z)iterator.next();
            String string = z3.b();
            if (ELEMENT_EJB.equals(string)) {
                AppXmlParser.processEjb(z3, appXmlHandler);
                continue;
            }
            if (ELEMENT_JAVA.equals(string)) {
                AppXmlParser.processJava(z3, appXmlHandler);
                continue;
            }
            if (!ELEMENT_WEB.equals(string)) continue;
            AppXmlParser.processWeb(z3, appXmlHandler);
        }
    }

    private static void processEjb(Z z2, AppXmlHandler appXmlHandler) {
        String string = z2.a();
        try {
            appXmlHandler.ejb(string);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void processJava(Z z2, AppXmlHandler appXmlHandler) {
        String string = z2.a();
        try {
            appXmlHandler.java(string);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void processWeb(Z z2, AppXmlHandler appXmlHandler) {
        String string = null;
        String string2 = null;
        Iterator iterator = z2.a().iterator();
        while (iterator.hasNext()) {
            Z z3 = (Z)iterator.next();
            String string3 = z3.b();
            if (ELEMENT_WEB_URI.equals(string3)) {
                string = z3.a();
                continue;
            }
            if (!ELEMENT_CONTEXT_ROOT.equals(string3)) continue;
            string2 = z3.a();
        }
        try {
            appXmlHandler.web(string, string2);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void expectName(Z z2, String string) {
        if (!string.equals(z2.b())) {
            throw new IllegalArgumentException("Element '" + string + "' expected instead of '" + z2.b() + "'.");
        }
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$AppXmlParser;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$AppXmlParser = new AppXmlParser[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
    }
}

