/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.javarebel.java4;

import com.zeroturnaround.javarebel.AP;
import com.zeroturnaround.javarebel.Ab;
import com.zeroturnaround.javarebel.Aj;
import com.zeroturnaround.javarebel.Eh;
import com.zeroturnaround.javarebel.HX;
import com.zeroturnaround.javarebel.Hv;
import com.zeroturnaround.javarebel.Ix;
import com.zeroturnaround.javarebel.bP;
import com.zeroturnaround.javarebel.java4.LicenseQueryCommandHandler;
import com.zeroturnaround.javarebel.java4.ValidateLicenseCommandHandler;
import com.zeroturnaround.javarebel.xQ;
import com.zeroturnaround.javarebel.xk;
import com.zeroturnaround.javarebel.xm;
import com.zeroturnaround.javarebel.xq;
import com.zeroturnaround.javarebel.xr;
import com.zeroturnaround.javarebel.xv;
import com.zeroturnaround.javarebel.zB;
import com.zeroturnaround.javarebel.zG;
import com.zeroturnaround.javarebel.zw;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.Licensing$ActivationException;

public class Install {
    private static final AP log = AP.getInstance("Core");
    private static final String REBEL_BOOTSTRAP_FILE_NAME = xq.e() + "-bootstrap.jar";
    private static final String REBEL_BOOTSTRAP_PROPERTIES = xq.e() + "-bootstrap.properties";
    private static final String REBEL_BOOTSTRAP_FILE = System.getProperty("rebel.bootstrap");
    private static final String JAVA_VENDOR_KEY = "java.vm.vendor";
    private static final String IBM_VENDOR_VALUE = "IBM Corporation";
    private static final String JAVA_FULLVERSION_KEY = "java.fullversion";
    static Class class$com$zeroturnaround$javarebel$java4$Install;

    public static void main(String[] stringArray) throws Exception {
        xQ.b();
        xQ.c();
        if (stringArray.length > 0 && "-validate-license".equals(stringArray[0])) {
            ValidateLicenseCommandHandler.validateLicense(stringArray);
            return;
        }
        if (stringArray.length > 0 && "-license".equals(stringArray[0])) {
            LicenseQueryCommandHandler.licenseQuery(stringArray);
            return;
        }
        if (stringArray.length > 0 && "-statistics".equals(stringArray[0])) {
            Install.handleStatisticsQuery(stringArray);
            return;
        }
        if (stringArray.length > 0 && "-clean-prefs".equals(stringArray[0])) {
            Install.cleanJavaPreferences(stringArray);
            return;
        }
        if (stringArray.length > 0 && "-go-offline".equals(stringArray[0])) {
            if (xm.b() != null) {
                Install.handleGoOfflineLS2(stringArray);
            } else {
                Install.handleGoOfflineLS1(stringArray);
            }
            return;
        }
        if (stringArray.length > 0 && "-go-online".equals(stringArray[0])) {
            if (xm.b() != null) {
                Install.handleGoOnlineLS2();
            } else {
                Install.handleGoOnlineLS1();
            }
            return;
        }
        if (stringArray.length > 0 && "-activate".equals(stringArray[0])) {
            try {
                HX.a(stringArray);
            }
            catch (Licensing$ActivationException licensing$ActivationException) {
                HX.a(licensing$ActivationException);
            }
            return;
        }
        Install.handleBootstrapGeneration();
    }

    private static void handleGoOnlineLS1() {
        zG.a(true);
        zB.a(null, null, false);
        System.out.println();
        if (Ab.a(true)) {
            System.out.println("SUCCESS: Acquired a new on-line license token.");
            return;
        }
        System.out.println("FAILED: Could not acquire an on-line license token.");
    }

    private static void handleGoOnlineLS2() {
        zG.a(true);
        System.out.println("Removing offline token for license server 2 ..");
        boolean bl2 = Aj.a().d();
        if (!bl2) {
            System.out.println("Go-online operation was NOT completely successful!");
        }
    }

    private static void handleGoOfflineLS1(String[] stringArray) {
        zG.a(true);
        zB.a(null, null, false);
        Integer n2 = null;
        if (zB.a().e()) {
            n2 = Install.extractDaysFromArgs(stringArray);
        }
        System.out.println();
        if (!zB.a().e()) {
            System.out.println("FAILED: You are not using a license server license.");
            return;
        }
        if (Ab.a(n2, true)) {
            System.out.println("SUCCESS: Acquired a new off-line license token.");
            return;
        }
        System.out.println("FAILED: Could not acquire an off-line license token.");
    }

    private static void handleGoOfflineLS2(String[] stringArray) {
        zG.a(true);
        Integer n2 = Install.extractDaysFromArgs(stringArray);
        int n3 = 1;
        if (n2 != null) {
            n3 = n2;
        }
        System.out.println("License server: going offline ..");
        Aj.a().a(n3);
    }

    private static Integer extractDaysFromArgs(String[] stringArray) {
        Integer n2 = null;
        if (stringArray.length > 1) {
            try {
                n2 = Integer.valueOf(stringArray[1]);
                if (n2 != null && n2 > 15) {
                    System.out.println();
                    System.out.println("Tip: the maximum length of offline period is 15 days");
                    System.out.println();
                    n2 = bP.a(15);
                } else if (n2 != null && n2 < 1) {
                    System.out.println();
                    System.out.println("The minimum length of offline period is 1 days! (Using default value 1)");
                    System.out.println();
                    n2 = bP.a(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println();
                System.out.println("The number of offline days was given using an invalid format");
                System.out.println();
            }
        } else {
            System.out.println();
            System.out.println("Tip: add the number of offline days after \"-go-offline\" parameter!");
            System.out.println();
        }
        return n2;
    }

    private static void cleanJavaPreferences(String[] stringArray) {
        try {
            System.out.println("Cleaning up JRebel locally stored settings ..");
            zw.e();
        }
        catch (Exception exception) {
            System.out.println("Failed to clean Java settings. Exception was: " + exception.getMessage());
        }
    }

    private static void handleStatisticsQuery(String[] stringArray) {
        zG.a(true);
        new xk().b();
    }

    private static void handleBootstrapGeneration() {
        xr.a();
        try {
            Object object;
            File file;
            File file2 = file = REBEL_BOOTSTRAP_FILE == null ? null : new File(REBEL_BOOTSTRAP_FILE);
            if (file == null) {
                object = Ix.getRebelJarPath();
                File file3 = xq.a();
                file = file3 != null ? new File(file3, REBEL_BOOTSTRAP_FILE_NAME) : new File(((File)object).getParentFile(), REBEL_BOOTSTRAP_FILE_NAME);
            } else {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                file.getParentFile().mkdirs();
            }
            object = Install.getJavaRuntimeVersion();
            try {
                Install.writeBootstrapJar(file, (String)object);
            }
            catch (IOException iOException) {
                throw new Eh(iOException);
            }
            StringBuffer stringBuffer = new StringBuffer().append(xq.c()).append(": Generated boostrap JAR for Java version '").append((String)object).append("' and ").append(xq.c()).append(" version '");
            Class<?> clazz = class$com$zeroturnaround$javarebel$java4$Install;
            if (clazz == null) {
                clazz = class$com$zeroturnaround$javarebel$java4$Install = new Install[0].getClass().getComponentType();
            }
            System.out.println(stringBuffer.append(clazz.getPackage().getSpecificationVersion()).append("': ").append(file.getAbsolutePath()).toString());
        }
        catch (Throwable throwable) {
            throw Ix.logAndRethrow(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBootstrapJar(File file, String string) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            Object object = xv.a.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                Install.transformClass(jarOutputStream, (Class)entry.getKey(), (ClassBytecodeProcessor)entry.getValue());
            }
            object = new Properties();
            ((Properties)object).setProperty("java.runtime.version", string);
            Class<?> clazz = class$com$zeroturnaround$javarebel$java4$Install;
            if (clazz == null) {
                clazz = class$com$zeroturnaround$javarebel$java4$Install = new Install[0].getClass().getComponentType();
            }
            ((Properties)object).setProperty("rebel.version", clazz.getPackage().getSpecificationVersion());
            jarOutputStream.putNextEntry(new JarEntry(REBEL_BOOTSTRAP_PROPERTIES));
            ((Properties)object).store(jarOutputStream, null);
            jarOutputStream.flush();
        }
        finally {
            try {
                jarOutputStream.close();
            }
            catch (Throwable throwable) {
                log.errorEcho(null, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkBootstrapJar() {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(REBEL_BOOTSTRAP_PROPERTIES);
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                String string = Install.getJavaRuntimeVersion();
                if (!properties.getProperty("java.runtime.version").equals(string)) {
                    log.warnEcho("");
                    log.warnEcho("'jrebel-bootstrap.jar' was generated with a different Java version!");
                    log.warnEcho("'jrebel-bootstrap.jar' Java version: '" + properties.getProperty("java.runtime.version") + "'!");
                    log.warnEcho("Running Java version: '" + string + "'!");
                    log.warnEcho("Please regenerate the bootstrap JAR by running 'java -jar jrebel.jar'");
                    log.warnEcho("");
                }
            }
            catch (IOException iOException) {
                log.error(null, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.error(null, iOException);
                }
            }
        }
    }

    private static void transformClass(JarOutputStream jarOutputStream, Class clazz, ClassBytecodeProcessor classBytecodeProcessor) throws IOException {
        byte[] byArray = Hv.a(clazz);
        byte[] byArray2 = classBytecodeProcessor.process(clazz.getClassLoader(), clazz.getName(), byArray);
        if (byArray2 != byArray) {
            jarOutputStream.putNextEntry(new JarEntry(clazz.getName().replace('.', '/') + ".class"));
            jarOutputStream.write(byArray2);
            jarOutputStream.flush();
        }
    }

    private static String getJavaRuntimeVersion() {
        if (Install.isVendorIBM()) {
            String string = System.getProperty(JAVA_FULLVERSION_KEY);
            string = string.replaceAll("enabled", "").replaceAll("disabled", "");
            string = string.replaceAll("Compressed References ", "");
            string = string.replaceAll("\nGC.*(\n|$)", "\n");
            return string;
        }
        return System.getProperty("java.runtime.version");
    }

    private static boolean isVendorIBM() {
        String string = System.getProperty(JAVA_VENDOR_KEY);
        return string != null && string.indexOf(IBM_VENDOR_VALUE) != -1;
    }
}

