/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.JDKKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.PKCS12BagAttributeCarrierImpl;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.X509SignatureUtil;
import com.zeroturnaround.javarebel.kP;
import com.zeroturnaround.javarebel.kT;
import com.zeroturnaround.javarebel.kZ;
import com.zeroturnaround.javarebel.ko;
import com.zeroturnaround.javarebel.kq;
import com.zeroturnaround.javarebel.kt;
import com.zeroturnaround.javarebel.ku;
import com.zeroturnaround.javarebel.lM;
import com.zeroturnaround.javarebel.lN;
import com.zeroturnaround.javarebel.lO;
import com.zeroturnaround.javarebel.lP;
import com.zeroturnaround.javarebel.le;
import com.zeroturnaround.javarebel.lh;
import com.zeroturnaround.javarebel.nL;
import com.zeroturnaround.javarebel.nn;
import com.zeroturnaround.javarebel.nv;
import com.zeroturnaround.javarebel.oe;
import com.zeroturnaround.javarebel.og;
import com.zeroturnaround.javarebel.oh;
import com.zeroturnaround.javarebel.sR;
import com.zeroturnaround.javarebel.tL;
import com.zeroturnaround.javarebel.tW;
import com.zeroturnaround.javarebel.tf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class X509CertificateObject
extends X509Certificate
implements tf {
    private oe a;
    private nv a;
    private boolean[] a;
    private boolean a;
    private int a;
    private tf a = new PKCS12BagAttributeCarrierImpl();

    public X509CertificateObject(oe oe2) throws CertificateParsingException {
        byte[] byArray;
        this.a = oe2;
        try {
            byArray = this.a("2.5.29.19");
            if (byArray != null) {
                this.a = nv.a(kq.a(byArray));
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.a("2.5.29.15");
            if (byArray != null) {
                kP kP2 = kP.a(kq.a(byArray));
                int n2 = (byArray = kP2.c()).length * 8 - kP2.a();
                this.a = new boolean[n2 < 9 ? 9 : n2];
                for (int i2 = 0; i2 != n2; ++i2) {
                    this.a[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
                }
            } else {
                this.a = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.a.b().a());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.a.a().a());
        }
    }

    public int getVersion() {
        return this.a.a();
    }

    public BigInteger getSerialNumber() {
        return this.a.a().a();
    }

    public Principal getIssuerDN() {
        return new sR(this.a.a());
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            kt kt2 = new kt(byteArrayOutputStream);
            kt2.a(this.a.a());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Principal getSubjectDN() {
        return new sR(this.a.b());
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            kt kt2 = new kt(byteArrayOutputStream);
            kt2.a(this.a.b());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getNotBefore() {
        return this.a.a().a();
    }

    public Date getNotAfter() {
        return this.a.b().a();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        lh lh2 = new lh(byteArrayOutputStream);
        try {
            lh2.a(this.a.a());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.a.a().c();
    }

    public String getSigAlgName() {
        Object object;
        Provider provider = Security.getProvider("BC");
        if (provider != null && (object = provider.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i2 = 0; i2 != ((Provider[])object).length; ++i2) {
            String string = object[i2].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.a.a().a().a();
    }

    public byte[] getSigAlgParams() {
        if (this.a.a().a() != null) {
            return this.a.a().a().a().b();
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        kP kP2 = this.a.a().a();
        if (kP2 != null) {
            byte[] byArray = kP2.c();
            boolean[] blArray = new boolean[byArray.length * 8 - kP2.a()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        kP kP2 = this.a.a().b();
        if (kP2 != null) {
            byte[] byArray = kP2.c();
            boolean[] blArray = new boolean[byArray.length * 8 - kP2.a()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.a;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.a("2.5.29.37");
        if (byArray != null) {
            try {
                ko ko2 = new ko(byArray);
                ku ku2 = (ku)ko2.a();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 != ku2.a(); ++i2) {
                    arrayList.add(((le)ku2.a(i2)).a());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.a != null) {
            if (this.a.a()) {
                if (this.a.a() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.a.a().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            oh oh2 = this.a.a().a();
            if (oh2 != null) {
                Enumeration enumeration = oh2.a();
                while (enumeration.hasMoreElements()) {
                    le le2 = (le)enumeration.nextElement();
                    og og2 = oh2.a(le2);
                    if (!og2.a()) continue;
                    hashSet.add(le2.a());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] a(String string) {
        og og2;
        oh oh2 = this.a.a().a();
        if (oh2 != null && (og2 = oh2.a(new le(string))) != null) {
            return og2.a().c();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        og og2;
        oh oh2 = this.a.a().a();
        if (oh2 != null && (og2 = oh2.a(new le(string))) != null) {
            try {
                return og2.a().a();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            oh oh2 = this.a.a().a();
            if (oh2 != null) {
                Enumeration enumeration = oh2.a();
                while (enumeration.hasMoreElements()) {
                    le le2 = (le)enumeration.nextElement();
                    og og2 = oh2.a(le2);
                    if (og2.a()) continue;
                    hashSet.add(le2.a());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        oh oh2;
        if (this.getVersion() == 3 && (oh2 = this.a.a().a()) != null) {
            Enumeration enumeration = oh2.a();
            while (enumeration.hasMoreElements()) {
                og og2;
                le le2 = (le)enumeration.nextElement();
                String string = le2.a();
                if (string.equals(RFC3280CertPathUtilities.m) || string.equals(RFC3280CertPathUtilities.a) || string.equals(RFC3280CertPathUtilities.b) || string.equals(RFC3280CertPathUtilities.c) || string.equals(RFC3280CertPathUtilities.i) || string.equals(RFC3280CertPathUtilities.d) || string.equals(RFC3280CertPathUtilities.f) || string.equals(RFC3280CertPathUtilities.g) || string.equals(RFC3280CertPathUtilities.h) || string.equals(RFC3280CertPathUtilities.j) || string.equals(RFC3280CertPathUtilities.k) || !(og2 = oh2.a(le2)).a()) continue;
                return true;
            }
        }
        return false;
    }

    public PublicKey getPublicKey() {
        return JDKKeyFactory.a(this.a.a());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        lh lh2 = new lh(byteArrayOutputStream);
        try {
            lh2.a(this.a);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        Certificate certificate = (Certificate)object;
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = certificate.getEncoded();
            return tL.a(byArray, byArray2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public synchronized int hashCode() {
        if (!this.a) {
            this.a = this.a();
            this.a = true;
        }
        return this.a;
    }

    private int a() {
        try {
            return tL.a(this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    public void a(le le2, kT kT2) {
        this.a.a(le2, kT2);
    }

    public kT a(le le2) {
        return this.a.a(le2);
    }

    public Enumeration a() {
        return this.a.a();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(tW.a(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(tW.a(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(tW.a(byArray, i2, byArray.length - i2))).append(string);
        }
        oh oh2 = this.a.a().a();
        if (oh2 != null) {
            Enumeration enumeration = oh2.a();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                le le2 = (le)enumeration.nextElement();
                og og2 = oh2.a(le2);
                if (og2.a() != null) {
                    byte[] byArray2 = og2.a().c();
                    ko ko2 = new ko(byArray2);
                    stringBuffer.append("                       critical(").append(og2.a()).append(") ");
                    try {
                        if (le2.equals(oh.g)) {
                            stringBuffer.append(new nv((ku)ko2.a())).append(string);
                            continue;
                        }
                        if (le2.equals(oh.c)) {
                            stringBuffer.append(new nL((kP)ko2.a())).append(string);
                            continue;
                        }
                        if (le2.equals(lM.a)) {
                            stringBuffer.append(new lN((kP)ko2.a())).append(string);
                            continue;
                        }
                        if (le2.equals(lM.c)) {
                            stringBuffer.append(new lO((kZ)ko2.a())).append(string);
                            continue;
                        }
                        if (le2.equals(lM.i)) {
                            stringBuffer.append(new lP((kZ)ko2.a())).append(string);
                            continue;
                        }
                        stringBuffer.append(le2.a());
                        stringBuffer.append(" value = ").append(nn.a(ko2.a())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(le2.a());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = X509SignatureUtil.a(this.a.a());
        try {
            signature = Signature.getInstance(string, "BC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.a(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = X509SignatureUtil.a(this.a.a());
        Signature signature = Signature.getInstance(string2, string);
        this.a(publicKey, signature);
    }

    private void a(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.a.a().equals(this.a.a().a())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        kT kT2 = this.a.a().a();
        X509SignatureUtil.a(signature, kT2);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }
}

