/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.ExtCRLException;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.X509CRLEntryObject;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.X509SignatureUtil;
import com.zeroturnaround.javarebel.km;
import com.zeroturnaround.javarebel.ko;
import com.zeroturnaround.javarebel.kq;
import com.zeroturnaround.javarebel.kt;
import com.zeroturnaround.javarebel.ku;
import com.zeroturnaround.javarebel.la;
import com.zeroturnaround.javarebel.le;
import com.zeroturnaround.javarebel.lh;
import com.zeroturnaround.javarebel.nK;
import com.zeroturnaround.javarebel.nV;
import com.zeroturnaround.javarebel.nn;
import com.zeroturnaround.javarebel.nw;
import com.zeroturnaround.javarebel.nx;
import com.zeroturnaround.javarebel.nz;
import com.zeroturnaround.javarebel.og;
import com.zeroturnaround.javarebel.oh;
import com.zeroturnaround.javarebel.sR;
import com.zeroturnaround.javarebel.tW;
import com.zeroturnaround.javarebel.uu;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class X509CRLObject
extends X509CRL {
    private nz a;
    private String a;
    private byte[] a;
    private boolean a;

    public X509CRLObject(nz nz2) throws CRLException {
        this.a = nz2;
        try {
            this.a = X509SignatureUtil.a(nz2.a());
            this.a = (byte[])(nz2.a().a() != null ? ((km)nz2.a().a()).b() : null);
            this.a = this.a();
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.remove(RFC3280CertPathUtilities.d);
        set.remove(RFC3280CertPathUtilities.f);
        return !set.isEmpty();
    }

    private Set a(boolean bl2) {
        oh oh2;
        if (this.getVersion() == 2 && (oh2 = this.a.a().a()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = oh2.a();
            while (enumeration.hasMoreElements()) {
                le le2 = (le)enumeration.nextElement();
                og og2 = oh2.a(le2);
                if (bl2 != og2.a()) continue;
                hashSet.add(le2.a());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.a(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.a(false);
    }

    public byte[] getExtensionValue(String string) {
        og og2;
        oh oh2 = this.a.a().a();
        if (oh2 != null && (og2 = oh2.a(new le(string))) != null) {
            try {
                return og2.a().a();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        lh lh2 = new lh(byteArrayOutputStream);
        try {
            lh2.a(this.a);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "BC");
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.a.a().equals(this.a.a().a())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.a.a();
    }

    public Principal getIssuerDN() {
        return new sR(this.a.a());
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            kt kt2 = new kt(byteArrayOutputStream);
            kt2.a(this.a.a());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.a.a().a();
    }

    public Date getNextUpdate() {
        if (this.a.b() != null) {
            return this.a.b().a();
        }
        return null;
    }

    private Set a() {
        HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
        Enumeration enumeration = this.a.a();
        X500Principal x500Principal = this.getIssuerX500Principal();
        while (enumeration.hasMoreElements()) {
            nV nV2 = (nV)enumeration.nextElement();
            X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(nV2, this.a, x500Principal);
            hashSet.add(x509CRLEntryObject);
            x500Principal = x509CRLEntryObject.getCertificateIssuer();
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.a.a();
        X500Principal x500Principal = this.getIssuerX500Principal();
        while (enumeration.hasMoreElements()) {
            nV nV2 = (nV)enumeration.nextElement();
            X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(nV2, this.a, x500Principal);
            if (bigInteger.equals(nV2.a().a())) {
                return x509CRLEntryObject;
            }
            x500Principal = x509CRLEntryObject.getCertificateIssuer();
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.a();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.a.a().a("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.a.a().c();
    }

    public String getSigAlgName() {
        return this.a;
    }

    public String getSigAlgOID() {
        return this.a.a().a().a();
    }

    public byte[] getSigAlgParams() {
        if (this.a != null) {
            byte[] byArray = new byte[this.a.length];
            System.arraycopy(this.a, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(tW.a(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(tW.a(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(tW.a(byArray, i2, byArray.length - i2))).append(string);
        }
        oh oh2 = this.a.a().a();
        if (oh2 != null) {
            object2 = oh2.a();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (le)object2.nextElement();
                og og2 = oh2.a((le)object);
                if (og2.a() != null) {
                    byte[] byArray2 = og2.a().c();
                    ko ko2 = new ko(byArray2);
                    stringBuffer.append("                       critical(").append(og2.a()).append(") ");
                    try {
                        if (((kq)object).equals(oh.h)) {
                            stringBuffer.append(new nx(la.a(ko2.a()).b())).append(string);
                            continue;
                        }
                        if (((kq)object).equals(oh.l)) {
                            stringBuffer.append("Base CRL: " + new nx(la.a(ko2.a()).b())).append(string);
                            continue;
                        }
                        if (((kq)object).equals(oh.m)) {
                            stringBuffer.append(new nK((ku)ko2.a())).append(string);
                            continue;
                        }
                        if (((kq)object).equals(oh.p)) {
                            stringBuffer.append(new nw((ku)ko2.a())).append(string);
                            continue;
                        }
                        if (((kq)object).equals(oh.v)) {
                            stringBuffer.append(new nw((ku)ko2.a())).append(string);
                            continue;
                        }
                        stringBuffer.append(((le)object).a());
                        stringBuffer.append(" value = ").append(nn.a(ko2.a())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((le)object).a());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        nV[] nVArray = this.a.a();
        if (nVArray != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            for (int i2 = 0; i2 < nVArray.length; ++i2) {
                if (!nVArray[i2].a().a().equals(bigInteger)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a() throws CRLException {
        byte[] byArray = this.getExtensionValue(oh.m.a());
        boolean bl2 = false;
        try {
            if (byArray != null) {
                bl2 = nK.a(uu.a(byArray)).c();
            }
        }
        catch (Exception exception) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", exception);
        }
        return bl2;
    }
}

