/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.javarebel.ku;
import com.zeroturnaround.javarebel.lb;
import com.zeroturnaround.javarebel.mf;
import com.zeroturnaround.javarebel.nP;
import com.zeroturnaround.javarebel.nS;
import com.zeroturnaround.javarebel.no;
import com.zeroturnaround.javarebel.sx;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

public class JCERSAPublicKey
implements RSAPublicKey {
    static final long serialVersionUID = 2675817738516720772L;
    private BigInteger a;
    private BigInteger b;

    JCERSAPublicKey(sx sx2) {
        this.a = sx2.a();
        this.b = sx2.b();
    }

    JCERSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        this.a = rSAPublicKeySpec.getModulus();
        this.b = rSAPublicKeySpec.getPublicExponent();
    }

    JCERSAPublicKey(RSAPublicKey rSAPublicKey) {
        this.a = rSAPublicKey.getModulus();
        this.b = rSAPublicKey.getPublicExponent();
    }

    JCERSAPublicKey(nS nS2) {
        try {
            nP nP2 = new nP((ku)nS2.c());
            this.a = nP2.a();
            this.b = nP2.b();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
    }

    public BigInteger getModulus() {
        return this.a;
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        nS nS2 = new nS(new no(mf.g_, new lb()), new nP(this.getModulus(), this.getPublicExponent()).a());
        return nS2.b();
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        return this.getModulus().equals(rSAPublicKey.getModulus()) && this.getPublicExponent().equals(rSAPublicKey.getPublicExponent());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("RSA Public Key").append(string);
        stringBuffer.append("            modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuffer.append("    public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

