/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.RGBImageObject;
import UIMGPKG.TVIcon;
import UIMGPKG.ThumbnailPanelIF;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JPanel;

class ThumbnailView
implements MouseListener {
    ThumbnailPanelIF tpanel;
    int h = 0;
    int w = 0;
    int TotalW;
    int TotalH;
    int wtab = 16;
    int htab = 16;
    int iBackGroundColor = 0xFFFFFF;
    LinkedList TVIconList = new LinkedList();

    ThumbnailView(int wt, int ht, int wl, int hl) {
        this.TotalW = wt;
        this.TotalH = ht;
        this.w = wl;
        this.h = hl;
    }

    public void Repaint() {
        this.tpanel.Repaint();
    }

    int SetThumbnailPanel(ThumbnailPanelIF tpl) {
        this.tpanel = tpl;
        JPanel jp1 = (JPanel)((Object)this.tpanel);
        jp1.addMouseListener(this);
        return 0;
    }

    public synchronized void AddBGRArray(RGBImageObject imageObject) {
        this.TVIconList.add(new TVIcon(this.htab, this.wtab, imageObject, this.tpanel));
        this.RenderOneThumbnail(this.TVIconList.size());
    }

    private void RenderOneThumbnail(int index) {
        int maxwah = Math.max(this.w, this.h);
        int BGRLen = this.TVIconList.size();
        if (BGRLen == 0) {
            return;
        }
        int column = this.TotalW / (maxwah + this.wtab);
        System.out.println(column);
        if (this.TotalW % (maxwah + this.wtab) < this.wtab) {
            --column;
        }
        int row = BGRLen / column;
        if (BGRLen % column != 0) {
            ++row;
        }
        int tmpr = maxwah + this.wtab;
        int i = index / column;
        int j = index - i * column;
        int tmpq = i * maxwah;
        int tmpp = i * this.htab + this.htab;
        if (i * column + j >= BGRLen) {
            return;
        }
        int p = j * tmpr + this.wtab;
        int q = tmpq + tmpp;
        if (i == 0) {
            q = this.htab;
        }
        if (j == 0) {
            p = this.wtab;
        }
        if (p + maxwah + this.wtab > this.TotalW) {
            return;
        }
        if (q + maxwah + this.htab > this.TotalH) {
            return;
        }
        ((TVIcon)this.TVIconList.get(column * i + j)).PaintView(p, q);
    }

    public void RenderThumbnail() {
        int maxwah = Math.max(this.w, this.h);
        int BGRLen = this.TVIconList.size();
        if (BGRLen == 0) {
            return;
        }
        int column = this.TotalW / (maxwah + this.wtab);
        System.out.println(column);
        if (this.TotalW % (maxwah + this.wtab) < this.wtab) {
            --column;
        }
        int row = BGRLen / column;
        if (BGRLen % column != 0) {
            ++row;
        }
        this.tpanel.SetWaHValue(this.TotalW, this.TotalH);
        this.tpanel.DrawBlackArea();
        int tmpr = maxwah + this.wtab;
        int i = 0;
        while (i < row) {
            int tmpq = i * maxwah;
            int tmpp = i * this.htab + this.htab;
            int j = 0;
            while (j < column) {
                if (i * column + j >= BGRLen) break;
                int p = j * tmpr + this.wtab;
                int q = tmpq + tmpp;
                if (i == 0) {
                    q = this.htab;
                }
                if (j == 0) {
                    p = this.wtab;
                }
                if (p + maxwah + this.wtab <= this.TotalW && q + maxwah + this.htab <= this.TotalH) {
                    ((TVIcon)this.TVIconList.get(column * i + j)).PaintView(p, q);
                }
                ++j;
            }
            ++i;
        }
    }

    public void SetThumbnailWValue(int w1) {
        this.w = w1;
    }

    public void SetThumbnailHValue(int h1) {
        this.h = h1;
    }

    public void SetTotalWValue(int w1) {
        this.TotalW = w1;
    }

    public void SetTotalHValue(int h1) {
        this.TotalH = h1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        int x = e.getX();
        int y = e.getY();
        int q = 0;
        while (q < this.TVIconList.size()) {
            TVIcon tvc = (TVIcon)this.TVIconList.get(q);
            if (tvc.IsThPointMe(x, y)) {
                tvc.ClickEvent();
            }
            ++q;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

