/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.ImgFileLoader;
import UIMGPKG.RGBArray;
import UIMGPKG.RGBImageObject;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class JpegLoader
implements ImgFileLoader {
    JpegLoader() {
    }

    @Override
    public RGBArray OpenFile(String filename) throws IOException {
        File f = new File(filename);
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream(f));
        BufferedImage image = decoder.decodeAsBufferedImage();
        int w = image.getWidth();
        int h = image.getHeight();
        RGBArray imgary = new RGBArray(w, h);
        int tmp = w * h - w;
        int j = 0;
        while (j < h) {
            int q = tmp - j * w;
            int i = 0;
            while (i < w) {
                int p = q + i;
                int gbr = image.getRGB(i, j);
                imgary.b[p] = gbr & 0xFF;
                imgary.g[p] = (gbr & 0xFF00) >> 8;
                imgary.r[p] = (gbr & 0xFF0000) >> 16;
                ++i;
            }
            ++j;
        }
        return imgary;
    }

    @Override
    public int SaveFile(byte[] header, RGBArray imgarray, String filename) throws IOException {
        File f = new File(filename);
        RGBImageObject uip1 = new RGBImageObject();
        uip1.LoadFromRGBArray(imgarray);
        int h = imgarray.height;
        int w = imgarray.width;
        BufferedImage image2 = new BufferedImage(w, h, 8);
        int j = 0;
        while (j < h) {
            int zu = h - j - 1;
            int q = j * w;
            int i = 0;
            while (i < w) {
                int r;
                int p = q + i;
                int b = uip1.GetValue('b', p);
                int g = uip1.GetValue('g', p);
                int gbr = r = uip1.GetValue('r', p);
                gbr <<= 8;
                gbr |= g;
                gbr <<= 8;
                gbr |= b;
                image2.setRGB(i, zu, gbr |= 0xFF000000);
                ++i;
            }
            ++j;
        }
        FileOutputStream sos = new FileOutputStream(f);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)sos);
        encoder.encode(image2);
        return 0;
    }
}

