/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.HistorGram;
import UIMGPKG.ImageObject;
import UIMGPKG.ImageOpertaor;
import UIMGPKG.ImgProcess;
import UIMGPKG.RGBArray;
import UIMGPKG.RGBImageObject;
import UIMGPKG.TransFunc;

class ImageProcessMachine
extends ImageOpertaor
implements ImgProcess {
    private TransFunc tranfunc1;
    private HistorGram hg1;

    ImageProcessMachine(ImageObject ioi1) {
        super(ioi1);
        this.OpenImgObj(ioi1);
        this.tranfunc1 = new TransFunc();
        this.hg1 = new HistorGram(ioi1.GetWValue(), ioi1.GetHValue());
        this.hg1.DoImageHistorGram((RGBImageObject)this.GetBackImageObject());
    }

    int[] GetImageStream() {
        return this.imgObj1.GetImageBGRStream();
    }

    int DoTemperature() {
        int i = 0;
        int[] q = this.hg1.DoImageHistorGram((RGBImageObject)this.GetBackImageObject());
        int z = (q[0] + q[1] + q[2]) / 3;
        do {
            int min;
            int max;
            if (q[0] > q[1]) {
                if (q[0] > q[2]) {
                    max = 0;
                    min = q[1] > q[2] ? 2 : 1;
                } else {
                    min = 1;
                    max = 2;
                }
            } else if (q[1] > q[2]) {
                max = 1;
                min = q[0] > q[2] ? 2 : 0;
            } else {
                max = 2;
                min = 0;
            }
            if (max == 0) {
                this.DoImageAdjustRGBBz('b', 0);
            } else if (max == 1) {
                this.DoImageAdjustRGBBz('g', 0);
            } else {
                this.DoImageAdjustRGBBz('r', 0);
            }
            if (min == 0) {
                this.DoImageAdjustRGBBz('b', 1);
            } else if (min == 1) {
                this.DoImageAdjustRGBBz('g', 1);
            } else {
                this.DoImageAdjustRGBBz('r', 1);
            }
            q = this.hg1.DoImageHistorGram((RGBImageObject)this.GetBackImageObject());
        } while (++i < 10);
        return 1;
    }

    @Override
    public void doGaussBlur() {
        double[] Normalidx = new double[]{0.0111, 0.1353, 0.6065, 1.0, 0.0, 6065.0, 0.1353, 0.0111};
        double sum = 3.08;
        double tmp = 0.0;
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                if (x >= 4 && x <= this.w - 5) {
                    tmp = Normalidx[0] * (double)this.bA[index1 - 3] + Normalidx[1] * (double)this.bA[index1 - 2] + Normalidx[2] * (double)this.bA[index1 - 1];
                    tmp += Normalidx[4] * (double)this.bA[index1 + 1] + Normalidx[5] * (double)this.bA[index1 + 2] + Normalidx[6] * (double)this.bA[index1 + 3];
                    tmp += (double)this.bA[index1] * Normalidx[3];
                    this.bA[index1] = (int)(tmp /= sum);
                    tmp = Normalidx[0] * (double)this.gA[index1 - 3] + Normalidx[1] * (double)this.gA[index1 - 2] + Normalidx[2] * (double)this.gA[index1 - 1];
                    tmp += Normalidx[4] * (double)this.gA[index1 + 1] + Normalidx[5] * (double)this.gA[index1 + 2] + Normalidx[6] * (double)this.gA[index1 + 3];
                    tmp += (double)this.gA[index1] * Normalidx[3];
                    this.gA[index1] = (int)(tmp /= sum);
                    tmp = Normalidx[0] * (double)this.rA[index1 - 3] + Normalidx[1] * (double)this.rA[index1 - 2] + Normalidx[2] * (double)this.rA[index1 - 1];
                    tmp += Normalidx[4] * (double)this.rA[index1 + 1] + Normalidx[5] * (double)this.rA[index1 + 2] + Normalidx[6] * (double)this.rA[index1 + 3];
                    tmp += (double)this.rA[index1] * Normalidx[3];
                    this.rA[index1] = (int)(tmp /= sum);
                }
                ++x;
            }
            ++y;
        }
    }

    int doAWB(int Qr, int Qg, int Qb, int qGray) {
        int aqr = 0;
        int aqg = 1;
        int aqb = 1;
        double nAb = 0.0;
        double nAr = 0.0;
        double nAg = 0.2;
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                this.bA[index1] = this.tranfunc1.YEQZX(this.bA[index1], nAb, aqb);
                this.rA[index1] = this.tranfunc1.YEQZX(this.rA[index1], nAr, aqr);
                this.gA[index1] = this.tranfunc1.YEQZX(this.gA[index1], nAg, aqg);
                ++x;
            }
            ++y;
        }
        return 0;
    }

    public void DoImageAdjustRGBBz(char cmd, int act) {
        int aq = act;
        int[] bChannel = null;
        if (act == 1) {
            this.tranfunc1.BezCurveInitial(-0.06);
        } else {
            this.tranfunc1.BezCurveInitial(0.06);
        }
        if (cmd == 'r') {
            bChannel = this.rA;
        } else if (cmd == 'g') {
            bChannel = this.gA;
        } else if (cmd == 'b') {
            bChannel = this.bA;
        } else if (cmd != 'l') {
            return;
        }
        if (cmd == 'l') {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    int index1 = y * this.w + x;
                    this.bA[index1] = this.tranfunc1.BezCurveValue(this.bA[index1]);
                    this.rA[index1] = this.tranfunc1.BezCurveValue(this.rA[index1]);
                    this.gA[index1] = this.tranfunc1.BezCurveValue(this.gA[index1]);
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    bChannel[y * this.w + x] = this.tranfunc1.BezCurveValue(bChannel[y * this.w + x]);
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public void DoImageAdjustRGB(char cmd, int act) {
        int aq = act;
        double nA = 0.03;
        int[] bChannel = null;
        if (cmd == 'r') {
            bChannel = this.rA;
        } else if (cmd == 'g') {
            bChannel = this.gA;
        } else if (cmd == 'b') {
            bChannel = this.bA;
        } else if (cmd != 'l') {
            return;
        }
        if (cmd == 'l') {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    int index1 = y * this.w + x;
                    this.bA[index1] = this.tranfunc1.YEQZX(this.bA[index1], nA, aq);
                    this.rA[index1] = this.tranfunc1.YEQZX(this.rA[index1], nA, aq);
                    this.gA[index1] = this.tranfunc1.YEQZX(this.gA[index1], nA, aq);
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    bChannel[y * this.w + x] = this.tranfunc1.YEQZX(bChannel[y * this.w + x], nA, aq);
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public void DoSinagleColor(char hc) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (hc != 'r') break block8;
                        int y = 0;
                        while (y < this.h) {
                            int x = 0;
                            while (x < this.w) {
                                int index1 = y * this.w + x;
                                this.bA[index1] = 0;
                                this.gA[index1] = 0;
                                ++x;
                            }
                            ++y;
                        }
                        break block9;
                    }
                    if (hc != 'g') break block10;
                    int y = 0;
                    while (y < this.h) {
                        int x = 0;
                        while (x < this.w) {
                            int index1 = y * this.w + x;
                            this.bA[index1] = 0;
                            this.rA[index1] = 0;
                            ++x;
                        }
                        ++y;
                    }
                    break block9;
                }
                if (hc != 'b') break block11;
                int y = 0;
                while (y < this.h) {
                    int x = 0;
                    while (x < this.w) {
                        int index1 = y * this.w + x;
                        this.gA[index1] = 0;
                        this.rA[index1] = 0;
                        ++x;
                    }
                    ++y;
                }
                break block9;
            }
            if (hc != 'w') break block9;
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    int index1 = y * this.w + x;
                    int z = this.bA[index1] + this.gA[index1] + this.rA[index1];
                    this.gA[index1] = this.rA[index1] = (z /= 3);
                    this.bA[index1] = this.rA[index1];
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public void DoImageInverseRGB() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                this.bA[index1] = 255 - this.bA[index1] & 0xFF;
                this.rA[index1] = 255 - this.rA[index1] & 0xFF;
                this.gA[index1] = 255 - this.gA[index1] & 0xFF;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void DoGrayWall() {
        int tmp1 = 0;
        int add = 200;
        int sub = 100;
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                int tmp = this.bA[index1] + this.rA[index1] + this.gA[index1];
                if ((tmp /= 3) > tmp1 - 70) {
                    int t = add;
                    add = sub;
                    sub = t;
                }
                this.rA[index1] = this.gA[index1] = add;
                this.bA[index1] = this.gA[index1];
                tmp1 = tmp;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void DoEqulize() {
        this.hg1.DoImageHistorGram((RGBImageObject)this.GetBackImageObject());
        int[] rh = new int[256];
        int total = 0;
        int z = 0;
        while (z < 256) {
            total += this.hg1.GetRHistogram(z);
            total += this.hg1.GetGHistogram(z);
            total += this.hg1.GetBHistogram(z);
            ++z;
        }
        int subtotal = 0;
        z = 0;
        while (z < 256) {
            subtotal += this.hg1.GetRHistogram(z);
            subtotal += this.hg1.GetGHistogram(z);
            rh[z] = (subtotal += this.hg1.GetBHistogram(z)) * 256 / total;
            ++z;
        }
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                this.rA[index1] = rh[this.rA[index1]];
                this.gA[index1] = rh[this.gA[index1]];
                this.bA[index1] = rh[this.bA[index1]];
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void DoBlur() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                if (x == 0) {
                    this.bA[index1] = (this.bA[index1] + this.bA[index1 + 1]) / 2;
                    this.gA[index1] = (this.gA[index1] + this.gA[index1 + 1]) / 2;
                    this.rA[index1] = (this.rA[index1] + this.rA[index1 + 1]) / 2;
                } else if (x == this.w - 1) {
                    this.bA[index1] = (this.bA[index1] + this.bA[index1 - 1]) / 2;
                    this.gA[index1] = (this.gA[index1] + this.gA[index1 - 1]) / 2;
                    this.rA[index1] = (this.rA[index1] + this.rA[index1 - 1]) / 2;
                } else {
                    this.bA[index1] = (this.bA[index1 - 1] + this.bA[index1] + this.bA[index1 + 1]) / 3;
                    this.gA[index1] = (this.gA[index1 - 1] + this.gA[index1] + this.gA[index1 + 1]) / 3;
                    this.rA[index1] = (this.rA[index1 - 1] + this.rA[index1] + this.rA[index1 + 1]) / 3;
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void DoContrast() {
        boolean state = true;
        boolean preindex = false;
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                if (x < 2 || x > this.w - 3 || y != this.h - 1) {
                    // empty if block
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void DoEdge() {
        RGBArray array22 = new RGBArray(this.w, this.h);
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                if (x == this.w - 1) {
                    array22.b[index1] = 0;
                } else {
                    int sum = Math.abs(this.bA[index1 + 1] - this.bA[index1]);
                    sum += Math.abs(this.gA[index1 + 1] - this.gA[index1]);
                    sum += Math.abs(this.rA[index1 + 1] - this.rA[index1]);
                    int sum2 = 0;
                    if (y < this.h - 2) {
                        sum2 = Math.abs(this.bA[index1 + this.w] - this.bA[index1]);
                        sum2 += Math.abs(this.gA[index1 + this.w] - this.gA[index1]);
                        sum2 += Math.abs(this.rA[index1 + this.w] - this.rA[index1]);
                    }
                    array22.b[index1] = (sum = Math.max(sum, sum2)) > 100 ? 255 : (sum > 80 ? 160 : (sum > 60 ? 96 : (sum > 40 ? 64 : (sum > 20 ? 32 : 0))));
                    array22.g[index1] = 0;
                    array22.r[index1] = 0;
                }
                ++x;
            }
            ++y;
        }
        this.imgObj1.SetImageArray(array22);
    }
}

