/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.GraphicOperator;
import UIMGPKG.ImageObject;
import UIMGPKG.ImageOpertaor;
import UIMGPKG.RGBArray;

class ImageGraphicsRuler
extends ImageOpertaor
implements GraphicOperator {
    ImageGraphicsRuler() {
    }

    @Override
    int OpenImgObj(ImageObject ioi1) {
        return super.OpenImgObj(ioi1);
    }

    ImageGraphicsRuler(ImageObject ioi1) {
        super(ioi1);
    }

    @Override
    public int FlipImg() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w / 2) {
                int index1 = y * this.w + x;
                int index2 = y * this.w + this.w - x - 1;
                int tmp = this.rA[index1];
                this.rA[index1] = this.rA[index2];
                this.rA[index2] = tmp;
                tmp = this.gA[index1];
                this.gA[index1] = this.gA[index2];
                this.gA[index2] = tmp;
                tmp = this.bA[index1];
                this.bA[index1] = this.bA[index2];
                this.bA[index2] = tmp;
                ++x;
            }
            ++y;
        }
        return 0;
    }

    @Override
    public int scaleimage(double rw, double rh) {
        int w = (int)((double)this.imgObj1.GetWValue() * rw);
        int h = (int)((double)this.imgObj1.GetHValue() * rh);
        RGBArray target = new RGBArray(w, h);
        RGBArray r2 = this.imgObj1.GetImageArray();
        r2.Scale(target);
        this.imgObj1.SetImageArray(target);
        this.InitialNewImgObj();
        return 0;
    }

    @Override
    public int Rotate(int drgree) {
        int neww = this.h;
        int newh = this.w;
        RGBArray target = new RGBArray(neww, newh);
        int[] rt = target.r;
        int[] gt = target.g;
        int[] bt = target.b;
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int index1 = y * this.w + x;
                int index2 = this.h - y - 1 + x * neww;
                rt[index2] = this.rA[index1];
                gt[index2] = this.gA[index1];
                bt[index2] = this.bA[index1];
                ++x;
            }
            ++y;
        }
        this.imgObj1.SetImageArray(target);
        this.InitialNewImgObj();
        return 0;
    }

    @Override
    public int CircleImg(double degree) {
        double centerX = this.w / 2;
        double centerY = this.h / 2;
        int newW = (int)((double)this.imgObj1.GetReservedImageArray().width * 1.1);
        int newH = (int)((double)this.imgObj1.GetReservedImageArray().height * 1.1);
        RGBArray target = new RGBArray(newW, newH);
        int[] rt = target.r;
        int[] gt = target.g;
        int[] bt = target.b;
        double y = 0.0;
        while (y < (double)this.h) {
            double x = 0.0;
            while (x < (double)this.w) {
                double Rlen = Math.sqrt((x - centerX) * (x - centerX) + (y - centerY) * (y - centerY));
                double theata = Math.atan((centerX - x) / (centerY - y));
                if (y < centerY) {
                    theata += Math.PI;
                }
                double diffX = Rlen * Math.sin(theata);
                double diffY = Rlen * Math.cos(theata);
                double oldX = centerX + diffX;
                if (oldX >= (double)this.w) {
                    oldX = this.w - 1;
                } else if (oldX < 0.0) {
                    oldX = 0.0;
                }
                double oldY = centerY + diffY;
                if (oldY >= (double)this.h) {
                    oldY = this.h - 1;
                } else if (oldY < 0.0) {
                    oldY = 0.0;
                }
                int index1 = (int)((double)(newH / 2 - this.h / 2) + y) * newW + (int)(x + (double)(newW / 2) - (double)(this.w / 2));
                int index2 = (int)oldX + (int)oldY * this.w;
                if (x != (double)(this.w - 1)) {
                    rt[index1] = (this.rA[index2] + this.rA[index2 + 1]) / 2;
                    gt[index1] = (this.gA[index2] + this.gA[index2 + 1]) / 2;
                    bt[index1] = (this.bA[index2] + this.bA[index2]) / 2;
                } else {
                    rt[index1] = this.rA[index2];
                    gt[index1] = this.gA[index2];
                    bt[index1] = this.bA[index2];
                }
                x += 1.0;
            }
            y += 1.0;
        }
        this.imgObj1.SetImageArray(target);
        this.InitialNewImgObj();
        return 0;
    }

    @Override
    public int Crop(int x0, int y0, int w4, int h4) {
        RGBArray target = new RGBArray(w4, h4);
        int[] rt = target.r;
        int[] gt = target.g;
        int[] bt = target.b;
        int q = 0;
        while (q < h4) {
            int p = 0;
            while (p < w4) {
                int index1 = (q + y0) * this.w + p + x0;
                int index2 = w4 * q + p;
                rt[index2] = this.rA[index1];
                gt[index2] = this.gA[index1];
                bt[index2] = this.bA[index1];
                ++p;
            }
            ++q;
        }
        this.imgObj1.SetImageArray(target);
        return 0;
    }
}

