/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.RGBImageObject;

class HistorGram {
    int w;
    int h;
    int[] RHistogram;
    int[] GHistogram;
    int[] BHistogram;

    HistorGram(int i, int j) {
        this.w = i;
        this.h = j;
        this.InitialHistogram();
    }

    public int InitialHistogram() {
        this.GHistogram = new int[256];
        this.BHistogram = new int[256];
        this.RHistogram = new int[256];
        return 0;
    }

    public int GetRHistogram(int index) {
        return this.RHistogram[index];
    }

    public int GetGHistogram(int index) {
        return this.GHistogram[index];
    }

    public int GetBHistogram(int index) {
        return this.BHistogram[index];
    }

    public void doHistorGram(int[] a, int[] b) {
        int q = 0;
        while (q < 256) {
            b[q] = 0;
            ++q;
        }
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                int n = a[y * this.w + x];
                b[n] = b[n] + 1;
                ++x;
            }
            ++y;
        }
    }

    int[] DoImageHistorGram(RGBImageObject io1) {
        int Qr = 0;
        int Qg = 0;
        int Qb = 0;
        int[] q = new int[3];
        int[] rA = io1.GetRChannel();
        int[] gA = io1.GetGChannel();
        int[] bA = io1.GetBChannel();
        this.doHistorGram(rA, this.RHistogram);
        this.doHistorGram(gA, this.GHistogram);
        this.doHistorGram(bA, this.BHistogram);
        int rrsum = 0;
        int p = 0;
        while (p < 256) {
            Qr += this.RHistogram[p] * p;
            Qg += this.GHistogram[p] * p;
            Qb += this.BHistogram[p] * p;
            rrsum += p;
            ++p;
        }
        q[0] = Qb /= rrsum;
        q[1] = Qg /= rrsum;
        q[2] = Qr /= rrsum;
        return q;
    }
}

