/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.ImgFileLoader;
import UIMGPKG.RGBArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class BitmapLoader
implements ImgFileLoader {
    private RGBArray imagearray;
    private byte[] BmpFileHeader;
    private static byte[] BmpFileHeaderTemplate;
    private int w = 130;
    private int h = 173;
    private FileInputStream fis = null;
    private File f = null;
    private int blacklinebytenum;
    private int[] rA;
    private int[] gA;
    private int[] bA;

    static {
        byte[] byArray = new byte[54];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[2] = 54;
        byArray[3] = 68;
        byArray[4] = 8;
        byArray[10] = 54;
        byArray[14] = 40;
        byArray[26] = 1;
        byArray[28] = 24;
        BmpFileHeaderTemplate = byArray;
    }

    BitmapLoader() {
    }

    @Override
    public RGBArray OpenFile(String filename) throws IOException {
        this.BmpFileHeader = new byte[54];
        if (filename == "") {
            return null;
        }
        this.f = new File(filename);
        this.fis = new FileInputStream(this.f);
        this.fis.read(this.BmpFileHeader, 0, 54);
        byte w1 = this.BmpFileHeader[19];
        byte h1 = this.BmpFileHeader[23];
        int w0 = this.BmpFileHeader[18] >= 0 ? this.BmpFileHeader[18] : this.BmpFileHeader[18] + 256;
        int h0 = this.BmpFileHeader[22] >= 0 ? this.BmpFileHeader[22] : this.BmpFileHeader[22] + 256;
        this.w = w0 + 256 * w1;
        this.h = h0 + 256 * h1;
        this.imagearray = new RGBArray(this.w, this.h);
        long b = this.f.length();
        double zh = (b - 54L - (long)(this.w * this.h * 3)) / (long)this.h;
        this.blacklinebytenum = zh > 2.5 ? 3 : (zh > 1.5 ? 2 : (zh > 0.5 ? 1 : 0));
        this.rA = new int[this.w * this.h];
        this.gA = new int[this.w * this.h];
        this.bA = new int[this.w * this.h];
        boolean index = false;
        boolean r = false;
        boolean g = false;
        boolean bp = false;
        int tmpindex1 = 0;
        int tmpindex2 = 0;
        int y = 0;
        while (y < this.h) {
            tmpindex2 = y * this.w;
            int x = 0;
            while (x < this.w) {
                tmpindex1 = tmpindex2 + x;
                this.bA[tmpindex1] = this.fis.read();
                this.gA[tmpindex1] = this.fis.read();
                this.rA[tmpindex1] = this.fis.read();
                ++x;
            }
            this.fis.skip(this.blacklinebytenum);
            ++y;
        }
        this.imagearray.b = this.bA;
        this.imagearray.g = this.gA;
        this.imagearray.r = this.rA;
        return this.imagearray;
    }

    @Override
    public int SaveFile(byte[] header, RGBArray imgarray, String filename) throws IOException {
        FileOutputStream fos = null;
        boolean r = false;
        boolean g = false;
        boolean bp = false;
        int tmpindex1 = 0;
        this.BmpFileHeader = header;
        this.bA = imgarray.b;
        this.rA = imgarray.r;
        this.gA = imgarray.g;
        this.BmpFileHeader[21] = (byte)(imgarray.width >> 24);
        this.BmpFileHeader[20] = (byte)(imgarray.width >> 16);
        this.BmpFileHeader[19] = (byte)(imgarray.width >> 8);
        this.BmpFileHeader[18] = (byte)imgarray.width;
        this.BmpFileHeader[25] = (byte)(imgarray.height >> 24);
        this.BmpFileHeader[24] = (byte)(imgarray.height >> 16);
        this.BmpFileHeader[23] = (byte)(imgarray.height >> 8);
        this.BmpFileHeader[22] = (byte)imgarray.height;
        this.w = imgarray.width;
        this.h = imgarray.height;
        File gf = new File(filename);
        fos = new FileOutputStream(gf);
        fos.write(this.BmpFileHeader, 0, 54);
        int tmpu = 0;
        int y = 0;
        while (y < this.h) {
            tmpu = y * this.w;
            int x = 0;
            while (x < this.w) {
                try {
                    tmpindex1 = tmpu + x;
                    fos.write(this.bA[tmpindex1]);
                    fos.write(this.gA[tmpindex1]);
                    fos.write(this.rA[tmpindex1]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++x;
            }
            if (this.blacklinebytenum > 0) {
                int k = 0;
                while (k < this.blacklinebytenum) {
                    fos.write(0);
                    ++k;
                }
            }
            ++y;
        }
        fos.close();
        return 0;
    }

    private int InitialHeader() {
        this.BmpFileHeader = new byte[54];
        int i = 0;
        while (i < 54) {
            this.BmpFileHeader[i] = BmpFileHeaderTemplate[i];
            ++i;
        }
        return 0;
    }

    byte[] GetBmpFileHeader() {
        return this.BmpFileHeader;
    }

    int GetBlackLineCount() {
        return this.blacklinebytenum;
    }

    int SetBlackLineCount(int count) {
        this.blacklinebytenum = count;
        return this.blacklinebytenum;
    }
}

