/*
 * Decompiled with CFR 0.152.
 */
package UIMGPKG;

import UIMGPKG.POINT;

class BCurveTwoDim {
    POINT p0;
    POINT p1;
    POINT p2;
    double t;
    double a;
    double b;
    double c;

    BCurveTwoDim(POINT a0, POINT a1, POINT a2) {
        this.p0 = new POINT(a0);
        this.p1 = new POINT(a1);
        this.p2 = new POINT(a2);
        this.a = this.p2.x - 2.0 * this.p1.x - this.p0.x;
        this.b = 2.0 * (this.p1.x - this.p0.x);
    }

    double BCurve2Dim(double x) {
        if (x == this.p0.x) {
            return this.p0.y;
        }
        if (x == this.p1.x) {
            return this.p1.y;
        }
        if (x == this.p2.x) {
            return this.p2.y;
        }
        this.c = this.p0.x - x;
        double ta = -1.0 * this.b / (2.0 * this.a);
        double tb = Math.sqrt(this.b * this.b - 4.0 * this.a * this.c) / (2.0 * this.a);
        this.t = ta + tb;
        if (this.t > 1.0 || this.t < 0.0) {
            this.t = ta - tb;
        }
        double By = (1.0 - this.t * this.t) * this.p0.y + 2.0 * this.t * (1.0 - this.t) * this.p1.y + this.t * this.t * this.p2.y;
        return By;
    }
}

