var c = new Array();
strBreadCrumbsTocIds = "";
strCurrentTocId = ""; // 現在ページのID
strCurrentChapterId = "";
from = ""; // document.referrerの代替（IE10はセキュリティー観点で使用できない）
var strPathPlus = 'x4';
var scrolling;
var scroll_top = 1;
var scroll_left = 0;
var contents_scroll_top;
var toc_scroll_top;
window.setTimeout(function() {
	window.onLoad = start();
}, 500);
function start() {
	try {

		// レイアウトモードをセッションストレージから取得
		var stored_layout_mode = fncGetLayoutMode();

		// PCモードをモバイル端末で表示した場合のデバイス回転時調整
		if (stored_layout_mode == "pc") {
			if (device.mobile() || device.tablet()) { // NOTE: ie8で「typeof window.orientation」がエラー
				if (typeof window.orientation === 'undefined') { // NOTE: orientationchange does not work in mobile ff
				} else {
					$(window).bind("orientationchange", function() {
						if (device.android()) {
							//var ti = setTimeout(adjust, 500); // NOTE: android stdだと回転前の高さが取得されてしまう 100だと早すぎる
							//function adjust() {
							document.location.reload(true); // NOTE: galaxy s3 stdで回転のたびにズームが働き、3回程度の回転でレイアウトが破たんする現象を回避するため、リロードにてレイアウトリセット（旧Androidでは処理不要だが分類が困難なのでAndroidの場合は一律処理）
							//}
						} else {
							fncOnResize(); 
						}
					});
				}

				// ビューポートの設定
				var meta = document.createElement("meta");
				meta.setAttribute("name", "viewport");
				if (device.mobile()) {
					meta.setAttribute("content", "width=device-width, maximum-scale=0.5, minimum-scale=0.5, initial-scale=0.5, user-scalable=yes");
				} else {
					meta.setAttribute("content", "width=device-width, maximum-scale=1.0, minimum-scale=1.0, initial-scale=1.0, user-scalable=yes");
				}
				document.getElementsByTagName("head")[0].appendChild(meta);
			}
		}

		// 初回アクセス時は現在の値を書き込み
		if (!fncGetSessionStorage('from')) {
			from = document.location.href;
		} else {

			// ストレージから前回ページを取得
			from = fncGetSessionStorage('from');
		}

		// 現在のページをストレージに書き込み
		fncSetSessionStorage('from', document.location.href);

		// resource.jsonのconstantでlang_codeが指定されている場合はドキュメントの言語属性を上書き
		// 例：
		// var constant = [
		// {
		// lang_code:		"zh-CN",
		// :
		var strLangCode = fncGetConstantByName("lang_code");
		if (strLangCode) {
			document.body.lang = strLangCode;
		}

		// CSS情報
		var objLink = document.getElementsByTagName("link");
		var nLinkLength = objLink.length;
		var strStyleNumber = "";

		// h1内のアンカーとしての<a>だけを絶対配置に指定
		$('#id_content h1 a, #id_content div.h1 a').each(function() {
			if ($(this).html() == "") {
				$(this).css("position", "absolute");
			}
		});

		// アンカーをタグの先頭に移動（GCでジャンプ時に隠れる現象を回避）
		if (strWindowType != 'HOME_TOC') {
			$('#id_content a').each(function() {
				if ($(this).html() == "") {
					$(this).get(0).parentNode.insertBefore($(this).get(0), $(this).get(0).parentNode.firstChild)
				}
			});
		}

		// index.htmlから起動していない場合、ウィンドウ名を復活させる
		// （お気に入りに登録された場合や、コンテンツHTMLを直接表示させた場合）
		if (window.name == "") {
			window.name = "canon_main_window";
		}

		// 通常のCSSをロード
		for (var i = 0; i < nLinkLength; i++) {
			if (objLink[i].href.indexOf("frame_style.css") != -1) {
				objLink[i].disabled = false;
			}
			if (objLink[i].href.indexOf("frame_sub.css") != -1) {
				objLink[i].disabled = true;
			}

			// スタイル番号を取得
			if (objLink[i].href.indexOf("styles/style") != -1) {

				// NOTE: hrefはIEでは相対パス、その他では絶対パスで取得される
				var arrStyleNumberPath = objLink[i].href.split("/");
				if (arrStyleNumberPath.length > 2) {
					strStyleNumber = arrStyleNumberPath[arrStyleNumberPath.length - 2];
					if (strStyleNumber != "") {
						strStyleNumber += "_";
					}
				}
			}
		}

		// 活用集のスタイリング
		if (document.location.search.indexOf("?theme=yes") != -1) {
			try {

				// 不要要素の削除
				$('#id_header, #id_panel, #id_breadcrumbs, #id_document_number').hide();

				$('div#id_content').wrap('<div class="page"><div class="center"><div id="id_right" class="right"></div></div></div>');

				// スタイル調整
				$('html').css('background', "url(../images/theme-center-bg.png) repeat-y center 0"); // コンテンツ領域のドロップシャドウは背景画像で表現
				$('html').css('overflow-x', 'hidden'); // ブラウザー間で横スクロールが発生する閾値が異なるため横スクロールを除去
				$('html').css('overflow-y', 'scroll'); // ブラウザー間で横スクロールが発生する閾値が異なるため横スクロールを除去
				$('body').css('cssText', 'background: transparent!important'); // ie8で背景色をグレーにしている処理を打消し
				$('div#id_content').addClass('theme_content'); // 活用集としてCSSセレクターが働くようにする
				$('.h1').css({'visibility': 'hidden'}); // H1タイトルは隠す（背景画像で表現）
				$('.center').css('padding-top', '400px'); // H1用の画像領域確保
				$('.center').css('padding-bottom', '50px'); // H1用の画像領域確保
				$('.center').css('width', '1010px'); // コンテンツ領域の幅指定
				$('.center').css('box-shadow', 'none'); // コンテンツ領域のドロップシャドウは背景画像で表現
				$('#id_right').css({'background': 'transparent', 'float': 'none'}); // 通常本文用のレイアウトを打消し
				$('#id_right').css('cssText', 'float:none!important;width:auto!important;position:static!important'); // 通常本文用のレイアウトを打消し

				// サブタイトル画像位置調整
				$('div.theme_sub_title img').each(function() {
					$(this).css('top', ($(this).parent().get(0).offsetHeight / 2) - ($(this).height() / 2)); // 天地中央揃え
				});

				// サブタイトルの切り替え
				$('.theme_sub_title').on('click', function() { // 表示
					$(this).slideToggle(500);
					$(this).next().slideToggle(500);

					// NOTE: ie8で切替後にサブタイトル上下のマージンがなくなることを防ぐ
					window.setTimeout(function() {
						$('.theme_sub_title').css({'margin-top': '6px', 'margin-bottom': '6px'});
						$('.invisible').css({'margin-top': '6px', 'margin-bottom': '6px'});
					}, 510);
					window.setTimeout(function() {
						$('.theme_sub_title').css({'margin-top': '5px', 'margin-bottom': '5px'});
						$('.invisible').css({'margin-top': '5px', 'margin-bottom': '5px'});
					}, 520);
				});
				$('.theme_sub_title').append('<img src="../images/theme-show.png" class="theme_show" />');
				$('.theme_sub_title').next().append('<img src="../images/theme-hide.png" class="theme_hide" />');
				$('.theme_sub_title').next().children(':first-child').each(function() {
					$(this).after('<div class="copied_sub_title">' + $(this).parent().prev().html() + '</div>');
				});
				$('.theme_hide').on('click', function() { // 非表示
					$(this).parent().parent().slideToggle(500);
					$(this).parent().parent().prev().slideToggle(500);

					// NOTE: ie8で切替後にサブタイトル上下のマージンがなくなることを防ぐ
					window.setTimeout(function() {
						$('.theme_sub_title').css({'margin-top': '6px', 'margin-bottom': '6px'});
						$('.invisible').css({'margin-top': '6px', 'margin-bottom': '6px'});
					}, 510);
					window.setTimeout(function() {
						$('.theme_sub_title').css({'margin-top': '5px', 'margin-bottom': '5px'});
						$('.invisible').css({'margin-top': '5px', 'margin-bottom': '5px'});
					}, 520);
				});

				// サブタイトル内の01画像を浮遊させるために、その他のDIV要素をラップ
				$('.theme_content div.invisible').wrapInner('<div class="theme_wrapper"></div>');
				$('.theme_content div.invisible .theme_wrapper div.theme_number').each(function() {
					$(this).prependTo($(this).parent().parent());
				});

				// g_greennavi_jaの座標調整とリンク設定
				$('img[src*=\'g_greennavi\']').css({'position': 'absolute', 'top': '339px', 'left': '390px', 'cursor': 'pointer'}).on('click', function() {window.open('http://cweb.canon.jp/ecology/green-navi/index.html', '_blank')});

				// 左右ナビゲーション
				var theme_nav_prev = document.createElement('img');
				theme_nav_prev.src = "../images/theme-nav-prev.png";
				theme_nav_prev.className = "theme_nav_prev";
				$('.page').append(theme_nav_prev);

				var theme_nav_next = document.createElement('img');
				theme_nav_next.src = "../images/theme-nav-next.png";
				theme_nav_next.className = "theme_nav_next";
				$('.page').append(theme_nav_next);

				// 左右ナビゲーションの縦位置調整
				$('.theme_nav_prev, .theme_nav_next').css('top', $(window).height() / 2 - 61 + "px");

				// 現在地の把握
				var theme_sign = "theme::";
				var t = eval(toc);
				var tLength = t.length;
				var current_theme = document.location.href.split("/");
				current_theme = current_theme[current_theme.length - 1];
				current_theme = current_theme.split(".html?")[0];
				var prev_theme;
				var next_theme;
				var themes = new Array();

				// 活用集IDの収集
				for (var i = 0; i < tLength; i++) {

					// 活用集コンテンツである
					if (t[i].link_name.indexOf(theme_sign) != -1) {
						themes.push(t[i].id);
						if (t[i].id == current_theme) {

							// H1背景画像を配置
							$('.center').css('background', 'url(../themes/h1_img_' + t[i].link_name.split(theme_sign)[1] + '.jpg) no-repeat');
						}
					}
				}
				var iLoopLength = themes.length;
				for (var i = 0; i < iLoopLength; i++) {

					// 現在表示中の活用集
					if (themes[i] == current_theme) {

						// 先頭の場合
						if (i == 0) {
							prev_theme = themes[iLoopLength - 1];
							next_theme = themes[i + 1];

						// 最後尾の場合
						} else if (i == iLoopLength - 1) {
							prev_theme = themes[i - 1];
							next_theme = themes[0];
						} else {
							prev_theme = themes[i - 1];
							next_theme = themes[i + 1];
						}
					}
				}

				// スライドアニメーションとリンク
				$(theme_nav_prev).on('click', function() {
					$('html').css('background', "none");
					$('body').css({overflow: "hidden"});
					$('.center').css("margin-left", $('.center').offset().left + "px");
					$('.center').animate({marginLeft: $(window).width()}, 1000, function() {
						document.location.href = prev_theme + ".html?theme=yes";
					});
				});
				$(theme_nav_next).on('click', function() {
					$('html').css('background', "none");
					$('body').css({overflow: "hidden"});
					$('.center').css("margin-left", $('.center').offset().left + "px");
					$('.center').animate({marginLeft: $(window).width() * -1}, 1000, function() {
						document.location.href = next_theme + ".html?theme=yes";
					});
				});

				// ボタンの位置調整
				window.onresize = function onresize() {
					var nMiddle = $(window).height() / 2 - 61 + "px";
					$(theme_nav_prev).css({top: nMiddle});
					$(theme_nav_next).css({top: nMiddle});
				}
				onresize();

				// 相互参照の表示に使うのは親ウィンドウ
				$('#id_content a').attr("target", "canon_main_window");

				// 表示の再開（IE8で通常スタイルで一瞬描画されてしまうことを防ぐ）
				$('body').css('visibility', 'visible');

				// 以降の処理（リソースのロード、目次生成など）不要
				return;
			} catch (e) {
				//alert(e.description);
			}
		}

		if (fncGetConstantByName('template_type') == 'ne') {
			$('div#id_content').addClass('normal_content'); // NE
		}

		// トップページ表示内容の切替
		if (strWindowType == "HOME_TOC") {
			if (stored_layout_mode == "mobile") {
				$('#mobile_home').show();
				$('#pc_home').remove();
			} else {
				$('#pc_home').show();
				$('#mobile_home').remove();
			}
		}

		// ヘッダー項目の生成
		fncIncludeHeader();

		// フッター項目の生成
		//fncIncludeFooter();

		// リソースをロード
		fncLoadResource();

		// pushStateでタイトルが無効になることを防ぐために元の状態を記憶
		//document.body.setAttribute('data-page-title', document.title);

		// 動的リンク生成
		fncGenerateDynamicLink();

		// 検索モード
		var search_mode = fncGetConstantByName("search_mode");

		// Googleカスタム検索の場合は処理しない
		if (search_mode != "gcs") {

			// 検索初期表示エリア下部に表示する検索に関するヘルプリンク
			//fncResetSearchDisplay();

			// 全角半角区別オプションの表示制御
//			var search_option_multibyte = fncGetConstantByName("search_option_multibyte");
//			if (search_option_multibyte != 1) {
//				document.getElementById("id_search_options_multibyte").parentNode.style.visibility = "Hidden";
//			}
		}

		// 現在カテゴリーのID
		strCurrentChapterId = "";
		if (document.getElementById("id_level_1")) {
			strCurrentChapterId = document.getElementById("id_level_1").getAttribute("toc_id");
		}

		// パンくずをたどり目次ツリーを展開
		var objBreadCrumb = document.getElementById("id_breadcrumbs");
		if (objBreadCrumb) {

			// パンくずの要素分繰り返し
			var iLoopLength = objBreadCrumb.getElementsByTagName("a").length;
			for (var i = 0; i < iLoopLength; i++) {

				if (objBreadCrumb.getElementsByTagName("a")[i].getAttribute("toc_id")) {
					strBreadCrumbsTocIds += objBreadCrumb.getElementsByTagName("a")[i].getAttribute("toc_id") + ",";
					strCurrentTocId = objBreadCrumb.getElementsByTagName("a")[i].getAttribute("toc_id");
				}

				if (!objBreadCrumb.getElementsByTagName("a")[i].getAttribute("href")) {
					objBreadCrumb.getElementsByTagName("a")[i].className = "no_underline";
				}

				// ループの最後
				if (iLoopLength == i + 1) {

					// 目次のすべて閉じるを押すとどこが現在地かがわからなくなる問題の対応
					objBreadCrumb.getElementsByTagName("a")[i].href = 'javascript: document.location.reload(false);';
					objBreadCrumb.getElementsByTagName("a")[i].className = '';
				}
			}

			// パンくずをNextE風にする
			var iLoopLength = objBreadCrumb.childNodes.length;
			for (var i = 0; i < iLoopLength; i++) {
				if (objBreadCrumb.childNodes[i].nodeValue && objBreadCrumb.childNodes[i].nodeValue.trim() == "»") {
					var img = document.createElement("img");
					//img.src = "../frame_images/f_breadcrumb.png";
					img.src = frame_path + "images/f_breadcrumb" + strPathPlus + ".png"; // NOTE: cloudfront -> s3 参照時に「+」だとエスケープされてリンクエラーになる
					img.width = "4";
					img.height = "8";
					objBreadCrumb.replaceChild(img, objBreadCrumb.childNodes[i]); // NOTE: FFでreplaceNodeは正しく動作しない
				}

				// パンくずリンクホバー時にアンダーライン
				if (objBreadCrumb.childNodes[i].href) {
					objBreadCrumb.childNodes[i].onmouseover = function () {
						this.style.textDecoration = "underline";
					}
					objBreadCrumb.childNodes[i].onmouseout = function () {
						this.style.textDecoration = "none";
					}
				}
			}

			// パンくずをh1タイトルの次に移動
			// NOTE: FireFoxではwhitespaceをchildNodesの勘定に含める
			var objTarget = document.getElementById("id_content").childNodes[0];

			// コンテンツ最初の段落がh1ではない場合、見つかるまで探索
			while (	(	(objTarget.className != strStyleNumber + "h1")
					&&	(objTarget.className != "h1")
					&&	(objTarget.nodeName.toLowerCase() != "h1")
				)	&&	(objTarget.nextSibling)
			) {
				objTarget = objTarget.nextSibling;
			}
			if (	(objTarget.className == strStyleNumber + "h1")
				||	(objTarget.className == "h1")
				||	(objTarget.nodeName.toLowerCase() == "h1")
			) {
				if (objTarget.className == "h1") {
					strStyleNumber = "";
				}

				// パンくずと文書番号の見た目をコントロール
				// 適用されているテンプレートによってスタイルを変更する
				var h1_style = objTarget.currentStyle || document.defaultView.getComputedStyle(objTarget, "");
				var h1_color = h1_style.backgroundColor;

				// PS Front系
				if (	(h1_color == "#555555") // IE
					||	(h1_color == "rgb(85, 85, 85)") // Other
				) {

					// パンくず
					if (objBreadCrumb) {

						// 配置
						objTarget.parentNode.insertBefore(objBreadCrumb, objTarget.nextSibling);
						objBreadCrumb.style.display = "Block";

						objBreadCrumb.style.position = "Static";
						objBreadCrumb.style.backgroundColor = "#FFFFFF";
						objBreadCrumb.style.padding = "1px 2px 2px 2px";
						objBreadCrumb.style.borderBottom = "Solid 5px #FFFFFF";
					}

					// 文書番号
					var objDocumentNumber = document.getElementById("id_document_number");
					if (objDocumentNumber) {

						// 配置
						objTarget.parentNode.insertBefore(objDocumentNumber, objTarget.nextSibling);

						// スタイル
						objDocumentNumber.style.backgroundColor = "#E3E3FF";
						objDocumentNumber.style.paddingRight = "2px";
					}

				// デフォルト
				} else {

					// パンくず
					if (objBreadCrumb) {

						// 配置
						objTarget.parentNode.insertBefore(objBreadCrumb, objTarget);
						objBreadCrumb.style.display = "Block";

						// スタイル
						objBreadCrumb.style.position = "Static";
						objBreadCrumb.style.backgroundColor = "#FFFFFF";
						objBreadCrumb.style.border = "None";
						objBreadCrumb.style.padding = "1px 10px 2px 2px";
						objBreadCrumb.style.marginBottom = "0px";
						objTarget.style.paddingTop = "15px";
					}

					// 文書番号
					var objDocumentNumber = document.getElementById("id_document_number");
					if (objDocumentNumber) {

						// 配置
						objTarget.parentNode.insertBefore(objDocumentNumber, objTarget.nextSibling);

						// スタイル
						objDocumentNumber.style.marginTop = "-12px";
					}
				}
			}
		}

		// 現在ページのIDをBODYにセット（検索時にヒット項目が現在ページかどうかを判定するため）
		if (strCurrentTocId != "") {
			document.body.toc_id = strCurrentTocId;
		} else {

			// ロードが中途半端に終了してしまったためにbreadcrumbが取得できない場合リロード
			if (strWindowType != 'HOME_TOC') {
				document.location.reload(true);
			}
		}

		var strSiblingTocIds = fncGetSiblingNodeId(strCurrentTocId);
		var strPreviousTocId = strSiblingTocIds.split(":")[0];
		var strNextTocId = strSiblingTocIds.split(":")[1];

		// TOCモードをセッションストレージから取得
		var stored_toc_mode = fncGetSessionStorage('toc-mode');

		// コンフィグ画面としてlink_nameで定義されているトピックには制御ボタンをトピック内に配置
		var config_toc = fncGetTocNodeByLinkName("config");
		$('#config').on('click', function() {
			document.location.href = "../contents/" + config_toc.href;
		}).attr('title', config_toc.title);
		if (config_toc) {
			if (config_toc.id == strCurrentTocId) {
				var config_html = new Array();
//				config_html.push("<div class=\"text\">" + fncGetResourceByResourceId("config_message_lead") + "</div>");

				config_html.push("<table class=\"config\"><tr>");
				config_html.push("<th>" + fncGetResourceByResourceId("config_message_font_size") + "</th>");
				config_html.push("<td>");

//				// 文字サイズの調整（小中大）※スマートフォンは小なし
//				if (!device.mobile()) {
//					//config_html.push("<button class=\"button_font_size\" id=\"button_font_size_small\">A</button>");
//					config_html.push("<div><input type=\"radio\" class=\"button_font_size\" name=\"button_font_size\" id=\"button_font_size_small\" /><label for=\"button_font_size_small\">A</label></div>");
//				}
				config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_font_size\" name=\"button_font_size\" id=\"button_font_size_middle\" /><label for=\"button_font_size_middle\">A</label></div>");
				config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_font_size\" name=\"button_font_size\" id=\"button_font_size_large\" /><label for=\"button_font_size_large\">A</label></div>");
				//config_html.push("<button class=\"button_font_size\" id=\"button_font_size_middle\">A</button>");
				//config_html.push("<button class=\"button_font_size\" id=\"button_font_size_large\">A</button>");
				config_html.push("</td>");
				config_html.push("</tr>");

				// レイアウトモード（PC/タブレットのみ）
				if (!device.mobile()) {
					config_html.push("<tr>");
					config_html.push("<th>" + fncGetResourceByResourceId("config_message_layout_mode") + "</th>");
					config_html.push("<td>");
					config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_layout_mode\" name=\"button_layout_mode\" id=\"button_layout_mode_mobile\" /><label for=\"button_layout_mode_mobile\">" + fncGetResourceByResourceId("config_message_layout_mode_mobile") + "</label></div>");
					config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_layout_mode\" name=\"button_layout_mode\" id=\"button_layout_mode_pc\" /><label for=\"button_layout_mode_pc\">" + fncGetResourceByResourceId("config_message_layout_mode_pc") + "</label></div>");

//					config_html.push("<button class=\"button_layout_mode\" id=\"button_layout_mode_mobile\">" + fncGetResourceByResourceId("config_message_layout_mode_mobile") + "</button>");
//					config_html.push("<br />");
//					config_html.push("<button class=\"button_layout_mode\" id=\"button_layout_mode_pc\">" + fncGetResourceByResourceId("config_message_layout_mode_pc") + "</button>");
					config_html.push("</td>");
					config_html.push("<tr>");
					config_html.push("<td colspan=\"2\" style=\"padding-top: 5px;\">");
					config_html.push("<div class=\"caution\">");
					config_html.push(fncGetResourceByResourceId("config_message_layout_mode_caution_1"));
					config_html.push("<br />");
					config_html.push(fncGetResourceByResourceId("config_message_layout_mode_caution_2"));
					config_html.push("</div>");
					config_html.push("</td>");
					config_html.push("</tr>");
				}

				// 目次モード
				config_html.push("<tr>");
				config_html.push("<th>" + fncGetResourceByResourceId("config_message_toc_mode") + "</th>");
				config_html.push("<td>");
//				config_html.push("<button class=\"button_toc_mode\" id=\"button_toc_mode_all\">" + fncGetResourceByResourceId("config_message_toc_mode_all") + "</button>");
//				config_html.push("<br />");
//				config_html.push("<button class=\"button_toc_mode\" id=\"button_toc_mode_chapter\">" + fncGetResourceByResourceId("config_message_toc_mode_chapter") + "</button>");
				config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_toc_mode\" name=\"button_toc_mode\" id=\"button_toc_mode_all\" /><label for=\"button_toc_mode_all\">" + fncGetResourceByResourceId("config_message_toc_mode_all") + "</label></div>");
				config_html.push("<div class=\"radio\"><input type=\"radio\" class=\"button_toc_mode\" name=\"button_toc_mode\" id=\"button_toc_mode_chapter\" /><label for=\"button_toc_mode_chapter\">" + fncGetResourceByResourceId("config_message_toc_mode_chapter") + "</label></div>");

				config_html.push("</td>");
				config_html.push("</tr>");
				config_html.push("<tr>");
				config_html.push("<td colspan=\"2\" style=\"padding-top: 5px;\">");
				config_html.push("<div class=\"caution\">");
				config_html.push(fncGetResourceByResourceId("config_message_toc_mode_caution_1"));
				config_html.push("<br />");
				config_html.push(fncGetResourceByResourceId("config_message_toc_mode_caution_2"));
				config_html.push("</div>");
				config_html.push("</td>");
				config_html.push("</tr>");
				config_html.push("<tr>");
				//config_html.push("<th>&nbsp;</th>");
				config_html.push("<td colspan=\"2\">");

				// [もどる]ボタン
				config_html.push("<button class=\"button_back\" id=\"button_back\">" + fncGetResourceByResourceId("config_message_back") + "</button>");
				config_html.push("</td>");
				config_html.push("</tr></table>");

				$('#id_content').append($(config_html.join("")));

				$('#button_font_size_small').on('click', function() {
					fncSetFontSize('small');
				});
				$('#button_font_size_middle').on('click', function() {
					fncSetFontSize('middle');
				});
				$('#button_font_size_large').on('click', function() {
					fncSetFontSize('large');
				});

				// [もどる]ボタン押下時の挙動
				$('#button_back').on('click', function() {
					//history.back(); // NOTE: galaxyでキャッシュが有効になってしまう

					if (fncGetSessionStorage('config-from')) {
						var refs = fncGetSessionStorage('config-from').split("?ref=");
						if (refs[1]) {

							// 検索結果からジャンプしてきた場合などでURLクエリーが付与されているかどうかをチェック
							var query_mark = "?";
							if (refs[1].indexOf("?s=") != -1) {
								query_mark = "&";
							}
							document.location.href = refs[1].replace(/\?r=[0-9][0-9]\@/g, "") + query_mark + "r=" + fncRandomParam() + "@";
						} else {

							// 検索結果からジャンプしてきた場合などでURLクエリーが付与されているかどうかをチェック
							var query_mark = "?";
							if (refs[0].indexOf("?s=") != -1) {
								query_mark = "&";
							}
							document.location.href = refs[0].replace(/\?r=[0-9][0-9]\@/g, "") + query_mark + "r=" + fncRandomParam() + "@";
						}
					} else {

						// 戻り先がない場合はトップページへ
						document.location.href = "../frame_htmls/home.html";
					}
				});
				$('#button_layout_mode_mobile').on('click', function() {
					fncSetLayoutMode('mobile');
				});
				$('#button_layout_mode_pc').on('click', function() {
					fncSetLayoutMode('pc');
				});
				$('#button_toc_mode_all').on('click', function() {
					fncSetTocMode('all');
				});
				$('#button_toc_mode_chapter').on('click', function() {
					fncSetTocMode('chapter');
				});
				if (stored_layout_mode == "mobile") {
					$('#button_layout_mode_mobile').attr('checked', 'checked');
					//$('#button_layout_mode_pc').css('background-color', '#eee');
				} else if (stored_layout_mode == "pc") {
					//$('#button_layout_mode_mobile').css('background-color', '#eee');
					$('#button_layout_mode_pc').attr('checked', 'checked');
				}
				if (stored_toc_mode == "all") {
					$('#button_toc_mode_all').attr('checked', 'checked');
					//$('#button_toc_mode_chapter').css('background-color', '#eee');
				} else if (stored_toc_mode == "chapter") {
					//$('#button_toc_mode_all').css('background-color', '#eee');
					$('#button_toc_mode_chapter').attr('checked', 'checked');
				} else {
					if (fncGetConstantByName("join_chapters") == 1) {
						$('#button_toc_mode_all').attr('checked', 'checked');
						//$('#button_toc_mode_chapter').css('background-color', '#eee');
					} else {
						//$('#button_toc_mode_all').css('background-color', '#eee');
						$('#button_toc_mode_chapter').attr('checked', 'checked');
					}
				}

				// 戻り先を記憶
				//var from = document.referrer; // NOTE: ie10では信頼済みサイトではないとreferrerが無効
				if (from.indexOf(config_toc.href) == -1) {
					fncSetSessionStorage('config-from', from);
				}
			}
		}

		// フッター要素の配置
		$("#id_content").append("<div id=\"id_flow_actions\"><button id=\"id_flow_prev\" /><button id=\"id_flow_top\" /><button id=\"id_flow_next\" /></div><div id=\"id_flow_product\"></div><div id=\"id_flow_guidename\"></div><div id=\"id_flow_pub\"></div>");

		// 著作権
		$('#id_flow_pub').html("<span id=\"id_res_pub_number\">"+fncGetResourceByResourceId("pub_number")+"</span>"+"<span id=\"id_res_pub_number2\">"+fncGetResourceByResourceId("pub_number2")+"</span>"+"<span id=\"id_res_copy_right\">"+fncGetResourceByResourceId("copy_right")+"</span>");


		// 前へ
		if ((!strPreviousTocId) || (strPreviousTocId.length == 0)) {
			$("#id_flow_prev").css({"opacity": "0.3", "cursor": "default"});
			$("#id_flow_prev").attr("disabled", true);
		} else {
			$("#id_flow_prev").click(function() {
				document.location.href = "../contents/" + strPreviousTocId + ".html";
			});
		}
		$("#id_flow_prev").attr('title', fncGetResourceByResourceId("contents_link_prev"));

		// 次へ
		if ((!strNextTocId) || (strNextTocId.length == 0)) {
			$("#id_flow_next").css({"color": "#aaa", "opacity": "0.3"});
			$("#id_flow_next").attr("disabled", true);
		} else {
			$("#id_flow_next").click(function() {
				document.location.href = "../contents/" + strNextTocId + ".html";
			});
			$("#id_flow_next").attr('title', fncGetResourceByResourceId("contents_link_next"));
		}

		// フッター
		if (strWindowType != "HOME_TOC") {
			$('#id_flow_product').html(fncGetResourceByResourceId("product_main_name") + ' ' + fncGetResourceByResourceId("product_sub_name") + ' ' + fncGetResourceByResourceId("version"));
			$('#id_flow_guidename').html(fncGetResourceByResourceId("guide_name"));
		} else {

			// トップページのフッターはhome.html側に記述
			$('#id_flow_product, #id_flow_guidename, #id_flow_pub').remove();
		}

		// 既存のチャプタープルダウンを除去
		if (document.getElementById("id_chapter_select")) {
			document.getElementById("id_chapter_select").parentNode.parentNode.removeChild(document.getElementById("id_chapter_select").parentNode);
		}

		// 目次
		// ----------------------------------------------------------------------------------------
		var bJoinChapters = false; // デフォルトは「全て」
		if (!stored_toc_mode) {
			if (fncGetConstantByName("join_chapters") == 1) {
				stored_toc_mode = "all"; // すべての章
			} else {
				stored_toc_mode = "chapter"; // 章単位
			}
		}

		// チャプター制御
		if (	(strWindowType == "HOME_TOC")
			||	(stored_toc_mode == "all")
		) {
			bJoinChapters = true;
			strCurrentChapterId = "ALL";
		} else {
			bJoinChapters = false;

			// 目次プルダウンの配置先
			var tabs = document.getElementById('id_tabs');

			// 目次プルダウン
			var select = document.createElement('select');
			select.id = "chapters";

			// チャプター一覧抽出のため目次情報をロード
			// toc.jsonのlevelが「1」のノードは「チャプター」とする
			var t = eval(toc);
			var iLoopLength = t.length;
			for (var i = 0; i < iLoopLength; i++) {

				// チャプター情報を抽出
				if (	(t[i].level == 1)
					&&	(t[i].show_toc != "n")
				) {
					var option = document.createElement('option');
					option.id = t[i].id;
					option.title = t[i].title;
					option.innerHTML = t[i].title;
					$(select).append(option);
					if (strCurrentChapterId == t[i].id) {
						option.selected = true;
					}
				}
			}
			select.title = select.options[select.options.selectedIndex].title; // 長いチャプタータイトルがプルダウン上で表示しきれないためツールチップ表示
			$(tabs).append(select);

			// チャプター移動制御
			$(select).on('change', function() {
				//document.getElementById("id_toc").scrollTop = 0;
				//document.getElementById("id_toc").scrollLeft = 0;
				var param = "";
				if (stored_layout_mode == "mobile") {
					//param = "?show=toc";
					fncSetSessionStorage('show-toc', 'yes');
				}
				document.location.href = "../contents/" + this.options[this.selectedIndex].id + ".html" + param;
			});
		}

		// 目次フレームのロード
		// -----------------------------------------------------------------------------------------
		
		// PCモード
		if (stored_layout_mode == "pc") {
			if (document.getElementById("id_toc")) {

				// 準備中表示
				$('#id_toc').html("<div id=\"wait\"></div>");
				var delay = 0;
				if (device.android()) {
					delay = 500;
				}

				// 目次表示処理
				window.setTimeout(function() {
					fncBuildToc(document.getElementById("id_toc"));
				}, delay);
				window.setTimeout(function() {
					fncSyncTocJson();
				}, 600);
			}

		// モバイルモード
		} else {
			if (document.getElementById("id_toc")) {

				// 目次除去
				document.getElementById("id_toc").parentNode.removeChild(document.getElementById("id_toc")); // モバイルレイアウトで[+][-]の制御ができない問題を回避するため非表示の目次を削除しておく
			}
		}

		// XLSから除去されたトグル判別用画像の動的埋め込み
		var icon_toggle_panel = document.createElement('img');
		icon_toggle_panel.id = 'id_res_bar_icon_toggle_panel';
		icon_toggle_panel.className = 'hide';
		document.getElementById('id_res_bar_icon_previous').parentNode.appendChild(icon_toggle_panel);

		// ----------------------------------------------------------------------------------------
		// 左パネルの表示・非表示
		// ----------------------------------------------------------------------------------------
		if (document.getElementById('id_res_bar_icon_toggle_panel')) {
			document.getElementById('id_res_bar_icon_toggle_panel').onclick = function() {

				// 非表示
				if (this.className == 'hide') {

					// 表示・非表示の切り替え
					document.getElementById("id_panel").style.display = "none";
					document.getElementById("id_tabs").style.display = "none";
					document.getElementById("id_content").style.width = fncGetWindowWidth() + "px";
					document.getElementById("id_content").style.left = "0px";
					this.parentNode.parentNode.colSpan = 2; // NOTE: 旧ff用にTDの内側にDIVがラップされている
					//this.src = frame_path + "images/bar_icon_pnl_show.png";
					this.className = 'show';

				// 表示
				} else {
					document.getElementById("id_panel").style.display = "Block";
					this.parentNode.parentNode.colSpan = 1;
					//if (document.all) {
					//	document.getElementById("id_tabs").style.display = "Block";
					//} else {
						document.getElementById("id_tabs").style.display = "Table-Cell";
					//}
					document.getElementById("icon_plus").style.display = "";
					document.getElementById("icon_minus").style.display = "";

					// NOTE: IE678でウィンドウサイズを300px以下まで狭くした時に幅指定が無効になる現象を避ける
					var nContentWidth = fncGetWindowWidth() - 300;
					if (nContentWidth < 0) {
						nContentWidth = 0;
					}
					document.getElementById("id_content").style.width = nContentWidth + "px";
					document.getElementById("id_content").style.left = "300px";
					//this.src = frame_path + "images/bar_icon_pnl_hide.png";
					this.className = 'hide';

					// 非表示にされていたボックスのスクロール位置を復元
					if (	(document.getElementById("id_search_chapters"))
						&&	(nTempSearchChaptersScrollTop != -1)
					) {
						document.getElementById("id_search_chapters").scrollTop = nTempSearchChaptersScrollTop;
					}
					if (	(document.getElementById("id_search_results"))
						&&	(nTempSearchResultsScrollTop != -1)
					) {
						document.getElementById("id_search_results").scrollTop = nTempSearchResultsScrollTop;
					}
					if (	(document.getElementById("id_toc"))
						&&	(nTempTocScrollTop != -1)
					) {
						document.getElementById("id_toc").scrollTop = nTempTocScrollTop;
					}
				}
			}

			if (fncGetCookie("LEFT_PANE_VISIBILITY") == "HIDE") {
				document.getElementById("id_panel").style.display = "None";
				document.getElementById("id_tabs").style.display = "None";
				document.getElementById("id_content").style.width = fncGetWindowWidth() + "px";
				document.getElementById("id_content").style.left = "0px";
				document.getElementById('id_res_bar_icon_toggle_panel').className = 'show';
				document.getElementById("id_res_bar_icon_toggle_panel").parentNode.colSpan = "2"; // NOTE: この時点ではまだTDの内側にラップしていない
			}
		}

		// ----------------------------------------------------------------------------------------
		// 前トピック
		// ----------------------------------------------------------------------------------------
		if (document.getElementById("id_res_bar_icon_previous")) {

			// 前トピックなし
			if (strPreviousTocId == "") {
				document.getElementById("id_res_bar_icon_previous").style.visibility = "hidden";

			// 前トピックあり
			} else {
				document.getElementById("id_res_bar_icon_previous").title = fncGetResourceByResourceId("bar_label_previous");
				document.getElementById("id_res_bar_icon_previous").onclick = function() {
					document.location.href = "../contents/" + strPreviousTocId + ".html";
				}
				document.getElementById("id_res_bar_icon_previous").style.display = '';
			}
		}

		// ----------------------------------------------------------------------------------------
		// 次トピック
		// ----------------------------------------------------------------------------------------
		if (document.getElementById("id_res_bar_icon_next")) {

			// 次トピックなし
			if (strNextTocId == "") {
				document.getElementById("id_res_bar_icon_next").style.visibility = "hidden";

			// 次トピックあり
			} else {
				document.getElementById("id_res_bar_icon_next").title = fncGetResourceByResourceId("bar_label_next");
				document.getElementById("id_res_bar_icon_next").onclick = function() {
					document.location.href = "../contents/" + strNextTocId + ".html";
				}
				document.getElementById("id_res_bar_icon_next").style.display = 'inline';
			}
		}

		// ----------------------------------------------------------------------------------------
		// タブの切り換え
		// ----------------------------------------------------------------------------------------
		if (	(document.getElementById("id_res_search"))
			&&	(document.getElementById("id_res_contents"))
		) {

			// 検索
			document.getElementById("id_res_search").onclick = function() {
				fncResSearchClick();
			}

			// 目次
			document.getElementById("id_res_contents").onclick = function() {
				fncResContentsClick();
			}
		}

		// 検索
		// ----------------------------------------------------------------------------------------

		// ローカル検索モード
		if (search_mode != "gcs") {

			// 検索エンジンを変更
			$("#id_panel_search").html(
				"<div id=\"id_panel_label\"><label id=\"id_res_keyword\" for=\"id_search\"></label><input placeholder=\"" + fncGetResourceByResourceId("enter_search_keyword") + "\" type=\"search\" id=\"id_search\" value=\"\" onkeydown=\"return fncSearchKeyDown(event.keyCode, this.value);\" /><button id=\"id_search_button\" onclick=\"fncClearSearch();fncDoSearch(1);\"></button></div><div id=\"id_search_pagination\"></div><div id=\"id_search_info\">" + fncGetResourceByResourceId("search_message_enter_search_keyword") + "</div><div id=\"id_search_results\"></div>"
			);

			// 検索キーワードの再現
			var strSavedSearchKeyword = fncGetCookie("SEARCH-KEYWORD");
			if (strSavedSearchKeyword) {
				if (strSavedSearchKeyword != fncGetResourceByResourceId("enter_search_keyword")) {
					document.getElementById("id_search").value = strSavedSearchKeyword;
				}
			}
			fncSearchBox();

		// Google Custom Search
		// ----------------------------------------------------------------------------------------
		} else {

			// 検索エンジンを変更
			$("#id_panel_search").html(
				"<div id=\"id_panel_label\"><label id=\"id_res_keyword\" for=\"id_search\"></label><input placeholder=\"" + fncGetResourceByResourceId("enter_search_keyword") + "\" type=\"search\" id=\"id_search\" value=\"\" onkeydown=\"return fncSearchKeyDown(event.keyCode, this.value);\" /><button id=\"id_search_button\" onclick=\"gcsearch('gcresult');\"></button></div><input id=\"id_start\" value=\"1\" type=\"hidden\" /><div id=\"id_search_pagination\"></div><div id=\"id_search_info\">" + fncGetResourceByResourceId("search_message_enter_search_keyword") + "</div><div id=\"id_search_results\"></div>"
			);

			// 検索キーワードの再現
			var strSavedSearchKeyword = fncGetCookie("SEARCH-KEYWORD");
			if (strSavedSearchKeyword) {
				if (strSavedSearchKeyword != fncGetResourceByResourceId("enter_search_keyword")) {
					document.getElementById("id_search").value = strSavedSearchKeyword;
				}
			}
		}

		// [+][-]アイコンの配置先
		var tabs = document.getElementById('id_tabs');

		// [+]アイコン
		var icon_plus = document.createElement("button");
		icon_plus.id = 'icon_plus';
		icon_plus.className = 'icon_plus_pc';
		icon_plus.onclick = function () {

			// iframe目次モード
			if (document.getElementById('iframe_toc')) {
				document.getElementById('iframe_toc').contentWindow.fncOpenCloseAllToc(2);

			// toc.json目次モード
			} else {
				fncOpenCloseAllToc(2); // すべて開く
			}
		}
		icon_plus.title = fncGetResourceByResourceId("open_toc_all");
		$(tabs).append(icon_plus);

		// [-]アイコン
		var icon_minus = document.createElement("button");
		icon_minus.id = 'icon_minus';
		icon_minus.className = 'icon_minus_pc';
		icon_minus.onclick = function () {

			// iframe目次モード
			if (document.getElementById('iframe_toc')) {
				document.getElementById('iframe_toc').contentWindow.fncOpenCloseAllToc(1);

			// toc.json目次モード
			} else {
				fncOpenCloseAllToc(1); // すべて閉じる
			}
		}
		icon_minus.title = fncGetResourceByResourceId("close_toc_all");
		$(tabs).append(icon_minus);

		// 検索ボックス
		$(tabs).append($('#id_search'));

		// 検索ボタン
		$(tabs).append($('#id_search_button'));

		// タブ選択状態の再現
		if (document.getElementById("id_res_search")) {
			if (fncGetCookie("TAB-POSITION") == "2") {

				// ローカル検索モード
				if (search_mode != "gcs") {

					// 検索ボックスの値が初期値でなければ検索実行へ
					if (document.getElementById("id_search").value != fncGetResourceByResourceId("enter_search_keyword")) {

						// 検索結果に表示するページを設定
						var nPage = 1;
						var strSearchResultSetting = fncGetCookie("SEARCH-RESULT-SETTING");
						if ("" != strSearchResultSetting) {

							// 検索結果から選択された場合はCookieから再表示するページ数を取得
							var arrSearchResultSetting = strSearchResultSetting.split(":");
							if ("" != arrSearchResultSetting[0] && undefined != arrSearchResultSetting[0]) {
								nPage = arrSearchResultSetting[0];
							}
						}
						var ti = window.setTimeout("fncDoSearch(" + nPage + ")", 13);
					}
				} else {
					gcsearch('gcresult');
				}
				fncResSearchClick();
			} else if (document.getElementById("id_res_contents")) {
				fncResContentsClick();
			}
		} else if (document.getElementById("id_res_contents")) {
			fncResContentsClick();
		}

		// すべてたたむリンクのイベント定義
		document.getElementById("id_res_close_toc_all").onclick = function() {
			fncOpenCloseAllToc(1);
		}
		var strCloseTocAllTitle = document.getElementById("id_res_close_toc_all").innerText;
		if (!strCloseTocAllTitle) {
			strCloseTocAllTitle = document.getElementById("id_res_close_toc_all").textContent;
		}
		if (strCloseTocAllTitle) {
			document.getElementById("id_res_close_toc_all").title = strCloseTocAllTitle;
		}

		// すべて開くリンクのイベント定義
		document.getElementById("id_res_open_toc_all").onclick = function() {
			fncOpenCloseAllToc(2);
		}
		var strOpenTocAllTitle = document.getElementById("id_res_open_toc_all").innerText;
		if (!strOpenTocAllTitle) {
			strOpenTocAllTitle = document.getElementById("id_res_open_toc_all").textContent;
		}
		if (strOpenTocAllTitle) {
			document.getElementById("id_res_open_toc_all").title = strOpenTocAllTitle;
		}

		// 詳細開閉処理
		// -----------------------------------------------------------------------------------------
		var objAnchors = document.getElementsByTagName("a");
		var nAnchorLength = objAnchors.length;
		for (var i = 0; i < nAnchorLength; i++) {
			if (objAnchors[i].className == "open_close_next_sibling") {
				objAnchors[i].innerHTML = fncGetResourceByResourceId("open_next_sibling");
				objAnchors[i].className = "open_next_sibling";
				objAnchors[i].onclick = function() {
					fncOpenCloseNextSibling(this);
					return false;
				}
			} else if(objAnchors[i].className == "open_all") {
				objAnchors[i].innerHTML = fncGetResourceByResourceId("open_all");
				objAnchors[i].onclick = function() {
					fncOpenCloseAll("open");
					return false;
				}
			} else if(objAnchors[i].className == "close_all") {
				objAnchors[i].innerHTML = fncGetResourceByResourceId("close_all");
				objAnchors[i].onclick = function() {
					fncOpenCloseAll("close");
					return false;
				}
			}
		}

		// 各ペインをウィンドウサイズに合わせてサイズ調整
		window.setTimeout(function() { // NOTE: for ios8+ipad safari on pc layout
			fncOnResize();
		}, 300); // 1000

		// 検索結果からジャンプしてきた場合、ヒット文字列をハイライトさせる
		if (document.location.search) {
		} else {

//			// IE6の場合リンクアンカーまでスクロールしないので、自前でアンカー位置にスクロール
//			if (document.all) { // FF/SFを除外
				if (document.location.hash != "") {
					var strHash = document.location.hash.substring(1);
					if (document.getElementById(strHash)) {
						window.setTimeout(function() {
							document.getElementById(strHash).scrollIntoView(true);
						}, 500);
					}
//					if (document.all.item(strHash)) {
//						document.all.item(strHash).scrollIntoView(true);
//					}
				}
//			}
		}

		// IE7の場合にのみ、スクロールのバーの位置と高さが正しく表示されないのを防ぐ
		if (	(document.all) // FF/SFを除外
			&&	(window.XMLHttpRequest)	// IE6を除外
		) {
			// <hr>タグをheightを指定した<div>タグ内に移動
			// NOTE: ここで<hr>を正規表現で<div ..><hr /></div>としてinnerHTMLで入れ替えると、スクリプトで設定したonclickイベントが消えてしまう
			var hrs = document.getElementById("id_content").getElementsByTagName("hr");
			var iLoopLength = hrs.length;
			for (var i = 0; i < iLoopLength; i++) {
				var objDiv = document.createElement("div");
				objDiv.style.height = "40px";
				objDiv.style.verticalAlign = "Middle";
				hrs[i].parentNode.insertBefore(objDiv, hrs[i]);
				objDiv.appendChild(hrs[i]);
			}
		}

		// -----------------------------------------------------------------------------------------
		// スマートフォン向けレイアウトリビルド
		// -----------------------------------------------------------------------------------------
		if (stored_layout_mode == "mobile") {

			// アドレスバーを隠す(Safari)
			setTimeout(scrollTo, 100, 0, 1);

			// ビューポートの設定
			var meta = document.createElement("meta");
			meta.setAttribute("name", "viewport");
			meta.setAttribute("content", "width=device-width, maximum-scale=1.0, minimum-scale=1.0, initial-scale=1.0, user-scalable=no");
			document.getElementsByTagName("head")[0].appendChild(meta);

			function fncAdjustImageWidth() {
				$("#id_flow_content img").each(function() {
					var img_parent_td_left = 0;
					var table_name = '';
					// tdを探索
					var node = $(this).get(0);
					while (node.id != "id_flow_content") {
						if (node.nodeName == "TD") {
							if (node.className) {
								if ($(node).hasClass('table_number')) {
									img_parent_td_left = $(node).offset().left;
								}
							}
							break;
						}
						node = node.parentNode;
					}

					// テーブル内の画像はカラム数に応じて幅を縮小
					// NOTE: 整形のためのカラムがある場合、余計に小さくなってしまう
					if (node.nodeName == "TD") {

						// trを探索
						while (node.id != "id_flow_content") {
							if (node.nodeName == "TR") {
								break;
							}
							node = node.parentNode;
						}
						if (node.nodeName == "TR") {

//							var tds = node.getElementsByTagName("TD"); // これだと、ネスト表内のTDすべてカウントしてしまい、画像が過剰に縮小されてしまう
							var tds = node.childNodes;
							var nTdLength = tds.length;
							var td_count = 0;
							var nbsp = 0;
							for (var i = 0; i < nTdLength; i++) {

								if (tds[i].nodeName == "TD") {
									td_count++;

									// 空セル
									var text = $(tds[i]).text().replace(/\t|\n/g, ""); // タブと改行は取り除く
									if (text == "\xa0") { // &nbsp;
										nbsp++;
									} else {
									}
								}
							}
							td_count = td_count - nbsp;

						} else {
							return false; // 通常発生しない
						}

						// tableを探索
						while (node.id != "id_flow_content") {
							if (node.nodeName == "TABLE") {
								break;
							}
							node = node.parentNode;
						}
						if (node.nodeName == "TABLE") {

							// テーブルのマージン分を考慮
							var nTableMargin = node.offsetLeft * 2 + (15 * nbsp); // nbspは空セル分
							table_name = node.className;

						} else {
							return false; // 通常発生しない
						}

						if (table_name == 'table_3column_yellow_level0') {
							$(this).css({"max-width": ($(window).width() * 0.2) + "px"});
						} else {

							// 複数列存在する場合
							if (td_count > 1) {
								//$(this).css({"max-width": ($(window).width() - nTableMargin) / td_count + "px"});
								if (img_parent_td_left != 0) { // table_numberの特別措置
									$(this).css({'max-width': ($(window).width() - img_parent_td_left) + 'px'});
								} else {
									$(this).css({'max-width': ($(window).width() - nTableMargin) / td_count + 'px'});
								}

							// 段落のマージン分を取り除いた有効幅まで画像を縮小
							} else {
								$(this).css({"max-width": $(window).width() - ($(this).offset().left * 2) + "px"});
							}
						}

					// 段落のマージン分を取り除いた有効幅まで画像を縮小
					} else {
						//$(this).css({"max-width": $(window).width() - ($(this).offset().left * 2) + "px"}); // テキストテキストテキスト画像（←テキスト部分の幅がoffsetで取得されてしまう）
						$(this).css({"max-width": $(window).width() - ($(this).parent().offset().left * 2) + "px"});
					}

					// invisible内の場合は画像最大幅を230pxにする
					var node = $(this).get(0);
					while (node.id != "id_flow_content") {
						if ((node.nodeName == "DIV") && (node.className == "invisible")) {
							break;
						}
						node = node.parentNode;
					}
					if (node.className == "invisible") {
						//$(node).show();
						//$(this).css({"max-width": $(window).width() - ($(this).parent().offset().left) - 20 + "px"});
						//$(node).hide();
						$(this).css({"max-width": 230});
						//$(this).parent().css('cssText', 'margin-left: 0!important, margin-right: 0!important, text-align: center!important');
						if (($(this).parent().attr('class')) && ($(this).parent().attr('class').indexOf('figure') != -1)) { // イラスト用段落スタイルの場合のみ
							$(this).parent().attr('class', 'figure_center'); // 枠からのはみ出し防止
						}
					}

				});
				if (device.mobile() || device.tablet()) { // PCでモバイルレイアウトでアクセスした場合は調整不要
					//$("#id_flow").css("width", $(window).width()); // NOTE: モバイル印刷で全幅出力されない原因。主要端末で削除して正しく表示されることを確認
				}
			}

			// デバイス回転時調整
			if (device.mobile() || device.tablet()) { // NOTE: ie8で「typeof window.orientation」がエラー
				if (typeof window.orientation === 'undefined') { // NOTE: orientationchange does not work in mobile ff
					var test = window.matchMedia("(orientation: portrait)");
					test.addListener(function(m) {
						var ti = setTimeout(adjust, 500);
						function adjust() {
							fncAdjustImageWidth();
						}
					});
				} else {
					
					$(window).bind("orientationchange", function() {
						var ti = setTimeout(adjust, 500); // NOTE: android stdだと回転前の高さが取得されてしまう 100だと早すぎる
						function adjust() {
							fncAdjustImageWidth();
						}
					});
				}
			}

			// 既存コンテンツの削除
			$('#id_header').hide();
			$('#id_panel').hide();
			$('#id_content').hide();

			// スマートフォン表示用フローの作成
			var flow = document.createElement("div");
			flow.id = "id_flow";
			document.body.appendChild(flow);

			// キヤノンロゴ領域
			$("#id_flow").append("<ul id=\"id_flow_canon_logo\"></ul>");
			$("#id_flow_canon_logo").append($("#id_res_canon_logo"));
			$(".canon_logo").wrap("<li></li>");

			// 左ペイン領域（目次）
			// -------------------------------------------------------------------------------------
			var side_toc = document.createElement("div");
			side_toc.id = "id_side_toc";
			$(side_toc).hide();
			document.body.appendChild(side_toc);

			// 左側ツールバー領域
			$(side_toc).append("<div id=\"id_side_toc_toolbar\"></div>");

			// チャプター選択プルダウン
			if ($('#chapters')) {
				$(side_toc).append($('#chapters'));
			}

			// [+]アイコン
			var icon_plus = document.createElement("button");
			icon_plus.id = 'icon_plus';
			icon_plus.className = 'icon_plus_mobile';
			icon_plus.onclick = function () {
				if (document.getElementById('iframe_toc')) {
					document.getElementById('iframe_toc').contentWindow.fncOpenCloseAllToc(2);
				} else {
					fncOpenCloseAllToc(2);
				}
			}
			icon_plus.title = fncGetResourceByResourceId("open_toc_all");
			$(side_toc).append(icon_plus);

			// [-]アイコン
			var icon_minus = document.createElement("button");
			icon_minus.id = 'icon_minus';
			icon_minus.className = 'icon_minus_mobile';
			icon_minus.onclick = function () {
				if (document.getElementById('iframe_toc')) {
					document.getElementById('iframe_toc').contentWindow.fncOpenCloseAllToc(1);
				} else {
					fncOpenCloseAllToc(1);
				}
			}
			icon_minus.title = fncGetResourceByResourceId("close_toc_all");
			$(side_toc).append(icon_minus);

			// 目次部分
			// -------------------------------------------------------------------------------------
			var toc_mobile = document.createElement('div');
			toc_mobile.id = 'toc_mobile';
			$(side_toc).append(toc_mobile);

			// 閉じるボタン
			var close_toc = document.createElement("button");
			close_toc.id = "close_toc";
			close_toc.title = fncGetResourceByResourceId("close");
			close_toc.onclick = function () {
				show_mobile_main(/*true*/);
			};
			$(id_side_toc_toolbar).append($(close_toc));

			// ボトムのページスクロールボタン[↑][↑↑][↓][x]
			if (device.mobile() || device.tablet()) { // PCでモバイルレイアウトでアクセスした場合は表示しない
				fncPlaceBottomNav(side_toc);
			}

			// 検索
			// -------------------------------------------------------------------------------------
			
			// Google検索モード
			if (search_mode == "gcs") {
				var side_search = document.createElement("div");
				side_search.id = "id_side_search";
				$(side_search).hide();
				document.body.appendChild(side_search);

				// 左側ツールバー領域
				$(side_search).append("<div id=\"id_side_search_toolbar\"></div>");

				// 検索部分
				var search_mobile = document.createElement('div');
				search_mobile.id = 'search_mobile';
				$('#id_side_search_toolbar').append(search_mobile);
				$(search_mobile).append($('#id_panel_search'));

				$(side_search).append($('#id_search_info'));
				$(side_search).append($('#id_search_results'));

				$('#id_panel_search').append($('#id_search'));
				$('#id_panel_search').append($('#id_search_button'));

				// 閉じるボタン
				var close_search = document.createElement("button");
				close_search.id = "close_search";
				close_search.title = fncGetResourceByResourceId("close");
				close_search.onclick = function () {
					show_mobile_main(/*true*/);
				};
				$(id_side_search_toolbar).append($(close_search));

				// 検索実行
				gcsearch('gcresult');

			// ローカル検索モード
			} else {
				var side_search = document.createElement('div');
				side_search.id = "id_side_search";
				$(side_search).hide();
				document.body.appendChild(side_search);

				// 左側ツールバー領域
				$(side_search).append("<div id=\"id_side_search_toolbar\"></div>");

				// 検索部分
				var search_mobile = document.createElement('div');
				search_mobile.id = 'search_mobile';
				$('#id_side_search_toolbar').append(search_mobile);
				$(search_mobile).append($('#id_panel_search'));

				$(side_search).append($('#id_search_info'));
				$(side_search).append($('#id_search_results'));

				$('#id_panel_search').append($('#id_search'));
				$('#id_panel_search').append($('#id_search_button'));

				// 閉じるボタン
				var close_search = document.createElement('button');
				close_search.id = "close_search";
				close_search.title = fncGetResourceByResourceId('close');
				close_search.onclick = function () {
					show_mobile_main(/*true*/);
				};
				$(id_side_search_toolbar).append($(close_search));

				// 検索実行
				fncDoSearch(1);
			}

			// ボトムのページスクロールボタン[↑][↑↑][↓]
			if (device.mobile() || device.tablet()) { // PCでモバイルレイアウトでアクセスした場合は表示しない
				fncPlaceBottomNav(side_search);
			}

			// 右側ツールバー領域
			// ------------------------------------------------------------------------------------
			if (document.location.search.indexOf("?sub=yes") == -1) {
				$("#id_flow").append("<div id=\"id_flow_toolbar_wrapper\"><div id=\"id_flow_toolbar\"></div></div>");

				// 目次ボタン
				// --------------------------------------------------------------------------------
				var icon_toc = document.createElement("button");
				icon_toc.id = 'icon_toc';
				icon_toc.title = fncGetResourceByResourceId("contents");
				icon_toc.onclick = function () {
					show_mobile_toc(/*true*/);
				}
				if (!is_android_old()) {
					$("#id_flow_toolbar").append(icon_toc);
					//document.getElementById('id_flow_toolbar').appendChild(icon_toc);
				} else {

					// NOTE: android 2.3.6 galaxy s1 stdでアイコンが表示されないことがあるため遅延を加える
					window.setTimeout(function() {
						$("#id_flow_toolbar").append(icon_toc);
					}, 500);
				}

				// 検索ボタン
				// --------------------------------------------------------------------------------

				// 検索モードがGCSの場合
				if (search_mode == "gcs") {
					var icon_search = document.createElement("button");
					icon_search.id = 'icon_search';
					icon_search.title = fncGetResourceByResourceId("search");
					icon_search.onclick = function () {
						show_mobile_search(/*true*/);
					}
					if (!is_android_old()) {
						$("#id_flow_toolbar").append(icon_search);
					} else {
						window.setTimeout(function() {
							$("#id_flow_toolbar").append(icon_search);
						}, 550);
					}

				// ローカル検索モード
				} else {
					var icon_search = document.createElement("button");
					icon_search.id = 'icon_search';
					icon_search.title = fncGetResourceByResourceId("search");
					icon_search.onclick = function () {
						show_mobile_search(/*true*/);
					}
					if (!is_android_old()) {
						$("#id_flow_toolbar").append(icon_search);
					} else {
						window.setTimeout(function() {
							$("#id_flow_toolbar").append(icon_search);
						}, 550);
					}
				}
				if (is_android_old()) {
					window.setTimeout(function() {
						$("#id_flow_toolbar").append(icon_search);
						if (!fncIsSvgEnabled()) {
							fncLoadPng();
						}
					}, 600);
				}

				// ツールバー [戻る]
				// --------------------------------------------------------------------------------
				var prev = document.createElement("button");
				prev.id = 'prev';
				prev.title = fncGetResourceByResourceId("bar_label_previous");
				if (!strPreviousTocId) {
					$(prev).css({'opacity': '0.3', 'cursor': 'default'});
				} else {
					prev.onclick = function () {
						$('#id_flow_prev').click();
					}
				}
				$("#id_flow_toolbar").append(prev);

				// ツールバー [進む]
				// --------------------------------------------------------------------------------
				var next = document.createElement("button");
				next.id = 'next';
				next.title = fncGetResourceByResourceId("bar_label_next");
				next.onclick = function () {
					$('#id_flow_next').click();
				}
				$("#id_flow_toolbar").append(next);
				if (!strNextTocId) {
					$(next).css('opacity', '0.3');
				} else {
					next.onclick = function () {
						$('#id_flow_next').click();
					}
				}

				// ヘルプボタン
				// --------------------------------------------------------------------------------
				var show_help = false;
				var help_toc = fncGetTocNodeByLinkName("help");
				if (help_toc) {
					if ((header) && (header.split(',').indexOf('help') != -1)) {
						var help = document.createElement("button");
						help.id = "help";
						help.title = help_toc.title;
						help.className = "header_help_button";
						help.onclick = function () {
							document.location.href = "../contents/" + help_toc.href;
						};
						$("#id_flow_toolbar").append(help);
						show_help = true;
					}
				}

				// 設定ボタン
				// --------------------------------------------------------------------------------
				var config_toc = fncGetTocNodeByLinkName("config");
				var config = document.createElement("button");
				config.id = "config";
				config.title = config_toc.title;
				config.className = "header_config_button";
				config.onclick = function () {
					document.location.href = "../contents/" + config_toc.href;
				};
				if (!show_help) {
					config.style.right = '0px';
				}
				$("#id_flow_toolbar").append(config);

				$("#id_breadcrumbs").show();
			}

			// 本文
			if (fncGetConstantByName('template_type') != 'ne') {
				$("#id_flow").append("<div id=\"id_flow_content\"></div>");
			} else {
				$("#id_flow").append("<div id=\"id_flow_content\" class=\"normal_content\"></div>"); // NE
			}
			$("#id_flow_content").append($("#id_content").children());

			// スタイル調整
			// ------------------------------------------------------------------------------------
			$('#id_flow_content div.h1, #id_flow_content div.h2, #id_flow_content h1, #id_flow_content h2').css({'margin-right': 0});
			$("#id_flow_content img").css({"max-width": "300px"});

			if (device.android()) {
				var ti = setTimeout(fncAdjustImageWidth, 100); // NOTE: android ffだとmetaで調整した前の幅980が取れてしまう
			} else {
				fncAdjustImageWidth();
			}

			// NOTE: android2.2で縦スクロールが効かない問題対応
			$('html').css('overflow', 'visible');

			//if (window.history && window.history.pushState) {
			//	window.history.pushState("main", null, "#main"); // NOTE: ios chromeでタイトルがURLに変わってしまう。document.titleに"文字列"を加えれば反映されるが、そのままだと無視される
			//	window.setTimeout(function() {
			//		document.title = document.body.getAttribute('data-page-title') + " - Canon";
			//	}, 0);
			//}

			$('#id_search').focus(function() {
				$('.bottom_scroller').hide();
			});
			$('#id_search').blur(function() {
				$('.bottom_scroller').show();
			});

			// チャプター選択プルダウンから移動してきたときは、目次を表示したままにする
			if (fncGetSessionStorage('show-toc') == 'yes') {
				fncSetSessionStorage('show-toc', 'no');
//				$('#icon_toc').click(); // NOTE: android2.3ではclick代理実行効かない
				show_mobile_toc(/*true*/);
			}

			if (device.mobile() || device.tablet() || (navigator.msMaxTouchPoints && navigator.msMaxTouchPoints > 1)) { // PCでモバイルレイアウトでアクセスした場合は表示しない
				var action = document.createElement('button');
				action.id = 'action';
				action.className = 'bottom';

				$('#id_flow').append(action);
				$(action).bind('click', function() {
					if ($(this).hasClass('top')) {
						document.location.href = '#id_flow';
					} else if ($(this).hasClass('bottom')) {
						show_mobile_toc(/*true*/);
					} else if ($(this).hasClass('left')) {
						$('#id_flow_prev').click();
					} else if ($(this).hasClass('right')) {
						$('#id_flow_next').click();
					}
				});

				// スクロールイベント
				var scroll_event_name = 'scroll';
				if (device.mobile() || device.tablet()) {
					scroll_event_name = 'touchmove';
				}

				// iOS+Chromeの場合、スクロール中はsetInteravlのコールバックが実行されない
				var ios_chrome = false;
				if (device.ios()) {
					if (navigator.userAgent.indexOf('CriOS') != -1) {
						ios_chrome = true;
					}
				}
				if (ios_chrome) {
					
					// 初めのスクロールが検知されない
					var first_scroll = true;

					$(window).bind(scroll_event_name, function() {

						// 現在のスクロール量を取得
						var __scroll_top = document.documentElement.scrollTop || document.body.scrollTop;
						if (__scroll_top == 0) {
							__scroll_top = 1;
						}
						var __scroll_left = document.documentElement.scrollLeft || document.body.scrollLeft;

						// 前回取得時点のスクロール量と比較し、一致している場合は抜ける
						if ((scroll_top == __scroll_top) && (scroll_left == __scroll_left) && (!first_scroll)) {
							stopScrollMobile();
						} else {

							first_scroll = false;

							// 本文ページが表示されている場合のみ実施
							if ($('#id_flow_content').is(':visible')) {

								// 移動量の算出
								var x = scroll_left - __scroll_left;
								var y = scroll_top - __scroll_top;

								// 横方向の移動
								if (Math.abs(x) > Math.abs(y)) {

									// 左方向の移動
									if (scroll_left < __scroll_left) {
										$('#action').removeClass('left');
										$('#action').removeClass('top');
										$('#action').removeClass('bottom');
										$('#action').addClass('right');

									// 右方向の移動
									} else {
										$('#action').removeClass('right');
										$('#action').removeClass('top');
										$('#action').removeClass('bottom');
										$('#action').addClass('left');
									}

								// 縦方向の移動
								} else {

									// 上方向の移動
									if (scroll_top < __scroll_top) {
										$('#action').removeClass('top').removeClass('left').removeClass('right').addClass('bottom');

									// 下方向の移動
									} else {
										$('#action').removeClass('left').removeClass('right').removeClass('bottom').addClass('top');
									}
								}
								$('#action').show();
								if (!fncIsSvgEnabled()) {
									fncLoadPng();
								}
							}
						}

						// スクロール量を記憶
						scroll_top = __scroll_top;
						scroll_left = __scroll_left;
					});
				} else {
					$(window).bind(scroll_event_name, function() {

						// スクロール中は処理しない
						if (!scrolling) {

							// スクロール中の監視
							scrolling = setInterval(function() { // NOTE: iOS+Chromeの場合、スクロール中はsetInteravlのコールバックが実行されない

								// 現在のスクロール量を取得
								var __scroll_top = document.documentElement.scrollTop || document.body.scrollTop;
								if (__scroll_top == 0) {
									__scroll_top = 1;
								}
								var __scroll_left = document.documentElement.scrollLeft || document.body.scrollLeft;

								// 前回取得時点のスクロール量と比較し、一致している場合は抜ける
								if ((scroll_top == __scroll_top) && (scroll_left == __scroll_left)) {
									stopScrollMobile();
									clearTimeout(scrolling);
									scrolling = false;
									return;
								} else {

									// 本文ページが表示されている場合のみ実施
									if ($('#id_flow_content').is(':visible')) {

										// 移動量の算出
										var x = scroll_left - __scroll_left;
										var y = scroll_top - __scroll_top;

										// 横方向の移動
										if (Math.abs(x) > Math.abs(y)) {

											// 左方向の移動
											if (scroll_left < __scroll_left) {
												$('#action').removeClass('left');
												$('#action').removeClass('top');
												$('#action').removeClass('bottom');
												$('#action').addClass('right');

											// 右方向の移動
											} else {
												$('#action').removeClass('right');
												$('#action').removeClass('top');
												$('#action').removeClass('bottom');
												$('#action').addClass('left');
											}

										// 縦方向の移動
										} else {

											// 上方向の移動
											if (scroll_top < __scroll_top) {
												$('#action').removeClass('top').removeClass('left').removeClass('right').addClass('bottom');

											// 下方向の移動
											} else {
												$('#action').removeClass('left').removeClass('right').removeClass('bottom').addClass('top');
											}
										}
										$('#action').show();
										if (!fncIsSvgEnabled()) {
											fncLoadPng();
										}
										clearTimeout(stopping);
										stopping = false;
									}
								}

								// スクロール量を記憶
								scroll_top = __scroll_top;
								scroll_left = __scroll_left;
							}, 100);
						}
					});
				}

				var stopping;
				function stopScrollMobile() {
					stopping = window.setTimeout(function() {
						$('#action').hide();
						clearTimeout(stopping);
						stopping = false;
					}, 3000);
				}
			}

			// NE
			// 折り畳み・展開用画像に処理をバインド
			if (fncGetConstantByName('template_type') == 'ne') {
				var imgs = document.getElementById("id_flow_content").getElementsByTagName("img");
				var iLoopLength = imgs.length;
				for (var i = 0; i < iLoopLength; i++) {
					var img = imgs[i];
					if (img.src.indexOf("g_ne_toggle") != -1) {
						img.onclick = function() {
							if (this.parentNode.nodeName.toLowerCase() == "span") {
								fncOpenCloseNextSibling2(this, jQuery(this.parentNode.parentNode).css("margin-left"));
							} else {
								fncOpenCloseNextSibling2(this, jQuery(this.parentNode).css("margin-left"));
							}
						}
						img.style.cursor = "pointer";
					}
				}
			}

		// PC向け処理
		// ----------------------------------------------------------------------------------------
		} else {
			var bar = document.getElementById('id_res_bar_icon_previous').parentNode;
			var icon_toc = document.createElement("button");
			icon_toc.id = 'icon_toc';
			icon_toc.className = 'icon_toc_pc';
			icon_toc.onclick = function () {
				if ($('#id_panel_toc').is(':visible')) {
					$('#id_res_bar_icon_toggle_panel').click();
				} else {
					if ($('#id_panel').is(':hidden')) {
						$('#id_res_bar_icon_toggle_panel').click();
					}
					$('#id_res_contents').click();
				}
				fncOnResize();
			}
			icon_toc.title = fncGetResourceByResourceId("contents");
			$(bar).append(icon_toc);
			var icon_search = document.createElement("button");
			icon_search.id = 'icon_search';
			icon_search.className = 'icon_search_pc';
			icon_search.onclick = function () {

				if ($('#id_panel_search').is(':visible')) {
					$('#id_res_bar_icon_toggle_panel').click();
				} else {
					if ($('#id_panel').is(':hidden')) {
						$('#id_res_bar_icon_toggle_panel').click();
					}
					$('#id_res_search').click();
				}
				fncOnResize();
			}
			icon_search.title = fncGetResourceByResourceId("search");
			$(bar).append(icon_search);

			// NOTE: 古いfirefox等正しいCSS2解釈によるとTDのposition: absoluteは規定されていないので本来レイアウト崩れ（アイコンがバーの外に配置されてしまう）が発生するが、ほとんどのブラウザーでは問題なくレンダリングされる
			// Firefox30において一般のレンダリング方法に歩み寄ってきたが、過去の互換性のため、TDの内側にラップ用DIVを追加する
			$('#id_header table td.bar #id_res_bar_icon_next').parent().wrapInner('<div style="position: relative; padding: 0;margin: 0; font-size: 0; top: -15px;"></div>');

			// NE
			// 折り畳み・展開用画像に処理をバインド
			if (fncGetConstantByName('template_type') == 'ne') {
				var imgs = document.getElementById("id_content").getElementsByTagName("img");
				var iLoopLength = imgs.length;
				for (var i = 0; i < iLoopLength; i++) {
					var img = imgs[i];
					if (img.src.indexOf("g_ne_toggle") != -1) {
						img.onclick = function() {
							if (this.parentNode.nodeName.toLowerCase() == "span") {
								fncOpenCloseNextSibling2(this, jQuery(this.parentNode.parentNode).css("margin-left"));
							} else {
								fncOpenCloseNextSibling2(this, jQuery(this.parentNode).css("margin-left"));
							}
						}
						img.style.cursor = "pointer";
					}
				}
			}

			var action = document.createElement('img');
			action.src = '../images/action-pc.png';
			action.id = 'action-pc';

			$('#id_content').append(action);
			$(action).bind('click', function() {
				document.location.href = '#id_breadcrumbs';
			});

			$('#id_content').bind('scroll', function() {

				// スクロール中は処理しない
				if (!scrolling) {

					// スクロール中の監視
					scrolling = setInterval(function() {

						// 現在のスクロール量を取得
						var __scroll_top = $('#id_content').scrollTop();
						if (__scroll_top == 0) {
							__scroll_top = 1;
						}

						// 前回取得時点のスクロール量と比較し、一致している場合は抜ける
						if (scroll_top == __scroll_top) {
							stopScroll();
							clearTimeout(scrolling);
							scrolling = false;
							return;
						} else {
							$('#action-pc').show();
							clearTimeout(stopping);
							stopping = false;
						}

						// スクロール量を記憶
						scroll_top = __scroll_top;
					}, 100);
				}
			});

			var stopping;
			function stopScroll() {
				stopping = window.setTimeout(function() {
					$('#action-pc').hide();
					clearTimeout(stopping);
					stopping = false;
				}, 3000);
			}
		}

		// svgアイコンの代替
		if (!fncIsSvgEnabled()) {
			fncLoadPng();
			if (stored_layout_mode == 'mobile') {
				$('#id_res_canon_logo img').css({'margin': '7px'});
			}
		} else {

			// キヤノンロゴをSVG化
			var svg_margin_top = "6px";
			if (stored_layout_mode == "mobile") {
				svg_margin_top = "14px";
			}
			$('#id_res_canon_logo img').css({'display': 'none'}).parent().css({'display': 'inline-block', 'margin': svg_margin_top + ' 0 7px 13px', 'height': '16px', 'width': '71px', 'background': "transparent url('data:image/svg+xml;charset=US-ASCII,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22utf-8%22%3F%3E%0D%0A%3C%21--%20Generator%3A%20Adobe%20Illustrator%2014.0.0%2C%20SVG%20Export%20Plug-In%20%20--%3E%0D%0A%3C%21DOCTYPE%20svg%20PUBLIC%20%22-//W3C//DTD%20SVG%201.1//EN%22%20%22http%3A//www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd%22%20%5B%0D%0A%09%3C%21ENTITY%20ns_flows%20%22http%3A//ns.adobe.com/Flows/1.0/%22%3E%0D%0A%5D%3E%0D%0A%3Csvg%20version%3D%221.1%22%0D%0A%09%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20xmlns%3Axlink%3D%22http%3A//www.w3.org/1999/xlink%22%20xmlns%3Aa%3D%22http%3A//ns.adobe.com/AdobeSVGViewerExtensions/3.0/%22%0D%0A%09%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2271px%22%20height%3D%2216px%22%20viewBox%3D%22-0.339%20-0.982%20172%2037%22%20enable-background%3D%22new%20-0.339%20-0.982%20172%2037%22%0D%0A%09%20xml%3Aspace%3D%22preserve%22%3E%0D%0A%3Cdefs%3E%0D%0A%3C/defs%3E%0D%0A%3Cpath%20fill%3D%22%23CC0000%22%20d%3D%22M27.91%2C32.271c-7.948%2C0-14.391-6.443-14.391-14.391S19.962%2C3.489%2C27.91%2C3.489c2.802%2C0%2C5.416%2C0.8%2C7.627%2C2.185%0D%0A%09L27.91%2C17.88l14.359-8.291c-1.559-2.488-3.797-4.631-6.509-6.256C32.323%2C1.274%2C27.535%2C0%2C22.241%2C0C14.684%2C0%2C8.059%2C2.74%2C4.361%2C6.853%0D%0A%09C1.629%2C9.891%2C0%2C13.719%2C0%2C17.88s1.629%2C7.989%2C4.361%2C11.027c3.707%2C4.122%2C10.233%2C6.853%2C17.662%2C6.853s13.953-2.734%2C17.662-6.853%0D%0A%09c0.203-0.226%2C0.399-0.456%2C0.59-0.688l-0.563-2.101C37.11%2C29.838%2C32.794%2C32.271%2C27.91%2C32.271z%22/%3E%0D%0A%3Cpath%20fill%3D%22%23CC0000%22%20d%3D%22M75.51%2C34.887l-6.023-22.479c-0.97-3.629-4.28-6.303-8.215-6.303c-1.022%2C0-2.001%2C0.181-2.909%2C0.511%0D%0A%09l-12.974%2C4.722h13.345l2.281%2C8.514c-2.214-1.908-5.095-3.063-8.247-3.063c-6.262%2C0-11.339%2C4.197-11.339%2C9.376%0D%0A%09s5.077%2C9.376%2C11.339%2C9.376c4.505%2C0%2C8.496-2.205%2C10.952-5.594l1.324%2C4.94H75.51z%20M57.129%2C31.398c-2.89%2C0-5.233-2.343-5.233-5.233%0D%0A%09s2.343-5.233%2C5.233-5.233c2.891%2C0%2C5.233%2C2.343%2C5.233%2C5.233S60.02%2C31.398%2C57.129%2C31.398z%22/%3E%0D%0A%3Cpath%20fill%3D%22%23CC0000%22%20d%3D%22M100.085%2C6.105c-0.791%2C0-1.539%2C0.176-2.212%2C0.49l-8.327%2C3.883c-0.41-2.48-2.564-4.373-5.162-4.373%0D%0A%09c-0.79%2C0-1.539%2C0.176-2.211%2C0.49l-10.171%2C4.743h7.149v23.549h10.467l0-20.933c0-1.445%2C1.172-2.617%2C2.617-2.617%0D%0A%09s2.617%2C1.172%2C2.617%2C2.617v20.933h10.466V11.338C105.317%2C8.448%2C102.976%2C6.105%2C100.085%2C6.105z%22/%3E%0D%0A%3Cpath%20fill%3D%22%23CC0000%22%20d%3D%22M165.718%2C6.105c-0.791%2C0-1.54%2C0.176-2.212%2C0.49l-8.326%2C3.883c-0.41-2.48-2.564-4.373-5.161-4.373%0D%0A%09c-0.791%2C0-1.54%2C0.176-2.213%2C0.49l-10.171%2C4.743h7.15v23.549h10.466V13.955c0-1.445%2C1.172-2.617%2C2.617-2.617s2.616%2C1.172%2C2.616%2C2.617%0D%0A%09l0.001%2C20.933h10.465V11.338C170.95%2C8.448%2C168.608%2C6.105%2C165.718%2C6.105z%22/%3E%0D%0A%3Cpath%20fill%3D%22%23CC0000%22%20d%3D%22M139.333%2C20.933c0%2C8.188-6.638%2C14.828-14.826%2C14.828c-8.189%2C0-14.828-6.639-14.828-14.828%0D%0A%09c0-8.189%2C6.639-14.828%2C14.828-14.828C132.695%2C6.105%2C139.333%2C12.744%2C139.333%2C20.933z%20M125.126%2C10.608%0D%0A%09c-0.468-1.745-2.262-2.781-4.006-2.313c-1.744%2C0.468-2.781%2C2.261-2.313%2C4.006l5.079%2C18.956c0.468%2C1.746%2C2.261%2C2.781%2C4.006%2C2.312%0D%0A%09c1.745-0.467%2C2.78-2.26%2C2.313-4.005L125.126%2C10.608z%22/%3E%0D%0A%3Crect%20x%3D%220.872%22%20y%3D%220.872%22%20fill%3D%22none%22%20width%3D%22170.078%22%20height%3D%2234.016%22/%3E%0D%0A%3C/svg%3E') no-repeat 50% 50%"}).attr('title', 'CANON');
		}

		load_retina_images();

		// NE
		// h2内の折り畳み展開ボタンを垂直中央に揃える
		if (fncGetConstantByName('template_type') == 'ne') {
			window.setTimeout(function() {
				$("div.h2 img, h2 img").each(function() {
					$(this).css("display", "none");
					$(this).css({"position": "absolute", "top": ($(this).parent().outerHeight() / 2) - (20 / 2)});
					$(this).css("display", "inline");
				});
	
				// h2内のトグル画像以外は右揃えにしない
				$("div.h2 img, h2 img").each(function() {
					if ($(this).attr("src").indexOf("toggle") == -1) {
						$(this).css({"position": "static", "margin-right": 0, "vertical-align": "middle"});
					}
				});
	
				// ie8互換モードでh2のアンカーにhoverが誤反応しリンクマークが表示されてしまう問題を回避
				var as = document.getElementsByTagName("a");
				var iLoopLength = as.length;
				for (var i = 0; i < iLoopLength; i++) {
					var a = as[i];
					if (a.innerHTML == "") {
						a.className += " anchor";
					}
				}
	
			}, 300); // NOTE: for android ff
		}

		// ボールドの調整
		if (!fncIsBoldEnabled()) {
			if (fncGetConstantByName('template_type') == 'ne') {
				$('b, table.config th, span.bold, div.step_text, h1, h4, h5, h6, div.h1, div.h4, div.h5, div.h6, div.list_link').each(function() { // ボールド指定が必要なセレクターをここに列挙
					$(this).css({
						'text-shadow': '1px 0 1px ' + $(this).css('color')
					});
				});
			} else {
				$('b, table.config th, span.bold, div.step_text, :header, div.h1, div.h2, div.h3, div.h4, div.h5, div.h6, div.list_link').each(function() { // ボールド指定が必要なセレクターをここに列挙
					$(this).css({
						'text-shadow': '1px 0 1px ' + $(this).css('color')
	//					'-webkit-text-stroke-width': '1px', // NOTE: android2.3で「はじめに」が「にはじめ」と表示されてしまう現象があった
	//					'-webkit-text-stroke-color': $(this).css('color'),
	//					'-webkit-text-fill-color': $(this).css('color')
					});
				});
			}
		}

		var help = fncGetTocNodeByLinkName("help");
		$('#help').on('click', function() {
			document.location.href = "../contents/" + help.href;
		}).attr('title', help.title);
		$('body').css("visibility",  "visible");
		//$('#id_res_guide_name').hide();

		// フォントサイズの再現
		var stored_font_size = fncGetSessionStorage('font-size');
		fncSetFontSize(stored_font_size);

		// ----------------------------------------------------------------------------------------
		// 子画面表示対応
		// ----------------------------------------------------------------------------------------

		// シャドー
		var shadow = document.createElement("div");
		shadow.className = "child_window_shadow";
		shadow.id = "child_window_shadow";
		document.body.appendChild(shadow);

		// スクロールバーの幅算出
		var temp = document.createElement("div");
		temp.style.width = "100px";
		temp.style.height = "100px";
		temp.style.overflow = "scroll";
		temp.style.position = "absolute";
		temp.style.top = "-9999px";
		document.body.appendChild(temp);
		var scroll_width = temp.offsetWidth - temp.clientWidth;
		document.body.removeChild(temp);

		// child_hnとchild_hn_linkの紐付け
		var divs = document.getElementsByTagName("div");
		var loop = divs.length;
		for (var i = 0; i < loop; i++) {
			var div = divs[i];
			if (	(div.className == "child_h1")
				||	(div.className == "child_h2")
				||	(div.className == "child_h3")
				||	(div.className == "child_h4")
				||	(div.className == "child_h5")
			) {
				// 段落内容をID化
				var div_id = div.innerText;
				if (!div_id) {
					div_id = div.textContent;
				}
				div.id = "id_" + div_id;
			} else if (	(div.className == "child_h1_link")
					||	(div.className == "child_h2_link")
					||	(div.className == "child_h3_link")
					||	(div.className == "child_h4_link")
					||	(div.className == "child_h5_link")
			) { // invisible内にある段落「child_hn_link」にリンクを付与
				var a = document.createElement("a");
				a.href = "javascript:void(0);";
				var div_text = div.innerText;
				if (!div_text) {
					div_text = div.textContent;
				}
				a.innerHTML = div_text;
				div.innerHTML = "";
				a.onclick = function() {
					var child_window = this;
					while (child_window.className != "child_window") {
						if (child_window === document.body) {
							return false;
						}
						child_window = child_window.parentNode;
					}
					var child_window_id = this.innerText;
					if (!child_window_id) {
						child_window_id = this.textContent;
					}
					$(child_window).scrollTop(document.getElementById("id_" + child_window_id).offsetTop); // リンク先は同じ段落内容の「child_hn」
				}
				div.appendChild(a);

			// 子画面内「トップに戻る」リンク
			} else if (div.className == "child_link_to_top") {

				// aタグを適用
				var a = document.createElement("a");
				a.href = "javascript:void(0);";
				a.innerHTML = div.innerHTML;
				div.innerHTML = "";

				// クリック時に子画面トップにジャンプする処理をバインド
				a.onclick = function() {
					var child_window = this;
					while (child_window.className != "child_window") {
						if (child_window === document.body) {
							return false;
						}
						child_window = child_window.parentNode;
					}
					$(child_window).scrollTop(0);
				}
				div.appendChild(a);
			}
		}

		// 子画面リスト
		var child_windows = new Array;

		// 文字スタイルchild_h0_link
		var spans = document.getElementsByTagName("span");
		var loop = spans.length;
		for (var i = 0; i < loop; i++) {
			var span = spans[i];
			if (span.className == "child_h0_link") {

				// 段落内テキストがIDとする
				var child_window_name = span.innerText;
				if (!child_window_name) {
					child_window_name = span.textContent;
				}

				// a要素でdiv.child_linkを囲む
				var a = document.createElement("a");
				a.href = "javascript:void(0);";
				a.innerHTML = span.innerHTML;
				a.id = "child_h0_link_" + child_window_name;
				span.innerHTML = "";

				// クリック時の処理をバインド
				a.onclick = function() {
					var title = this.id.split("child_h0_link_")[1];

					// 子画面要素の特定
					var child_window = document.getElementById("child_window_" + title);

					// 子画面を表示
					if (child_window.style.display != "block") {

						// 親ウィンドウのスクロール量を取得
						var scroll_top = $(window).scrollTop();

						// シャドーを表示
						$("html").css({"overflow-y": "hidden", "padding-right": scroll_width});

						$("body").css({"top": (-scroll_top) + "px"});
						$("div.child_window_shadow").css({"top": $(window).scrollTop()});
						if (!document.all) {
							$("div.child_window_shadow").css({"top": "0px"});
							$("div.child_window_shadow").css({"height": $("html").height()});
						}
						$("div.child_window_shadow").show();

						// tabキーの無効化
						document.onkeydown = function() {
							if (event.keyCode == 9) {
								return false;
							}
						};

						document.onkeydown = function() {
							if (event.keyCode == 27) {
								child_window.style.display = "none";

								// 子画面のヘッダー・フッター・背景は使いまわさない
								child_window_header.parentNode.removeChild(child_window_header);
								child_window_footer.parentNode.removeChild(child_window_footer);
								child_window_background.parentNode.removeChild(child_window_background);
								$("html").css({"overflow-y": "auto", "padding-right": 0});
								$("div.child_window_shadow").hide();
								document.onkeydown = function() {};
							}
						};

						// ヘッダーを表示
						var child_window_header = document.createElement("div");
						child_window_header.className = "child_window_header";
						child_window_header.style.top = (50 + $(window).scrollTop()) + "px";
						//child_window_header.style.height = "50px";
						document.body.appendChild(child_window_header);
						child_window_header.style.display = "block";
						var child_window_header_title = document.createElement("span");
						//child_window_header_title.innerHTML = title;
						child_window_header_title.innerHTML = document.getElementById("child_h0_link_" + title).innerHTML;
						// img.linkを除去(ie7対策のリンクマーク画像がchild_window内のchild_linkからコピーしてきてしまう)
						if (child_window_header_title.getElementsByTagName("img").length != 0) {
							child_window_header_title.removeChild(child_window_header_title.getElementsByTagName("img")[0]);
						}
						child_window_header_title.className = "child_window_header_title";
						child_window_header.style.left = (document.body.clientWidth / 2) - (child_window_header.offsetWidth / 2) + "px";
						child_window_header.appendChild(child_window_header_title);

						// レンダリング後の子画面タイトルの高さ調整
						if (child_window_header.offsetHeight < 45) { // 2L: IE51 WFF50 WSF50 MFF52 MSF48
							child_window_header.style.height = "50px";
						} else {
							child_window_header.childNodes[0].style.fontSize = "117%";
							child_window_header.childNodes[0].style.lineHeight = "120%";
							child_window_header.style.height = child_window_header.offsetHeight + 20 + "px";
						}
						child_window_header.style.position = "absolute";
						child_window_header_title.style.position = "absolute";

						// 子画面を表示
						child_window.style.display = "block";
						document.body.appendChild(child_window); // もとの位置のままだとrightのposition: relativeに影響し画面中央に配置できない

						// 子画面の位置決め
						child_window.style.left = (document.body.clientWidth / 2) - (child_window.offsetWidth / 2) + "px";
						child_window.style.top = (50 + 10 + child_window_header.offsetHeight + $(window).scrollTop()) + "px";
						child_window.style.height = $(window).height() - 180 - child_window_header.offsetHeight + "px";

						// ドロップシャドウ用背景を表示
						var child_window_background = document.createElement("div");
						child_window_background.className = "child_window_background";
						child_window_background.style.left = (document.body.clientWidth / 2) - (child_window.offsetWidth / 2) + "px";
						child_window_background.style.top = (50 + $(window).scrollTop()) + "px";
						child_window_background.style.height = $(window).height() - 100 + "px";
						document.body.appendChild(child_window_background);
						child_window_background.style.display = "block";

						// タイトル位置調整
						child_window_header_title.style.top = (child_window_header.offsetHeight / 2) - (child_window_header_title.offsetHeight / 2) + "px";

						// フッターを表示
						var child_window_footer = document.createElement("div");
						child_window_footer.className = "child_window_footer";
						child_window_footer.style.left = (document.body.clientWidth / 2) - (child_window.offsetWidth / 2) + "px";
						child_window_footer.style.top = $(window).scrollTop() + $(window).height() - 100 + "px";
						child_window_footer.style.height = "50px";
						document.body.appendChild(child_window_footer);
						child_window_footer.style.display = "block";

						// 閉じるボタン
						var child_window_close = document.createElement("div");
						child_window_close.className = "child_window_close";
						child_window_close.innerHTML = fncGetResourceByResourceId("child_window_close");
						child_window_close.onclick = function() {
							child_window.style.display = "none";

							// 子画面のヘッダー・フッター・背景は使いまわさない
							child_window_header.parentNode.removeChild(child_window_header);
							child_window_footer.parentNode.removeChild(child_window_footer);
							child_window_background.parentNode.removeChild(child_window_background);
							$("html").css({"overflow-y": "auto", "padding-right": 0});
							$("div.child_window_shadow").hide();
							document.onkeydown = function() {};
							$('body').css({'overflow': 'visible'});
						}
						child_window_close.onmouseover = function() {
							this.style.background = "#f39c15 url(../images/f_chld_win_btn_over.png) repeat-x";
							this.style.color = "#000";
						}
						child_window_close.onmouseout = function() {
							this.style.background = "#666 url(../images/f_chld_win_btn_out.png) repeat-x";
							this.style.color = "#fff";
						}
						child_window_footer.appendChild(child_window_close);
						child_window_close.style.left = (child_window_footer.offsetWidth / 2) - (child_window_close.offsetWidth / 2) + "px";
						child_window_close.style.top = (child_window_footer.offsetHeight / 2) - (child_window_close.offsetHeight / 2) + "px";
						$('body').css({'overflow': 'hidden'});
					}
				}
				span.appendChild(a);

				// 関係するinvisibleを探す（child_h0が一致するもの）
				var divs = document.getElementsByTagName("div");
				var loop_j = divs.length;
				for (var j = 0; j < loop_j; j++) {
					var div = divs[j];
					if (div.className == "child_h0") {

						// マッピング
						var child_h0_text = div.innerText;
						if (!child_h0_text) {
							child_h0_text = div.textContent;
						}
						var child_h0_link_text = a.innerText;
						if (!child_h0_link_text) {
							child_h0_link_text = a.textContent;
						}
						if (child_h0_text == child_h0_link_text) {
							div.parentNode.className = "child_window";
							div.parentNode.id = "child_window_" + child_window_name;

							// ここでクローンするとループがずれるので、ここではリストアップのみ
							child_windows.push(div.parentNode);
						}
					}
				}
			}
		}

		// 印刷用途向けに現在位置にクローンを作る
		var loop = child_windows.length;
		for (var i = 0; i < loop; i++) {
			var print_child_window = child_windows[i].cloneNode(true);
			print_child_window.className = "print_child_window";
			child_windows[i].parentNode.insertBefore(print_child_window, child_windows[i]);

			// 印刷用途向けはID属性値を削除
			fncRemoveId(print_child_window);

			// NOTE: ここに関数定義するとFFで動作しない

		}

		window.onscroll = function() {

			// 子画面のサイズ調整
			if (document.getElementById('child_window_shadow') && (document.getElementById('child_window_shadow').style.display.toLowerCase() == 'block')) {
				var base_child_width = $('div.child_window_background').width() / 2;
				$(".child_window_header").css({"top": (50 + $(window).scrollTop()) + "px"});
				$(".child_window_header").css({"left": (document.body.clientWidth / 2) - (base_child_width) + "px"});
				$(".child_window").css({"top": (50 + 10 + $(".child_window_header").height() + $(window).scrollTop()) + "px"});
				$(".child_window").css({"left": (document.body.clientWidth / 2) - (base_child_width) + "px"});
				$(".child_window").css({"height": $(window).height() - 180 - $(".child_window_header").height() + "px"});
				$(".child_window_background").css({"top": (50 + $(window).scrollTop()) + "px"});
				$(".child_window_background").css({"left": (document.body.clientWidth / 2) - (base_child_width) + "px"});
				$(".child_window_background").css({"height": $(window).height() - 100 + "px"});
				$(".child_window_footer").css({"left": (document.body.clientWidth / 2) - (base_child_width) + "px"});
				$(".child_window_footer").css({"top": $(window).scrollTop() + $(window).height() - 100 + "px"});
				$(".child_window_shadow").css({"left": $(window).scrollLeft()}); // ウィンドウサイズが狭い場合に子画面表示中に横スクロールしても背景影が追従するようにする
			}

			// モバイル目次のフッターナビ
			var scroll_speed = 500;
			var scroll_ease = 'swing';

			// 本文が表示されている場合は実行しない
			if ($('#id_flow_content').is(':visible')) {
				return;
			}

			// NOTE: android mobile ffだとdocument.body.scrollTopが取得できない
			var bottom_speed = 100;
			var scroll_top;
			if (is_android_ff()) {
				scroll_top = $(document).scrollTop();
				if (scroll_top > 50) {
					$('.bottom_scroller').css({
						bottom: 0
					});
				} else {
					$('.bottom_scroller').css({
						bottom: -44
					});
				}
			} else {
				scroll_top = document.body.scrollTop;
				if ($('.bottom_scroller').is(':visible')) { // id_searchにフォーカスがある場合には表示しない

					if (scroll_top > 50) {
						$('.bottom_scroller').animate({
							bottom: 0
						}, bottom_speed, scroll_ease);
					} else {
						$('.bottom_scroller').animate({
							bottom: -44
						}, bottom_speed, scroll_ease);
					}
				}
			}
		};

		// トップページ
		// ----------------------------------------------------------------------------------------
		if (strWindowType == "HOME_TOC") {
			if (stored_layout_mode == 'pc') {

				// 活用術スライド用画像をカルーセルにセット
				var theme_sign = "theme::";
				var carousel = document.getElementById('id_carousel');
				if (carousel) {
					var iLoopLength = toc.length;
					for (var i = 0; i < iLoopLength; i++) {
						if (toc[i].link_name.indexOf(theme_sign) != -1) {
							var link_name_after = toc[i].link_name.split(theme_sign)[1];
							var img = document.createElement('img');
							img.src = "../themes/top_img_" + link_name_after + ".jpg";
							img.theme_href = toc[i].href;
							img.onclick = function() {
								fncOpenSubWindow("../contents/" + this.theme_href, "theme");
							}
							img.width = 600;
							img.height = 304;
							carousel.appendChild(img);
						}
					}
				}
				$('div#id_content').addClass('normal_content');

				// スライドショー
				if (carousel) {
					window.setTimeout(function() {
						try {
							$("div.carousel").carouFredSel(
								{
									auto: {duration: 1000, pauseDuration: 5000, pauseOnHover: true},
									pagination: "#pager",
									circular: false
								}
							);
						} catch (e) {
							document.location.reload(true);
						}
					}, 500);
					$('div#id_content div.carousel img').show();
				}
			} else {
				$('#mobile_home #toc').on('click', function() {
					show_mobile_toc(/*true*/);
				});
			}
		}

		// ----------------------------------------------------------------------------------------
		// 本文レイアウト調整
		// ----------------------------------------------------------------------------------------

		// NE
		if (fncGetConstantByName('template_type') == 'ne') {
			// 折り畳み・展開領域について、非対応ブラウザーでは角丸ドロップシャドウではなく
			// 破線矩形で囲むようにする
			if (!($.support.cssFloat)) {
				$('div.invisible').css({
					"background-color": "#fafafa",
					"border": "dotted 1px #efefef",
				});
			}
		}

		$("div.child_window div.child_link_to_top a").css({
			background: "url(../images/style_child_link_to_top.png) No-Repeat 0 50%",
			paddingLeft: "18px"
		});
		$("div.child_window div.child_link_to_top a img").css({
			display: "none"
		});
		$("div.print_child_window div.child_link_to_top a").css({
			background: "url(../images/style_child_link_to_top.png) No-Repeat 0 50%",
			paddingLeft: "25px"
		});
		$("div.print_child_window div.child_link_to_top a img").css({
			display: "none"
		});

		// 手順番号縦位置が、ひとつ前の段落のマージン設定によってずれてしまう現象を回避するため、見えないボーダーを引く
		$("div.step_number").wrap("<div class=\"step_number_fixer\"></div>");

		// 手順文内のインライングラフィックによってラインが崩れる現象を回避するため、インライングラフィックを浮遊ラッパーで囲み、ベースラインに影響が出ないようにする
		// ただし、インライングラフィックによって行間が自動的に広がらなくなることになるので、インライングラフィックの高さは28pxに制限することとする
		$("div.step_text img").wrap("<span style='display:inline-block;position:relative;vertical-align:middle;height:1em;overflow:visible;'></span>").each(function() {
			if (fncGetConstantByName('template_type') != 'ne') {
				$(this).css({'margin-top': $(this).height() / 2.5 * -1});
			}
		});

		// IE6で箇条書きマークが印刷されない現象を避けるため、ズーム属性を付与
		// CSS側で設定してしまうと、Web編集時に支障をきたすため、ここで設定
		$("div.list, div.list_level0, div.list_level1, div.list_level2, div.bullet, div.dash, div.h3, div.list_annotation").css({zoom: 1});

		// IE6・7、互換モードでは手順番号が飛び出してしまう現象を避ける
		// また、幅指定がWeb編集時に支障をきたすので、CSSではなくここで設定
		if ($.browser.msie && parseInt($.browser.version) == 6) {
			$('div.step_number').css({position: 'absolute', marginLeft: '0', width: '50px', textAlign: 'center', zIndex: 1}); // NOTE: For web edit
			$("div.invisible div.step_number").css({marginLeft: "-20px"}); // NOTE: For web edit
		} else if ($.browser.msie && parseInt($.browser.version) == 7) {

			// ie7
			if (!document.documentMode) {
				//$("div.step_number").before("<div> </div>"); // 手順の前に折りたたみがあると手順番号の横位置が右にずれる問題を回避 →　折りたたみを展開すると数字の縦位置がずれる
				// ie7の場合、Absoluteにすると複数ページ印刷時に手順番号がページ左上に配置されてしまう。
				$("div.step_text").css({marginTop: "-2.7em"});
				$("div.step_number").css({marginLeft: "6px"});
				$("div.step_number_fixer").css({border: "0"});
				$("div.invisible div.step_number").css({marginLeft: "-15px"}); // NOTE: For web edit

				// ie7でテーブル幅が100%だと縦スクロール量が誤認識されてしまう問題を回避
				window.setTimeout(function() {
					$('table.trouble_shooting, table.table_ui, table.table_matrix, table.table_general').css({'width': parseInt(document.getElementById('id_content').style.width) - 60});
				}, 100);

			// 互換モード
			} else {
				$('div.step_number').css({position: 'absolute', marginLeft: '0', width: '50px', textAlign: 'center', zIndex: 1}); // NOTE: For web edit
				$("div.invisible div.step_number").css({marginLeft: "-40px"}); // NOTE: For web edit
			}
		} else {
			$('div.step_number').css({position: 'absolute', marginLeft: '0', width: '50px', textAlign: 'center', zIndex: 1}); // NOTE: For web edit
			$("div.invisible div.step_number").css({marginLeft: "-40px"}); // NOTE: For web edit
		}

		// 上付き文字の幅指定はWeb編集時に支障をきたすので、CSSではなくここで設定
		if (	($.browser.msie && parseInt($.browser.version) != 6)
		) {
			$("div.annotation span.superscript").css({width: "1.5em", display: "Inline-Block", textAlign: "Right", marginLeft: "-2px", position: "Relative"});
		}

		// 手順番号についているドットを消す
		$('div.step_number').each(function() {
			var txt = $(this).html();
			$(this).html(
				txt.replace(/\./g, '')
			);
		});


		////////// step_pathとstep_textの順番を入れ替える

		// step_pathを収集
		$('div.step_path').each(function() {

			// 次の段落がstep_textかstep_pathであれば入れ替える
			while (	($(this).next('div')[0])
				&&	($(this).next('div')[0].className == "step_text"
				||	 $(this).next('div')[0].className == "step_path")
			) {

				// 順番入れ替え
				$(this).next('div').after($(this));

				// 前の段落がstep_pathではなければstep_pathのマージンを詰める
				if (($(this).prev('div')[0].className != 'step_path')) {
					$(this).css({'margin-top': '-24.99px', 'padding-bottom': '25px'});
				}
			}
		});

		// step_textを収集
		$('div.step_text').each(function() {

			// 前の段落がstep_number_fixer（先頭）でなければマージン調整
			if (($(this).prev('div')[0]) && ($(this).prev('div')[0].className != "step_number_fixer")) {
				$(this).css({'margin-top': '-25px', 'padding-bottom': '15px'});
			}

			// 次の段落がstep_pathであればstep_textの下マージン詰める
			if (($(this).next('div')[0]) && ($(this).next('div')[0].className == "step_path")) {
				if ($($(this).next('div')).css('padding-bottom') != '25px') {
					$(this).css({'padding-bottom': '0', 'margin-bottom': '0'});
				}
			}
		});

		// step_pathの下余白調整
		$('div.step_path').each(function() {
			if (($(this).css('margin-top') == '-24.99px') || ($(this).css('margin-top') == '-24px')) { // NOTE: ie8では小数点以下が切り捨てられる
				if (($(this).next('div')[0]) && (($(this).next('div')[0].className != "step_path") && ($(this).next('div')[0].className != "step_text"))) {
					$(this).css({'padding-bottom': '0'});
				}
			}
		});

		// スマートフォン・タブレットの場合はスワイプ操作にページ移動を割り当てる
		if (device.mobile() || device.tablet()/* || (navigator.msMaxTouchPoints && navigator.msMaxTouchPoints > 1)*/) { // NOTE: surfaceではCSS側の「-ms-touch-action」で「double-tap-zoom」とすることでブラウザー側のジェスチャーからスワイプイベントを奪うことができるが、縦スワイプによるスクロールが効かなくなる
			$(window).on('swipeleft', function(e) {
				if ($('#id_flow_content').is(':visible')) {
//					$('#id_flow_next').click();
					if ($('#id_flow_next').attr('disabled') != 'disabled') {
						$('#action').show();
						$('#action').addClass('right');
						$('#action').removeClass('left');
						$('#action').removeClass('top');
						$('#action').removeClass('bottom');
						if (!fncIsSvgEnabled()) {
							fncLoadPng();
						}
					}
				}
			});
			$(window).on('swiperight', function(e) {
				if ($('#id_flow_content').is(':visible')) {
//					$('#id_flow_prev').click();
					if ($('#id_flow_prev').attr('disabled') != 'disabled') {
						$('#action').show();
						$('#action').addClass('left');
						$('#action').removeClass('right');
						$('#action').removeClass('top');
						$('#action').removeClass('bottom');
						if (!fncIsSvgEnabled()) {
							fncLoadPng();
						}
					}
				}
			});
		}

		// 特定の表の前にズームボタンを配置する
		if ((stored_layout_mode == 'mobile') && (device.mobile() || device.tablet())) {
			var flow_content = document.getElementById('id_flow_content');
			if (flow_content) {
				var tables = flow_content.getElementsByTagName('table');
				var loop = tables.length;
				for (var i = 0; i < loop; i++) {
					var table = tables[i];
					if (	(table.className == "table_general")
						||	(table.className == "table_general_level0") // NE
						||	(table.className == "table_general_level1") // NE
						||	(table.className == "table_general_level2") // NE
						||	(table.className == "table_matrix")
						||	(table.className == "table_matrix_level0") // NE
						||	(table.className == "table_matrix_level1") // NE
						||	(table.className == "table_matrix_level2") // NE
						||	(table.className == "table_ui")
						||	(table.className == "trouble_shooting")
					) {
						var button = document.createElement('button');
						button.setAttribute('data-order', i);
						button.className = 'open_table';
						button.onclick = function () {
							fncOpenTable(document.location.href, this.getAttribute('data-order'));
						}
						table.parentNode.insertBefore(button, table);
					}
				}

				if (fncGetConstantByName('template_type') == 'ne') {
					$('button.open_table').css({'margin-left': '0'}); // デフォルトは-20px
				}
			}
		}

		// 章扉レイアウト調整
		// ----------------------------------------------------------------------------------------
		if (fncGetConstantByName('template_type') != 'ne') { // NEには不要
			if (cover) {
				var current_toc = fncGetTocById(strCurrentTocId);
				var current_link_name = current_toc.link_name;
				var loop = cover.length;
				for (var i = 0; i < loop; i++) {
					if (cover[i].cover_name == current_link_name) {
						$('h1, div.h1').css({'display': 'none'});
						$('h2, div.h2').css({'margin': '0 10px 0 10px', 'padding': '0 5px 0 5px', 'background': 'transparent', 'font-size': '120%'});
						$('h3, div.h3').css({'margin-top': '15px'});
						$('.hr2').css({'display': 'none'});
						//$('.col_0.row_0.table_no_border.table_no_border_col_0.table_no_border_row_0 img').css({'display': 'none'}); // ←複数テンプレートを使用しているとstyleNNNがクラス名に含まれるため適用されない
						$('div.table_no_border table.table_no_border img').css({'display': 'none'});
					}
				}
			}
		}

		//if (window.history && window.history.pushState) {
		//	$(window).on('popstate', function(event) {
		//		try {
		//			var stored_layout_mode = fncGetLayoutMode();
		//			if (stored_layout_mode == "mobile") {
		//				var state = event.originalEvent.state;
		//				if (state == "search") {
		//					show_mobile_search();
		//				} else if (state == "toc") {
		//					show_mobile_toc();
		//				} else if (state == "main") {
		//					show_mobile_main();
		//				} else {
		//					// NOTE: ie10では信頼サイトではない場合document.referrerが取得できない
		//					if (document.location.hash == "") {
		//						if (from.indexOf(document.location.hostname) != -1) {
		//							history.back(); // ページロード直後にブラウザーの←をクリックすると#mainが取れるだけで前のページに戻れない現象を回避するために加えたが、mac safariで初回アクセス時にページにたどりつかず、前ページに強制移動してしまう
		//						}
		//					}
		//				}
		//				//window.history.replaceState("");
		//			}
		//		} catch (e) {
		//		}
		//	});
		//}

		// 言語属性によってフォントを切替
		if (document.body.lang == 'zh-CN') {
			$('*').css({'font-family': '"Microsoft YaHei", "SimSun", "Arial", "Helvetica", Sans-serif'});
		} else if (document.body.lang == 'zh-TW') {
			$('*').css({'font-family': '"Microsoft JhengHei", "PMingLiU", "Arial", "Helvetica", Sans-serif'});
		} else if ((document.documentElement.lang == 'kr') || (document.documentElement.getAttribute('xml:lang') == 'ko')) {
			$('*').css({'font-family': '"Malgun Gothic", "Gulim", "Arial", "Helvetica", Sans-serif'});
		}

	} catch (e) {
//		alert("onload: " + e);
	}
} // END OF ONLOAD

// 指定したノード以下のID属性値を空にする
function fncRemoveId(target) {
	if (target.nodeType == 1) { // ELEMENT_NODE

		// ID属性値をリセット
		target.id = "";

		// 下階層を走査
		var loop = target.childNodes.length;
		for (var j = 0; j < loop; j++) {
			fncRemoveId(target.childNodes[j]);
		}
	}
}

var wnd_table;
function fncOpenTable(url, order) {
	try {

		// URLを分解して自分のファイル名を取得
		var arr = url.split('/');
		var file_name = arr[arr.length - 1];
		file_name = file_name.split('#')[0];
		var url = 'table.html#' + file_name + '::' + order + '?z=1';
		window.open(url, '_blank');

		// NOTE: 表のための別ウィンドウを再利用し、ウィンドウが増殖することを防ぐことを考えていたが、ブラウザーごとに挙動が大きく異なり、また将来的にも動作を保障できないので、単純に開くだけに変更

//		if (device.ios()) {
//
//			// chrome
//			if (navigator.userAgent.indexOf('CriOS') != -1) {
//				var gc_version = window.navigator.userAgent.split('CriOS/')[1];
//				gc_version = parseInt(gc_version);
//				if (gc_version <= 28) {
//
//					// ポップアップブロックのメッセージが表示されてしまう（close→openしなければメッセージ表示されないが再利用時に内容が更新されない）
//					if (wnd_table) {
//						wnd_table.close();
//					}
//					wnd_table = window.open(url, 'canon_sub');
//					wnd_table.focus();
//
//				} else {
//					wnd_table = window.open(url, 'canon_sub');
//					wnd_table = window.open(url, 'canon_sub'); // 2回目だと反映されることを利用して、2回呼び出す
//
//					// iosのchromeではwnd_tableにはnullが返ってくる
//					// popup blockの懸念
//				}
//
//			// safari
//			} else {
//				if (navigator.userAgent.indexOf('Version/6.0') != -1) {
//					wnd_table = window.open(url, 'canon_sub'); // ios6+safariで先にウィンドウを閉じようとするとabout:blankのウィンドウが残る
//					wnd_table.focus();
//				} else {
//					if (wnd_table) { // 別タブを前面に切り替えるためには、一度タブを落とす必要がある
//						wnd_table.close();
//					}
//					wnd_table = window.open(url, 'canon_sub');
//					wnd_table.focus();
//				}
//
//				// 別ウィンドウが増えていくことはないが、一旦閉じているので別ウィンドウ側で←→が使えない
//			}
//		} else if (device.android()) {
//			if (navigator.userAgent.indexOf('Firefox') != -1) {
////				window.open(url, '_blank'); // 新規別ウィンドウで開く（再利用は諦める）
//
//				if (wnd_table) {
//					wnd_table.close();
//				}
//				window.setTimeout(function() {
//					wnd_table = window.open(url, 'canon_sub');
//				}, 500);
////				wnd_table.focus();
//
//			} else {
//				wnd_table = window.open('about:blank', 'canon_sub');
//				wnd_table.close();
//				wnd_table = window.open(url, 'canon_sub');
//				window.blur();
//				wnd_table.focus();
//			}
//		} else {
//			window.open(url, '_blank'); // 新規別ウィンドウで開く（再利用は諦める）
//		}
	} catch (e) {
//		alert(e);
	}
}
function fncIsSvgEnabled() {
	return !!(document.createElementNS && document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect);
}
function fncLoadPng() {
	$('button#icon_toc').css('background-image', 'url(' + frame_path + 'images/bullets-black.png)');
	$('button#icon_search').css('background-image', 'url(' + frame_path + 'images/search-black.png)');
	$('#id_flow_toolbar button#prev, #id_flow_actions button#id_flow_prev').css('background-image', 'url(' + frame_path + 'images/carat-l-black.png)');
	$('#id_flow_toolbar button#next, #id_flow_actions button#id_flow_next').css('background-image', 'url(' + frame_path + 'images/carat-r-black.png)');
	$('#id_side_toc_toolbar button#close_toc').css('background-image', 'url(' + frame_path + 'images/delete-black.png)');
	$('#id_side_search_toolbar button#close_search').css('background-image', 'url(' + frame_path + 'images/delete-black.png)');
	$('#id_side_toc #scroll_up, #id_side_search #scroll_up').css('background-image', 'url(' + frame_path + 'images/carat-u-white.png)');
	$('#id_side_toc #scroll_top, #id_side_search #scroll_top').css('background-image', 'url(' + frame_path + 'images/carat-t-white.png)');
	$('#id_side_toc #scroll_down, #id_side_search #scroll_down').css('background-image', 'url(' + frame_path + 'images/carat-d-white.png)');
	$('#id_side_toc #scroll_close, #id_side_search #scroll_close').css('background-image', 'url(' + frame_path + 'images/delete-white.png)');
	$('#search_mobile #id_search_button, #id_tabs.bar button#id_search_button').css('background-image', 'url(' + frame_path + 'images/search-white.png)');
	$('#sliderwrapper #slider_top').css('background-image', 'url(' + frame_path + 'images/carat-u-white.png)');
	$('button#config').css('background-image', 'url(' + frame_path + 'images/gear-black.png)');
	$('button#help').css('background-image', 'url(' + frame_path + 'images/help.png)');
	$('#id_header table td.bar #id_res_bar_icon_previous').css('background-image', 'url(' + frame_path + 'images/carat-l-black.png)');
	$('#id_header table td.bar #id_res_bar_icon_next').css('background-image', 'url(' + frame_path + 'images/carat-r-black.png)');
	$('button#icon_plus').css('background-image', 'url(' + frame_path + 'images/plus-white.png)');
	$('button#icon_minus').css('background-image', 'url(' + frame_path + 'images/minus-white.png)');
	$('img.plus').css('background-image', 'url(' + frame_path + 'images/chapter-sign-2-24.png)');
	$('img.minus').css('background-image', 'url(' + frame_path + 'images/chapter-sign-1-24.png)');
	$('img.chapter-sign-1').css('background-image', 'url(' + frame_path + 'images/chapter-sign-1-24.png)');
	$('img.chapter-sign-2').css('background-image', 'url(' + frame_path + 'images/chapter-sign-2-24.png)');
	$('img.toc-sign-0-active').css('background-image', 'url(' + frame_path + 'images/toc-sign-0-active.png)');
	$('img.toc-sign-0').css('background-image', 'url(' + frame_path + 'images/toc-sign-0.png)');
	$('img.toc-sign-1').css('background-image', 'url(' + frame_path + 'images/toc-sign-1.png)');
	$('img.toc-sign-2').css('background-image', 'url(' + frame_path + 'images/toc-sign-2.png)');
	$('#action.top').css('background-image', 'url(' + frame_path + 'images/carat-t-white.png)');
	$('#action.bottom').css('background-image', 'url(' + frame_path + 'images/bullets-white.png)');
	$('#action.left').css('background-image', 'url(' + frame_path + 'images/carat-l-white.png)');
	$('#action.right').css('background-image', 'url(' + frame_path + 'images/carat-r-white.png)');
	$('.open_table').css('background-image', 'url(' + frame_path + 'images/zoomin-white.png)');
	$('table.config td button.button_back').css('background-image', 'url(' + frame_path + 'images/arrow-l-white.png)');
}
function fncPlaceBottomNav(place) {

	var scroll_speed = 500;
	var scroll_ease = 'swing';

	var bottom_scroller = document.createElement('div');
	bottom_scroller.id = 'bottom_scroller';
	bottom_scroller.className = 'bottom_scroller';

	// scroll-up ----------------------------------------------------------------------------------
	var scroll_up = document.createElement('button');
	scroll_up.id = 'scroll_up';
	scroll_up.innerHTML = '';
	scroll_up.onclick = function(e) {
		if (is_android_ff()) {
			window.setTimeout(function() {
				var speed = 500;
				var y = $(document).scrollTop() - $(window).height();
				if (y < 0) {
					y = 1; // NOTE: android 2.2 std トップにジャンプした後元の位置に戻ってしまう現象を回避
				}
				$(document).scrollTop(y);
			}, 100);
		} else {
			//var y = document.body.scrollTop - $(window).height();
			var y = $(document).scrollTop() - $(window).height();
			if (y < 0) {
				y = 1; // NOTE: android 2.2 std トップにジャンプした後元の位置に戻ってしまう現象を回避
			}
			$('body').animate({ // $('html, body')
				scrollTop: y
			}, scroll_speed, scroll_ease);
		}
	};
	$(bottom_scroller).append($(scroll_up));

	// scroll-top ---------------------------------------------------------------------------------
	var scroll_top = document.createElement('button');
	scroll_top.id = 'scroll_top';
	scroll_top.innerHTML = '';
	scroll_top.onclick = function(e) {
		if (is_android_ff()) {
			window.setTimeout(function() {
				window.scrollTo(0, 1);

				// 最上部なのでバーを隠す
				$('.bottom_scroller').css({
					bottom: -44
				});

			}, 100);


		} else {
			window.scrollTo(0, 1);

			// 最上部なのでバーを隠す
			var bottom_speed = 100;
			var scroll_ease = 'swing';
			$('.bottom_scroller').animate({
				bottom: -44
			}, bottom_speed, scroll_ease);
		}
	};
	$(bottom_scroller).append($(scroll_top));

	// scroll-down --------------------------------------------------------------------------------
	var scroll_down = document.createElement('button');
	scroll_down.id = 'scroll_down';
	scroll_down.innerHTML = '';
	scroll_down.onclick = function(e) {
		if (is_android_ff()) {
			window.setTimeout(function() {
				var speed = 500;
				var y = $(document).scrollTop() + $(window).height();
				$(document).scrollTop(y);
			}, 100);
		} else {
			var speed = 500;
			var y = $(document).scrollTop() + $(window).height();
			$('body').animate({
				//scrollTop: document.body.scrollTop + $(window).height()
				scrollTop: y
			}, scroll_speed, scroll_ease);
		}
	};
	$(bottom_scroller).append($(scroll_down));

	// close ---------------------------------------------------------------------------------------
	var scroll_close = document.createElement('button');
	scroll_close.id = 'scroll_close';
	scroll_close.innerHTML = '';
	scroll_close.onclick = function(e) {
		show_mobile_main(/*true*/);
	};
	$(bottom_scroller).append($(scroll_close));

	// 組み立てたボタンを配置
	$(place).append($(bottom_scroller));

	// 少しスクロールしたらボタンを表示させる
//	window.onscroll = function() {
//
//		// 本文が表示されている場合は実行しない
//		if ($('#id_flow_content').is(':visible')) {
//			return;
//		}
//
//		// NOTE: android mobile ffだとdocument.body.scrollTopが取得できない
//		var bottom_speed = 100;
//		var scroll_top;
//		if (is_android_ff()) {
//			scroll_top = $(document).scrollTop();
//			if (scroll_top > 50) {
//				$('.bottom_scroller').css({
//					bottom: 0
//				});
//			} else {
//				$('.bottom_scroller').css({
//					bottom: -44
//				});
//			}
//		} else {
//			scroll_top = document.body.scrollTop;
//			if ($('.bottom_scroller').is(':visible')) { // id_searchにフォーカスがある場合には表示しない
//
//				if (scroll_top > 50) {
//					$('.bottom_scroller').animate({
//						bottom: 0
//					}, bottom_speed, scroll_ease);
//				} else {
//					$('.bottom_scroller').animate({
//						bottom: -44
//					}, bottom_speed, scroll_ease);
//				}
//			}
//		}
//	};
}

function is_android_old() {
	if (device.android() && (navigator.userAgent.indexOf("2.3.6") != -1)) {
		return true;
	} else {
		return false;
	}
}

function is_android_ff() {
	if (device.android() && (navigator.userAgent.indexOf("Firefox") != -1)) {
		return true;
	} else {
		return false;
	}
}
//bWideTocMode = false;
// NOTE: IE678以外のブラウザーはdisplay属性で表示・非表示を切り替えた際、元のスクロール位置が保持されない
var nTempSearchChaptersScrollTop = -1;
var nTempSearchResultsScrollTop = -1;
var nTempTocScrollTop = -1;
function fncResContentsClick() {
	try {

		// 非表示にされるボックスのスクロール位置を一時記憶
		if (document.getElementById("id_search_chapters")) {
			nTempSearchChaptersScrollTop = document.getElementById("id_search_chapters").scrollTop;
		}
		if (document.getElementById("id_search_results")) {
			nTempSearchResultsScrollTop = document.getElementById("id_search_results").scrollTop;
		}

		// 表示・非表示の切り替え
		document.getElementById("id_res_contents").className = "tab_active";
		document.getElementById("id_res_search").className = "tab_inactive";
		document.getElementById("id_panel_toc").style.display = "Block";
		document.getElementById("id_panel_search").style.display = "None";
		$('#icon_plus').show();
		$('#icon_minus').show();
		$('#chapters').show();
		$('#id_search').hide();
		$('#id_search_button').hide();
		// 非表示にされていたボックスのスクロール位置を復元
		if (	(document.getElementById("id_toc"))
			&&	(nTempTocScrollTop != -1)
		) {
			document.getElementById("id_toc").scrollTop = nTempTocScrollTop;
		}

		// 選択中のトピックをハイライト
		var iframe = document.getElementById('iframe_toc');
		if (iframe && iframe.contentWindow.document.getElementById('id_toc_current')) {
			var stored_layout_mode = fncGetLayoutMode();
			if (stored_layout_mode == "mobile") {
				iframe.contentWindow.document.getElementById('scroll_anchor').scrollIntoView(false); // NOTE: scrollIntoView(true)だとgcなどでiframeが5ピクセル程度縦にずれてしまう（iframeごと若干スクロール）
			} else {
				if (device.ipad()) {
					iframe.contentWindow.document.getElementById('id_toc_current').scrollIntoView(true); // NOTE: ipadで目次クリック時にHTML全体が反応してしまう現象をtrueで回避
				} else {
					iframe.contentWindow.document.getElementById('id_toc_current').scrollIntoView(false); // NOTE: scrollIntoView(true)だとgcなどでiframeが5ピクセル程度縦にずれてしまう（iframeごと若干スクロール）
				}
			}
		}
	} catch (e) {
		//alert(e);
	}
}
function fncResSearchClick() {
	try {

		// 非表示にされるボックスのスクロール位置を一時記憶
		if (document.getElementById("id_toc")) {
			nTempTocScrollTop = document.getElementById("id_toc").scrollTop;
		}

		// 表示・非表示の切り替え
		document.getElementById("id_res_search").className = "tab_active";
		document.getElementById("id_res_contents").className = "tab_inactive";

		document.getElementById("id_panel_toc").style.display = "None";
		document.getElementById("id_panel_search").style.display = "Block";
		$('#icon_plus').hide();
		$('#icon_minus').hide();
		$('#chapters').hide();
		$('#id_search').show();
		$('#id_search_button').show();
//		document.getElementById("chapters").style.display = "None";

		// 非表示にされていたボックスのスクロール位置を復元
		if (	(document.getElementById("id_search_chapters"))
			&&	(nTempSearchChaptersScrollTop != -1)
		) {
			document.getElementById("id_search_chapters").scrollTop = nTempSearchChaptersScrollTop;
		}
		if (	(document.getElementById("id_search_results"))
			&&	(nTempSearchResultsScrollTop != -1)
		) {
			document.getElementById("id_search_results").scrollTop = nTempSearchResultsScrollTop;
		}
	} catch (e) {
		//alert(e);
	}
}

function fncMarkupSearch() {
	return false;
}

// ------------------------------------------------------------------------------------------------
// 本文中の検索キーワードと合致する文字列をハイライトする
// ------------------------------------------------------------------------------------------------
function fncMarkupText(element, arrSearchText, strSearchOptionCaseSensitive, bWordMarking) {
	try {

		// 子ノード数分繰り返し
		var nElementChildLength = element.childNodes.length;
		for (var i = 0; i < nElementChildLength; i++) {
			var child = element.childNodes[i];

			// パンくず部分は対象外
			if (child.id == "id_breadcrumbs") {
				continue;
			}

			// #textまでたどり着いたらマークアップ処理
			if (child.nodeType == 3) { // #text

				var strNodeValue = child.nodeValue;

				// NOTE: Safariにおいて検索画面からジャンプした際に表レイアウトが崩れる現象を回避
				// トリムした結果文字列が残らない場合はマーキング処理を実行しない
				var strNodeValueTemp = strNodeValue.replace(/\t| |\n/g, "");
				if (strNodeValueTemp == "") {
					continue;
				}

				// マーキング対象の有無
				var bIsMarkedup = false;

				// 各検索条件文字列にマーキング
				// 10種類のカラーバリエーションを循環
				var nMarkerColor = 0;
				var nSearchTextLength = arrSearchText.length;
				for (var j = 0; j < nSearchTextLength; j++) {

					// 1桁数字を検索した場合にカラーバリエーションクラス名まで文字列置換されてしまうことを防ぐ
					// 0-9の代わりにU+2080(Subscript Zero)-U+2089(Subscript Nine)を使用する
					switch (nMarkerColor) {
						case 0:
							strMarkerColor = String.fromCharCode(0x2080); // "₀";
							break;
						case 1:
							strMarkerColor = String.fromCharCode(0x2081); // "₁";
							break;
						case 2:
							strMarkerColor = String.fromCharCode(0x2082); // "₂";
							break;
						case 3:
							strMarkerColor = String.fromCharCode(0x2083); // "₃";
							break;
						case 4:
							strMarkerColor = String.fromCharCode(0x2084); // "₄";
							break;
						case 5:
							strMarkerColor = String.fromCharCode(0x2085); // "₅";
							break;
						case 6:
							strMarkerColor = String.fromCharCode(0x2086); // "₆";
							break;
						case 7:
							strMarkerColor = String.fromCharCode(0x2087); // "₇";
							break;
						case 8:
							strMarkerColor = String.fromCharCode(0x2088); // "₈";
							break;
						case 9:
							strMarkerColor = String.fromCharCode(0x2089); // "₉";
							break;
					}

					// キーワードの取り出し
					var strSearchText = arrSearchText[j];

					// キーワードに合致するかどうかを判定
					var strSearchTextParam = "(" + strSearchText + ")";
					if (bWordMarking) {
						// 単語単位で検索された文字列をマーキング
						strSearchTextParam = "\\b(" + strSearchText + ")\\b";
					}
					var re = new RegExp(strSearchTextParam, "g" + strSearchOptionCaseSensitive);

					if (re.exec(strNodeValue) != null) {

						// テキスト値に<～>で囲まれた文字列が含まれると、innerHTMLで戻すときにタグとして認識され、囲まれた文字列が表示されなくなってしまう現象を回避
						// またマーキング用のタグ文字列と部分合致するキーワードが検索された場合にマーキング用タグまで文字列置換されてしまうことを防ぐ
						// マーキング開始タグの開始:	⁅(U+2045(Left Square Bracket With Quill))
						// マーキング開始タグの終了:	⁆(U+2046(Right Square Bracket With Quill))
						// マーキング終了タグ:			₎(U+208E(Subscript Right Parenthesis))
						//var strNodeValue = strNodeValue.replace(re, "⁅" + strMarkerColor + "⁆$1₎");
						var strNodeValue = strNodeValue.replace(re, String.fromCharCode(0x2045) + strMarkerColor + String.fromCharCode(0x2046) + "$1" + String.fromCharCode(0x208E));
						bIsMarkedup = true;
					}
					nMarkerColor++;
					if (nMarkerColor >= 10) {
						nMarkerColor = 0;
					}
				}
				if (bIsMarkedup) {

					// テキスト値に<～>で囲まれた文字列が含まれると、innerHTMLで戻すときにタグとして認識され、囲まれた文字列が表示されなくなってしまう現象を回避
					strNodeValue = strNodeValue.replace(/</g, "&lt;");
					strNodeValue = strNodeValue.replace(/>/g, "&gt;");

					// マーキングタグを復元
					strNodeValue = strNodeValue.replace(/\u2045/g, "<span id=\"id_hit\" class=\"hit hit_"); // ⁅
					strNodeValue = strNodeValue.replace(/\u2046/g, "\">"); // ⁆
					strNodeValue = strNodeValue.replace(/\u2080/g, "0"); // ₀
					strNodeValue = strNodeValue.replace(/\u2081/g, "1"); // ₁
					strNodeValue = strNodeValue.replace(/\u2082/g, "2"); // ₂
					strNodeValue = strNodeValue.replace(/\u2083/g, "3"); // ₃
					strNodeValue = strNodeValue.replace(/\u2084/g, "4"); // ₄
					strNodeValue = strNodeValue.replace(/\u2085/g, "5"); // ₅
					strNodeValue = strNodeValue.replace(/\u2086/g, "6"); // ₆
					strNodeValue = strNodeValue.replace(/\u2087/g, "7"); // ₇
					strNodeValue = strNodeValue.replace(/\u2088/g, "8"); // ₈
					strNodeValue = strNodeValue.replace(/\u2089/g, "9"); // ₉
					strNodeValue = strNodeValue.replace(/\u208E/g, "</span>"); // ₎

					// マーキング済みの文字列に差し替え
					var newNode = document.createElement("span");
					newNode.innerHTML = strNodeValue;
					element.replaceChild(newNode, child);
				}

			// <div><span><a>はさらに子ノードを処理
			} else {
				fncMarkupText(child, arrSearchText, strSearchOptionCaseSensitive, bWordMarking);
			}
		}
	} catch (e) {
	}
}

// ズームでリサイズイベントが発動しない問題を防ぐ（IE8）
try {
	if (document.all) {
		if (document.documentMode == 8) {
			window.setInterval(fncOnResize, 500);
		}
	}
} catch (e) {
}

// 各ペインをウィンドウサイズに合わせてサイズ調整
window.onresize = fncOnResize;
function fncOnResize() {
	try {

		// ウィンドウサイズの取得
		var w = fncGetWindowWidth();
		var h = fncGetWindowHeight();

		// メインウィンドウ
		if (document.location.search.indexOf("?sub=yes") == -1) {

			var stored_layout_mode = fncGetLayoutMode();

			// パネル高さ・目次高さ・コンテンツ高さ
			document.getElementById("id_panel").style.height = h - 67 + "px";
			document.getElementById("id_content").style.height = h - 67 + "px";

			// ペイントグルボタンがない場合のコンテンツ幅設定
			if (!document.getElementById('id_res_bar_icon_toggle_panel')) {
				document.getElementById("id_content").style.width = w - 300 + "px";

			// 左ペインが表示された状態のコンテンツ幅
			} else if (document.getElementById('id_res_bar_icon_toggle_panel').className == 'hide') {
				document.getElementById("id_content").style.width = w - 300 + "px";
//				$('#id_header').width(w); // NOTE: for galaxy s3 std

			// 左ペインが非表示の状態のコンテンツ幅
			} else {
				document.getElementById("id_content").style.width = w - 0 + "px";
			}

			// 検索結果

			// ローカル検索
			if (search_mode != "gcs") {
				if (stored_layout_mode == "pc") {
					document.getElementById("id_search_results").style.height = h - 118 + "px";
				} else {
					document.getElementById("id_search_results").style.height = h - 138 + "px";
				}

			// Google検索
			} else {

				// PCでモバイルレイアウトを利用している場合は検索領域の高さを確保
				var stored_layout_mode = fncGetLayoutMode();
				if (stored_layout_mode == "pc") {
					document.getElementById("id_search_results").style.height = h - 118 + "px";
				} else {
					document.getElementById("id_search_results").style.height = h - 138 + "px";
				}
			}

			// TOC表示エリア
			if ((stored_layout_mode == "pc") && toc_mode == "json") {
				if (document.getElementById("id_toc")) {
					document.getElementById("id_toc").style.top = "0px";
					document.getElementById("id_toc").style.height = h - 120 + "px";
				}
			} else if ((stored_layout_mode == "pc") && toc_mode == "iframe") {
				if (document.getElementById("id_toc")) {
					document.getElementById("id_toc").style.top = "0px";
					document.getElementById("id_toc").style.height = h - 66 + "px";
				}
			}

			if (toc_mode == 'iframe') {
				if (!device.mobile() && !device.tablet()) { // NOTE: ie10(PC)でモバイルレイアウトでアクセスしたときに目次の高さが確保されない
					$('#toc_mobile').css({'height': $(window).height() - 89}); // 95
				}
			}

			// トップページ
			if (strWindowType == "HOME_TOC") {

				// 一列表示のための順序入れ替え
				var rb = $('.right.b').get(0);
				if (rb) {
					rb.parentNode.appendChild(rb);
				}

				$(".home").css("width", document.getElementById("id_content").style.width);
				var pc_home_width = $('#pc_home').width();
				if (pc_home_width > 700) {
					var column_width = (pc_home_width / 2) - 52; //60
					$('.column .left').css({'width': column_width, 'position': 'absolute', 'left': '0'});
					$('.column .right').css({'width': column_width, 'position': 'absolute', 'right': '0'});

					$('.column').each(function() {
						var column_left_height = $(this).children('.left').outerHeight();
						var column_right_height = $(this).children('.right').outerHeight();
						var column_height;
						if (column_left_height < column_right_height) {
							column_height = column_right_height;
							$(this).children('.left').height(column_height - 35); // 35: padding
						} else {
							column_height = column_left_height;
							$(this).children('.right').height(column_height - 35);
						}
						$(this).css({'height': column_height});
						//$(this).css({'margin-bottom': '25px'});
					});

				} else {
					$('.column .left').css({'width': pc_home_width - 40, 'position': 'static'});
					$('.column .right').css({'width': pc_home_width - 40, 'position': 'static'});
					$('.column .left').parent().css({'height': 'auto'});
					$('.column .left').height('auto');
					$('.column .right').height('auto');
				}
			}

			// 子画面のサイズ調整
			if (document.getElementById('child_window_shadow') && (document.getElementById('child_window_shadow').style.display.toLowerCase() == 'block')) {
				var base_child_width = $('div.child_window_background').width() / 2;
				$('.child_window_header').css({'left': (document.body.clientWidth / 2) - (base_child_width) + 'px'});
				$('.child_window').css({'left': (document.body.clientWidth / 2) - (base_child_width) + 'px'});
				$('.child_window').css({'height': $(window).height() - 180 - $('.child_window_header').height() + 'px'});
				$('.child_window_background').css({'left': (document.body.clientWidth / 2) - (base_child_width) + 'px'});
				$('.child_window_background').css({'height': $(window).height() - 100 + 'px'});
				$('.child_window_footer').css({'left': (document.body.clientWidth / 2) - (base_child_width) + 'px'});
				$('.child_window_footer').css({'top': $(window).scrollTop() + $(window).height() - 100 + 'px'});
			}
		}
	} catch (e) {
		//alert(e);
	}
}

// NE
// 折り畳み・展開処理
function fncOpenCloseNextSibling2(img, iOffsetLeft) {
	try {

		// スイッチ画像のパスを取得
		var strSrcPath = frame_path + "images/";

		// スイッチ画像から段落タグに遡る
		var target = img;

		while (	(target.nodeName.toLowerCase() != "h1")
			&&	(target.nodeName.toLowerCase() != "h2")
			&&	(target.nodeName.toLowerCase() != "h3")
			&&	(target.nodeName.toLowerCase() != "h4")
			&&	(target.nodeName.toLowerCase() != "h5")
			&&	(target.nodeName.toLowerCase() != "h6")
			&&	(target.nodeName.toLowerCase() != "div")
			||	($(target).hasClass('figure'))
		) {
			target = target.parentNode;
		}

		// 段落タグから次の非表示要素まで移動
		while (!$(target).hasClass("invisible")) {
			target = target.nextSibling;
		}

		// 非表示要素を検出
		if ($(target).hasClass("invisible")) {

			// 左位置情報を引数から取得
			target.style.marginLeft = iOffsetLeft;
			if (iOffsetLeft == '0px') {
				target.style.marginLeft = '5px';
			}

			// IE678では処理を簡略化
			if (	($.browser.msie && parseInt($.browser.version) == 6)
				||	($.browser.msie && parseInt($.browser.version) == 7)
				||	($.browser.msie && parseInt($.browser.version) == 8)
			) {
				if (img.src.indexOf("g_ne_toggle_open") != -1) {
					img.src = strSrcPath + "g_ne_toggle_close.gif";
					jQuery(target).css({display: "block"});
				} else if (img.src.indexOf("g_ne_toggle_close") != -1) {
					img.src = strSrcPath + "g_ne_toggle_open.gif";
					jQuery(target).css({display: "none"});
				} else if (img.src.indexOf("g_ne_toggle_en_open") != -1) {
					img.src = strSrcPath + "g_ne_toggle_en_close.png";
					jQuery(target).css({display: "block"});
				} else if (img.src.indexOf("g_ne_toggle_en_close") != -1) {
					img.src = strSrcPath + "g_ne_toggle_en_open.png";
					jQuery(target).css({display: "none"});
				}
				//fncAdjustColumnHeight();
				// ie6で上付き文字が折り畳み展開直後だけ位置が崩れてしまう現象を防ぐ
				if ($.browser.msie && parseInt($.browser.version) == 6) {
					$("span.superscript").css({left: "0"});
				}
			} else {
				// jQueryによるアニメーション効果とスイッチ画像の切り替え
				//jQuery(target).slideToggle(500, fncAdjustColumnHeight);
				jQuery(target).slideToggle(500);
				if (img.src.indexOf("g_ne_toggle_open") != -1) {
					img.src = strSrcPath + "g_ne_toggle_close.gif";
				} else if (img.src.indexOf("g_ne_toggle_close") != -1) {
					img.src = strSrcPath + "g_ne_toggle_open.gif";
				} else if (img.src.indexOf("g_ne_toggle_en_open") != -1) {
					img.src = strSrcPath + "g_ne_toggle_en_close.png";
				} else if (img.src.indexOf("g_ne_toggle_en_close") != -1) {
					img.src = strSrcPath + "g_ne_toggle_en_open.png";
				}
			}
		}
	} catch (e) {
	}
}

// 詳細開閉処理
function fncOpenCloseNextSibling(eSrc) {
	try {
		var objNextSibling;
		objNextSibling = eSrc.parentNode.nextSibling;
		while (objNextSibling.nodeType != 1) {
			objNextSibling = objNextSibling.nextSibling;
		}
		if (objNextSibling.style && objNextSibling.style.display.toLowerCase() != "block") {
			objNextSibling.style.display = "block";
			eSrc.innerHTML = fncGetResourceByResourceId("close_next_sibling");
			eSrc.className = "close_next_sibling";
		} else {
			objNextSibling.style.display = "none";
			eSrc.innerHTML = fncGetResourceByResourceId("open_next_sibling");
			eSrc.className = "open_next_sibling";
		}
	} catch (e) {
	}
}

// 詳細一括開閉処理
function fncOpenCloseAll(strMethod) {
	try {
		var objDivs = document.getElementsByTagName("div");
		var nDivLength = objDivs.length;
		for (var i = 0; i < nDivLength; i++) {
			if (objDivs[i].className == "invisible") {
				var objPreviousSibling;
				objPreviousSibling = objDivs[i].previousSibling;
				while (objPreviousSibling.nodeType != 1) {
					objPreviousSibling = objPreviousSibling.previousSibling;
				}
				if (strMethod == "open") {
					objDivs[i].style.display = "block";
					if	(	(objPreviousSibling.childNodes[0].className == "open_next_sibling")
						||	(objPreviousSibling.childNodes[0].className == "close_next_sibling")
						)
					{
						objPreviousSibling.childNodes[0].innerHTML = fncGetResourceByResourceId("close_next_sibling");
						objPreviousSibling.childNodes[0].className = "close_next_sibling";
					}
				} else {
					objDivs[i].style.display = "none";
					if	(	(objPreviousSibling.childNodes[0].className == "open_next_sibling")
						||	(objPreviousSibling.childNodes[0].className == "close_next_sibling")
						)
					{
						objPreviousSibling.childNodes[0].innerHTML = fncGetResourceByResourceId("open_next_sibling");
						objPreviousSibling.childNodes[0].className = "open_next_sibling";
					}
				}
			}
		}
	} catch (e) {
	}
}

window.onbeforeunload = function fncOnBeforeUnLoad() {
	try {

		// ----------------------------------------------------------------------------------------
		// クッキーに情報を保存
		// ----------------------------------------------------------------------------------------

		// タブ位置の記憶
		if (document.getElementById("id_res_contents") && document.getElementById("id_res_search")) {
			var strTabPosition = "0";
			if (document.getElementById("id_res_contents").className == "tab_active") {
				strTabPosition = "1";
			} else if (document.getElementById("id_res_search").className == "tab_active") {
				strTabPosition = "2";
			}
			fncSetCookie("TAB-POSITION", strTabPosition);
		}

		// 検索キーワードの記憶
		if (document.getElementById("id_search")) {
			var strSearchKeyword = document.getElementById("id_search").value;
			fncSetCookie("SEARCH-KEYWORD", strSearchKeyword);
		}

		// 左パネルの表示・非表示状態の記憶
		if (document.getElementById("id_res_bar_icon_toggle_panel")) {

			// 非表示
			if (document.getElementById('id_res_bar_icon_toggle_panel').className == 'hide') {
				fncSetCookie("LEFT_PANE_VISIBILITY", "SHOW");
			} else {
				fncSetCookie("LEFT_PANE_VISIBILITY", "HIDE");
			}
		}
	} catch (e) {
//		alert(e);
	}
}

// NOTE: for ios
window.onpagehide = function() {
	if (device.ipod() || device.iphone() || device.ipad()) {

		// 検索キーワードの記憶
		if (document.getElementById("id_search")) {
			var strSearchKeyword = document.getElementById("id_search").value;
			fncSetCookie("SEARCH-KEYWORD", strSearchKeyword);
		}

		// タブ位置の記憶
		var strTabPosition = "0";
		if (document.getElementById("id_res_contents").className == "tab_active") {
			strTabPosition = "1";
		} else if (document.getElementById("id_res_search").className == "tab_active") {
			strTabPosition = "2";
		}
		fncSetCookie("TAB-POSITION", strTabPosition);

		// 左パネルの表示・非表示状態の記憶
		if (document.getElementById('id_res_bar_icon_toggle_panel')) {

			// 非表示
			if (document.getElementById('id_res_bar_icon_toggle_panel').className == 'hide') {
				fncSetCookie("LEFT_PANE_VISIBILITY", "SHOW");
			} else {
				fncSetCookie("LEFT_PANE_VISIBILITY", "HIDE");
			}
		}

	}
};
//if ((strWindowType != "HOME") && (strWindowType != "HOME_TOC")) {
//	var strWindowType = "MAIN";
//}

function gcsearch(callback) {
	try {

		var gcs_cx_prefix = fncGetConstantByName("gcs_cx_prefix");
		var gcs_cx_suffix = fncGetConstantByName("gcs_cx_suffix");
		var gcs_timeout = fncGetConstantByName("gcs_timeout");
		var gcs_key = fncGetConstantByName("gcs_key");

		// apiの制約上、同時表示数は10件まで
		var search_show_result_count = fncGetConstantByName("search_show_result_count");
		if (search_show_result_count > 10) {
			search_show_result_count = 10;
		}

		// キーワードと開始位置
		var q = document.getElementById("id_search").value;
		var start = document.getElementById("id_start").value;

		// キーワードが指定されていない場合
		if (q == "") {
			return;
		}

		// Webストレージ（揮発）に検索結果が残っている場合は再利用
		var stored_search_results = fncGetSessionStorage('search-results');
		if (stored_search_results) {

			// テキストデータからJSONに復元
			var json = JSON.parse(stored_search_results);
			if (json != null) {
				if (!json.queries) { // json破損の可能性

					// セッションストレージを空にする
					fncSetSessionStorage('search-results', '');
				} else {

					// 前回のキーワードが一致していれば再利用可能とみなす
					var stored_search_terms = json.queries.request[0].searchTerms;
					var stored_search_start = json.queries.request[0].startIndex;
					if (	(q == stored_search_terms)
						&&	(start <= stored_search_start)
					) {

						// Webストレージ上のjsonをそのまま返却
						gcresult(json, true);
						return;

					// キーワード不一致（検索開始インデックスをリセット）
					} else if (q != stored_search_terms) {
						start = 1; // canon -> 11 hit -> more -> start:11 -> desktop -> 11 <> 1
					}
				}
			}
		}

		// Google検索実行 // NOTE: encodeURIComponentがないとie10でマルチバイトを検索できないことがある
		$.ajax({timeout: gcs_timeout, error: gcerror, url: "https://www.googleapis.com/customsearch/v1?q=" + encodeURIComponent(q) + "&cx=" + gcs_cx_prefix + ":" + gcs_cx_suffix + "&key=" + gcs_key + "&alt=json&callback=" + callback + "&num=" + search_show_result_count + "&start=" + start, async: true, dataType: "jsonp", crossDomain: true}).responseText;
	} catch (e) {
		//alert(e);
	}
}
function gcerror(XMLHttpRequest, textStatus, errorThrown) {
	if (textStatus == "timeout") {
		gcsetmessage(fncGetResourceByResourceId("search_message_timeout"));
	} else if (textStatus == "error") {
		gcsetmessage(fncGetResourceByResourceId("search_message_error"));
	}
}
function gcsetmessage(message) {
	$('#id_search_results').html(
		'<div class="gcs_message">' + message + '</div>'
	);
}
function gcresult(json, reused) {
	try {

		// 再利用されなかった場合、ストレージを丸ごと差し替え
		if (!reused) {
			fncSetSessionStorage('search-results', JSON.stringify(json));
			document.getElementById("id_start").value = 1;
		} else {
			document.getElementById('id_start').value = json.queries.request[0].startIndex;
		}

		// 検索結果欄を初期化
		$('#id_search_results').html("");
		$('#id_search_info').html("");

		// 検索結果が「0」
		if (json.searchInformation.totalResults == 0) {

			// 修正候補あり（例：すみ消し）
			if (json.spelling && json.spelling.correctedQuery) {

				// 修正候補文字列で再検索
				var result_html = new Array();

				result_html.push('<div class="gcs_message">');
				result_html.push(fncGetResourceByResourceId("search_message_not_found"));
				result_html.push('</div>');
				result_html.push('<div class="gcs_message">');
				result_html.push(fncGetResourceByResourceId("search_message_corrected_query"));
				result_html.push("<a href=\"#\" style=\"font-weight: bold;\" onclick=\"document.getElementById('id_search').value = '" + json.spelling.correctedQuery + "'; gcsearch('gcresult')\">");
				result_html.push(json.spelling.correctedQuery);
				result_html.push('</a>');
				result_html.push('</div>');
				$('#id_search_results').html(result_html.join("")).css('background-color', '#fff');
				$('#id_search_info').html(
					"0 " + fncGetResourceByResourceId("search_found")
				);

			// 修正候補なし
			} else {
				var result_html = new Array();

				result_html.push('<div class="gcs_message">');
				result_html.push(fncGetResourceByResourceId("search_message_not_found"));
				result_html.push('<br />');
				result_html.push(fncGetResourceByResourceId("search_message_hint"));
				result_html.push('</div>');
				$('#id_search_results').html(result_html.join("")).css('background-color', '#fff');
				$('#id_search_info').html(
					"0 " + fncGetResourceByResourceId("search_found")
				);
			}

		// 検索結果を表示
		} else {

			var result_html = new Array();

			// 修正候補あり（例：てｔ）
			if (json.spelling && json.spelling.correctedQuery) {

				// 修正候補文字列で再検索を促す
				result_html.push('<div class="gcs_message">');
				result_html.push(fncGetResourceByResourceId("search_message_did_you_mean"));
				result_html.push("<a href=\"#\" style=\"font-weight: bold;\" onclick=\"document.getElementById('id_search').value = '" + json.spelling.correctedQuery + "'; gcsearch('gcresult')\">");
				result_html.push(json.spelling.correctedQuery);
				result_html.push('</a>');
				result_html.push('</div>');
			}

			// ヒット数
			var size = json.items.length;
			var pagination_html = new Array();
			var total_results = json.searchInformation.totalResults;

			// 検索結果（タイトルとサマリー）を表示（最大10件）
			for (var i = 0; i < size; i++) {
				result_html.push('<div class="search_topic_title"><a href="' + json.items[i].link + '?s=' + document.getElementById('id_search').value + '">' + json.items[i].title + '</a></div><div class="search_topic_summary">' + json.items[i].htmlSnippet + '</div>');
			}

			// 検索情報を表示（ヒット数）
			$('#id_search_info').html(
				fncGetResourceByResourceId("search_about") + " <span style=\"color: #cf4e32;\">" + total_results + "</span> " + fncGetResourceByResourceId("search_found")
			);

			// 次の検索結果を表示するボタン
			if (json.queries.nextPage) {
				result_html.push('<div class="gcs_more">');
				result_html.push("<button id=\"gcs_more\" onclick=\"this.innerHTML = '...'; document.getElementById('id_start').value = " + json.queries.nextPage[0].startIndex + ";gcsearch('gcmore')\">");
				result_html.push(fncGetResourceByResourceId("search_message_more"));
				result_html.push('</button>');
				result_html.push('</div>');
			} else {
				result_html.push('<div class="gcs_last">&nbsp;</div>');
			}

			$('#id_search_results').html(result_html.join("")).css('background-color', '#fff');

			$('#id_search_pagination').html(
				pagination_html.join("")
			);
		}

		if (	(device.mobile())
			||	(device.tablet())
		) {
			document.getElementById("id_search").blur(); // キーボード非表示にする
		} else {
			document.getElementById("id_search").select(); // 検索条件欄を選択状態にし、次に検索しやすいようにする
		}

	} catch (e) {
		//alert(e);
	}
}

function gcmore(json) {
	try {

		// もっと表示ボタンを消す
		var more = document.getElementById('gcs_more');
		more.parentNode.parentNode.removeChild(more.parentNode);

		// Webストレージに結果を付け足しするためにWebストレージのJSONを解凍
		var stored_search_results = fncGetSessionStorage('search-results');
		var stored_json = JSON.parse(stored_search_results);

		// 検索結果を表示
		var size = json.items.length;
		var result_html = new Array();
		for (var i = 0; i < size; i++) {
			result_html.push('<div class="search_topic_title"><a href="' + json.items[i].link + '?s=' + document.getElementById('id_search').value + '">' + json.items[i].title + '</a></div><div class="search_topic_summary">' + json.items[i].htmlSnippet + '</div>');

			// Webストレージに結果を付け足し
			stored_json.items.push(json.items[i]);
		}
		$('#id_search_results').append(result_html.join(""));

		// Webストレージ上の検索開始位置の更新
		stored_json.queries.request[0].startIndex = json.queries.request[0].startIndex;
		if (json.queries.nextPage) {
			stored_json.queries.nextPage[0].startIndex = json.queries.nextPage[0].startIndex;
		} else {
			delete stored_json.queries.nextPage;
		}

		// Webストレージを保存
		fncSetSessionStorage('search-results', JSON.stringify(stored_json));

		// さらに「もっと表示」
		if (json.queries.nextPage) {
			var result_html = new Array();
			result_html.push('<div class="gcs_more">');
			result_html.push("<button id=\"gcs_more\" onclick=\"this.innerHTML = '...'; document.getElementById('id_start').value = " + json.queries.nextPage[0].startIndex + ";gcsearch('gcmore')\">");
			result_html.push(fncGetResourceByResourceId("search_message_more"));
			result_html.push('</button>');
			result_html.push('</div>');
			$('#id_search_results').append(result_html.join(""));
		} else {
			var result_html = new Array();
			result_html.push('<div class="gcs_last">&nbsp;</div>');
			$('#id_search_results').append(result_html.join(""));
		}
	} catch (e) {
		//alert(e);
	}
}

function fncBuildToc(toc_place) {
	try {

		// iframeによる目次表示
		// -----------------------------------------------------------------------------------------
		if (toc_mode != "json") {

			// 目次プルダウンが存在する場合、チャプター単位の目次をロードする
			var chapters = document.getElementById('chapters');
			var toc_file_name;
			if (chapters) {
				toc_file_name = "toc-" + chapters.options[chapters.selectedIndex].id + ".html";
			} else {
				toc_file_name = "toc.html";
			}

			var iframe = document.createElement('iframe');
			iframe.src = '../contents/' + toc_file_name + "?ref=" + document.location.href;
			iframe.frameBorder = '0';
			iframe.style.height = '100%';
			iframe.id = 'iframe_toc';
			toc_place.appendChild(iframe);

			// 無効な目次ファイルがロードされた場合、iframeを削除する
			var toc_file_data = $.ajax({url:"../contents/" + toc_file_name, async:false}).responseText;
			var static_toc_html_code = fncGetResourceByResourceId('static_toc_html_code');
			if (!static_toc_html_code || static_toc_html_code == '') {
				return false;
			}
			if (toc_file_data.indexOf(static_toc_html_code) == -1) {
				return false;
			}
			if (iframe.addEventListener) {
				iframe.onload = function() {
					fncSyncToc(this, strCurrentTocId, strBreadCrumbsTocIds);
					$('#wait').remove();
					this.contentWindow.document.getElementsByTagName('link')[0].href = frame_path + 'styles/frame_toc.css';
					if (document.body.lang == 'zh-CN') {
						$(this.contentWindow.document).contents().find('*').css({'font-family': '"Microsoft YaHei", "SimSun", "Arial", "Helvetica", Sans-serif'});
					} else if (document.body.lang == 'zh-TW') {
						$(this.contentWindow.document).contents().find('*').css({'font-family': '"Microsoft JhengHei", "PMingLiU", "Arial", "Helvetica", Sans-serif'});
					} else if ((document.documentElement.lang == 'kr') || (document.documentElement.getAttribute('xml:lang') == 'ko')) {
						$(this.contentWindow.document).contents().find('*').css({'font-family': '"Malgun Gothic", "Gulim", "Arial", "Helvetica", Sans-serif'});
					}
//					$(iframe.contentWindow.document).contents().find('li.current').css({'width': $(iframe.contentWindow.document).contents().find('li.current a').width()});
				};
			} else if (iframe.attachEvent) { // NOTE: for ie8
				iframe.attachEvent('onload',  function() {
					fncSyncToc(iframe, strCurrentTocId, strBreadCrumbsTocIds);
					$('#wait').remove();
					iframe.contentWindow.document.getElementsByTagName('link')[0].href = frame_path + 'styles/frame_toc.css';
					if (document.body.lang == 'zh-CN') {
						$(iframe.contentWindow.document).contents().find('*').css({'font-family': '"Microsoft YaHei", "SimSun", "Arial", "Helvetica", Sans-serif'});
					} else if (document.body.lang == 'zh-TW') {
						$(iframe.contentWindow.document).contents().find('*').css({'font-family': '"Microsoft JhengHei", "PMingLiU", "Arial", "Helvetica", Sans-serif'});
					} else if ((document.documentElement.lang == 'kr') || (document.documentElement.getAttribute('xml:lang') == 'ko')) {
						$(iframe.contentWindow.document).contents().find('*').css({'font-family': '"Malgun Gothic", "Gulim", "Arial", "Helvetica", Sans-serif'});
					}
//					$(iframe.contentWindow.document).contents().find('li.current').css({'width': $(iframe.contentWindow.document).contents().find('li.current a').width()});
				});
			}

		// toc.jsonによる目次表示
		// -----------------------------------------------------------------------------------------
		} else {

			var iHideLevel = 999;
			var bIsCurrentChapter = false;

			// 目次プルダウンが存在する場合、チャプター単位の目次をロードする
			var chapters = document.getElementById('chapters');
			if (chapters) {
				bJoinChapters = false;
			} else {
				bJoinChapters = true;
			}

			// 目次表示領域
			// -------------------------------------------------------------------------------------
			var ul = document.getElementById('id_toc');

			// モバイルレイアウトの場合、目次領域が事前に除去されているので復活
			if (!ul) {
				ul = document.createElement('ul');
				ul.id = 'id_toc';
				var stored_layout_mode = fncGetLayoutMode();
				if (stored_layout_mode == "mobile") {
					ul.className = "mobile";
				}
			}

			// 章単位目次の場合、クラス名でインデント調整
			if (!bJoinChapters) {
				ul.className += " chapter";
				ul.className = ul.className.trim();
			}

			// トップページへのリンク
			// -------------------------------------------------------------------------------------
			var li = document.createElement('li');
			li.className = 'level_1';
			li.toc_id = 'home';
			var sign = document.createElement('img');
			sign.src = frame_path + "images/toc-icon.png";
			sign.className = 'toc-sign-0';
			li.appendChild(sign);
			var a = document.createElement('a');
			var top_title = fncGetResourceByResourceId('home');
			a.innerHTML = top_title;
			a.title = top_title;
			a.href = '../frame_htmls/home.html';
			li.appendChild(a);
			ul.appendChild(li);

			// 目次項目のボックス部分も押下可能にする
			li.onclick = function(e) {

				var clicked_target;
				if (!e) { // NOTE: for ie8
					clicked_target = window.event.srcElement;
				} else {
					clicked_target = e.target;
				}

				// [+][-]は反応させない
				if (clicked_target.nodeName != 'IMG') {
					this.childNodes[1].click();
				}
			};
			li.style.cursor = 'pointer';

			// チャプター冒頭のlevel_1末端コンテンツ（紹介ページ）の表示方法
			// resource.jsonのcoverに定義がない場合は、level_1末端コンテンツはプルダウンには表示する
			try {
				var v = eval(cover);
				var vLength = v.length;
			} catch (e) {
				var vLength = 0;
			}

			// 目次情報をJSONから取得
			var t = eval(toc);
			var tLength = t.length;
			var strScroll = fncGetCookie("CONTENTS-SCROLL");
			for (var i = 0; i < tLength; i++) {

				// チャプターをまとめて表示
				// ---------------------------------------------------------------------------------
				if (bJoinChapters) {

					// 目次に表示しない場合スキップ
					if (t[i].show_toc == "n") {
						continue;
					}

					// h1 - h6
					var li = document.createElement('li');
					li.className = 'level_' + t[i].level;
					if (strCurrentTocId == t[i].id) {
						li.className += ' current';
					}
					if (iHideLevel < t[i].level) {
						li.style.display = 'none';
					} else {
						iHideLevel = 999;
					}

					// [+][-][ ]
					var sign = document.createElement('img');

					// 子トピックあり
					if	(	(t[i + 1])
						&&	(t[i + 1].level > t[i].level)
						)
					{

						// [+][-]リンク要素の作成
						var a = document.createElement('a');

						// パンくず上に存在→展開
						if (strBreadCrumbsTocIds.indexOf(t[i].id + ",") != -1) {
							sign.src = frame_path + "images/toc-icon.png";
							sign.className = 'toc-sign-1';
							if (t[i].level == 1) {
								sign.className = 'chapter-sign-1';
							}

						// 折り畳み表示
						} else {
							sign.src = frame_path + "images/toc-icon.png";
							sign.className = 'toc-sign-2';
							if (t[i].level == 1) {
								sign.className = 'chapter-sign-2';
							}

							// 現在のレベル以降を非表示にする
							if (iHideLevel == 999) {
								iHideLevel = t[i].level;
							}
						}

						// [+][-]クリック時処理の定義
						a.onclick = fncToggleWrapper;
						a.href = '#';
						a.className = 'sign';

						// [+][-]リンク要素に[+][-]マークを挿入
						a.appendChild(sign);

						// 目次項目に[+][-]リンク要素を挿入
						li.appendChild(a);

					// 子トピックなし
					} else {

						// 現在表示中のトピック
						if (strCurrentTocId == t[i].id) {
							sign.src = frame_path + "images/toc-icon.png";
							sign.className = 'toc-sign-0-active';
						} else {
							sign.src = frame_path + "images/toc-icon.png";
							sign.className = 'toc-sign-0';
						}
						li.appendChild(sign);
					}

					// トピックにHTMLが存在する場合
					if (t[i].href) {

						// HTMLへのリンク要素を作成
						var a = document.createElement('a');
						a.href = "../contents/" + t[i].href;
						a.innerHTML = t[i].title;

							// 現在表示中のトピック
							if (strCurrentTocId == t[i].id) {
//								a.className = "current";
								a.id = "id_toc_current";
							}

						// 目次項目にHTMLへのリンク要素を挿入（[+][-]の後ろ）
						li.appendChild(a);

						// 目次項目のボックス部分も押下可能にする
						li.onclick = function(e) {
							var clicked_target;
							if (!e) { // NOTE: for ie8
								clicked_target = window.event.srcElement;
							} else {
								clicked_target = e.target;
							}

							// [+][-]は反応させない
							if (clicked_target.nodeName != 'IMG') {
								this.childNodes[1].click();
							}
						};
						li.style.cursor = 'pointer';


					// 階層だけのノードの場合
					} else {
						var span = document.createElement('span');
						span.innerHTML = t[i].title;
						li.appendChild(span);
					}

					// マウスオーバー時のティップス情報
					li.title = t[i].title.replace(/&quot;/g, "\"").replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&amp;/g, "&").replace(/&shy;|­/g, "").replace(/&#x200b;/gi, "");

					// 目次項目をドキュメントに挿入
					ul.appendChild(li);

				// チャプターをプルダウンで切り替える
				// ---------------------------------------------------------------------------------
				} else {

					// h1階層はプルダウンにチャプターとして出力
					if (t[i].level == 1) {

						// 目次に出力しない場合スキップ
						if (t[i].show_toc == "n") {
							continue;
						}

						// 当該チャプター以外の情報は出力しないようにするための制御
						if (strCurrentChapterId == t[i].id) {
							bIsCurrentChapter = true;
						} else {
							bIsCurrentChapter = false;
						}

						// 現在のチャプター
						if (bIsCurrentChapter) {
							var strTocLinkName = t[i].link_name;

							// resource.jsonのcoverに現在のチャプター名が存在するかどうかを探索
							var cover_title = "";
							for (var j = 0; j < vLength; j++) {

								// toc.link_nameに「::」が含まれる場合、
								//「::」から前の文字列は上位グループ名
								//「::」から後の文字列はチャプター名
								var strDivMark = "::";
								var nDivPosition = strTocLinkName.indexOf(strDivMark);

								// toc.link_nameからチャプター名を取得
								if (nDivPosition != -1) {
									strTocLinkName = strTocLinkName.substring(nDivPosition + strDivMark.length);
								}

								// チャプター名合致
								// cover側の定義に「::」が含まれる場合はを除去してから評価
								if (v[j].cover_name.indexOf(strDivMark) != -1) {
									var v_cover_name = v[j].cover_name.substring(v[j].cover_name.indexOf(strDivMark) + strDivMark.length);
								} else {
									var v_cover_name = v[j].cover_name;
								}
								if (v_cover_name == strTocLinkName) {
									cover_title = v[j].cover_title;
								}
							}

							// h2としてTOCに要素を追加
							var li = document.createElement('li');
							var sign = document.createElement('img');
							sign.src = frame_path + "images/toc-icon.png";
							li.appendChild(sign);
							li.className = "level_1";

							// 現在表示中のトピック
							if (strCurrentTocId == t[i].id) {
								li.className += ' current';
							}

							if (cover_title == "") {
								cover_title = t[i].title;
							}

							// トピックにHTMLが存在する場合、リンク可能に
							if (t[i].href) {

								// HTMLへのリンク要素を作成
								var a = document.createElement('a');
								a.href = "../contents/" + t[i].href;
								a.innerHTML = cover_title;
								if (strCurrentTocId == t[i].id) {
									sign.className = 'toc-sign-0-active';
									a.id = "id_toc_current";
								} else {
									sign.className = 'toc-sign-0';
								}

								// 目次項目にHTMLへのリンク要素を挿入（[+][-]の後ろ）
								li.appendChild(a);

								// 目次項目のボックス部分も押下可能にする
								li.onclick = function(e) {

									var clicked_target;
									if (!e) { // NOTE: for ie8
										clicked_target = window.event.srcElement;
									} else {
										clicked_target = e.target;
									}

									// [+][-]は反応させない
									if (clicked_target.nodeName != 'IMG') {
										this.childNodes[1].click();
									}
								};
								li.style.cursor = 'pointer';

								// マウスオーバー時のティップス情報
								li.title = cover_title;

								// 目次項目をドキュメントに挿入
								ul.appendChild(li);
							}

						}

					// チャプター下の目次階層
					// -----------------------------------------------------------------------------
					} else {

						// 目次に表示しない場合スキップ
						if (t[i].show_toc == "n") {
							continue;
						}

						// 当該チャプターのみ情報を出力（他はスキップ）
						if (bIsCurrentChapter) {

							// h2 - h6
							var li = document.createElement("li");
							li.className = 'level_' + t[i].level;
							if (strCurrentTocId == t[i].id) {
								li.className += ' current';
							}
							if (iHideLevel < t[i].level) {
								li.style.display = 'none';
							} else {
								iHideLevel = 999;
							}

							// [+][-][ ]
							var sign = document.createElement('img');

							// 子トピックあり
							if	(	(t[i + 1])
								&&	(t[i + 1].level > t[i].level)
								)
							{

								// [+][-]リンク要素の作成
								var a = document.createElement('a');

								// パンくず上に存在→展開
								if (strBreadCrumbsTocIds.indexOf(t[i].id + ",") != -1) {
									sign.src = frame_path + "images/toc-icon.png";
									sign.className = 'toc-sign-1';

								// 折り畳み表示
								} else {
									sign.src = frame_path + "images/toc-icon.png";
									sign.className = 'toc-sign-2';

									// 現在のレベル以降を非表示にする
									if (iHideLevel == 999) {
										iHideLevel = t[i].level;
									}
								}

								// [+][-]クリック時処理の定義
								a.onclick = fncToggleWrapper;
								a.href = "#";
								a.className = 'sign';

								// [+][-]リンク要素に[+][-]マークを挿入
								a.appendChild(sign);

								// 目次項目に[+][-]リンク要素を挿入
								li.appendChild(a);

							// 子トピックなし
							} else {

								// 現在表示中のトピック
								if (strCurrentTocId == t[i].id) {
									sign.src = frame_path + "images/toc-icon.png";
									sign.className = 'toc-sign-0-active';
								} else {
									sign.src = frame_path + "images/toc-icon.png";
									sign.className = 'toc-sign-0';
								}
								li.appendChild(sign);
							}

							// トピックにHTMLが存在する場合
							if (t[i].href) {

								// HTMLへのリンク要素を作成
								var a = document.createElement('a');
								a.href = "../contents/" + t[i].href;
								a.innerHTML = t[i].title;

									// 現在表示中のトピック
									if (strCurrentTocId == t[i].id) {
										a.id = "id_toc_current";
									}

								// 目次項目にHTMLへのリンク要素を挿入（[+][-]の後ろ）
								li.appendChild(a);

								// 目次項目のボックス部分も押下可能にする
								li.onclick = function(e) {

									var clicked_target;
									if (!e) { // NOTE: for ie8
										clicked_target = window.event.srcElement;
									} else {
										clicked_target = e.target;
									}

									// [+][-]は反応させない
									if (clicked_target.nodeName != 'IMG') {
										this.childNodes[1].click();
									}
								};
								li.style.cursor = 'pointer';

							// 階層だけのノードの場合
							} else {
								var span = document.createElement('span');
								span.innerHTML = t[i].title;
								li.appendChild(span);
							}

							// マウスオーバー時のティップス情報
							li.title = t[i].title.replace(/&quot;/g, "\"").replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&amp;/g, "&").replace(/&shy;|­/g, "").replace(/&#x200b;/gi, "");

							// 目次項目をドキュメントに挿入
							ul.appendChild(li);
						}
					}
				}
			}
			// 「Contents」タブ表示時のスクロール位置初期化フラグを元に戻す
			//fncSetCookie("CONTENTS-SCROLL", "");
			//}
			
			if (toc_place.id == "id_toc") {

			} else {
				toc_place.appendChild(ul);
			}
			$('#wait').remove();
			$('#id_toc').show();
//			$('li.current').css({'width': $('li.current a').width()});
		}
		if (!fncIsSvgEnabled()) {
			fncLoadPng();
		}
		return;
	} catch (e) {
		//alert(e);
	}
}

// カテゴリー目次[+][-]開閉処理
function fncToggleWrapper() {
	fncToggle(this);
	return false; // NOTE: aタグのhref="#"で目次ペインがページ先頭に戻ってしまうことを防ぐ
}
function fncToggle(a) {
	try {

		var iTargetLevel = 999; // 初期値
		var strDisplay = "";

		// [-] -> [+]
		if (a.childNodes[0].className == "toc-sign-1") {
			a.childNodes[0].className = "toc-sign-2";
			strDisplay = "none";

		// [+] -> [-]
		} else if (a.childNodes[0].className == "toc-sign-2") {
			a.childNodes[0].className = "toc-sign-1";
			strDisplay = "block";

		} else if (a.childNodes[0].className == "chapter-sign-1") {
			a.childNodes[0].className = "chapter-sign-2";
			strDisplay = "none";

		// [+] -> [-]
		} else if (a.childNodes[0].className == "chapter-sign-2") {
			a.childNodes[0].className = "chapter-sign-1";
			strDisplay = "block";
		}

		var target_li = a.parentNode;
		var target_level = parseInt(target_li.className.split(" ")[0].split("_")[1]); // class="level_* current"

		// 目次項目ループ
		var lis = document.getElementById("id_toc").getElementsByTagName('li');
		var loop = lis.length;
		for (var i = 0; i < loop; i++) {

			// 表示切替開始位置を探索
			if (lis[i] === target_li) {

				// 処理対象レベルを取得（クリックされた[+][-]がh2ならば、表示切替対象はh3）
				iTargetLevel = target_level + 1;
				continue;
			}
			var haystack_level = lis[i].className.split(" ")[0].split("_")[1];

			// [-] -> [+]がクリックされた場合、下階層すべてを非表示にする
			if (strDisplay == "none") {
				if (haystack_level >= iTargetLevel) {

					// 表示を切り替え
					lis[i].style.display = strDisplay;

					// [-][+] -> [+]
					if (lis[i].childNodes[0].nodeName.toLowerCase() == "a") {
						//lis[i].childNodes[0]/*(a)*/.childNodes[0]/*(img)*/.src = "../frame_images/toc_sign_2.png";
						lis[i].childNodes[0]/*(a)*/.childNodes[0]/*(img)*/.className = "toc-sign-2";

					}
				} else {
					if (iTargetLevel != 999) {
						break;
					}
					continue;
				}

			// [+] -> [-]がクリックされた場合、下階層のみを表示する
			} else {
				if (haystack_level == iTargetLevel) {

					// 表示を切り替え
					lis[i].style.display = strDisplay;
					continue;
				} else {

					if (	(iTargetLevel != 999)
						&&	(iTargetLevel > haystack_level)
					) {
						break;
					}
					continue;
				}
			}
		}
		if (!fncIsSvgEnabled()) {
			fncLoadPng();
		}
	} catch (e) {
	}
}

// カテゴリー目次一括開閉処理
function fncOpenCloseAllToc(nMethod) {
	try {
		var imgs = document.getElementById("id_toc").getElementsByTagName("img");
		var loop = imgs.length;
		for (var i = 0; i < loop; i++) {
			if ((imgs[i].className == "toc-sign-" + nMethod) || (imgs[i].className == "chapter-sign-" + nMethod)) {
				fncToggle(imgs[i].parentNode);
			}
		}
		if (!fncIsSvgEnabled()) {
			fncLoadPng();
		}
	} catch (e) {
		//alert(e);
	}
}

function fncGetLayoutMode() {
	var stored_layout_mode = fncGetSessionStorage('layout-mode');

	// セッションストレージになかった場合はデバイスから判断
	if (!stored_layout_mode) {
		if (device.mobile() || device.tablet()) {
			stored_layout_mode = 'mobile';
		} else {
			stored_layout_mode = 'pc';

			// NOTE: for surface
			if (navigator.msMaxTouchPoints && navigator.msMaxTouchPoints > 1) {
				stored_layout_mode = 'mobile'; // タッチデバイスはモバイルレイアウト表示
			}
		}
	}
	return stored_layout_mode;
}

function fncSyncTocJson() {
	try {

		// 選択中のトピックをハイライト
		var stored_layout_mode = fncGetLayoutMode();
		if (stored_layout_mode == "mobile") {

			// ハイライトが一番下だとボトムバーが邪魔で選択できなくなる…liに絶対配置のspanを配置してそこにスクロールさせる
			var scroll_anchor = document.createElement('span');
			scroll_anchor.id = 'scroll_anchor';
			scroll_anchor.style.position = 'absolute';
			scroll_anchor.style.bottom = '-44px';
			document.getElementById('id_toc_current').appendChild(scroll_anchor);
			document.getElementById('scroll_anchor').scrollIntoView(false);
		} else {
			if (device.ipad()) {
				document.getElementById('id_toc_current').scrollIntoView(true); // NOTE: ipadで目次クリック時にHTML全体が反応してしまう現象をtrueで回避
			} else {
				document.getElementById('id_toc_current').scrollIntoView(false); // NOTE: scrollIntoView(true)だとgcなどでiframeが5ピクセル程度縦にずれてしまう（iframeごと若干スクロール）
			}
		}
	} catch (e) {
		//alert(e);
	}
}

function fncSyncToc(iframe, current, breadcrumbs) {
	try {

		// TOCモードをセッションストレージから取得
		var stored_toc_mode = fncGetSessionStorage('toc-mode');
		var bJoinChapters = false; // デフォルトは「全て」
		if (!stored_toc_mode) {
			if (fncGetConstantByName("join_chapters") == 1) {
				stored_toc_mode = "all"; // すべての章
			} else {
				stored_toc_mode = "chapter"; // 章単位
			}
		}
		var bCurrentChapter = false;
		var stored_layout_mode = fncGetLayoutMode();
		var id_toc = iframe.contentWindow.document.getElementById('id_toc');
		if (	(	(stored_layout_mode == "mobile")
				||	device.mobile()
				||	device.tablet()
				)
			&&	(stored_layout_mode != "pc")
		) {
			id_toc.className = "mobile";
		}

		// モバイル端末でPCレイアウトの目次をスクロールできるようにする
		if ((stored_layout_mode == "pc") && (device.mobile() || device.tablet())) {
			iframe.contentWindow.document.body.parentNode.style.overflow = "scroll";
			iframe.contentWindow.document.body.style.overflow = "scroll";
		} else {
			if (navigator.userAgent.indexOf("Firefox") != -1) {
				//iframe.contentWindow.document.body.style.overflow = "scroll";
			}
		}

		// 目次プルダウンが存在する場合、インデントを抑える
		var chapters = document.getElementById('chapters');
		if (chapters) {
			id_toc.className += " chapter";
		}
		var lis = iframe.contentWindow.document.getElementsByTagName('li');
		var loop = lis.length;

		var iHideLevel = 999;
		var strDivMark = "::";
		for (var i = 0; i < loop; i++) {
			var li = lis[i];
			var level = li.className.substring(6); // class="level_2"

			// h1 - h6
			if (iHideLevel < level) {
				li.style.display = 'none';
			} else {
				iHideLevel = 999;
			}

			// 現在のページ
			if (current == li.getAttribute("toc_id")) {
				li.id = "id_toc_current";
				li.className += " current";
				//li.scrollIntoView(true);
			}

			// 現在のチャプター
			if (stored_toc_mode == 'chapter') {
				if (level == 2) {
					if (strCurrentChapterId == li.getAttribute("toc_id")) {
						try {

							// toc_idからlink_nameを取得
							var t = fncGetTocById(li.getAttribute("toc_id"));
							
							var strTocLinkName = t.link_name;

							// resource.jsonのcoverに現在のチャプター名が存在するかどうかを探索
							var v = eval(cover);
							var vLength = v.length;
							var cover_title = "";
							for (var j = 0; j < vLength; j++) {
								// toc.link_nameに「::」が含まれる場合、
								//「::」から前の文字列は上位グループ名
								//「::」から後の文字列はチャプター名
								
								var nDivPosition = strTocLinkName.indexOf(strDivMark);

								// toc.link_nameからチャプター名を取得
								if (nDivPosition != -1) {
									strTocLinkName = strTocLinkName.substring(nDivPosition + strDivMark.length);
								}

								// チャプター名合致
								// cover側の定義に「::」が含まれる場合はを除去してから評価
								if (v[j].cover_name.indexOf(strDivMark) != -1) {
									var v_cover_name = v[j].cover_name.substring(v[j].cover_name.indexOf(strDivMark) + strDivMark.length);
								} else {
									var v_cover_name = v[j].cover_name;
								}
								if (v_cover_name == strTocLinkName) {
									cover_title = v[j].cover_title;
								}
								if (cover_title == "") {
									cover_title = t.title;
								}
								li.childNodes[1].innerHTML = cover_title;
							}
						} catch (e) {
						}
					}
				}
			}

			// アイコン表示
			if (li.childNodes[0].nodeName.toLowerCase() == 'a') {
				li.childNodes[0].childNodes[0].src = frame_path + 'images/toc-icon.png';
			} else {
				li.childNodes[0].src = frame_path + 'images/toc-icon.png';
			}

			// 子トピックあり
			if (	(li.nextSibling)
				&&	(li.nextSibling.className)
				&&	(li.nextSibling.className.substring(6) > level)
			) {

				// パンくず上に存在→展開
				if ((li.childNodes[0]) && (li.childNodes[0].childNodes[0]) && (li.childNodes[0].childNodes[0].className) && (li.childNodes[0].childNodes[0].className.indexOf("sign") != -1)) {
					if (breadcrumbs.indexOf(li.getAttribute("toc_id") + ",") != -1) {
						li.childNodes[0].childNodes[0].className = "toc-sign-1";

						if (level == 1) {
							li.childNodes[0].childNodes[0].className = "chapter-sign-1";
						}

					// 折り畳み表示
					} else {
						li.childNodes[0].childNodes[0].className = "toc-sign-2";

						if (level == 1) {
							li.childNodes[0].childNodes[0].className = "chapter-sign-2";
						}

						// 現在のレベル以降を非表示にする
						if (iHideLevel == 999) {
							iHideLevel = level;
						}
					}
				}

			// 子トピックなし
			} else {

				// 現在表示中のトピック
				if (current == li.getAttribute("toc_id")) {
					li.childNodes[0].className = "toc-sign-0-active";
					//li.scrollIntoView(true);

				} else {
				}
			}

			// トピックにHTMLが存在する場合
			if (li.childNodes[1] && li.childNodes[1].href) {

				// 目次項目のボックス部分も押下可能にする
				li.onclick = function(e) {

					var clicked_target;
					if (!e) { // NOTE: for ie8
						clicked_target = iframe.contentWindow.event.srcElement;
					} else {
						clicked_target = e.target;
					}

					// [+][-]は反応させない
					if (clicked_target.nodeName != 'IMG') {
						this.childNodes[1].click();
					}
				};
				li.style.cursor = 'pointer';
			}

		}

		if (!fncIsSvgEnabled()) {
			iframe.contentWindow.fncLoadPng();
		}

		// 同期後、表示
		id_toc.style.display = "block";

		// 選択中のトピックをハイライト
		if (iframe.contentWindow.document.getElementById('id_toc_current')) {
			if (stored_layout_mode == "mobile") {

				// ハイライトが一番下だとボトムバーが邪魔で選択できなくなる…liに絶対配置のspanを配置してそこにスクロールさせる
				var scroll_anchor = document.createElement('span');
				scroll_anchor.id = 'scroll_anchor';
				scroll_anchor.style.position = 'absolute';
				scroll_anchor.style.bottom = '-44px';
				iframe.contentWindow.document.getElementById('id_toc_current').appendChild(scroll_anchor);
				iframe.contentWindow.document.getElementById('scroll_anchor').scrollIntoView(false); // NOTE: scrollIntoView(true)だとgcなどでiframeが5ピクセル程度縦にずれてしまう（iframeごと若干スクロール）
			} else {
				if (device.ipad()) {
					iframe.contentWindow.document.getElementById('id_toc_current').scrollIntoView(true); // NOTE: ipadで目次クリック時にHTML全体が反応してしまう現象をtrueで回避
				} else {
					window.setTimeout(function() { // NOTE: FF向け目次スクロールタイミング調整
						iframe.contentWindow.document.getElementById('id_toc_current').scrollIntoView(false); // NOTE: scrollIntoView(true)だとgcなどでiframeが5ピクセル程度縦にずれてしまう（iframeごと若干スクロール）
					}, 500);
				}
			}
		}
	} catch (e) {
		//alert(e);
	}
}
function fncSetFontSize(size) {
	try {
		if (size == "small") {
			//$('#id_content, #id_flow_content').css('font-size', '70%');
			$('body').css('font-size', '70%');
			$('#button_font_size_small').attr('checked', 'checked');
		} else if (size == "large") {
			//$('#id_content, #id_flow_content').css('font-size', '120%');
			$('body').css('font-size', '120%');
			$('#button_font_size_large').attr('checked', 'checked');
		} else {
			//$('#id_content, #id_flow_content').css('font-size', '100%');
			$('body').css('font-size', '100%');
			$('#button_font_size_middle').attr('checked', 'checked');
		}
		fncSetSessionStorage('font-size', size);
	} catch (e) {
		//alert(e);
	}
}
function fncSetLayoutMode(layout_mode) {
	try {
		if (layout_mode == "mobile") {
			$('#button_layout_mode_mobile').attr('checked', 'checked');
			//$('#button_layout_mode_pc').css('background-color', '#eee');
		} else if (layout_mode == "pc") {
			//$('#button_layout_mode_mobile').css('background-color', '#eee');
			$('#button_layout_mode_pc').attr('checked', 'checked');
		}
		fncSetSessionStorage('layout-mode', layout_mode);
		document.location.reload(true);
	} catch (e) {
		//alert(e);
	}
}
function fncSetTocMode(toc_mode) {
	try {
		if (toc_mode == "all") {
			$('#button_toc_mode_all').attr('checked', 'checked');
			//$('#button_toc_mode_chapter').css('background-color', '#eee');
		} else if (toc_mode == "pc") {
			$('#button_toc_mode_all').attr('checked', 'checked');
			//$('#button_toc_mode_chapter').css('background-color', '#eee');
		}
		fncSetSessionStorage('toc-mode', toc_mode);
		document.location.reload(true); // NOTE: ここでリロードすると「もどる」先が設定画面になってしまう
	} catch (e) {
		//alert(e);
	}
}
function fncIsBoldEnabled() {
	//alert("debug...\n" + navigator.userAgent);
	if (	(!device.mobile())
		&&	(!device.tablet())
	) {
		return true; // PCは太字表現可能
	} else if (navigator.userAgent.match(/iPhone|iPod|iPad|IS04/)) { // 太字が表現可能な端末をリストアップ
		return true; // iOSは太字表現可能
	} else if (navigator.userAgent.match(/Android 4/)) {
		return true;
	} else if (navigator.userAgent.match(/Android 5/)) {
		return true;
	} else if (is_android_ff()) {
		return true;
	} else {
		return false;
	}
}

function show_mobile_main(/*bPushState*/) {
	try {
		//if (bPushState) {
		//	if (window.history && window.history.pushState) {
		//		window.history.pushState('main', null, '#main');
		//		window.setTimeout(function() {
		//			document.title = document.body.getAttribute('data-page-title') + " - Canon";
		//		}, 0);
		//	}
		//}
		$('#id_flow_toolbar').show();
		$('#id_breadcrumbs').show();
		$('#id_flow_content').show();
		//$('#id_flow_actions').show();
		document.getElementById('id_side_search').style.display = 'none';
		document.getElementById('id_side_toc').style.display = 'none';

		// 元のスクロール位置を再現
		var scroll_top_before = fncGetSessionStorage('scroll-top-before');
		if (scroll_top_before) {
			$(document).scrollTop(scroll_top_before);
		}
	} catch (e) {
	}
}

function show_mobile_toc(/*bPushState*/) {
	try {
		//if (bPushState) {
		//	if (window.history && window.history.pushState) {
		//		window.history.pushState('toc', null, '#toc');
		//		window.setTimeout(function() {
		//			document.title = fncGetResourceByResourceId('contents');
		//		}, 0);
		//	}
		//}

		// 現在のスクロール位置を記録
		var scroll_top_before = (document.documentElement.scrollTop || document.body.scrollTop);
		fncSetSessionStorage('scroll-top-before', scroll_top_before);

		$('#id_flow_toolbar').hide();
		$('#id_breadcrumbs').hide();
		$('#id_flow_content').hide();
		//$('#id_flow_actions').hide();
		$('#id_side_toc').show();
		$('#chapters').show(); // NOTE: for ie11
		//$('#float_toc, #float_top').hide();
		$('#action').hide();

		// 目次フレームをロードする（初回のみ）
		var toc_mobile = document.getElementById('toc_mobile');
		if (toc_mobile.childNodes.length == 0) {
			if (!device.mobile() && !device.tablet() && (toc_mode == 'iframe')) { // NOTE: ie10(PC)でモバイルレイアウトでアクセスしたときに目次の高さが確保されない
				$(toc_mobile).css({'height': $(window).height() - 89});
			}
			$(toc_mobile).html('<div id="wait"></div>');
			window.setTimeout(function() {
				fncBuildToc(toc_mobile);
			}, 39);
		}

	} catch (e) {
	}
}

function show_mobile_search(/*bPushState*/) {
	try {

		//if (bPushState) {
		//	if (window.history && window.history.pushState) {
		//		window.history.pushState('search', null, '#search');
		//		window.setTimeout(function() {
		//			document.title = fncGetResourceByResourceId('search');
		//		}, 0);
		//	}
		//}

		// 現在のスクロール位置を記録
		var scroll_top_before = (document.documentElement.scrollTop || document.body.scrollTop);
		fncSetSessionStorage('scroll-top-before', scroll_top_before);

		$('#id_flow_toolbar').hide();
		$('#id_breadcrumbs').hide();
		$('#id_flow_content').hide();
		//$('#id_flow_actions').hide();
		document.getElementById('id_side_search').style.display = 'block';
		$('#id_panel_search').show();
		$('#search_mobile').show();
		$('#id_search').show();
		$('#id_search_button').show();
		$('#id_search').focus(); // NOTE: android 2.2 std で検索ボックスにフォーカスが入ってもテキスト入力できない
		$('#id_side_search').scrollTop = 100;
		$('#id_side_search').scrollTop = 0;
		//$('#float_toc, #float_top').hide();
		$('#action').hide();

	} catch (e) {
	}
}

function fncRandomParam() {
	var temp = new Date().getSeconds().toString();
	if (temp.length == 1) {
		temp = 0 + temp;
	}
	return temp;
}

function load_retina_images() {
	try {
		if (fncGetConstantByName('template_type') == 'ne') {

			// NE
			if (strWindowType == 'HOME_TOC') { // トップページフッターのリンクにマークが表示されてしまう現象を防ぐ（トップページでは処理不要）
				return;
			}
	
			// Retina用画像の適用
			// NOTE: cloudfront -> s3 参照時に「+」だとエスケープされてリンクエラーになる
			if ($.browser.msie && parseInt($.browser.version) <= 8) {
			} else {
				$('div#id_flow_content a:link, div#id_content a:link, div.child_window a:link').css({'background-image': 'url(' + template_path + 'style_a' + strPathPlus + '.png)', 'background-size': '14px 14px'});
			}
		} else {

			// Retina用画像の適用
			// NOTE: cloudfront -> s3 参照時に「+」だとエスケープされてリンクエラーになる
			if ($.browser.msie && parseInt($.browser.version) <= 8) {
			} else {
				$('div.table_important td div.list').css({'background-image': 'url(' + template_path + 'style_list_important' + strPathPlus + '.png)', 'background-size': '10px 10px'});
				$('#id_flow_content>div.list, #id_content>div.list, div.table_important div.table_matrix td div.list, div.table_important div.table_general td div.list, div.table_important div.table_no_border td div.list, div.table_important div.table_number td div.list, div.table_note div.table_matrix td div.list, div.table_note div.table_general td div.list, div.table_note div.table_no_border td div.list, div.table_note div.table_number td div.list, td.outline_col_2 div.list').css({'background-image': 'url(' + template_path + 'style_list' + strPathPlus + '.png)', 'background-size': '10px 10px'});
				$('div.table_caution td div.list').css({'background-image': 'url(' + template_path + 'style_list_caution' + strPathPlus + '.png)', 'background-size': '10px 10px'});
				$('div.table_warning td div.list') .css({'background-image': 'url(' + template_path + 'style_list_warning' + strPathPlus + '.png)', 'background-size': '10px 10px'});
				$('div.table_note td div.list').css({'background-image': 'url(' + template_path + 'style_list_note' + strPathPlus + '.png)', 'background-size': '10px 10px'});
				$('thead.table_note td.table_note').css({'background-image': 'url(' + template_path + 'style_note' + strPathPlus + '.png)', 'background-size': '25px 30px'});
				$('thead.table_important td.table_important').css({'background-image': 'url(' + template_path + 'style_important' + strPathPlus + '.png)', 'background-size': '25px 30px'});
				$('thead.table_warning td.table_warning').css({'background-image': 'url(' + template_path + 'style_warning' + strPathPlus + '.png)', 'background-size': '25px 30px'});
				$('thead.table_caution td.table_caution').css({'background-image': 'url(' + template_path + 'style_caution' + strPathPlus + '.png)', 'background-size': '25px 30px'});
				$('div.list_link').css({'background-image': 'url(' + template_path + 'style_a' + strPathPlus + '.png)', 'background-size': '14px 14px'});
				$('div.link_to_top a').css({'background-image': 'url(' + template_path + 'style_a' + strPathPlus + '.png)', 'background-size': '14px 14px'});
				$('div.path, div.step_path').css({'background-image': 'url(' + template_path + 'style_path' + strPathPlus + '.png)', 'background-size': '16px 16px'});
				$('div.step_sub').css({'background-image': 'url(' + template_path + 'style_step_sub' + strPathPlus + '.png)', 'background-size': '11px 11px'});
				$('div.dash').css({'background-image': 'url(' + template_path + 'style_dash' + strPathPlus + '.png)', 'background-size': '19px 18px'});
				$('a.open_all, a.open_next_sibling').css({'background-image': 'url(' + template_path + 'style_open' + strPathPlus + '.png)', 'background-size': '13px 12px'});
				$('a.close_all, a.close_next_sibling').css({'background-image': 'url(' + template_path + 'style_close' + strPathPlus + '.png)', 'background-size': '13px 12px'});
			}
		}
		if ((typeof $('body').css('transform') === 'string') || (typeof $('body').css('transform') === 'object')) {
			$('body').addClass('transformable');
		}
	} catch (e) {
	}
}

//window.onunload = function() {};