GLOBAL.require 'screens.cheatsscreen'
GetPlayer = GLOBAL.GetPlayer
IsHUDPaused = GLOBAL.IsPaused
TheInput = GLOBAL.TheInput
TheFrontEnd = GLOBAL.TheFrontEnd
TheSim = GLOBAL.TheSim

local ticker = 0
local fueled = {"amulet", "blueamulet", "purpleamulet", "orangeamulet", "greenamulet", "yellowamulet", "torch"}

local function CheatsUpdateInit(component)
	local original_OnUpdate = component.OnUpdate
	component.OnUpdate = function(self, dt)
		original_OnUpdate(self, dt)
		
		if not self:IsEnabled() then return end
		
		local player = GetPlayer()
		local Profile = GLOBAL.Profile
		
		if not Profile then return end
		
		if player.components.health and player.components.health:IsHurt() and Profile:GetValue("infhealth") then
			--player.components.health:SetVal(player.components.health.maxhealth)
			player.components.health:DoDelta(player.components.health.maxhealth, true)
		end
		
		if player.components.hunger and player.components.hunger.current < player.components.hunger.max and Profile:GetValue("infhunger") then
			player.components.hunger:DoDelta(player.components.hunger.max, true)
		end
		
		if player.components.sanity and player.components.sanity.current < player.components.sanity.max and Profile:GetValue("infsanity") then
			player.components.sanity:DoDelta(player.components.sanity.max, true)
		end
		
		if Profile:GetValue("inftooluses") or Profile:GetValue("infarmor") or Profile:GetValue("infheatstone") then
		
			if player.components.inventory then
			
				local items = {}

				for k,item in pairs(player.components.inventory.itemslots) do
					table.insert( items, item )
				end
				
				for k,item in pairs(player.components.inventory.equipslots) do
					table.insert( items, item )
				end
			
				for k,item in pairs(items) do
				
					if item and item.components then
						if item.components.finiteuses and Profile:GetValue("inftooluses") then
							item.components.finiteuses:SetUses(item.components.finiteuses.total)
						end
						
						if item.components.fueled and item:HasTag("hat") and Profile:GetValue("infarmor") then
							item.components.fueled:DoDelta(item.components.fueled.maxfuel)
						end
						
						if item.components.armor and Profile:GetValue("infarmor") then
							item.components.armor:SetCondition(item.components.armor.maxcondition)
						end
						
						if item.components.heater and item.components.temperature and Profile:GetValue("infheatstone")then
							item.components.temperature:SetTemp(item.components.temperature.maxtemp)
						end
						
						if Profile:GetValue("inftooluses") and TableContains(fueled, item.prefab) then
							if item.components.fueled then
								item.components.fueled:DoDelta(item.components.fueled.maxfuel)
							end
						end
					end
				end
			end
		end
		
		if Profile:GetValue("noperish") or Profile:GetValue("infcampfire") then
		
			if GLOBAL.GetTime() - ticker > 2 then
				ticker = GLOBAL.GetTime()
				local x,y,z = GetPlayer().Transform:GetWorldPosition()
			    local ents = TheSim:FindEntities(x,y,z, 500)
			    for k,v in pairs(ents) do
			    	
			    	if v.components then
			    	
				    	if v.components.perishable and Profile:GetValue("noperish") then
					    	v.components.perishable:SetPerishTime(GLOBAL.TUNING.PERISH_SUPERSLOW)
				    	end
				    	
				    	if v.components.fueled and v:HasTag("campfire") and Profile:GetValue("infcampfire") and v.components.fueled.currentfuel < v.components.fueled.maxfuel and v.components.cooker then
					    	v.components.fueled:DoDelta(v.components.fueled.maxfuel)
				    	end
				    	
			    	end
			    end
			end
		end
	end
end
AddComponentPostInit("playercontroller", CheatsUpdateInit)

local function HealthCompInit(component)
	local original_SetVal = component.SetVal
	component.SetVal = function(self, val, cause)
		original_SetVal(self, val, cause)
		
		local Profile = GLOBAL.Profile
		
		if Profile and Profile:GetValue("onehitkill") and self and self.inst and self.inst ~= GetPlayer() and val > 0 and not self:IsInvincible() and cause == GetPlayer().prefab then
			self:Kill()
		end
	end
end
AddComponentPostInit("health", HealthCompInit)

local function WorkableCompInit(component)
	local original_WorkedBy = component.WorkedBy
	component.WorkedBy = function(self, worker, numworks)
		print("TEST")
		print(self.prefab,worker,numworks)
		local Profile = GLOBAL.Profile
		if Profile and Profile:GetValue("onehitbreak") and worker == GetPlayer() then
			self.workleft = 0
		end
		original_WorkedBy(self, worker, numworks)
	end
end
AddComponentPostInit("workable", WorkableCompInit)


CheatsKeyHandler = Class(function(self)   
    self.handler = TheInput:AddKeyHandler(function(key, down) self:OnRawKey(key, down) end )
end)

function CheatsKeyHandler:OnRawKey(key, down)

	if IsHUDPaused() or not GetPlayer() then return end
	
	if (key == GLOBAL.KEY_I and not down) then
		GLOBAL.TheFrontEnd:PushScreen(GLOBAL.CheatsScreen())
	end
	
	if (key == GLOBAL.KEY_F11 and not down and TheInput:IsControlPressed(GLOBAL.CONTROL_FORCE_STACK)) then
		if GetPlayer() and GetPlayer().components and GetPlayer().components.builder then
			local comp = GetPlayer().components.builder
			for k,recipe in pairs(GLOBAL.GetAllRecipes()) do
				comp:UnlockRecipe(recipe.name)
				comp.inst:PushEvent("techtreechange", {level = comp.accessible_tech_trees})
			end
			GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/collect_newitem")
		end
	end
	
	if (key == GLOBAL.KEY_F12 and not down and TheInput:IsControlPressed(GLOBAL.CONTROL_FORCE_STACK)) then
		for k,recipe in pairs(GLOBAL.GetAllRecipes()) do
			recipe.ingredients = {}
		end
		GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/collect_newitem")
	end
	
	if (key == GLOBAL.KEY_F10 and not down and TheInput:IsControlPressed(GLOBAL.CONTROL_FORCE_STACK)) then
		local minimap = TheSim:FindFirstEntityWithTag("minimap")
		minimap.MiniMap:ShowArea(0,0,0, 2000)
		GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/collect_newitem")
	end
end

CJBCheatsKeyHandler = CheatsKeyHandler()

function TableContains(table, val)
	if not table and not val then return end
	
	for k,v in pairs(table) do
		if v == val then return true end
	end
	
	return false
end