local assets=
{
	Asset("ANIM", "anim/spider_gland.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spider_gland")
    inst.AnimState:SetBuild("spider_gland")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
    
	MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)

    ---------------------       
    
    inst:AddComponent("inspectable")
local colours=
{
    {198/255,43/255,43/255},
    {79/255,153/255,68/255},
    {35/255,105/255,235/255},
    {233/255,208/255,69/255},
    {109/255,50/255,163/255},
    {222/255,126/255,39/255},
}
local function OnDeploy (inst, pt)
    local lamp = SpawnPrefab("spidergland")
    lamp.Transform:SetPosition(pt.x, pt.y, pt.z)
    lamp.AnimState:SetBank("trinkets")
    lamp.AnimState:SetBuild("trinkets")
    lamp.AnimState:PlayAnimation(tostring(2))
    lamp.components.inventoryitem:ChangeImageName("trinket_2")
    lamp.entity:AddSoundEmitter()
    lamp.Transform:SetScale(1.2,1.2,1.2)
    lamp.colour_idx = math.random(#colours)
    lamp.AnimState:SetMultColour(colours[lamp.colour_idx][1],colours[lamp.colour_idx][2],colours[lamp.colour_idx][3],1)
    lamp:RemoveComponent("stackable")
    lamp:RemoveComponent("healer")
    lamp:RemoveComponent("burnable")
    lamp:RemoveComponent("propagator")
    lamp:RemoveComponent("deployable")
    lamp:AddComponent("cooker")
    lamp:AddComponent("burnable")
    lamp.components.burnable:SetFXLevel(3)
    lamp.components.burnable:AddBurnFX("campfirefire", Vector3(0,0.5,0) )
    lamp.components.burnable:Ignite(true)
    lamp.components.inventoryitem:SetOnDroppedFn(function() lamp.components.burnable:Ignite(true) lamp:AddTag("ontheground") end )
    lamp.components.inventoryitem:SetOnPickupFn(function() lamp.components.burnable:Extinguish() lamp:RemoveTag("ontheground") end )
    lamp.components.inventoryitem:SetOnPutInInventoryFn(function() lamp.components.burnable:Extinguish() lamp:RemoveTag("ontheground") end )
    lamp:ListenForEvent("onignite", function()
        if not lamp.components.cooker then lamp:AddComponent("cooker") end
    end )
    lamp:ListenForEvent("onextinguish", function()
        lamp.SoundEmitter:PlaySound("dontstarve/common/fireOut")  
        if lamp.components.cooker then lamp:RemoveComponent("cooker") end
    end )
    lamp:AddComponent("workable")
    lamp.components.workable:SetWorkAction(ACTIONS.HAMMER)
    lamp.components.workable:SetWorkLeft(3)
    lamp.components.workable:SetOnFinishCallback(function(lamp)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(lamp.Transform:GetWorldPosition())
        lamp:Remove()
    end )
    lamp:AddTag("ontheground")
    lamp:AddTag("light")
    lamp:AddTag("lamps")
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

local function onsave(inst, data)
    if inst:HasTag("lamps") then
       data.lamps = true
    end
    if inst:HasTag("ontheground") then
       data.ontheground = true
    end
    data.colour_idx = inst.colour_idx
end
local function onload(inst, data)
  if data and data.lamps then
    inst.AnimState:SetBank("trinkets")
    inst.AnimState:SetBuild("trinkets")
    inst.AnimState:PlayAnimation(tostring(2))
    inst.components.inventoryitem:ChangeImageName("trinket_2")
    inst.entity:AddSoundEmitter()
    inst.Transform:SetScale(1.2,1.2,1.2)
    inst.colour_idx = math.random(#colours)
    inst.AnimState:SetMultColour(colours[inst.colour_idx][1],colours[inst.colour_idx][2],colours[inst.colour_idx][3],1)
    inst:RemoveComponent("stackable")
    inst:RemoveComponent("healer")
    inst:RemoveComponent("burnable")
    inst:RemoveComponent("propagator")
    inst:RemoveComponent("deployable")
    inst:AddComponent("burnable")
    inst.components.burnable:SetFXLevel(3)
    inst.components.burnable:AddBurnFX("campfirefire", Vector3(0,0.5,0) )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.components.burnable:Ignite(true) inst:AddTag("ontheground") end )
    inst.components.inventoryitem:SetOnPickupFn(function() inst.components.burnable:Extinguish() inst:RemoveTag("ontheground") end )
    inst.components.inventoryitem:SetOnPutInInventoryFn(function() inst.components.burnable:Extinguish() inst:RemoveTag("ontheground") end )
    inst:ListenForEvent("onignite", function()
        if not inst.components.cooker then inst:AddComponent("cooker") end
    end )
    inst:ListenForEvent("onextinguish", function()
        inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")  
        if inst.components.cooker then inst:RemoveComponent("cooker") end
    end )
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(function(inst)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(inst.Transform:GetWorldPosition())
        inst:Remove()
    end )
    inst:AddTag("light")
    inst:AddTag("lamps")
  end
  if data and data.ontheground then
    inst.components.burnable:Ignite(true)
    inst:AddComponent("cooker")
    inst:AddTag("ontheground")
  end
  if data and data.colour_idx then
     inst.colour_idx = math.min(#colours, data.colour_idx)
     inst.AnimState:SetMultColour(colours[inst.colour_idx][1],colours[inst.colour_idx][2],colours[inst.colour_idx][3],1)
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("healer")
    inst.components.healer:SetHealthAmount(TUNING.HEALING_MEDSMALL)
    
    return inst
end

return Prefab( "common/inventory/spidergland", fn, assets) 

