local assets =
{
	-- Animation files used for the item.
	Asset("ANIM", "anim/swap_new_shovel.zip"),

	-- Inventory image and atlas file used for the item.
    Asset("ATLAS", "images/inventoryimages/new_shovel.xml"),
    Asset("IMAGE", "images/inventoryimages/new_shovel.tex"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_new_shovel", "swap_new_shovel") -- ([symbol you want to override], [symbol name from your build], [your build name])
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function init()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("new_shovel") -- bank, aka entity name in your spriter file
    inst.AnimState:SetBuild("swap_new_shovel") -- build, aka name of your *.scml file 
    inst.AnimState:PlayAnimation("idle") -- animation name, ofc

	inst:AddTag("sharp")
	
	inst.entity:SetPristine()
		
	if not TheWorld.ismastersim then
		return inst
	end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE) -- is stronker
	inst.components.weapon.attackwear = 2

	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.DIG)
	
    inst:AddComponent("inspectable")
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SHOVEL_USES)
    inst.components.finiteuses:SetUses(TUNING.SHOVEL_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
    inst.components.finiteuses:SetConsumption(ACTIONS.DIG, 1)
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/new_shovel.xml"
    inst.components.inventoryitem.imagename = "new_shovel"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	MakeHauntableLaunch(inst)
    
    return inst
end


return Prefab("common/inventory/new_shovel", init, assets)