local assets =
{
	-- Animation files used for the item.
	Asset("ANIM", "anim/swap_wudi_axe.zip"),

	-- Inventory image and atlas file used for the item.
    Asset("ATLAS", "images/inventoryimages/new_axe.xml"),
    Asset("IMAGE", "images/inventoryimages/new_axe.tex"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_wudi_axe", "swap_wudi_axe") -- ([symbol you want to override], [symbol name from your build], [your build name])
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function init()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("new_axe") -- bank, aka entity name in your spriter file
    inst.AnimState:SetBuild("swap_wudi_axe") -- build, aka name of your *.scml file 
    inst.AnimState:PlayAnimation("idle") -- animation name, ofc

	inst:AddTag("sharp")
	
	inst.entity:SetPristine()
		
	if not TheWorld.ismastersim then
		return inst
	end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE) -- is stronker
	inst.components.weapon.attackwear = 2

	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP)
	
    inst:AddComponent("inspectable")
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.AXE_USES)
    inst.components.finiteuses:SetUses(TUNING.AXE_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/new_axe.xml"
    inst.components.inventoryitem.imagename = "new_axe"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	MakeHauntableLaunch(inst)
    
    return inst
end


return Prefab("common/inventory/new_axe", init, assets)