Assets = {
	Asset("ANIM", "anim/lucy_wudi.zip"),
	Asset("ANIM", "anim/swap_wudi_axe.zip"),

	Asset("ATLAS", "images/inventoryimages/lucy.xml"),
	Asset("IMAGE", "images/inventoryimages/lucy.tex"),
	
	Asset("ATLAS", "images/avatars/self_inspect_woodie.xml"),
	Asset("IMAGE", "images/avatars/self_inspect_woodie.tex"),
	
	Asset("ATLAS", "images/avatars/avatar_woodie.xml"),
	Asset("IMAGE", "images/avatars/avatar_woodie.tex"),
	
	Asset("ATLAS", "bigportraits/woodie_none.xml"),
	Asset("IMAGE", "bigportraits/woodie_none.tex"),
	
	Asset("ATLAS", "images/names_woodie.xml"),
	Asset("IMAGE", "images/names_woodie.tex"),
	
	Asset("MINIMAP_IMAGE", "lucy_axe"),
	Asset("MINIMAP_IMAGE", "woodie"),
}

local SP = GLOBAL.SpawnPrefab
local STGS = GLOBAL.STRINGS
local Vector3 = GLOBAL.Vector3
local require = GLOBAL.require

RemapSoundEvent( "dontstarve/characters/woodie/lucytalk_LP", "dontstarve/characters/woodie/talk_LP" )
RemapSoundEvent( "dontstarve/characters/woodie/lucy_transform", "dontstarve/characters/woodie/yawn" )
RemapSoundEvent( "dontstarve/characters/woodie/lucy_warn_1", "dontstarve/characters/woodie/yawn" )
RemapSoundEvent( "dontstarve/characters/woodie/lucy_warn_2", "dontstarve/characters/woodie/yawn" )
RemapSoundEvent( "dontstarve/characters/woodie/lucy_warn_3", "dontstarve/characters/woodie/yawn" )
RemapSoundEvent( "dontstarve/characters/woodie/talk_LP", "dontstarve/characters/woodie/lucytalk_LP" )
RemapSoundEvent( "dontstarve/characters/woodie/emote", "dontstarve/characters/woodie/lucy_warn_1" )
RemapSoundEvent( "dontstarve/characters/woodie/death_voice", "dontstarve/characters/woodie/lucy_transform" )
RemapSoundEvent( "dontstarve/characters/woodie/hurt", "dontstarve/characters/woodie/lucy_warn_3" )
RemapSoundEvent( "dontstarve/characters/woodie/yawn", "dontstarve/characters/woodie/lucy_transform" )
RemapSoundEvent( "dontstarve/characters/woodie/ghost_LP", "dontstarve/characters/woodie/lucy_transform" )
RemapSoundEvent( "dontstarve/characters/woodie/pose", "dontstarve/characters/woodie/lucy_warn_2" )
RemapSoundEvent( "dontstarve/characters/woodie/eye_rub_vo", "dontstarve/characters/woodie/lucy_warn_2" )

STGS.NAMES.LUCY = "Woodie the Lumberjack"
STGS.CHARACTERS.WOODIE.DESCRIBE.LUCY = "It looks just like my favorite philosopher, sCHOPenhauer"

STGS.CHARACTER_NAMES.woodie = "Lucy"
STGS.CHARACTER_TITLES.woodie = "The Axe"
STGS.CHARACTER_DESCRIPTIONS.woodie = "*Has a lovely lumberjack\n*Has a terrible secret"
STGS.CHARACTER_QUOTES.woodie = "\"What a lucyd dream.\""

STGS.CHARACTERS.WOODIE.ACTIONFAIL.ABIGAILHEART = "I'd never hear the end of it from 'Woodie if I didn't try."
STGS.CHARACTERS.WOODIE.ACTIONFAIL.CANTLEARN = "Err... do you understand this one, 'Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.WEBBER.MURDERER = "'Luce gave me the go-ahead! You're in trouble now, %s!"
STGS.CHARACTERS.WOODIE.DESCRIBE.SPEAR_WATHGRITHR = "Who needs a spear when you got ol'Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.BERNIE_INACTIVE.GENERIC = "Cute, isn't it 'Woodie?"
STGS.CHARACTERS.WOODIE.ANNOUNCE_SACREDCHEST_NO = "We didn't cut it, Woodie."
STGS.CHARACTERS.WOODIE.ANNOUNCE_SOAKED = "Better hold on tight, Woodie."
STGS.CHARACTERS.WOODIE.ANNOUNCE_ENCUMBERED =
{
        "Hnff...",
        "No... Don't get up... Woodie...",
        "Heavy... Eh...?",
        "...oof...",
        "I'll keep... lumberin' along...",
        "No point... complainin'...",
        "Work's... gotta get done...",
        "Nothin' like... honest work...",
        "I'm more of a chopper than a lifter...",
        "Huff... huff...",
}
STGS.CHARACTERS.WOODIE.ANNOUNCE_ACCOMPLISHMENT= "Woodie is going to be so proud of me!"
STGS.CHARACTERS.WOODIE.ANNOUNCE_WORMS = "Oh geez. I hope you're ready, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.WAXWELL.GHOST = "Woodie says I have to help you, %s. Let's get goin'."
STGS.CHARACTERS.WOODIE.DESCRIBE.GIFTWRAP = "Should we do something nice today, Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.MOONDIAL.WEREBEAVER = "Just about time again, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.OPALPRECIOUSGEM = "You're fond of it, aren'tcha Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.MUSHROOM_LIGHT.ON = "Soak in that all-natural light, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.TOADSTOOL.RAGE = "Alright, enough playin' around! Get'em Woodie!"
STGS.CHARACTERS.WOODIE.DESCRIBE.MUSHROOMSPROUT.BURNT = "Don't breathe it in, Woodie!"
STGS.CHARACTERS.WOODIE.DESCRIBE.SPORE_SMALL.GENERIC = "We've been visited by a forest sprite, Woodie!"
STGS.CHARACTERS.WOODIE.DESCRIBE.AXE = "It's not as nice as Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.CHESSPIECE_ROOK.STRUGGLE = "Get ready, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.CHESSPIECE_KNIGHT.STRUGGLE = "Get ready, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.CHESSPIECE_BISHOP.STRUGGLE = "Get ready, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.CHESSPIECE_MUSE = "I don't tend to trust anyone without a face. Myself excluded, of course."
STGS.CHARACTERS.WOODIE.DESCRIBE.CHESSPIECE_PIPE = "Kitschy. Just how Woodie and I like it."
STGS.CHARACTERS.WOODIE.DESCRIBE.CANARY.HELD = "Want a peek at our prisoner, Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.LAVAE_TOOTH = "Not as sharp as Woodie!"
STGS.CHARACTERS.WOODIE.DESCRIBE.EVERGREEN_SPARSE.GENERIC = "Woodie would want me to chop it down."
STGS.CHARACTERS.WOODIE.DESCRIBE.FOSSIL_STALKER.FUNNY = "Eh... Should we try again, Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.GOLDENAXE = "It's almost as nice as Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.MARBLETREE = "Even Woodie can't chop that one down."
STGS.CHARACTERS.WOODIE.DESCRIBE.PANFLUTE = "I only sing for Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.PETALS = "I wonder if I like these. I'll ask myself next time."
STGS.CHARACTERS.WOODIE.DESCRIBE.SCULPTURE_BISHOPBODY.COVERED = "I don't get art. Whattaya think Woodie?"
STGS.CHARACTERS.WOODIE.DESCRIBE.TRINKET_20 = "Wilfredige keeps using it to \"shag\" me and Woodie. We prefer wood."
STGS.CHARACTERS.WOODIE.DESCRIBE.TRINKET_25 = "It's as small as Woodie's ding-dong."
STGS.CHARACTERS.WOODIE.DESCRIBE.HALLOWEENCANDY_2 = "Don't worry, I'll eat enough for the both of us, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.HALLOWEENCANDY_8 = "I'll tell you what it tastes like, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.HALLOWEENCANDY_10 = "I'll tell you what it tastes like, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.REDPOUCH = "It's Woodie-colour."
STGS.CHARACTERS.WOODIE.DESCRIBE.WINTER_ORNAMENTLIGHT = "What do you think, Woodie? Decorate, or chop?"
STGS.CHARACTERS.WOODIE.DESCRIBE.WINTER_FOOD9 = "Psst, Woodie. Do I have a 'nog moustache?"
STGS.CHARACTERS.WOODIE.DESCRIBE.ATRIUM_RUBBLE.LINE_4 = "Don't look at this one, Woodie."
STGS.CHARACTERS.WOODIE.DESCRIBE.ATRIUM_GATE.OFF = "Where d'you think it goes, Woodie?"

STGS.LUCY =
{
    equipped =
    {
        "I like trees",
		"I want to chop trees",
		"Trees",
		"OMG WHAT IS THAT wait its a tree",
		"Being a Werebeaver was les terribel",
    },

    on_ground =
    {
        "I've come to chop some trees and kick some asses, and I'm out of asses",
        "with an easter egg",
    },

    on_haunt =
    {
        "Is this the pain olympics?"
    },

    in_container =
    {
        "I Dont see any Trees here"
    },

    other_owner =
    {
        "well shit, I wana die",
    },

    on_pickedup =
    {
        "lets chop tres now",
		"yaey",
		"yaaass"
    },

    on_woodie_pickedup_other =
    {
        "Chop, chop, chop your boat and see if it still floats"
    },

    on_dropped =
    {
        "HOW COULD THIS HAPPEN TO MEEEEEE",
        "I dropped my wood",
		"you arent the real lucy you freak",
    },

    on_chopped =
    {
        "WOW, this trunk is thicc",
		"chop tre faster luci",
		"my hed hurts, but i love it",
		"okey",
		"nothin like sum fresh branches"
    },

    beaver_down_early =
    {
        "git guder",
        "stop suk",
        "Axe you okay?"
    },
    beaver_down_mid =
    {
        "Aint it time for sum logins?",
        "Lucy! Remember to chop your wood!"
    },
    beaver_down_late =
    {
        "IT'S TIME TO STOP"
    },
    beaver_up_waslow =
    {
        "HUUUUGE",
		"Wood you stop?",
		"I think we'll be alright, Eh?"
    },

    transform_beaver =
    {
        "Knuckles",
		"dang.",
		"Chop it out, man",
		"U Dont like it when ur angry",
		"You treespassed the limit"
    },
    transform_woodie =
    {
        "dang^2.",
		"That was some deep shit, mam",
		"Time to log out"
    },
}

AddPlayerPostInit(function(inst)
	if inst.prefab == "woodie" and inst.AnimState then
		inst:DoTaskInTime(0, function(inst)
			inst.AnimState:OverrideSymbol("face", "lucy_wudi", "face")
			inst.AnimState:OverrideSymbol("headbase", "lucy_wudi", "headbase")
			inst.AnimState:OverrideSymbol("headbase_hat", "lucy_wudi", "headbase_hat")
			inst.AnimState:OverrideSymbol("cheeks", "lucy_wudi", "cheeks")
			inst.AnimState:OverrideSymbol("SWAP_ICON", "lucy_wudi", "SWAP_ICON")
		end)
		
		if inst.components.talker then
			inst.components.talker.colour = Vector3(.9, .4, .4)
		end
		
		if inst.MiniMapEntity then
			inst.MiniMapEntity:SetIcon("lucy_axe.png")
		end
	end
end)

-- Skins fix:
local SkinsPuppet = require("widgets/skinspuppet")
local CLOTHING = GLOBAL.CLOTHING
local _oldSetSkins = SkinsPuppet.SetSkins
function SkinsPuppet:SetSkins(prefabname, base_skin, clothing_names, skip_change_emote)
	_oldSetSkins(self, prefabname, base_skin, clothing_names, skip_change_emote)
	
	if prefabname ~= nil and prefabname == "woodie" then
		self.animstate:OverrideSymbol("face", "lucy_wudi", "face")
		self.animstate:OverrideSymbol("headbase", "lucy_wudi", "headbase")
		self.animstate:OverrideSymbol("headbase_hat", "lucy_wudi", "headbase_hat")
		self.animstate:OverrideSymbol("cheeks", "lucy_wudi", "cheeks")
		
	elseif prefabname == nil or prefabname ~= nil and prefabname ~= "malami" then
		self.animstate:ClearOverrideSymbol("face")
		self.animstate:ClearOverrideSymbol("headbase")
		self.animstate:ClearOverrideSymbol("headbase_hat")
		self.animstate:ClearOverrideSymbol("cheeks")
    end
end

local function ChangeLucy(inst)
	if inst.MiniMapEntity then
		inst.MiniMapEntity:SetIcon("woodie.png")
	end
	
	if inst.components.talker then
		inst.components.talker.colour = Vector3(1, 1, 1) -- this has to be done clientside as well to work properly
	end
	
    if GLOBAL.TheWorld.ismastersim then
        inst.AnimState:SetBank("new_axe") 
		inst.AnimState:SetBuild("swap_wudi_axe")
		inst.AnimState:PlayAnimation("idle")
		
		local function onequip(inst, owner)
			owner.AnimState:OverrideSymbol("swap_object", "swap_wudi_axe", "swap_wudi_axe")
			owner.AnimState:Show("ARM_carry")
			owner.AnimState:Hide("ARM_normal")
		end
		
		if not inst.components.equippable then
			inst:AddComponent("equippable")
		end
		inst.components.equippable:SetOnEquip(onequip)
		
		if not inst.components.inventoryitem then
			inst:AddComponent("inventoryitem")
		end
		inst.components.inventoryitem.atlasname = "images/inventoryimages/lucy.xml"
		inst.components.inventoryitem.imagename = "lucy"
    end
end
 
AddPrefabPostInit("lucy", ChangeLucy)