local assets = 
{
	Asset( "ANIM", "anim/ram_meal.zip" ),
	Asset( "ATLAS", "images/ram_meal.xml" ),
	Asset( "ATLAS", "images/ram_meal2.xml" ),
}

local function fn0()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ram_meal")
    inst.AnimState:SetBuild("ram_meal")
    --inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 50
    inst.components.edible.hungervalue = 50
    inst.components.edible.sanityvalue = 0
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_MEDITEM
	
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime( 10 * TUNING.TOTAL_DAY_TIME)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    return inst
end

local function fn()

	local inst = fn0()

	inst.AnimState:PlayAnimation("idle")

	if not TheWorld.ismastersim then
        return inst
    end
	
	inst.components.inventoryitem.atlasname = "images/ram_meal.xml"
	inst.components.inventoryitem.imagename = "ram_meal"
	
	inst.components.edible.foodtype = FOODTYPE.MEAT

	return inst
end

local function fn2()

	local inst = fn0()

	inst.AnimState:PlayAnimation("idle2")

	if not TheWorld.ismastersim then
        return inst
    end
	
	inst.components.inventoryitem.atlasname = "images/ram_meal2.xml"
	inst.components.inventoryitem.imagename = "ram_meal2"
	
	inst.components.edible.foodtype = FOODTYPE.VEGGIE

	return inst
end

return Prefab("ram_meal", fn, assets),
	Prefab("ram_meal2", fn2, assets)



