local assets =
{
    Asset("ANIM", "anim/ram_bola.zip"),
    Asset("ANIM", "anim/ram_bola_swap.zip"),
	Asset( "ATLAS", "images/ram_bola.xml" ),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "ram_bola_swap", "ram_bola_swap")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ram_bola")
    inst.AnimState:SetBuild("ram_bola")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)
	inst.components.weapon:SetRange(1)
	inst.components.weapon:SetOnAttack(function (weapon, attacker, target)
		if target ~= nil and math.random() < .2 then
			local fx = SpawnPrefab("tornado")
			fx.WINDSTAFF_CASTER = inst
			fx.Transform:SetPosition( target:GetPosition():Get() )
			fx:SetStateGraph("SGtornado_ram")
		end
	end)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/ram_bola.xml"
	inst.components.inventoryitem.imagename = "ram_bola"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab("ram_bola", fn, assets)