local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH
local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler

STRINGS.NAMES.MECH_HAY_ITEM = "Hay Wall Gate"
STRINGS.RECIPE_DESC.MECH_HAY_ITEM = "Hay Wall Gate Segments."

STRINGS.NAMES.MECH_WOOD_ITEM = "Wood Wall Gate"
STRINGS.RECIPE_DESC.MECH_WOOD_ITEM = "Wooden Wall Gate Segments."

STRINGS.NAMES.MECH_STONE_ITEM = "Stone Wall Gate"
STRINGS.RECIPE_DESC.MECH_STONE_ITEM = "Stone Wall Gate Segments."

STRINGS.NAMES.MECH_RUINS_ITEM = "Thulecite Wall Gate"
STRINGS.RECIPE_DESC.MECH_RUINS_ITEM = "Thulecite Wall Gate Segments."

STRINGS.NAMES.MECH_HAY = "Hay Wall Gate"
STRINGS.NAMES.MECH_WOOD = "Wooden Wall Gate"
STRINGS.NAMES.MECH_STONE = "Stone Wall Gate"
STRINGS.NAMES.MECH_RUINS = "Thulecite Wall Gate"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_HAY = "Open, Sesame!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_RUINS = "Open, Sesame!"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_HAY_ITEM = "Knock knock!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_WOOD_ITEM = "Knock knock!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_STONE_ITEM = "Knock knock!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MECH_RUINS_ITEM = "Knock knock!"

STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WX78.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MECH_HAY = "Open, Sesame!"

STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_RUINS = "Open, Sesame!"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_STONE = "Open, Sesame!"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_WOOD = "Open, Sesame!"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.MECH_HAY = "Open, Sesame!"

PrefabFiles = 
{
	"mech.lua",
}
Assets = 
{
	Asset("ATLAS", "images/inventoryimages/mech_hay_item.xml"),
	Asset("ATLAS", "images/inventoryimages/mech_wood_item.xml"),
	Asset("ATLAS", "images/inventoryimages/mech_stone_item.xml"),
	Asset("ATLAS", "images/inventoryimages/mech_ruins_item.xml"),
}


local OPEN = Action(3)
OPEN.str = "Open"
OPEN.id = "OPEN"
OPEN.fn = function(act)
	local tar = act.target
    if tar and tar.components.wallgates and not tar.components.wallgates:IsOpen() then
		tar.components.wallgates:OpenWall(tar)
		return true
    end
end

AddAction(OPEN)

AddStategraphActionHandler("wilson", ActionHandler(OPEN, "give"))

local CLOSE = Action(3)
CLOSE.str = "Close"
CLOSE.id = "CLOSE"
CLOSE.fn = function(act)
	local tar = act.target
    if tar and tar.components.wallgates and tar.components.wallgates:IsOpen() then
        tar.components.wallgates:CloseWall(tar)
        return true
    end
end

AddAction(CLOSE)

AddStategraphActionHandler("wilson", ActionHandler(CLOSE, "give"))

local mech_hay_item = GLOBAL.Recipe("mech_hay_item", {Ingredient("wall_hay_item", 1), Ingredient("goldnugget", 2),Ingredient("gears", 1)}, RECIPETABS.TOWN, TECH.SCIENCE_TWO, nil, nil, nil, 1)
mech_hay_item.atlas = "images/inventoryimages/mech_hay_item.xml"

local mech_wood_item = GLOBAL.Recipe("mech_wood_item", {Ingredient("wall_wood_item", 1), Ingredient("goldnugget", 2),Ingredient("gears", 1)}, RECIPETABS.TOWN, TECH.SCIENCE_TWO, nil, nil, nil, 1)
mech_wood_item.atlas = "images/inventoryimages/mech_wood_item.xml"

local mech_stone_item = GLOBAL.Recipe("mech_stone_item", {Ingredient("wall_stone_item", 1), Ingredient("goldnugget", 2),Ingredient("gears", 1)}, RECIPETABS.TOWN, TECH.SCIENCE_TWO, nil, nil, nil, 1)
mech_stone_item.atlas = "images/inventoryimages/mech_stone_item.xml"

local mech_ruins_item = GLOBAL.Recipe("mech_ruins_item", {Ingredient("wall_ruins_item", 1), Ingredient("goldnugget", 2),Ingredient("gears", 1)}, RECIPETABS.ANCIENT, TECH.ANCIENT_TWO, nil, nil, true, 1)
mech_ruins_item.atlas = "images/inventoryimages/mech_ruins_item.xml"