<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id: payment.mdl.php 9343 2015-03-24 07:07:00Z youyi $
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Mdl_Trade_Payment extends Model 
{
    
    public function order($code, $from, $order, $form=false)
    {

        if(!$oPayApi = $this->loadPayment($code)){
            return false;
        }
        if(!$log = K::M('payment/log')->log_by_no($order['order_id'])){
            $log = array('uid'=>$order['uid'], 'from'=>$from, 'trade_no'=>$order['order_id'], 'payment'=>$code, 'amount'=>$order['amount']); //插入订单记录表
            if(!$log_id = K::M('payment/log')->create($log)){
                return false;
            }
            $log = K::M('payment/log')->detail($log_id);
            //$log['log_id'] = $log_id;
        }
        if($log['payed'] == 1){
            $this->msgbox->add('该订单已经支付成功', 211);
            return false;
        }
        $a = array();        
        if($log['amount'] != $order['amount']){
            $a['amount'] = $order['amount'];
        }
        if($log['from'] != $from){
            $a['from'] = $from;
        }        
        if($log['payment'] != $code){
            $a['payment'] = $code;
        }
        if($a){
            K::M('payment/log')->update($log['log_id'], $a,  true);
        }
        $params = array();
        $params['trade_no'] = $order['order_id'];
        $site = K::$system->config->get('site');        
        $params['title'] = $site['title'].'订单';
        $params['body'] = $order['addr'].'('.$order['contact'].','.$order['mobile'].')';        
        $params['amount'] = $order['amount'];
        $params['contact'] = $order['contact'];
        $params['mobile'] = $order['mobile'];
        $params['addr'] = $order['addr'];
        if($form){
            return $oPayApi->build_form($params);
        }else{
            return $oPayApi->build_url($params);
        }
    }

    public function payed_order($log, $trade)
    {
        if($log['log_id']){
            if(!$order = K::M('trade/order')->detail($log['from'], $log['order_id'])){
                return false;
            }
            K::M('trade/order')->set_payed($log['from'], $log['order_id'], $trade);         
        }
        return true;
    }

    
    public function money($uid, $code, $amount)
    {
        if(!$uid = (int)$uid){
            return false;
        }else if(!$member = K::M('member/member')->detail($uid)){
            return false;
        }else if(!$oPayApi = $this->loadPayment($code)){
            return false;
        }
        $log = array('uid'=>$uid,'amount'=>$amount,'payment'=>$code,'from'=>'money');
        if(!$log_id = K::M('payment/log')->create($log, true)){
            return false;
        }
        $log = K::M('payment/log')->detail($log_id);
        $site = K::$system->config->get('site');
        $params = array();
        $params['title'] = $site['title'].'-充值余额';
        $params['body'] = '会员:'.$member['nickname'].'('.$uid.')';
        $params['amount'] = $amount;
        $params['trade_no'] = $log['trade_no'];
        return array('url'=>$oPayApi->build_url($params),'trade_no'=>$log['trade_no']);
    }

    public function payed_money($log,$trade)
    {
        $paynum = K::M('member/member')->getPaynum();   
        $package = K::M('member/money')->package();
        if($smoney = $package[$log['money']]){
            $money = $money + $smoney;
            $intro = "在线充值￥{$log['trade']},送￥{$smoney}";
        }else{
            $intro = "在线充值￥{$log['trade']}";
        }
        return K::M('member/member')->update_money($log['uid'],array('money'=>$money), $intro);
    }

    public function loadPayment($code)
    {

        static $_PayApiObj = array();
        if(!is_object($_PayApiObj[$code])){
            $file = __CFG::DIR."plugins/payments/{$code}/{$code}.php";
            if(!file_exists($file)){
                $this->msgbox->add('您选择的支付接口不存在', 311);
                return false;
            }else if(!$payment = K::M('payment/payment')->payment($code)){
                $this->msgbox->add('您选择的支付接口不存在', 312);
                return false;
            }else if(empty($payment['status'])){
                $this->msgbox->add('您选择的支付接口不可用', 313);
                return false;
            }
            if (defined('IN_WEIXIN') && $code == 'wxpay') {
                $file = __CFG::DIR."plugins/payments/{$code}/jsapi.php";
                include($file);
                $clsName = "Weixin_".ucfirst('jsapi');
            }else{
                include($file);
                $clsName = "Payment_".ucfirst($code);
            }
            $config = $payment['config'];
            $site = K::$system->config->get('site');
            
            if(defined('IN_MOBILE')){
                $in_mobile = 'mobile/';
            }          
            $config['return_url'] = $site['siteurl'].'/'.K::M('helper/link')->mklink($in_mobile.'trade/payment:return', array($code));
            $config['notify_url'] = $site['siteurl'].'/'.K::M('helper/link')->mklink($in_mobile.'trade/payment:notify', array($code));
            $_PayApiObj[$code] = new $clsName($config);
        }
        return $_PayApiObj[$code];
    }
    
    
    
    
}