<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id: order.mdl.php 6303 2014-09-17 11:01:41Z youyi $
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Mdl_Trade_Order extends Mdl_Table
{   
  
    protected $_table = 'order';
    protected $_pk = 'order_id';
    protected $_cols = 'order_id,order_no,uid,shop_id,city_id,product_count,product_number,product_amount,freight,amount,contact,mobile,addr,note,pay_status,order_status,pay_time,audit,closed,clientip,dateline';
    protected $_orderby = array('order_id'=>'DESC');
    
    public function create($data, $checked=false)
    {
        if(!$checked && !$data = $this->_check_schema($data)){
            return false;
        }
        return $this->db->insert($this->_table, $data, true);
    }

    public function create_by_cart($cart, $data)
    {
        $orders = $product_list = $spec_list = array();
        if(empty($cart['items'])){
            $this->msgbox->add('购物车不能为空', 211);
            return false;
        }
        foreach($cart['items'] as $sk=>$item){
            list($pid, $spid) = explode('-', $sk);
            $product_ids[$pid] = $pid;
            if($spid){
                $spec_ids[$spid] = $spid;
            }
            $orders[$item['shop_id']][$item['cart_key']] = $item;
        }
        if($product_ids){
            if($product_list = K::M('product/product')->items_by_ids($product_ids)){
                if($spec_ids){
                    $spec_list = K::M('product/spec')->items_by_ids($spec_ids);
                }
            }
        }
        foreach($orders as $shop_id=>$items){
            $product_amount = $shop_fee = $product_count = $product_number = 0;
            $products = $sale_counts = $product_names = array();
			$shop = K::M('shop/shop')->detail($shop_id);
            foreach($items as $item){
                $theproduct = $product_list[$item['product_id']];         
                if($theproduct['store'] < $item['num']){
                    $this->msgbox->add($item['name'].'商品库存不足', 321);
                    return false;
                }else if($theproduct['sale_type'] == 1 && ($theproduct['sale_sku']<($theproduct['sale_count']+$item['num']))){
                    $this->msgbox->add($item['name'].'商品库存不足', 321);
                    return false;
                }else if($item['spec_id'] && ($item['spec']['sale_sku'] < $item['num'])){
                    $this->msgbox->add($item['name'].'商品库存不足', 321);
                    return false;  
                }
                $product = array();
                $product_names[$item['product_id']] = $item['name'];
                $product_count += $item['num'];
                $product_number ++;
                $product_amount += $item['product_price'] * $item['num'];
                $freight += $item['freight'];
                $product['product_id'] = $item['product_id'];
                $product['spec_id'] = $item['spec_id'];                
                if($item['spec_id']){
                    $product['spec_name'] = $item['spec_name'];
                }
                $product['product_name'] = $item['name'];
                $product['product_price'] = $item['product_price'];
                $product['number'] = $item['num'];
                $prodcut['freight'] =$item['freight'];
                $product['amount'] = $product['product_price'] * $item['num'] + $product['freight'];
                $products[$item['cart_key']] = $product;
                $sale_counts[$item['cart_key']] = $item['num'];
            }
            $order = array();
            $order['uid'] = $data['uid'];
            $order['shop_id'] = $shop_id;
            $order['contact'] = $data['contact'];
            $order['mobile'] = $data['mobile']?$data['mobile']:$data['phone'];
            $order['addr'] = $data['addr'];
            $order['note'] = $data['note'];
            $order['product_count'] = $product_count;
            $order['product_number'] = $product_number;
            $order['product_amount'] = $product_amount;
            $order['freight'] = $freight;
            $order['amount'] = $product_amount + $freight;
            $order['order_no'] = $this->create_order_no();
			$order['city_id'] = $shop['city_id'];
            if(!$order_id = $this->create($order)){
                return false;
            }
            foreach($products as $sk=>$product){
                list($pid, $spid) = explode('-', $sk);
                $product['order_id'] = $order_id;
                K::M('trade/product')->create($product, true);
                $a = array('store'=>"`store`-{$product[number]}", 'buys'=>"`buys`+{$product[number]}");
                if($product_list[$pid]['sale_type'] == 1){
                    $a['sale_count'] = "`sale_count`+{$product[number]}";
                }
                K::M('product/product')->update($pid, $a, true);
                if($spid = (int)$spid){
                    $b = array('sale_sku'=>"`sale_sku`-{$product[number]}", 'sale_count'=>"`sale_count`+{$product[number]}");
                    K::M('product/spec')->update($spid, $b, true);
                }
            }
            K::M('shop/shop')->update_count($shop_id, 'sales', $product_count);
            $maildata = array('order_no'=>$order['order_no'], 'order_amount'=>$order['amount'], 'contact'=>$order['contact']);
            $maildata['product_name'] = implode(',', $product_names);
            $maildata['link'] = K::M('helper/link')->mklink('trade/order:detail', array($order['order_no']), array(), true);
            //send mail to buyer
            K::M('helper/mail')->send($member['mail'], 'order_buyer', $maildata);
            //send mail to seller
            if($shop = K::M('shop/shop')->detail($shop_id)){
                K::M('helper/mail')->send('order_seller', $maildata, $shop);
            }
        }
        //print_r($this->db->SQLLOG());
        //echo 'FILE:',__FILE__,'LINE:',__LINE__;exit();
        return $order;
    }

    public function create_order_no()
    {
        $i = rand(0, 9999);
        do {
            if (9999 == $i) {
                $i = 0;
            } 
            ++$i;
            $no = date("ymd") . str_pad($i, 4, "0", STR_PAD_LEFT);
            $order_no = $this->db->GetRow("SELECT order_no FROM ".$this->table($this->_table)." WHERE order_no='{$no}'");
        } while ($order_no);
        return $no;
    }

    public function update($pk, $data, $checked=false)
    {
        $this->_checkpk();
        if(!$checked && !$data = $this->_check_schema($data,  $pk)){
            return false;
        }
        return $this->db->update($this->_table, $data, $this->field($this->_pk, $pk));
    }

    public function detail($order_id, $closed=false)
    {
        if($row = parent::detail($order_id, $closed)){
            $row['products'] = K::M('trade/product')->order_products($row['order_id']);
        }
        return $row;
    }

    public function detail_by_no($no)
    {
        if($no = (int)$no){
            $where = "order_id=$no";
        }else{
            return false;
        }
        $sql = "SELECT * FROM ".$this->table($this->_table)." WHERE order_id='$no'";
        if($row = $this->db->GetRow($sql)){
            $row = $this->_format_row($row);
        }
        return $row;
    }

    public function set_payed($no, $trade=array())
    {
        
        if(!$order = $this->detail_by_no($no)){
            return false;
        }
        $a = array('pay_status'=>1, 'pay_time'=>__CFG::TIME);
        if($ret = $this->update($order['order_id'], $a, true)){
            //阿姨加钱

            $detail = K::M('order/order')->detail($order['order_id']);

            if($detail){

                $aunt = K::M('aunt/aunt')->detail($order['aunt_id']);
                $js_price = $aunt['money'] + $detail['js_price'];
                
                if($aunt){
                    $uup = K::M('aunt/aunt') -> update($aunt['id'],array('money'=>$js_price));
                    K::M('aunt/logs')->logs($aunt['id'],$detail['js_price'],'完成了编号【'.$detail['order_id'].'】的订单，结算');
                }

            }
    
            
        }
        return $ret;
    }

    public function count_by_shop($shop_id)
    {
        if(!$shop_id = (int)$shop_id){
            return false;
        }
        $sql = "SELECT order_status, COUNT(1) as C FROM ".$this->table($this->_table)." WHERE shop_id='$shop_id' AND closed=0 GROUP BY order_status";
        $order_count = array('count'=>0, 'cancel'=>0,'member_cancel'=>0,'shop_cancel'=>0,'unship'=>0,'new'=>0, 'unpay'=>0,'finish'=>0);
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                if($row['order_status'] == -1){
                    $order_count['member_cancel'] = $row['C'];
                    $order_count['cancel'] += $row['C'];
                }else if($row['order_status'] == -2){
                    $order_count['shop_cancel'] = $row['C'];
                    $order_count['cancel'] += $row['C'];
                }else if($row['order_status'] == 1){
                    $order_count['unship'] = $row['C'];
                }else if($row['order_status'] == 2){
                    $order_count['finish'] = $row['C'];
                }else if($row['order_status'] == 0){
                    $order_count['new'] = $row['C'];
                }
                $order_count['count'] += $row['C'];
            }
        }
        $sql = "SELECT COUNT(1) FROM ".$this->table($this->_table)." WHERE shop_id='$shop_id' AND closed=0 AND pay_status=0";
        $order_count['unpay'] = $this->db->GetOne($sql);        
        return $order_count;
    }

    public function count_by_uid($uid)
    {
        if(!$uid = (int)$uid){
            return false;
        }
        $sql = "SELECT order_status, COUNT(1) as C FROM ".$this->table($this->_table)." WHERE uid='$uid' AND closed=0 GROUP BY order_status";
        $order_count = array('count'=>0, 'cancel'=>0,'member_cancel'=>0,'shop_cancel'=>0,'unship'=>0,'new'=>0, 'unpay'=>0,'finish'=>0);
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                if($row['order_status'] == -1){
                    $order_count['member_cancel'] = $row['C'];
                    $order_count['cancel'] += $row['C'];
                }else if($row['order_status'] == -2){
                    $order_count['shop_cancel'] = $row['C'];
                    $order_count['cancel'] += $row['C'];
                }else if($row['order_status'] == 1){
                    $order_count['unship'] = $row['C'];
                }else if($row['order_status'] == 2){
                    $order_count['finish'] = $row['C'];
                }else if($row['order_status'] == 0){
                    $order_count['new'] = $row['C'];
                }
                $order_count['count'] += $row['C'];
            }
        }
        $sql = "SELECT COUNT(1) FROM ".$this->table($this->_table)." WHERE uid='$uid' AND closed=0 AND pay_status=0";
        $order_count['unpay'] = $this->db->GetOne($sql);               
        return $order_count;
    }

}