<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if (!defined('__CORE_DIR')) {
    exit("Access Denied");
}

class Mdl_Member_Member extends Mdl_Table {

    protected $_table = 'member';
    protected $_pk = 'uid';
    protected $_cols = 'uid,mobile,passwd,nickname,face,wx_openid,loginip,lastlogin,regip,closed,dateline';

    public function member($u, $l = 'uid') {
        $l = strtolower($l);
        switch ($l) {
            case 'uid':
                $field = 'uid';
                break;
            case 'mobile':
                $field = 'mobile';
                break;
            default:
                return false;
        }
        $sql = "SELECT * FROM " . $this->table($this->_table) . " WHERE " . $this->field($field, $u);

        if ($row = $this->db->GetRow($sql)) {
            $row = $this->_format_row($row);
        }
        return $row;
    }

    public function guest()
    {
        static $guest = array('uid' => 0, 'mobile' => '', 'nickname' => '游客');
        return $this->_format_row($guest);
    }

    public function create($data, $checked = false) 
    {
        if (!$checked && !($data = $this->_check($data))) {
            return false;
        }
        $data['regip'] = $data['regip'] ? $data['regip'] : __IP;
        $data['dateline'] = $data['dateline'] ? $data['dateline'] : __CFG::TIME;
        if ($uid = $this->db->insert($this->_table, $data, true)) {
            return $uid;
            //$this->db->Execute("INSERT INTO " . $this->table('member_fields') . "(uid) VALUES('$uid')");
        }
        
    }

    public function getPaynum() 
    {
        return array(
            '1' => '1',
            '500'  => '50',
            '2000' => '250',
            '5000' => '600',
        );
    }
    
    public function update_money($uid,$money)
    {
        return K::M('member/money')->update($uid,$money,true);        
    }   

}
