<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_XiChe extends Ctl
{
    
    public function __construct(&$system) 
    {
        parent::__construct($system);
        $this->system->config->get('mobile');
        $this->msgbox->template("xiche/page/notice.html");
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false) {
            if ($this->wx_openid = $this->token_openid()) {
                if ($m = K::M('member/weixin')->detail_by_openid($this->wx_openid)) {
                    if ($uid = (int) $m['uid']) {     //如果数据库中存在该微信id则直接登录
                        K::M('member/auth')->manager($uid);
                    }
                }
            }
        }
    }
    
    
    
    protected function token_openid() 
    {
        static $openid = null;
        if ($openid === null) {
            if ($openid = $this->GP('WXOPENID')) {
                $client = $this->wechat_client();
                $m = K::M('member/weixin')->detail_by_openid($openid);
                if ($m['uid']) {
                    K::M('member/auth')->manager($m['uid']);
                } else if ($wx_info = $client->getUserInfoById($openid)) {
                    
                    if ($m = K::M('member/weixin')->create_account($wx_info, $openid)) {
                        K::M('member/auth')->manager($m['uid']);
                    }
                }
                $this->cookie->set('wx_openid', $openid);
            } else { //获取cookie的openid                
                if (!$openid = $this->cookie->get('wx_openid')) {
                    $client = $this->wechat_client(); //$client
                    $url = $this->request['url'] . '/' . $this->request['uri'];
                    $authurl = 'http://fz.jhcms.cn/weixin/token/index.html?reback_url=' . urlencode($url);
                    header('Location:' . $authurl);
                    exit();
                }
            }

            if (!defined('WX_OPENID')) {
                define('WX_OPENID', $openid);
            }
            if (!defined('WX_OPENID')) {
                define('WX_UNIONID', $unionid);
            }
        }
        if (empty($openid)) {
            $this->err->add('获取授权失败！');
            $this->err->set_data('forward', '/xiche/index');
        }
        return $openid;
    }

    
    
    protected function access_openid($force = false) 
    {
        //setcookie("wx_openid","",time()-3600);

        static $openid = null;
        if ($force || $openid === null) {

            if ($code = $this->GP('code')) {
                
                $client = $this->wechat_client();
                
                $ret = $client->getAccessTokenByCode($code);
                if ($openid = $ret['openid']) {
                    $m = K::M('member/weixin')->detail_by_openid($openid);
                } else {
                    $this->err->add('获取授权失败1！');
                    $this->err->set_data('forward', '/mobile/index');
                }
   
                if ($m['uid']) {
                    K::M('member/auth')->manager($m['uid']);
                } else if ($wx_info = $client->getUserInfoById($ret['openid'])) {
                    if ($m = K::M('member/weixin')->create_account($wx_info, $openid)) {
                        K::M('member/auth')->manager($m['uid']);
                    }
                }

                $this->cookie->set('wx_openid', $openid);
            } else { //获取cookie的openid                
                if (!$openid = $this->cookie->get('wx_openid')) {
                    $client = $this->wechat_client();                    //$client
                    $url = $this->request['url'] . '/' . $this->request['uri'];
                    $authurl = $client->getOAuthConnectUri($url, $state, 'snsapi_userinfo');
                    header('Location:' . $authurl);
                    exit();
                }
            }

            if (!defined('WX_OPENID')) {
                define('WX_OPENID', $openid);
            }
            if (!defined('WX_OPENID')) {
                define('WX_UNIONID', $unionid);
            }
        }
        if (empty($openid)) {
            $this->err->add('获取授权失败！');
            $this->err->set_data('forward', '/mobile/index');
        }
        return $openid;
    }

    protected function wechat_client() 
    {
        static $client = null;
        if ($client === null) {
            $client = K::M('weixin/wechat')->wechat_client();
        }
        return $client;
    }

    
    
}