<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_XiChe_Ucenter_Addr extends Ctl_Xiche_Ucenter
{

    public function index()
    {
        $gid = $this->GP('gid');
        if($gid){
            $this->pagedata['gid'] = $gid;
        }
        $car_id = $this->GP('car_id');
        if($car_id){
            $this->pagedata['car_id'] = $car_id;
        }
        $addrs = K::M('member/addr')->items(array('uid'=>$this->MEMBER['uid']));
        $this->pagedata['addrs'] = $addrs;
        $this->tmpl = 'xiche/ucenter/addr/index.html';
    }
    
    
    public function check()
    {
        $addrs = K::M('member/addr')->items();
        $this->pagedata['addrs'] = $addrs;
        $this->tmpl = 'xiche/ucenter/addr/check.html';
    }
    
    
    public function add(){
        $lat = $this->GP('lat');
        $lng = $this->GP('lng');
        $addr = $this->GP('addr');
        if($lat){
            $this->pagedata['lat'] = $lat;
        }
        if($lng){
            $this->pagedata['lng'] = $lng;
        }
        if($addr){
            $this->pagedata['addr'] = $addr;
        }
        $gid = (int)$this->GP('gid');
        if($gid){
            $this->pagedata['gid'] = $gid;
        }
        $car_id = (int)$this->GP('car_id');
        if($car_id){
            $this->pagedata['car_id'] = $car_id;
        }
        $this->tmpl = 'xiche/ucenter/addr/add.html';
    }
    
    public function add_handle(){
        $contact = htmlspecialchars($this->GP('contact'));
        $mobile = $this->GP('mobile'); 
        $addr = htmlspecialchars($this->GP('addr'));
        $remark = htmlspecialchars($this->GP('remark'));
        $lng = $this->GP('lng');
        $lat = $this->GP('lat');
        if(!$contact){
            $this->msgbox->add('名字没有填写', 211)->response();
        }else{
            $data['contact'] = $contact;
        }
        if(!$m = K::M('verify/check')->mobile($mobile)){
            $this->msgbox->add('手机号码有误', 212)->response();
        }else{
            $data['mobile'] = $mobile;
        }
        if(!$addr){
            $this->msgbox->add('地址没有填写', 213)->response();
        }else{
            $data['addr'] = $addr;
        }
        
        if($remark){
            $data['remark'] = $remark;
        }
        
        if(!$this->uid){
            $this->msgbox->add('没有登录', 101)->response();
        }
        
        if($lat){
            $data['lat'] = $lat;
        }
        
        if($lng){
            $data['lng'] = $lng;
        }
        
        $data['uid'] = $this->uid;

        
        $data['dateline'] = $data['dateline'] ? $data['dateline'] :  __CFG::TIME;
        if ($addr_id = K::M('member/addr')->create($data)) {
           $this->msgbox->add('地址创建成功');
           $this->msgbox->set_data('addr_id',$addr_id);
           if($gid){
               $this->msgbox->set_data('gid',$gid);
           }
        }else{
            $this->msgbox->add('创建失败', 404);
        }

        
    }
    
    public function location(){
        $gid = (int)$this->GP('gid');
        if($gid){
            $this->pagedata['gid'] = $gid;
        }
        $car_id = (int)$this->GP('car_id');
        if($car_id){
            $this->pagedata['car_id'] = $car_id;
        }
        $this->tmpl = 'xiche/ucenter/addr/location.html';
    }

    
    
    public function del_addr(){
        $addr_id = (int)$this->GP('addr_id');
        if(!$addr_id){
            $this->msgbox->add('错误的地址!',211);
            $this->msgbox->response();
        }else if(!$addr =K::M('member/addr')->detail($addr_id)){
            $this->msgbox->add('错误的地址!',211);
            $this->msgbox->response();
        }else if(!$this->uid){
            $this->msgbox->add('您还没有登录或登录超时!',101);
            $this->msgbox->response();
        }else if($addr['uid'] != $this->uid){
            $this->msgbox->add('不可操作别人的地址!',213);
            $this->msgbox->response();
        }else{
            $del = K::M('member/addr')->delete(array('addr_id'=>$addr_id));
            if($del){
                $this->msgbox->add('删除成功!');
            }else{
                $this->msgbox->add('删除失败!',215);
                $this->msgbox->response();
            }
        }
    }
    
    
}