<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_XiChe_Order extends Ctl
{
    
    public function index()
    {
        $this->tmpl = 'xiche/order/index.html';
    }
    
    public function service_list(){
        $this->tmpl = 'xiche/order/service_list.html';
    }
    
    public function goods()
    {
        $goods_id = (int)$this->GP('gid');
        $car_id = (int)$this->GP('car_id');
        $addr_id = (int)$this->GP('addr_id');
        $this->pagedata['gid'] = $goods_id;
        $this->pagedata['car_id'] = $car_id;
        $this->pagedata['addr_id'] = $addr_id;
        $res = K::M('xiche/goods')->detail($goods_id);
        $car = K::M('xiche/car')->detail($car_id);
        $addr = K::M('member/addr')->detail($addr_id);
        $this->pagedata['car'] = $car;
        $this->pagedata['addr'] = $addr;
        
        //查询附加商品
        $product = K::M('xiche/product')->items(array('goods_id'=>$goods_id));
        $i=1;
        $cookies = array();
        foreach($product as $k => $v){
            $product[$k]['key'] = $i;
            $i=$i+1;
            if($_COOKIE['product'.$v['product_id']] == $v['product_id']){
               $cookies[$v['product_id']] = $v['product_id'];
            }
        }
        if($cookies){
            $this->pagedata['cookies'] = $cookies;
        }
       
        if($product){
            $this->pagedata['product'] = $product;
        }
        if(!$res){
            $this->msgbox->add('错误',403)->response();
        }else{
            $this->pagedata['res'] = $res;
        }

        
        //创造日期数组
        $today = date("Y-m-d",time());
        $today_w = date("w",time());
        $week = array();
        $week[0]['d'] = $today;
        $week[0]['w'] = $today_w;
        for($i=1;$i<=6;$i++){
                $d = date('Y-m-d',86400*$i+time());
                $w = date('w',86400*$i+time());
                $week[$i]['d'] = $d;
                $week[$i]['w'] = $w;
        }
        
        
        foreach($week as $k => $v){
            switch ($week[$k]['w']){
            case 0:
              $week[$k]['w'] = "周日";
              break;
            case 1:
              $week[$k]['w'] = "周一";
              break;
            case 2:
              $week[$k]['w'] = "周二";
              break;
           case 3:
              $week[$k]['w'] = "周三";
              break;
           case 4:
              $week[$k]['w'] = "周四";
              break;
           case 5:
              $week[$k]['w'] = "周五";
              break;
           case 6:
              $week[$k]['w'] = "周六";
              break;
            }
        }
        $this->pagedata['week'] = $week;

        
        $this->tmpl = 'xiche/order/goods.html';
    }

    
    public function handle(){
        $product = $this->GP('product');
        if(!$this->uid){
            $this->msgbox->add('您还没有登录或登录超时', 210);
        }else if(!$gid = $this->GP('gid')){
            $this->msgbox->add('商品错误', 211);
        }else if(!$mobile = K::M('verify/check')->mobile($this->GP('mobile'))){
            $this->msgbox->add('手机号码有误', 212);
        }else if(!$car = $this->GP('car')){
            $this->msgbox->add('车辆没有选择', 213);
        }else if(!$addr = $this->GP('addr')){
            $this->msgbox->add('地址没有选择', 214);
        }else if(!$week = $this->GP('week')){
            $this->msgbox->add('服务时间没有选择完整'.$week, 215);
        }else if(!$hour = $this->GP('hour')){
            $this->msgbox->add('服务时间没有选择完整', 215);
        }else if(!$goods = K::M('xiche/goods')->detail($gid)){
            $this->msgbox->add('错误的商品', 216);
        }else{            
            $data = array();
            $data['uid'] = $this->uid;
            $data['goods_id'] = $gid;
            $data['mobile'] = $mobile;
            $data['addr'] = $addr;
            $data['car'] = $car;
            $data['fuwu_time'] = strtotime($week)+($hour*3600);
            $data['price'] = $goods['price'];
            $data['order_status'] = 1;
            $data['amount'] = $data['price'];            
            //如果有附加项目
            $product = $this->GP('product');
            if($product && $product != 0){
                $product = substr($product,0,strlen($product)-1); 
                $product = explode(',',$product);
                foreach($product as $k => $v){
                    $r=K::M('xiche/product')->detail($v);
                    $price += $r['price'];
                }
                $data['price'] += $price;
            }
            if($order_id = K::M('xiche/order')->create($data)){                
                //order插入成功，如果有附加项，就加入product表
                if($product && $product != 0){
                    foreach($product as $k => $v){
                        $r=K::M('xiche/product')->detail($v);
                        $data_array = array(
                            'order_id'=>$order_id,
                            'product_id'=>$v,
                            'product_name'=>$r['title'],
                            'product_price'=>$r['price'],
                            'product_number'=>1
                        );
                       $c = K::M('xiche/order/product') -> create($data_array); 
                    }
                }
                $this->msgbox->set_data('oid',$order_id);
                $this->msgbox->add('下单成功！');
                
            }else{
                $this->msgbox->add('下单失败！');
            }
            
        }
    }
    
    
    public function ok(){  //确认订单，订单收货，把钱打到服务人员账户里。
        
        $order_id = $this->GP('order_id');
        if(!$order = K::M('xiche/order')->detail($order_id)){
            $this->msgbox->add('不存在的订单！',211);
            $this->msgbox->response();
        }else if($order['order_status'] != 4){
            $this->msgbox->add('订单状态错误！',212);
            $this->msgbox->response();
        }else if($order['uid'] != $this->uid){
            $this->msgbox->add('不能操作别人的订单！',213);
            $this->msgbox->response();
        }else{

            $r = K::M('xiche/order')->update($order['order_id'],array('order_status'=>5));
            if($r){
                //如果操作成功，把订单的资金增加到师傅账户中。
                $up = K::M('staff/staff') -> update_count($order['staff_id'],'money',$order['price']);
                if($up){//插入资金记录表
                    K::M('staff/log')->logs($order['staff_id'],$order['price'],'完成了编号【'.$order['order_id'].'】的订单，结算');
                }

                 //更新模版消息
            if ($this->MEMBER['wx_openid']) {
                //获取模版消息配置
                $wx_config = $this->system->config->get('wx_config');
                $config = $this->system->config->get('site');
                $a = array('title'=>'您的订单已被您最终确认！', 'items' => array('OrderSn' => $order['order_id'], 'OrderStatus' => '订单已被您最终确认'), 'remark' =>'您的订单于'.date('Y-m-d H:i:s',time()).'已被您最终确认');
                $url = K::M('helper/link')->mklink('xiche/order:detail', array($order['order_id']), array(), 'www');
                K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['order_id'], $url, $a);    
            }

                $this->msgbox->add('确认成功！资金已入师傅账户');
            }else{
                $this->msgbox->add('操作失败！',214);
            }
        }
        
    }
    
    public function detail($order_id)
    {
        if(!$order_id){
         $order_id = $this->GP('order_id');   
        }
        $res = K::M('xiche/order')->detail($order_id);
        if(!$res){
            $this->msgbox->add('错误的订单！',401);
        }else{
            $this->pagedata['res'] = $res;
        }
        //查询订单中的商品信息
        $goods = K::M('xiche/goods')->detail($res['goods_id']);
        $this->pagedata['goods'] = $goods;
        
        //查附加服务
        $product = K::M('xiche/order/product')->items(array('order_id'=>$order_id));
 
        if($product){
            $this->pagedata['product'] = $product;
        }
        if($res['pay_status'] == 0){
            $this->tmpl = 'xiche/order/detail.html';
        }else if($res['order_status'] >= 1){
            
            //查询师傅信息
            $staff = K::M('staff/staff')->detail($res['staff_id']);
            $this->pagedata['staff'] = $staff;
            $count = K::M('xiche/order')->count(array('staff_id'=>$staff['staff_id'],'order_status'=>4));
            if(!$count){
                $count = 0;
            }
            $this->pagedata['count'] = $count;
            
            //查询洗车照片
            $photo = K::M('xiche/order/photo')->find(array('order_id'=>$res['order_id']));
            $this->pagedata['photo'] = $photo;
            
            //查询评价
            $is_comment = K::M('staff/comment')->find(array('uid'=>$this->uid,'order_id'=>$res['order_id'],'staff_id'=>$res['staff_id']));
            $this->pagedata['is_comment'] = $is_comment;
       
            
            $this->tmpl = 'xiche/order/detail_payed.html';
        }else{
            $this->error(404);
        }
        
    }


    
    
    public function pay()
    {   
        $this->check_login();
        $order_id = intval($this->GP('oid'));
        $o = K::M('xiche/order') -> detail($order_id);
        if($o['uid'] == $this->uid){            
            $hb_arr = array();
            $hb_arr['uid'] = $this->uid;
            $hb_arr['need_amount'] = '<=:'.$o['price'];
            $hb_arr['is_used'] = 0;
            $hongbao = K::M('hongbao/hongbao') -> items($hb_arr,array('amount'=>'desc'));
            if($hongbao){
                $this->pagedata['hongbao'] = $hongbao;
            }            
           $p = K::M('xiche/order/product') -> items(array('order_id'=>$order_id));
           $g = K::M('xiche/goods') -> items();
           
           if($g){
               $this->pagedata['g'] = $g;
           }
           $og = K::M('xiche/order/product') -> select(array('order_id'=>$o['order_id']),array('id'=>'desc'));
           if($og){
               $this->pagedata['og'] = $og;
           }
           
           //获取cookie
           $is_wx = $this->cookie->get('wx_openid');

           if($is_wx){
                $is_wx = 1;
           }else{
                $is_wx = 0;
           }

           $this->pagedata['is_wx'] = $is_wx;
           

           $this->pagedata['o'] = $o;
           $this->tmpl = 'xiche/order/pay.html'; 
        }
        
    }
    
    
    
    
    
     public function cancel()
    {
        
        $order_id = $this->GP('order_id');
        if(!$order_id){
            $this->msgbox->add('错误的订单', 215);
            $this->msgbox->response();
        }
        $f = K::M('xiche/order') ->detail($order_id);
        if($f['uid'] != $this->uid){
            $this->msgbox->add('不可操作别人的订单', 444);
            $this->msgbox->response();
        }
        $c = K::M('xiche/order') -> update($order_id,array('order_status'=>8));
        if(!$c){
            $this->msgbox->add('取消失败', 404);
            $this->msgbox->response();
        }else{
            //更新模版消息
            if ($this->MEMBER['wx_openid']) {
                //获取模版消息配置
                $wx_config = $this->system->config->get('wx_config');
                $config = $this->system->config->get('site');
                $a = array('title'=>'您的订单已取消！', 'items' => array('OrderSn' => $f['order_id'], 'OrderStatus' => '订单已被取消'), 'remark' =>'您的订单于'.date('Y-m-d H:i:s',time()).'已取消');
                $url = K::M('helper/link')->mklink('xiche/order:detail', null,array('order_id'=>$f['order_id']), 'www');
                K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['order_id'], $url, $a);    
            }
            $this->msgbox->add('成功');
        }
        
    }
    
    
    
    
}