<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_XiChe_Mcenter_Money extends Ctl_XiChe_Mcenter
{
  
    // 资金-明细
    public function details($page)
    {
        $filter = $pager = array();
        $pager['page'] = max(intval($page), 1);
        $pager['limit'] = $limit = 10;
        $orderby = array('log_id'=>'desc');
        $filter['staff_id'] = $this->staff['staff_id'];
        $td = strtotime(date('Y-m-d', time())); // 今天
        $tyd = strtotime(date('Y-m-d', time()-30*86400));  //30天前
        $filter['dateline'] = $tyd.'~'.time();

        if($items = K::M('staff/log')->items($filter, $orderby, $page, $limit, $count)){
            $pager['count'] = $count;
            $pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink(null, array('{page}')));
        }

        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager; 
    	$this->tmpl = 'xiche/mcenter/money/details.html';
    }

    // 资金-提现
    public function cash()
    {
        if ($money = $this->GP('money')) {
            $money = abs((int)$money); // 提现金额取整

            if(empty($this->staff['staff_id'])){
              $this->msgbox->add(array('您还未登陆，无法操作'),101);
              $this->msgbox->response();
            }

            $td = strtotime(date('Y-m-d', time()));
            $tmd = strtotime(date('Y-m-d', time()+86400)); 
            $cash_logs = K::M('staff/tixian')->find(array('staff_id'=>$this->staff['staff_id'],'dateline'=>$td."~".$tmd));
     
            if(!empty($cash_logs)){
              $this->msgbox->add(array('您今天已提现过了，请明天再来'),102);
              $this->msgbox->response();
            }
            if($money > $this->staff['money']){
               $this->msgbox->add(array('提现金额不能大于您账户余额'),103);
               $this->msgbox->response();
            }
            

            $cash_money = $this->staff['money']-$money;

            // 更新staff余额
            if(false !== K::M('staff/staff')->updates($this->staff['staff_id'],array('money'=>$cash_money))){
              // 更新明细记录
              if(false !== K::M('staff/log')->logs($this->staff['staff_id'],-$money,'商户提现，扣款')){
                
                  // 更新提现记录
                  if(false !== K::M('staff/tixian')->logs($this->staff['staff_id'],-$money,'商户提现，扣款')){
                      // 管理员审核
                      $this->msgbox->add(array('提现申请成功，请等待管理员审核'));
                      $this->msgbox->response();
                  }
              }
            }

            $this->msgbox->add(array('提现失败'),105);
            $this->msgbox->response();
        } else {
            $this->tmpl = 'xiche/mcenter/money/cash.html';
        }
    }

}