<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Xiche_Goods extends Ctl
{
    
    public function index($page=1)
    {
    	$filter = $pager = array();
    	$pager['page'] = max(intval($page), 1);
    	$pager['limit'] = $limit = 50;
        
        if($items = K::M('xiche/goods')->items($filter, null, $page, $limit, $count)){
        	$pager['count'] = $count;
        	$pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink(null, array('{page}')), array('SO'=>$SO));
        }
        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager;
        $this->tmpl = 'admin:xiche/goods/items.html';
    }

    public function create()
    {
        if($data = $this->checksubmit('data')){
                    if($_FILES['data']){
            foreach($_FILES['data'] as $k=>$v){
                foreach($v as $kk=>$vv){
                    $attachs[$kk][$k] = $vv;
                }
            }
            $upload = K::M('magic/upload');
            foreach($attachs as $k=>$attach){
                if($attach['error'] == UPLOAD_ERR_OK){
                    if($a = $upload->upload($attach, 'xiche')){
                        $data[$k] = $a['photo'];
                    }
                }
            }
        }

            if($goods_id = K::M('xiche/goods')->create($data)){
                $this->msgbox->add('添加内容成功');
                $this->msgbox->set_data('forward', '?xiche/goods-index.html');
            } 
        }else{
           $this->tmpl = 'admin:xiche/goods/create.html';
        }
    }

    public function edit($goods_id=null)
    {
        if(!($goods_id = (int)$goods_id) && !($goods_id = $this->GP('goods_id'))){
            $this->msgbox->add('未指定要修改的内容ID', 211);
        }else if(!$detail = K::M('xiche/goods')->detail($goods_id)){
            $this->msgbox->add('您要修改的内容不存在或已经删除', 212);
        }else if($data = $this->checksubmit('data')){
            if($_FILES['data']){
                foreach($_FILES['data'] as $k=>$v){
                    foreach($v as $kk=>$vv){
                        $attachs[$kk][$k] = $vv;
                    }
                }
                $upload = K::M('magic/upload');
                foreach($attachs as $k=>$attach){
                    if($attach['error'] == UPLOAD_ERR_OK){
                        if($a = $upload->upload($attach, 'xiche')){
                            $data[$k] = $a['photo'];
                        }
                    }
                }
            }

            if(K::M('xiche/goods')->update($goods_id, $data)){
                $this->msgbox->add('修改内容成功');
            }  
        }else{
        	$this->pagedata['detail'] = $detail;
        	$this->tmpl = 'admin:xiche/goods/edit.html';
        }
    }

    public function delete($goods_id=null)
    {
        if($goods_id = (int)$goods_id){
            if(!$detail = K::M('xiche/goods')->detail($comment_id)){
                $this->msgbox->add('你要删除的内容不存在或已经删除', 211);
            }else{
                if(K::M('xiche/goods')->delete($goods_id)){
                    $this->msgbox->add('删除内容成功');
                }
            }
        }else if($ids = $this->GP('goods_id')){
            if(K::M('xiche/goods')->delete($ids)){
                $this->msgbox->add('批量删除内容成功');
            }
        }else{
            $this->msgbox->add('未指定要删除的内容ID', 401);
        }
    }  

    public function product($goods_id=null)
    {
        if(!($goods_id = (int)$goods_id) && !($goods_id = $this->GP('goods_id'))){
            $this->msgbox->add('未指定商品的ID', 211);
        }else if(!$goods = K::M('xiche/goods')->detail($goods_id)){
            $this->msgbox->add('商品不存在或已经删除', 212);
        }else{
            $this->pagedata['goods'] = $goods;
            $this->pagedata['items'] = K::M('xiche/product')->items_by_goods($goods_id);
            $this->tmpl = 'admin:xiche/goods/product.html';
        }
    }

    public function updateproduct()
    {
        if(!$goods_id = $this->GP('goods_id')){
            $this->err->add('未指关联的商品', 211);
        }else if(!$goods = K::M('xiche/goods')->detail($goods_id)){
            $this->err->add('商品不存或已经删除', 212);
        }else if($this->checksubmit()){
            $obj = K::M('xiche/product');
            if($data = $this->GP('data')){
                foreach($data as $k=>$v){
                    $a = array('title'=>$v['title'], 'price'=>$v['price'], 'orderby'=>$v['orderby']);
                    $obj->update($k, $a);
                }
            }
            if($products = $this->GP('product')){
                foreach($products as $v){
                    if($v['title']){
                        $a = array('goods_id'=>$goods_id, 'title'=>$v['title'], 'price'=>$v['price'], 'orderby'=>$v['orderby']);
                        $obj->create($a);
                    }
                }
            }
        }
    }

    public function delproduct($pid = null)
    {
        if(!empty($pid)){
            if(K::M('xiche/product')->delete($pid)){
                $this->msgbox->add('删除选项成功');
            }
        }else if($pids = $this->GP('product_id')){
            if(K::M('xiche/product')->delete($pids)){
                $this->msgbox->add('批量删除附加服务成功');
            }
        }else{
            $this->msgbox->add('未指定要删除的附加服务', 401);
        }     
    }

}