<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Xiche_Car_Brand extends Ctl
{
    
    public function index($parent_id=0)
    {
    	$filter = $pager = array();
    	$pager['page'] = max(intval($page), 1);
    	$pager['limit'] = $limit = 100;
        $filter['parent_id'] = $parent_id = (int)$parent_id;
        if($items = K::M('xiche/car/brand')->items($filter, null, $page, $limit, $count)){
        	$pager['count'] = $count;
        	$pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink(null, array('{page}')), array('SO'=>$SO));
        }
        if(($parent_id = (int)$parent_id) && ($parent_brand = K::M('xiche/car/brand')->detail($parent_id))){
            $this->pagedata['parent_brand'] = $parent_brand;
        }        
        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager;
        $this->tmpl = 'admin:xiche/car/brand/items.html';
    }



    public function detail($brand_id = null)
    {
        if(!$brand_id = (int)$brand_id){
            $this->msgbox->add('未指定要查看内容的ID', 211);
        }else if(!$detail = K::M('xiche/car/brand')->detail($brand_id)){
            $this->msgbox->add('您要查看的内容不存在或已经删除', 212);
        }else{
            $this->pagedata['detail'] = $detail;
            $this->tmpl = 'admin:xiche/car/brand/detail.html';
        }
    }

    public function create($parent_id=null)
    {
        $parent_id = (int)$parent_id;
        if($data = $this->checksubmit('data')){
            if($_FILES['data']){
                foreach($_FILES['data'] as $k=>$v){
                    foreach($v as $kk=>$vv){
                        $attachs[$kk][$k] = $vv;
                    }
                }
                $upload = K::M('magic/upload');
                foreach($attachs as $k=>$attach){
                    if($attach['error'] == UPLOAD_ERR_OK){
                        if($a = $upload->upload($attach, 'xiche/car')){
                            $data[$k] = $a['photo'];
                        }
                    }
                }
            }
            if($brand_id = K::M('xiche/car/brand')->create($data)){
                $this->msgbox->add('添加内容成功');
                $this->msgbox->set_data('forward', '?xiche/car/brand-index.html');
            } 
        }else{
            if(($parent_id = (int)$parent_id) && ($parent_brand = K::M('xiche/car/brand')->detail($parent_id))){
                $this->pagedata['parent_brand'] = $parent_brand;
            }
            $this->pagedata['parent_id'] = $parent_id;
           $this->tmpl = 'admin:xiche/car/brand/create.html';
        }
    }

    public function edit($brand_id=null)
    {
        if(!($brand_id = (int)$brand_id) && !($brand_id = $this->GP('brand_id'))){
            $this->msgbox->add('未指定要修改的内容ID', 211);
        }else if(!$detail = K::M('xiche/car/brand')->detail($brand_id)){
            $this->msgbox->add('您要修改的内容不存在或已经删除', 212);
        }else if($data = $this->checksubmit('data')){
            if($_FILES['data']){
                foreach($_FILES['data'] as $k=>$v){
                    foreach($v as $kk=>$vv){
                        $attachs[$kk][$k] = $vv;
                    }
                }
                $upload = K::M('magic/upload');
                foreach($attachs as $k=>$attach){
                    if($attach['error'] == UPLOAD_ERR_OK){
                        if($a = $upload->upload($attach, 'xiche/car')){
                            $data[$k] = $a['photo'];
                        }
                    }
                }
            }

            if(K::M('xiche/car/brand')->update($brand_id, $data)){
                $this->msgbox->add('修改内容成功');
            }  
        }else{
            if(($parent_id = (int)$detail['parent_id']) && ($parent_brand = K::M('xiche/car/brand')->detail($parent_id))){
                $this->pagedata['parent_brand'] = $parent_brand;
            }            
        	$this->pagedata['detail'] = $detail;
        	$this->tmpl = 'admin:xiche/car/brand/edit.html';
        }
    }


    public function delete($brand_id=null)
    {
        if($brand_id = (int)$brand_id){
            if(!$detail = K::M('xiche/car/brand')->detail($comment_id)){
                $this->msgbox->add('你要删除的内容不存在或已经删除', 211);
            }else{
                if(K::M('xiche/car/brand')->delete($brand_id)){
                    $this->msgbox->add('删除内容成功');
                }
            }
        }else if($ids = $this->GP('brand_id')){
            if(K::M('xiche/car/brand')->delete($ids)){
                $this->msgbox->add('批量删除内容成功');
            }
        }else{
            $this->msgbox->add('未指定要删除的内容ID', 401);
        }
    }  

}