<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Xiche_Car extends Ctl
{
    
    public function index($page=1)
    {
        $filter = $pager = array();
        $pager['page'] = max(intval($page), 1);
        $pager['limit'] = $limit = 50;
        
        if($items = K::M('xiche/car')->items($filter, null, $page, $limit, $count)){
            $pager['count'] = $count;
            $pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink(null, array('{page}')), array('SO'=>$SO));
            $uids = $brand_ids = array();
            foreach($items as $k=>$v){
                $uids[$v['uid']] = $v['uid'];
            }
            if($uids){
                $this->pagedata['member_list'] = K::M('member/member')->items_by_ids($uids);
            }
        }
        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager;
        $this->tmpl = 'admin:xiche/car/items.html';
    }

    public function create()
    {
        if($data = $this->checksubmit('data')){
            if($_FILES['data']){
                foreach($_FILES['data'] as $k=>$v){
                    foreach($v as $kk=>$vv){
                        $attachs[$kk][$k] = $vv;
                    }
                }
                $upload = K::M('magic/upload');
                foreach($attachs as $k=>$attach){
                    if($attach['error'] == UPLOAD_ERR_OK){
                        if($a = $upload->upload($attach, 'xiche')){
                            $data[$k] = $a['photo'];
                        }
                    }
                }
            }
            if($car_id = K::M('xiche/car')->create($data)){
                $this->msgbox->add('添加内容成功');
                $this->msgbox->set_data('forward', '?xiche/car-index.html');
            } 
        }else{
           $this->tmpl = 'admin:xiche/car/create.html';
        }
    }

    public function edit($car_id=null)
    {
        if(!($car_id = (int)$car_id) && !($car_id = $this->GP('car_id'))){
            $this->msgbox->add('未指定要修改的内容ID', 211);
        }else if(!$detail = K::M('xiche/car')->detail($car_id)){
            $this->msgbox->add('您要修改的内容不存在或已经删除', 212);
        }else if($data = $this->checksubmit('data')){
            if($_FILES['data']){
                foreach($_FILES['data'] as $k=>$v){
                    foreach($v as $kk=>$vv){
                        $attachs[$kk][$k] = $vv;
                    }
                }
                $upload = K::M('magic/upload');
                foreach($attachs as $k=>$attach){
                    if($attach['error'] == UPLOAD_ERR_OK){
                        if($a = $upload->upload($attach, 'xiche')){
                            $data[$k] = $a['photo'];
                        }
                    }
                }
            }
            if(K::M('xiche/car')->update($car_id, $data)){
                $this->msgbox->add('修改内容成功');
            }  
        }else{
            $chepai_list = K::M('data/data')->chepai();
            $color_list = K::M('data/data')->checolor();
            $chepai_list = array_combine($chepai_list, $chepai_list);
            $color_list = array_combine($color_list, $color_list);
            $this->pagedata['chepai_list'] = $chepai_list;
            $this->pagedata['color_list'] = $color_list;
            if($brand_list = K::M('xiche/car/brand')->fetch_all()){
                $oTree = K::M('helper/tree');
                $oTree->icon = array('|--- ','|--- ','|---');
                $oTree->nbsp = '&nbsp;&nbsp;&nbsp;';
                $oTree->init($brand_list);
                $strtmpl = '<option value={$brand_id} {$selected}>{$spacer}{$title}</option>';
                $this->pagedata['brand_tree'] = $oTree->tree(0, $strtmpl, $detail['brand_id']);
            }
            if($uid = $detail['uid']){
                $this->pagedata['member'] = K::M('member/member')->detail($uid);
            }
            $this->pagedata['detail'] = $detail;
            $this->tmpl = 'admin:xiche/car/edit.html';
        }
    }


    public function delete($car_id=null)
    {
        if($car_id = (int)$car_id){
            if(!$detail = K::M('xiche/car')->detail($comment_id)){
                $this->msgbox->add('你要删除的内容不存在或已经删除', 211);
            }else{
                if(K::M('xiche/car')->delete($car_id)){
                    $this->msgbox->add('删除内容成功');
                }
            }
        }else if($ids = $this->GP('car_id')){
            if(K::M('xiche/car')->delete($ids)){
                $this->msgbox->add('批量删除内容成功');
            }
        }else{
            $this->msgbox->add('未指定要删除的内容ID', 401);
        }
    }  

}