
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/willow.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/nep.zip" ),
}
local prefabs = {}

local fn = function(inst)
	
	inst.soundsname = "willow"

	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("neptune.tex")

	inst.components.sanity:SetMax(175)
	inst.components.health:SetMaxHealth(300)
	inst.components.combat.damagemultiplier = 4.00
			local light = inst.entity:AddLight()
		light:SetFalloff(20)
		light:SetIntensity(0.001)
		light:SetRadius(10)
		light:SetColour(255/255, 204/255, 229/255)
		light:Enable(true)		
end

STRINGS.CHARACTER_TITLES.nep = "Neptune"
STRINGS.CHARACTER_NAMES.nep = "Neptune"
STRINGS.CHARACTER_DESCRIPTIONS.nep = "*the power of a goddess.                                           *a glowing aura of a goddess.            ++++Damage.   -Sanity.  +++Health."
STRINGS.CHARACTER_QUOTES.nep = "\"I will show you the true power of a goddess.\""

return MakePlayerCharacter("nep", prefabs, assets, fn)
