local Screen = require "widgets/screen"
local Button = require "widgets/button"
local AnimButton = require "widgets/animbutton"
local Menu = require "widgets/menu"
local Text = require "widgets/text"
local Image = require "widgets/image"
local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local ImageButton = require "widgets/imagebutton"

local MessageScreen = Class(Screen, function(self,inst)
	Screen._ctor(self, "messagescreen")
	self.messageshow = inst
	self.active = true
	SetPause(true,"pause")
	TheInputProxy:SetCursorVisible(true)
	
    self.black = self:AddChild(Image("images/global.xml", "square.tex"))
    self.black:SetVRegPoint(ANCHOR_MIDDLE)
    self.black:SetHRegPoint(ANCHOR_MIDDLE)
    self.black:SetVAnchor(ANCHOR_MIDDLE)
    self.black:SetHAnchor(ANCHOR_MIDDLE)
    self.black:SetScaleMode(SCALEMODE_FILLSCREEN)
	self.black:SetTint(0,0,0,.75)	

	self.proot = self:AddChild(Widget("ROOT"))
    self.proot:SetVAnchor(ANCHOR_MIDDLE)
    self.proot:SetHAnchor(ANCHOR_MIDDLE)
    self.proot:SetPosition(0,0,0)
    self.proot:SetScaleMode(SCALEMODE_PROPORTIONAL)

	self.bg = self.proot:AddChild(Image("images/"..inst.mymessage..".xml", inst.mymessage..".tex"))
    self.bg:SetVRegPoint(ANCHOR_MIDDLE)
    self.bg:SetHRegPoint(ANCHOR_MIDDLE)
	self.bg:SetScale(1,1,1)
	
    self.kmemo = self.proot:AddChild(Image("images/"..inst.mymessage.."_t.xml", inst.mymessage.."_t.tex"))
    self.kmemo:SetVRegPoint(ANCHOR_MIDDLE)
    self.kmemo:SetHRegPoint(ANCHOR_MIDDLE)
	self.kmemo:SetPosition(0, 170, 0)
	self.kmemo:SetScale(.8,.8,.8)
	
    self.title = self.proot:AddChild(Text(TITLEFONT, 50))
    self.title:SetPosition(0, 220, 0)
    self.title:SetString("- UNKNOWN MESSAGE -")
	
    self.subtext = self.proot:AddChild(Text(TITLEFONT, 34))
    self.subtext:SetPosition(0, -185, 0)
    self.subtext:SetString("The letter is stamped with animal footprints.\nThis letter will disappear.")
	
	self.bresume = self.proot:AddChild(ImageButton())
	self.bresume:SetPosition(0, -270, 0)
	self.bresume:SetText("Close")
	self.bresume:SetOnClick(function()
		TheFrontEnd:PopScreen(self)
		if not self.was_paused then
			SetPause(false)
		end
		GetWorld():PushEvent("notpause")
	end)
	
	self.default_focus = self.bresume
end)

function MessageScreen:OnControl(control, down)
	if MessageScreen._base.OnControl(self,control, down) then return true end
	if (control == CONTROL_PAUSE or control == CONTROL_CANCEL) and not down then	
		self.active = false
		TheFrontEnd:PopScreen() 
		SetPause(false)
		GetWorld():PushEvent("notpause")
		return true
	end

end

function MessageScreen:OnUpdate(dt)
	if self.active then
		SetPause(true)
	end
end

return MessageScreen